VERSION 6
BEGIN SCHEMATIC
    BEGIN ATTR DeviceFamilyName "spartan3"
        DELETE all:0
        EDITNAME all:0
        EDITTRAIT all:0
    END ATTR
    BEGIN NETLIST
        SIGNAL F_MISO
        SIGNAL XLXN_892(3:0)
        SIGNAL F_MOSI
        SIGNAL F_DS
        SIGNAL F_SCK
        SIGNAL F_RS
        SIGNAL XLXN_917(31:0)
        SIGNAL XLXN_1087(3:0)
        SIGNAL LC_DATA(31:0)
        SIGNAL XLXN_1096(18:0)
        SIGNAL LC_WEN
        SIGNAL P_ADDR(15:0)
        SIGNAL P_RD_N
        SIGNAL P_WR_N
        SIGNAL P_ADDR(18:0)
        SIGNAL WEN
        SIGNAL VRAM_A(18:0)
        SIGNAL OEN
        SIGNAL VRAM_D(7:0)
        SIGNAL XLXN_1180(7:0)
        SIGNAL P_ADDR(11:0)
        SIGNAL hs_out
        SIGNAL ClkIn
        SIGNAL XLXN_1196(7:0)
        SIGNAL XLXN_1197(7:0)
        SIGNAL KBD_DWN
        SIGNAL XLXN_1239
        SIGNAL XLXN_1168(7:0)
        SIGNAL XLXN_1195
        SIGNAL StartAdr(18:0)
        SIGNAL DAC_MPX
        SIGNAL DAC_WR
        SIGNAL DAC_CLK
        SIGNAL XLXN_1283
        SIGNAL vs_out
        SIGNAL SYSCLK
        SIGNAL PS2_Clk
        SIGNAL PS2_Data
        SIGNAL PS2code(7:0)
        SIGNAL SPI_Key(7:0)
        SIGNAL XLXN_1331
        SIGNAL XLXN_1353
        SIGNAL XLXN_1356
        SIGNAL KeyRate15Hz
        SIGNAL XLXN_1268(7:0)
        SIGNAL SPI_KeyStrobe
        SIGNAL LC_ENA
        SIGNAL XLXN_1267
        SIGNAL CPU_RST
        SIGNAL XLXN_1334
        SIGNAL ComRx(7:0)
        SIGNAL SPI_Key(31:0)
        SIGNAL ComRx(31:0)
        SIGNAL XLXN_1145
        SIGNAL StartAdr(15:8)
        SIGNAL PreStrobe0
        SIGNAL Strobe1
        SIGNAL XLXN_1485
        SIGNAL IRQ_Source(7:0)
        SIGNAL ComTx(7:0)
        SIGNAL ComTx(31:0)
        SIGNAL IRQ_Source(3)
        SIGNAL IRQ_Source(2)
        SIGNAL IRQ_Source(1)
        SIGNAL IRQ_Source(0)
        SIGNAL red_out
        SIGNAL green_out
        SIGNAL blue_out
        SIGNAL F_Int
        SIGNAL ComEna(7:0)
        SIGNAL ComEna(0)
        SIGNAL ComEna(1)
        SIGNAL XLXN_1490
        SIGNAL XLXN_1492
        SIGNAL XLXN_1494
        SIGNAL XLXN_1496
        SIGNAL ComEna(2)
        SIGNAL XLXN_1498
        SIGNAL TestLED
        SIGNAL XLXN_1500
        PORT Output F_MISO
        PORT Input F_MOSI
        PORT Input F_DS
        PORT Input F_SCK
        PORT Input F_RS
        PORT Output WEN
        PORT Output VRAM_A(18:0)
        PORT Output OEN
        PORT BiDirectional VRAM_D(7:0)
        PORT Output hs_out
        PORT Input ClkIn
        PORT Output DAC_MPX
        PORT Output DAC_WR
        PORT Output DAC_CLK
        PORT Output vs_out
        PORT Input PS2_Clk
        PORT Input PS2_Data
        PORT Output red_out
        PORT Output green_out
        PORT Output blue_out
        PORT Output F_Int
        PORT Output TestLED
        BEGIN BLOCKDEF constant
            TIMESTAMP 2006 1 1 10 10 10
            RECTANGLE N 0 0 112 64 
            LINE N 144 32 112 32 
        END BLOCKDEF
        BEGIN BLOCKDEF vcc
            TIMESTAMP 2000 1 1 10 10 10
            LINE N 64 -32 64 -64 
            LINE N 64 0 64 -32 
            LINE N 96 -64 32 -64 
        END BLOCKDEF
        BEGIN BLOCKDEF ibufg
            TIMESTAMP 2000 1 1 10 10 10
            LINE N 64 0 64 -64 
            LINE N 128 -32 64 0 
            LINE N 64 -64 128 -32 
            LINE N 224 -32 128 -32 
            LINE N 0 -32 64 -32 
        END BLOCKDEF
        BEGIN BLOCKDEF SPI
            TIMESTAMP 2009 2 27 11 39 9
            LINE N 64 -608 0 -608 
            LINE N 64 -544 0 -544 
            LINE N 64 -480 0 -480 
            LINE N 64 -416 0 -416 
            LINE N 64 -352 0 -352 
            RECTANGLE N 0 -300 64 -276 
            LINE N 64 -288 0 -288 
            RECTANGLE N 0 -236 64 -212 
            LINE N 64 -224 0 -224 
            RECTANGLE N 0 -172 64 -148 
            LINE N 64 -160 0 -160 
            RECTANGLE N 0 -108 64 -84 
            LINE N 64 -96 0 -96 
            RECTANGLE N 0 -44 64 -20 
            LINE N 64 -32 0 -32 
            LINE N 320 -608 384 -608 
            RECTANGLE N 320 -300 384 -276 
            LINE N 320 -288 384 -288 
            RECTANGLE N 320 -236 384 -212 
            LINE N 320 -224 384 -224 
            RECTANGLE N 320 -172 384 -148 
            LINE N 320 -160 384 -160 
            RECTANGLE N 320 -108 384 -84 
            LINE N 320 -96 384 -96 
            LINE N 320 -544 384 -544 
            LINE N 320 -480 384 -480 
            LINE N 320 -416 384 -416 
            LINE N 320 -352 384 -352 
            RECTANGLE N 64 -640 320 120 
            LINE N 320 0 384 0 
            LINE N 320 32 384 32 
            LINE N 320 64 384 64 
            LINE N 320 96 384 96 
        END BLOCKDEF
        BEGIN BLOCKDEF SPI_LC
            TIMESTAMP 2009 2 6 8 30 24
            RECTANGLE N 0 -44 64 -20 
            LINE N 64 -32 0 -32 
            RECTANGLE N 320 -108 384 -84 
            LINE N 320 -96 384 -96 
            LINE N 64 -352 0 -352 
            LINE N 64 -224 0 -224 
            LINE N 64 -288 0 -288 
            LINE N 64 -96 0 -96 
            LINE N 64 -160 0 -160 
            RECTANGLE N 64 -384 320 0 
            LINE N 320 -160 384 -160 
            RECTANGLE N 320 -236 384 -212 
            LINE N 320 -224 384 -224 
            LINE N 320 -288 384 -288 
        END BLOCKDEF
        BEGIN BLOCKDEF COUNT_LC
            TIMESTAMP 2009 2 22 18 26 13
            RECTANGLE N 0 52 64 76 
            LINE N 64 64 0 64 
            LINE N 64 -128 0 -128 
            LINE N 352 0 416 0 
            LINE N 64 -64 0 -64 
            LINE N 352 -64 416 -64 
            RECTANGLE N 352 -140 416 -116 
            LINE N 352 -128 416 -128 
            LINE N 64 0 0 0 
            RECTANGLE N 64 -160 352 96 
        END BLOCKDEF
        BEGIN BLOCKDEF t65_wrap
            TIMESTAMP 2009 2 16 16 44 24
            LINE N 64 -288 0 -288 
            LINE N 64 -224 0 -224 
            LINE N 64 -160 0 -160 
            RECTANGLE N 0 -44 64 -20 
            LINE N 64 -32 0 -32 
            RECTANGLE N 368 -44 432 -20 
            LINE N 368 -32 432 -32 
            RECTANGLE N 368 -108 432 -84 
            LINE N 368 -96 432 -96 
            LINE N 368 -224 432 -224 
            LINE N 368 -160 432 -160 
            RECTANGLE N 64 -320 368 12 
            LINE N 64 -96 0 -96 
        END BLOCKDEF
        BEGIN BLOCKDEF inv
            TIMESTAMP 2000 1 1 10 10 10
            LINE N 0 -32 64 -32 
            LINE N 224 -32 160 -32 
            LINE N 64 -64 128 -32 
            LINE N 128 -32 64 0 
            LINE N 64 0 64 -64 
            CIRCLE N 128 -48 160 -16 
        END BLOCKDEF
        BEGIN BLOCKDEF vga_txt
            TIMESTAMP 2009 2 19 12 25 19
            RECTANGLE N 0 -108 64 -84 
            LINE N 64 -96 0 -96 
            RECTANGLE N 0 -44 64 -20 
            LINE N 64 -32 0 -32 
            LINE N 320 -416 384 -416 
            LINE N 64 -352 0 -352 
            LINE N 64 -416 0 -416 
            LINE N 320 -352 384 -352 
            LINE N 320 -288 384 -288 
            RECTANGLE N 64 -448 320 0 
            LINE N 64 -288 0 -288 
            LINE N 320 -96 384 -96 
            LINE N 320 -32 384 -32 
            RECTANGLE N 0 -236 64 -212 
            LINE N 64 -224 0 -224 
            RECTANGLE N 0 -172 64 -148 
            LINE N 64 -160 0 -160 
        END BLOCKDEF
        BEGIN BLOCKDEF ps2kbd
            TIMESTAMP 2009 2 23 21 5 14
            RECTANGLE N 64 -320 352 0 
            LINE N 64 -288 0 -288 
            LINE N 64 -224 0 -224 
            LINE N 64 -96 0 -96 
            LINE N 64 -32 0 -32 
            LINE N 352 -288 416 -288 
            LINE N 352 -224 416 -224 
            LINE N 352 -32 416 -32 
            RECTANGLE N 352 -172 416 -148 
            LINE N 352 -160 416 -160 
        END BLOCKDEF
        BEGIN BLOCKDEF atom_glue
            TIMESTAMP 2009 2 28 14 24 9
            LINE N 64 272 0 272 
            RECTANGLE N 448 4 512 28 
            LINE N 448 16 512 16 
            RECTANGLE N 448 68 512 92 
            LINE N 448 80 512 80 
            RECTANGLE N 0 -252 64 -228 
            LINE N 64 -240 0 -240 
            LINE N 64 -752 0 -752 
            LINE N 64 -688 0 -688 
            RECTANGLE N 0 -636 64 -612 
            LINE N 64 -624 0 -624 
            RECTANGLE N 448 -572 512 -548 
            LINE N 448 -560 512 -560 
            RECTANGLE N 0 -572 64 -548 
            LINE N 64 -560 0 -560 
            RECTANGLE N 0 -444 64 -420 
            LINE N 64 -432 0 -432 
            RECTANGLE N 448 -252 512 -228 
            LINE N 448 -240 512 -240 
            LINE N 448 -368 512 -368 
            LINE N 448 -304 512 -304 
            RECTANGLE N 448 -444 512 -420 
            LINE N 448 -432 512 -432 
            LINE N 64 -368 0 -368 
            LINE N 64 -304 0 -304 
            LINE N 448 -688 512 -688 
            LINE N 64 -816 0 -816 
            RECTANGLE N 0 196 64 220 
            LINE N 64 208 0 208 
            LINE N 64 -48 0 -48 
            LINE N 64 16 0 16 
            RECTANGLE N 0 68 64 92 
            LINE N 64 80 0 80 
            LINE N 448 208 512 208 
            RECTANGLE N 0 452 64 476 
            LINE N 64 464 0 464 
            RECTANGLE N 448 452 512 476 
            LINE N 448 464 512 464 
            RECTANGLE N 0 388 64 412 
            LINE N 64 400 0 400 
            RECTANGLE N 448 388 512 412 
            LINE N 448 400 512 400 
            RECTANGLE N 64 -924 448 504 
            LINE N 64 -880 0 -880 
        END BLOCKDEF
        BEGIN BLOCKDEF or2
            TIMESTAMP 2000 1 1 10 10 10
            LINE N 0 -64 64 -64 
            LINE N 0 -128 64 -128 
            LINE N 256 -96 192 -96 
            ARC N 28 -224 204 -48 112 -48 192 -96 
            ARC N -40 -152 72 -40 48 -48 48 -144 
            LINE N 112 -144 48 -144 
            ARC N 28 -144 204 32 192 -96 112 -144 
            LINE N 112 -48 48 -48 
        END BLOCKDEF
        BEGIN BLOCKDEF key_fifo
            TIMESTAMP 2009 2 23 18 18 7
            RECTANGLE N 32 48 288 384 
            BEGIN LINE W 0 80 32 80 
            END LINE
            LINE N 0 336 32 336 
            LINE N 0 272 32 272 
            LINE N 0 208 32 208 
            LINE N 0 144 32 144 
            BEGIN LINE W 320 80 288 80 
            END LINE
            LINE N 320 144 288 144 
            LINE N 320 208 288 208 
            LINE N 160 416 160 384 
        END BLOCKDEF
        BEGIN BLOCKDEF cb4ce
            TIMESTAMP 2000 1 1 10 10 10
            RECTANGLE N 64 -512 320 -64 
            LINE N 0 -32 64 -32 
            LINE N 0 -128 64 -128 
            LINE N 384 -256 320 -256 
            LINE N 384 -320 320 -320 
            LINE N 384 -384 320 -384 
            LINE N 384 -448 320 -448 
            LINE N 80 -128 64 -144 
            LINE N 64 -112 80 -128 
            LINE N 384 -128 320 -128 
            LINE N 192 -32 64 -32 
            LINE N 192 -64 192 -32 
            LINE N 0 -192 64 -192 
            LINE N 384 -192 320 -192 
        END BLOCKDEF
        BEGIN BLOCKDEF and2b1
            TIMESTAMP 2000 1 1 10 10 10
            LINE N 64 -48 64 -144 
            LINE N 64 -144 144 -144 
            LINE N 144 -48 64 -48 
            ARC N 96 -144 192 -48 144 -48 144 -144 
            LINE N 256 -96 192 -96 
            LINE N 0 -128 64 -128 
            LINE N 0 -64 40 -64 
            CIRCLE N 40 -76 64 -52 
        END BLOCKDEF
        BEGIN BLOCKDEF fd
            TIMESTAMP 2000 1 1 10 10 10
            RECTANGLE N 64 -320 320 -64 
            LINE N 0 -128 64 -128 
            LINE N 0 -256 64 -256 
            LINE N 384 -256 320 -256 
            LINE N 80 -128 64 -144 
            LINE N 64 -112 80 -128 
        END BLOCKDEF
        BEGIN BLOCKDEF buf
            TIMESTAMP 2000 1 1 10 10 10
            LINE N 0 -32 64 -32 
            LINE N 224 -32 128 -32 
            LINE N 64 0 128 -32 
            LINE N 128 -32 64 -64 
            LINE N 64 -64 64 0 
        END BLOCKDEF
        BEGIN BLOCKDEF or4
            TIMESTAMP 2000 1 1 10 10 10
            LINE N 0 -64 48 -64 
            LINE N 0 -128 64 -128 
            LINE N 0 -192 64 -192 
            LINE N 0 -256 48 -256 
            LINE N 256 -160 192 -160 
            ARC N 28 -208 204 -32 192 -160 112 -208 
            LINE N 112 -208 48 -208 
            LINE N 112 -112 48 -112 
            LINE N 48 -256 48 -208 
            LINE N 48 -64 48 -112 
            ARC N -40 -216 72 -104 48 -112 48 -208 
            ARC N 28 -288 204 -112 112 -112 192 -160 
        END BLOCKDEF
        BEGIN BLOCKDEF and2
            TIMESTAMP 2000 1 1 10 10 10
            LINE N 0 -64 64 -64 
            LINE N 0 -128 64 -128 
            LINE N 256 -96 192 -96 
            ARC N 96 -144 192 -48 144 -48 144 -144 
            LINE N 144 -48 64 -48 
            LINE N 64 -144 144 -144 
            LINE N 64 -48 64 -144 
        END BLOCKDEF
        BEGIN BLOCKDEF fd4ce
            TIMESTAMP 2000 1 1 10 10 10
            LINE N 384 -448 320 -448 
            LINE N 384 -384 320 -384 
            LINE N 0 -384 64 -384 
            LINE N 0 -448 64 -448 
            LINE N 0 -320 64 -320 
            LINE N 0 -256 64 -256 
            LINE N 384 -256 320 -256 
            LINE N 384 -320 320 -320 
            RECTANGLE N 64 -512 320 -64 
            LINE N 0 -192 64 -192 
            LINE N 0 -32 64 -32 
            LINE N 192 -32 64 -32 
            LINE N 192 -64 192 -32 
            LINE N 80 -128 64 -144 
            LINE N 64 -112 80 -128 
            LINE N 0 -128 64 -128 
        END BLOCKDEF
        BEGIN BLOCK XLXI_838 SPI
            PIN SYSCLK SYSCLK
            PIN F_DS F_DS
            PIN F_RS F_RS
            PIN F_SCLK F_SCK
            PIN F_MOSI F_MOSI
            PIN D0(31:0) ComTx(31:0)
            PIN D1(31:0)
            PIN D2(31:0)
            PIN D3(31:0) XLXN_917(31:0)
            PIN BASEADR(3:0) XLXN_892(3:0)
            PIN F_MISO F_MISO
            PIN Q0(31:0)
            PIN Q1(31:0) ComRx(31:0)
            PIN Q2(31:0)
            PIN Q3(31:0) SPI_Key(31:0)
            PIN STROBE0
            PIN STROBE1 Strobe1
            PIN STROBE2
            PIN STROBE3 SPI_KeyStrobe
            PIN PRESTRB0 PreStrobe0
            PIN PRESTRB1
            PIN PRESTRB2
            PIN PRESTRB3
        END BLOCK
        BEGIN BLOCK XLXI_341 constant
            BEGIN ATTR CValue "0"
                DELETE all:1 sym:0
                EDITNAME all:1 sch:0
                VALUETYPE BitVector 32 Hexadecimal
            END ATTR
            PIN O XLXN_892(3:0)
        END BLOCK
        BEGIN BLOCK XLXI_759 constant
            BEGIN ATTR CValue "27022009"
                DELETE all:1 sym:0
                EDITNAME all:1 sch:0
                VALUETYPE BitVector 32 Hexadecimal
            END ATTR
            PIN O XLXN_917(31:0)
        END BLOCK
        BEGIN BLOCK XLXI_866 t65_wrap
            PIN RST CPU_RST
            PIN IRQ XLXN_1490
            PIN NMI
            PIN DATA_I(7:0) XLXN_1180(7:0)
            PIN WR_N P_WR_N
            PIN RD_N P_RD_N
            PIN ADDR(15:0) P_ADDR(15:0)
            PIN DATA_O(7:0) XLXN_1168(7:0)
            PIN CLK_X4 SYSCLK
        END BLOCK
        BEGIN BLOCK XLXI_879 vga_txt
            PIN RST
            PIN SYSCLK50 SYSCLK
            PIN CURSX(7:0) XLXN_1196(7:0)
            PIN CURSY(7:0) XLXN_1197(7:0)
            PIN R red_out
            PIN G green_out
            PIN B blue_out
            PIN RAMWR XLXN_1195
            PIN hsync hs_out
            PIN vsync vs_out
            PIN RAMADR(11:0) P_ADDR(11:0)
            PIN RAMDASCII(7:0) XLXN_1168(7:0)
        END BLOCK
        BEGIN BLOCK XLXI_833 ibufg
            PIN I ClkIn
            PIN O SYSCLK
        END BLOCK
        BEGIN BLOCK XLXI_890 atom_glue
            PIN CLK_X4 SYSCLK
            PIN CPU_RDn P_RD_N
            PIN CPU_WRn P_WR_N
            PIN LC_WRn LC_WEN
            PIN LC_ENA LC_ENA
            PIN SPI_KEYENA XLXN_1334
            PIN PS2_DWN KBD_DWN
            PIN PS2_UP XLXN_1239
            PIN CPU_ADR(18:0) P_ADDR(18:0)
            PIN LC_ADR(18:0) XLXN_1096(18:0)
            PIN CPU_DATAi(7:0) XLXN_1168(7:0)
            PIN LC_DATA(31:0) LC_DATA(31:0)
            PIN PBE00i(7:0) ComRx(7:0)
            PIN PBF00i(7:0) IRQ_Source(7:0)
            PIN SPI_KEY(7:0) XLXN_1268(7:0)
            PIN PS2_CODE(7:0) PS2code(7:0)
            PIN RAM_DATAz(7:0) VRAM_D(7:0)
            PIN RAM_OEn OEN
            PIN RAM_WEn WEN
            PIN VGA_WR XLXN_1195
            PIN KeyLED
            PIN RAM_ADR(18:0) VRAM_A(18:0)
            PIN CPU_DATAo(7:0) XLXN_1180(7:0)
            PIN CURSX(7:0) XLXN_1196(7:0)
            PIN CURSY(7:0) XLXN_1197(7:0)
            PIN PBE00o(7:0) ComTx(7:0)
            PIN PBF00o(7:0) ComEna(7:0)
            PIN CPU_RST CPU_RST
        END BLOCK
        BEGIN BLOCK XLXI_865 COUNT_LC
            PIN SYSCLK SYSCLK
            PIN CORERST XLXN_1494
            PIN RAMINCR XLXN_1145
            PIN LC_ENA LC_ENA
            PIN LC_WEN LC_WEN
            PIN LC_ADDR(18:0) XLXN_1096(18:0)
            PIN START(18:0) StartAdr(18:0)
        END BLOCK
        BEGIN BLOCK XLXI_831 vcc
            PIN P DAC_MPX
        END BLOCK
        BEGIN BLOCK XLXI_882 vcc
            PIN P DAC_WR
        END BLOCK
        BEGIN BLOCK XLXI_883 vcc
            PIN P DAC_CLK
        END BLOCK
        BEGIN BLOCK XLXI_903 cb4ce
            PIN C vs_out
            PIN CE XLXN_1283
            PIN CLR
            PIN CEO
            PIN Q0
            PIN Q1 KeyRate15Hz
            PIN Q2
            PIN Q3
            PIN TC
        END BLOCK
        BEGIN BLOCK XLXI_904 vcc
            PIN P XLXN_1283
        END BLOCK
        BEGIN BLOCK XLXI_884 ps2kbd
            PIN Rst_n XLXN_1492
            PIN Clk SYSCLK
            PIN PS2_Clk PS2_Clk
            PIN PS2_Data PS2_Data
            PIN Press KBD_DWN
            PIN Release XLXN_1239
            PIN Reset XLXN_1267
            PIN ScanCode(7:0) PS2code(7:0)
        END BLOCK
        BEGIN BLOCK XLXI_896 key_fifo
            PIN din(7:0) SPI_Key(7:0)
            PIN rd_clk KeyRate15Hz
            PIN rd_en XLXN_1331
            PIN wr_clk SPI_KeyStrobe
            PIN wr_en XLXN_1331
            PIN dout(7:0) XLXN_1268(7:0)
            PIN full
            PIN empty XLXN_1353
            PIN rst
        END BLOCK
        BEGIN BLOCK XLXI_923 fd
            PIN C KeyRate15Hz
            PIN D XLXN_1353
            PIN Q XLXN_1356
        END BLOCK
        BEGIN BLOCK XLXI_920 and2b1
            PIN I0 XLXN_1356
            PIN I1 KeyRate15Hz
            PIN O XLXN_1334
        END BLOCK
        BEGIN BLOCK XLXI_915 vcc
            PIN P XLXN_1331
        END BLOCK
        BEGIN BLOCK XLXI_894 or2
            PIN I0 LC_ENA
            PIN I1 XLXN_1267
            PIN O CPU_RST
        END BLOCK
        BEGIN BLOCK XLXI_850 SPI_LC
            PIN F_RS F_RS
            PIN F_MOSI F_MOSI
            PIN F_DS F_DS
            PIN F_SCLK F_SCK
            PIN SYSCLK SYSCLK
            PIN BASEADR(3:0) XLXN_1087(3:0)
            PIN RAMD(31:0) LC_DATA(31:0)
            PIN RAMINCR XLXN_1145
            PIN CORESEL(7:0) StartAdr(15:8)
            PIN CORERST XLXN_1494
        END BLOCK
        BEGIN BLOCK XLXI_853 constant
            BEGIN ATTR CValue "8"
                DELETE all:1 sym:0
                EDITNAME all:1 sch:0
                VALUETYPE BitVector 32 Hexadecimal
            END ATTR
            PIN O XLXN_1087(3:0)
        END BLOCK
        BEGIN BLOCK XLXI_961 or2
            PIN I0 PreStrobe0
            PIN I1 Strobe1
            PIN O XLXN_1485
        END BLOCK
        BEGIN BLOCK XLXI_963 buf
            PIN I ComEna(0)
            PIN O F_Int
        END BLOCK
        BEGIN BLOCK XLXI_964 or4
            PIN I0 IRQ_Source(3)
            PIN I1 IRQ_Source(2)
            PIN I2 IRQ_Source(1)
            PIN I3 IRQ_Source(0)
            PIN O XLXN_1496
        END BLOCK
        BEGIN BLOCK XLXI_966 inv
            PIN I XLXN_1494
            PIN O XLXN_1492
        END BLOCK
        BEGIN BLOCK XLXI_967 and2
            PIN I0 ComEna(2)
            PIN I1 XLXN_1496
            PIN O XLXN_1490
        END BLOCK
        BEGIN BLOCK XLXI_968 or2
            PIN I0 CPU_RST
            PIN I1 ComEna(1)
            PIN O XLXN_1498
        END BLOCK
        BEGIN BLOCK XLXI_969 fd4ce
            PIN C SYSCLK
            PIN CE XLXN_1485
            PIN CLR XLXN_1498
            PIN D0 PreStrobe0
            PIN D1 Strobe1
            PIN D2
            PIN D3
            PIN Q0 IRQ_Source(0)
            PIN Q1 IRQ_Source(1)
            PIN Q2 IRQ_Source(2)
            PIN Q3 IRQ_Source(3)
        END BLOCK
        BEGIN BLOCK XLXI_905 inv
            PIN I XLXN_1490
            PIN O TestLED
        END BLOCK
    END NETLIST
    BEGIN SHEET 1 7040 5440
        BEGIN BRANCH F_MISO
            WIRE 256 1296 1056 1296
            WIRE 1056 1296 1056 1456
        END BRANCH
        BEGIN BRANCH XLXN_892(3:0)
            WIRE 304 2080 464 2080
            WIRE 464 2032 464 2080
            WIRE 464 2032 672 2032
        END BRANCH
        BEGIN BRANCH F_MOSI
            WIRE 272 1712 528 1712
            WIRE 528 1712 672 1712
            WIRE 528 1712 528 2480
            WIRE 528 2480 672 2480
        END BRANCH
        BEGIN BRANCH F_DS
            WIRE 272 1520 576 1520
            WIRE 576 1520 672 1520
            WIRE 576 1520 576 2288
            WIRE 576 2288 672 2288
        END BRANCH
        BEGIN BRANCH F_SCK
            WIRE 272 1648 544 1648
            WIRE 544 1648 672 1648
            WIRE 544 1648 544 2416
            WIRE 544 2416 672 2416
        END BRANCH
        BEGIN BRANCH F_RS
            WIRE 272 1584 560 1584
            WIRE 560 1584 672 1584
            WIRE 560 1584 560 2352
            WIRE 560 2352 672 2352
        END BRANCH
        BEGIN BRANCH XLXN_917(31:0)
            WIRE 304 1968 672 1968
        END BRANCH
        BEGIN INSTANCE XLXI_838 672 2064 R0
        END INSTANCE
        BEGIN BRANCH XLXN_1087(3:0)
            WIRE 320 2544 672 2544
        END BRANCH
        BEGIN BRANCH LC_DATA(31:0)
            WIRE 1056 2480 1680 2480
            WIRE 1680 2480 1680 2816
            WIRE 1680 2816 1872 2816
            WIRE 1872 2816 2240 2816
            BEGIN DISPLAY 1872 2816 ATTR Name
                ALIGNMENT SOFT-BCENTER
            END DISPLAY
        END BRANCH
        BEGIN BRANCH XLXN_1096(18:0)
            WIRE 1664 2624 2240 2624
        END BRANCH
        BEGIN BRANCH LC_WEN
            WIRE 1664 2752 1872 2752
            WIRE 1872 2752 2240 2752
            BEGIN DISPLAY 1872 2752 ATTR Name
                ALIGNMENT SOFT-BCENTER
            END DISPLAY
        END BRANCH
        BEGIN INSTANCE XLXI_341 160 2048 R0
        END INSTANCE
        BEGIN INSTANCE XLXI_759 160 1936 R0
        END INSTANCE
        BEGIN BRANCH P_ADDR(15:0)
            WIRE 2000 1856 2080 1856
            WIRE 2080 1856 2080 2336
            WIRE 2080 1312 2080 1360
            WIRE 2080 1360 2080 1856
        END BRANCH
        BEGIN INSTANCE XLXI_866 1568 1952 R0
        END INSTANCE
        BEGIN BRANCH P_RD_N
            WIRE 2000 1792 2224 1792
            WIRE 2224 1792 2224 1984
            WIRE 2224 1984 2224 2304
            WIRE 2224 2304 2240 2304
            BEGIN DISPLAY 2224 1984 ATTR Name
                ALIGNMENT SOFT-TVCENTER
            END DISPLAY
        END BRANCH
        BEGIN BRANCH P_WR_N
            WIRE 2000 1728 2176 1728
            WIRE 2176 1728 2176 1984
            WIRE 2176 1984 2176 2368
            WIRE 2176 2368 2240 2368
            BEGIN DISPLAY 2176 1984 ATTR Name
                ALIGNMENT SOFT-TVCENTER
            END DISPLAY
        END BRANCH
        BEGIN BRANCH P_ADDR(18:0)
            WIRE 1984 2432 2080 2432
            WIRE 2080 2432 2240 2432
            BEGIN DISPLAY 1984 2432 ATTR Name
                ALIGNMENT SOFT-RIGHT
            END DISPLAY
        END BRANCH
        BUSTAP 2080 2432 2080 2336
        BEGIN BRANCH WEN
            WIRE 2752 2752 3408 2752
        END BRANCH
        BEGIN BRANCH VRAM_A(18:0)
            WIRE 2752 2624 3408 2624
        END BRANCH
        BEGIN BRANCH OEN
            WIRE 2752 2688 3408 2688
        END BRANCH
        BEGIN BRANCH VRAM_D(7:0)
            WIRE 2752 2816 3392 2816
        END BRANCH
        BEGIN BRANCH XLXN_1180(7:0)
            WIRE 1536 1920 1536 2064
            WIRE 1536 2064 2832 2064
            WIRE 2832 2064 2832 2496
            WIRE 1536 1920 1568 1920
            WIRE 2752 2496 2832 2496
        END BRANCH
        BEGIN BRANCH P_ADDR(11:0)
            WIRE 2176 1360 2464 1360
            WIRE 2464 1360 2944 1360
            BEGIN DISPLAY 2464 1360 ATTR Name
                ALIGNMENT SOFT-BCENTER
            END DISPLAY
        END BRANCH
        BUSTAP 2080 1360 2176 1360
        BEGIN INSTANCE XLXI_879 2944 1584 R0
        END INSTANCE
        BEGIN BRANCH hs_out
            WIRE 3328 1488 3552 1488
        END BRANCH
        INSTANCE XLXI_833 304 1200 R0
        BEGIN BRANCH ClkIn
            WIRE 256 1168 304 1168
        END BRANCH
        BEGIN BRANCH XLXN_1196(7:0)
            WIRE 2752 3072 2864 3072
            WIRE 2864 1488 2864 3072
            WIRE 2864 1488 2944 1488
        END BRANCH
        BEGIN BRANCH XLXN_1197(7:0)
            WIRE 2752 3136 2896 3136
            WIRE 2896 1552 2896 3136
            WIRE 2896 1552 2944 1552
        END BRANCH
        BEGIN BRANCH KBD_DWN
            WIRE 1072 3008 2240 3008
        END BRANCH
        BEGIN BRANCH XLXN_1239
            WIRE 1072 3072 2240 3072
        END BRANCH
        BEGIN BRANCH XLXN_1168(7:0)
            WIRE 2000 1920 2128 1920
            WIRE 2128 1920 2128 2496
            WIRE 2128 2496 2240 2496
            WIRE 2128 1424 2944 1424
            WIRE 2128 1424 2128 1920
        END BRANCH
        BEGIN BRANCH XLXN_1195
            WIRE 2752 2368 2800 2368
            WIRE 2800 1296 2944 1296
            WIRE 2800 1296 2800 2368
        END BRANCH
        BEGIN INSTANCE XLXI_890 2240 3056 R0
        END INSTANCE
        BEGIN INSTANCE XLXI_865 1248 2752 R0
        END INSTANCE
        BEGIN BRANCH StartAdr(18:0)
            WIRE 1136 2816 1184 2816
            WIRE 1184 2816 1248 2816
            BEGIN DISPLAY 1136 2816 ATTR Name
                ALIGNMENT SOFT-RIGHT
            END DISPLAY
        END BRANCH
        BEGIN DISPLAY 4616 3956 TEXT "AutoIncrement Counter"
            FONT 40 "Arial"
        END DISPLAY
        BEGIN DISPLAY 4612 4036 TEXT "LC_WEN active low"
            FONT 32 "Arial"
        END DISPLAY
        BEGIN DISPLAY 4612 4116 TEXT "LC_ENA active high from 1st RAMINCR pulse"
            FONT 32 "Arial"
        END DISPLAY
        BEGIN DISPLAY 4612 4196 TEXT "(SPI SubCh 128), until CORERST (SPI SubCh 129)"
            FONT 32 "Arial"
        END DISPLAY
        BEGIN DISPLAY 4612 4276 TEXT "new LC_ADDR valid after LC_WEN ends"
            FONT 32 "Arial"
        END DISPLAY
        BEGIN DISPLAY 4608 4388 TEXT "RAMD valid before RAMINCR pulse"
            FONT 32 "Arial"
        END DISPLAY
        BEGIN BRANCH DAC_MPX
            WIRE 4704 3488 4704 3504
            WIRE 4704 3504 4784 3504
        END BRANCH
        BEGIN BRANCH DAC_WR
            WIRE 4704 3664 4704 3680
            WIRE 4704 3680 4784 3680
        END BRANCH
        BEGIN BRANCH DAC_CLK
            WIRE 4704 3824 4704 3840
            WIRE 4704 3840 4784 3840
        END BRANCH
        INSTANCE XLXI_831 4640 3488 R0
        INSTANCE XLXI_882 4640 3664 R0
        INSTANCE XLXI_883 4640 3824 R0
        BEGIN BRANCH XLXN_1283
            WIRE 3120 2032 3120 2080
            WIRE 3120 2080 3152 2080
        END BRANCH
        INSTANCE XLXI_903 3152 2272 R0
        INSTANCE XLXI_904 3056 2032 R0
        BEGIN BRANCH vs_out
            WIRE 3040 1664 3376 1664
            WIRE 3040 1664 3040 2144
            WIRE 3040 2144 3152 2144
            WIRE 3328 1552 3376 1552
            WIRE 3376 1552 3552 1552
            WIRE 3376 1552 3376 1664
        END BRANCH
        BEGIN BRANCH SYSCLK
            WIRE 528 1168 592 1168
            WIRE 592 1168 592 1456
            WIRE 592 1456 672 1456
            WIRE 592 1456 592 2224
            WIRE 592 2224 592 2624
            WIRE 592 2624 896 2624
            WIRE 896 2624 1248 2624
            WIRE 592 2624 592 3072
            WIRE 592 3072 656 3072
            WIRE 592 2224 672 2224
            WIRE 592 1168 1488 1168
            WIRE 1488 1168 1488 1856
            WIRE 1488 1856 1568 1856
            WIRE 1488 1856 1488 2240
            WIRE 1488 2240 2240 2240
            WIRE 1488 1168 2048 1168
            WIRE 2048 1168 2944 1168
            WIRE 1488 768 1488 1168
            WIRE 1488 768 1664 768
            BEGIN DISPLAY 896 2624 ATTR Name
                ALIGNMENT SOFT-BCENTER
            END DISPLAY
            BEGIN DISPLAY 2048 1168 ATTR Name
                ALIGNMENT SOFT-BCENTER
            END DISPLAY
        END BRANCH
        BEGIN BRANCH PS2_Clk
            WIRE 336 3200 656 3200
        END BRANCH
        BEGIN BRANCH PS2_Data
            WIRE 336 3264 656 3264
        END BRANCH
        BEGIN INSTANCE XLXI_884 656 3296 R0
        END INSTANCE
        BEGIN BRANCH PS2code(7:0)
            WIRE 1072 3136 1648 3136
            WIRE 1648 3136 2240 3136
            BEGIN DISPLAY 1648 3136 ATTR Name
                ALIGNMENT SOFT-BCENTER
            END DISPLAY
        END BRANCH
        BEGIN BRANCH SPI_Key(7:0)
            WIRE 320 3792 592 3792
            BEGIN DISPLAY 320 3792 ATTR Name
                ALIGNMENT SOFT-RIGHT
            END DISPLAY
        END BRANCH
        BEGIN BRANCH XLXN_1331
            WIRE 528 3744 528 3856
            WIRE 528 3856 592 3856
            WIRE 528 3856 528 3984
            WIRE 528 3984 592 3984
        END BRANCH
        BEGIN BRANCH XLXN_1353
            WIRE 912 3920 976 3920
        END BRANCH
        BEGIN BRANCH XLXN_1356
            WIRE 1360 3920 1408 3920
        END BRANCH
        BEGIN BRANCH KeyRate15Hz
            WIRE 528 4048 592 4048
            WIRE 528 4048 528 4208
            WIRE 528 4208 960 4208
            WIRE 960 4208 1376 4208
            WIRE 1376 4208 1616 4208
            WIRE 1616 4208 3712 4208
            WIRE 960 4048 976 4048
            WIRE 960 4048 960 4208
            WIRE 1376 3984 1408 3984
            WIRE 1376 3984 1376 4208
            WIRE 3536 1888 3664 1888
            WIRE 3664 1888 3712 1888
            WIRE 3712 1888 3712 4208
            BEGIN DISPLAY 1616 4208 ATTR Name
                ALIGNMENT SOFT-BCENTER
            END DISPLAY
            BEGIN DISPLAY 3664 1888 ATTR Name
                ALIGNMENT SOFT-BCENTER
            END DISPLAY
        END BRANCH
        BEGIN INSTANCE XLXI_896 592 3712 R0
        END INSTANCE
        INSTANCE XLXI_923 976 4176 R0
        INSTANCE XLXI_920 1408 3856 M180
        BEGIN BRANCH XLXN_1268(7:0)
            WIRE 912 3792 2016 3792
            WIRE 2016 3264 2016 3792
            WIRE 2016 3264 2240 3264
        END BRANCH
        BEGIN BRANCH SPI_KeyStrobe
            WIRE 320 3920 592 3920
            BEGIN DISPLAY 320 3920 ATTR Name
                ALIGNMENT SOFT-RIGHT
            END DISPLAY
        END BRANCH
        INSTANCE XLXI_915 464 3744 R0
        BEGIN BRANCH XLXN_1267
            WIRE 1072 3264 1328 3264
        END BRANCH
        BEGIN BRANCH CPU_RST
            WIRE 1584 3296 1648 3296
            BEGIN DISPLAY 1648 3296 ATTR Name
                ALIGNMENT SOFT-LEFT
            END DISPLAY
        END BRANCH
        INSTANCE XLXI_894 1328 3392 R0
        BEGIN BRANCH XLXN_1334
            WIRE 1664 3952 2080 3952
            WIRE 2080 3328 2240 3328
            WIRE 2080 3328 2080 3952
        END BRANCH
        BEGIN BRANCH ComRx(7:0)
            WIRE 1920 3456 2240 3456
            BEGIN DISPLAY 1920 3456 ATTR Name
                ALIGNMENT SOFT-RIGHT
            END DISPLAY
        END BRANCH
        BEGIN BRANCH SPI_Key(31:0)
            WIRE 1056 1968 1152 1968
            BEGIN DISPLAY 1152 1968 ATTR Name
                ALIGNMENT SOFT-LEFT
            END DISPLAY
        END BRANCH
        BEGIN INSTANCE XLXI_850 672 2576 R0
        END INSTANCE
        BEGIN BRANCH XLXN_1145
            WIRE 1056 2416 1136 2416
            WIRE 1136 2416 1136 2752
            WIRE 1136 2752 1248 2752
        END BRANCH
        BEGIN INSTANCE XLXI_853 176 2512 R0
        END INSTANCE
        BUSTAP 1184 2816 1184 2720
        BEGIN BRANCH StartAdr(15:8)
            WIRE 1056 2352 1184 2352
            WIRE 1184 2352 1184 2384
            WIRE 1184 2384 1184 2720
            BEGIN DISPLAY 1184 2384 ATTR Name
                ALIGNMENT SOFT-TVCENTER
            END DISPLAY
        END BRANCH
        IOMARKER 272 1712 F_MOSI R180 28
        IOMARKER 272 1520 F_DS R180 28
        IOMARKER 272 1648 F_SCK R180 28
        IOMARKER 272 1584 F_RS R180 28
        IOMARKER 256 1296 F_MISO R180 28
        IOMARKER 256 1168 ClkIn R180 28
        IOMARKER 3408 2752 WEN R0 28
        IOMARKER 3408 2624 VRAM_A(18:0) R0 28
        IOMARKER 3408 2688 OEN R0 28
        IOMARKER 3392 2816 VRAM_D(7:0) R0 28
        IOMARKER 4784 3504 DAC_MPX R0 28
        IOMARKER 4784 3680 DAC_WR R0 28
        IOMARKER 4784 3840 DAC_CLK R0 28
        IOMARKER 3552 1552 vs_out R0 28
        IOMARKER 3552 1488 hs_out R0 28
        IOMARKER 336 3200 PS2_Clk R180 28
        IOMARKER 336 3264 PS2_Data R180 28
        BEGIN BRANCH SPI_KeyStrobe
            WIRE 1056 1712 1152 1712
            BEGIN DISPLAY 1152 1712 ATTR Name
                ALIGNMENT SOFT-LEFT
            END DISPLAY
        END BRANCH
        BEGIN BRANCH IRQ_Source(7:0)
            WIRE 1920 3520 2240 3520
            BEGIN DISPLAY 1920 3520 ATTR Name
                ALIGNMENT SOFT-RIGHT
            END DISPLAY
        END BRANCH
        BEGIN BRANCH ComTx(7:0)
            WIRE 2752 3456 2864 3456
            BEGIN DISPLAY 2864 3456 ATTR Name
                ALIGNMENT SOFT-LEFT
            END DISPLAY
        END BRANCH
        BEGIN DISPLAY 1640 1484 TEXT "6502 CPU"
            FONT 56 "Arial"
        END DISPLAY
        BEGIN DISPLAY 756 4312 TEXT "Keyboard Simulator"
            FONT 56 "Arial"
        END DISPLAY
        BEGIN BRANCH ComTx(31:0)
            WIRE 464 1776 672 1776
            BEGIN DISPLAY 464 1776 ATTR Name
                ALIGNMENT SOFT-RIGHT
            END DISPLAY
        END BRANCH
        BEGIN BRANCH ComRx(31:0)
            WIRE 1056 1840 1152 1840
            BEGIN DISPLAY 1152 1840 ATTR Name
                ALIGNMENT SOFT-LEFT
            END DISPLAY
        END BRANCH
        INSTANCE XLXI_961 1216 800 R0
        BEGIN BRANCH IRQ_Source(3)
            WIRE 2048 640 2080 640
            WIRE 2080 640 2080 640
            WIRE 2080 640 2176 640
            WIRE 2176 640 2176 944
            WIRE 2176 944 2336 944
            WIRE 2176 640 2352 640
            BEGIN DISPLAY 2088 640 ATTR Name
                ALIGNMENT SOFT-BCENTER
            END DISPLAY
        END BRANCH
        BEGIN BRANCH IRQ_Source(2)
            WIRE 2048 576 2080 576
            WIRE 2080 576 2080 576
            WIRE 2080 576 2208 576
            WIRE 2208 576 2208 880
            WIRE 2208 880 2336 880
            WIRE 2208 576 2352 576
            BEGIN DISPLAY 2088 576 ATTR Name
                ALIGNMENT SOFT-BCENTER
            END DISPLAY
        END BRANCH
        BEGIN BRANCH IRQ_Source(1)
            WIRE 2048 512 2080 512
            WIRE 2080 512 2080 512
            WIRE 2080 512 2240 512
            WIRE 2240 512 2352 512
            WIRE 2240 512 2240 816
            WIRE 2240 816 2336 816
            BEGIN DISPLAY 2088 512 ATTR Name
                ALIGNMENT SOFT-BCENTER
            END DISPLAY
        END BRANCH
        BEGIN BRANCH IRQ_Source(0)
            WIRE 2048 448 2080 448
            WIRE 2080 448 2080 448
            WIRE 2080 448 2272 448
            WIRE 2272 448 2352 448
            WIRE 2272 448 2272 752
            WIRE 2272 752 2336 752
            BEGIN DISPLAY 2088 448 ATTR Name
                ALIGNMENT SOFT-BCENTER
            END DISPLAY
        END BRANCH
        BEGIN BRANCH red_out
            WIRE 3328 1168 3552 1168
        END BRANCH
        BEGIN BRANCH green_out
            WIRE 3328 1232 3552 1232
        END BRANCH
        BEGIN BRANCH blue_out
            WIRE 3328 1296 3552 1296
        END BRANCH
        IOMARKER 3552 1168 red_out R0 28
        IOMARKER 3552 1232 green_out R0 28
        IOMARKER 3552 1296 blue_out R0 28
        BEGIN BRANCH PreStrobe0
            WIRE 1056 2064 1120 2064
            WIRE 1120 448 1360 448
            WIRE 1360 448 1664 448
            WIRE 1120 448 1120 736
            WIRE 1120 736 1216 736
            WIRE 1120 736 1120 2064
            BEGIN DISPLAY 1360 448 ATTR Name
                ALIGNMENT SOFT-BCENTER
            END DISPLAY
        END BRANCH
        BEGIN BRANCH Strobe1
            WIRE 1056 1584 1088 1584
            WIRE 1088 512 1360 512
            WIRE 1360 512 1664 512
            WIRE 1088 512 1088 672
            WIRE 1088 672 1216 672
            WIRE 1088 672 1088 1584
            BEGIN DISPLAY 1360 512 ATTR Name
                ALIGNMENT SOFT-BCENTER
            END DISPLAY
        END BRANCH
        IOMARKER 3424 3712 F_Int R0 28
        BEGIN BRANCH ComEna(7:0)
            WIRE 2752 3520 2816 3520
            WIRE 2816 3520 2864 3520
            BEGIN DISPLAY 2864 3520 ATTR Name
                ALIGNMENT SOFT-LEFT
            END DISPLAY
        END BRANCH
        INSTANCE XLXI_963 2864 3840 R0
        BEGIN BRANCH ComEna(0)
            WIRE 2816 3616 2816 3680
            WIRE 2816 3680 2816 3808
            WIRE 2816 3808 2864 3808
            BEGIN DISPLAY 2816 3680 ATTR Name
                ALIGNMENT SOFT-TVCENTER
            END DISPLAY
        END BRANCH
        BUSTAP 2816 3520 2816 3616
        BEGIN BRANCH CPU_RST
            WIRE 816 976 1152 976
            WIRE 1152 976 1424 976
            WIRE 1424 976 1424 1664
            WIRE 1424 1664 1568 1664
            WIRE 1424 1664 1424 2176
            WIRE 1424 2176 2240 2176
            WIRE 1152 896 1216 896
            WIRE 1152 896 1152 976
            BEGIN DISPLAY 816 976 ATTR Name
                ALIGNMENT SOFT-RIGHT
            END DISPLAY
        END BRANCH
        BEGIN BRANCH XLXN_1485
            WIRE 1472 704 1664 704
        END BRANCH
        BEGIN BRANCH IRQ_Source(7:0)
            WIRE 2448 400 2448 448
            WIRE 2448 448 2448 512
            WIRE 2448 512 2448 544
            WIRE 2448 544 2448 576
            WIRE 2448 576 2448 640
            WIRE 2448 640 2448 688
            BEGIN DISPLAY 2448 544 ATTR Name
                ALIGNMENT SOFT-TVCENTER
            END DISPLAY
        END BRANCH
        BUSTAP 2448 640 2352 640
        BUSTAP 2448 576 2352 576
        BUSTAP 2448 512 2352 512
        BUSTAP 2448 448 2352 448
        INSTANCE XLXI_964 2336 1008 R0
        BEGIN DISPLAY 1652 944 TEXT "IRQ Source Latch"
            FONT 56 "Arial"
        END DISPLAY
        BEGIN DISPLAY 696 3620 TEXT "PS2 Keyboard Interface"
            FONT 56 "Arial"
        END DISPLAY
        INSTANCE XLXI_966 336 3040 R0
        BEGIN BRANCH XLXN_1492
            WIRE 560 3008 656 3008
        END BRANCH
        BEGIN BRANCH LC_ENA
            WIRE 1264 2944 2112 2944
            WIRE 1264 2944 1264 3328
            WIRE 1264 3328 1328 3328
            WIRE 1664 2688 1872 2688
            WIRE 1872 2688 2112 2688
            WIRE 2112 2688 2240 2688
            WIRE 2112 2688 2112 2944
            BEGIN DISPLAY 1872 2688 ATTR Name
                ALIGNMENT SOFT-BCENTER
            END DISPLAY
        END BRANCH
        BEGIN BRANCH XLXN_1494
            WIRE 304 2688 304 3008
            WIRE 304 3008 336 3008
            WIRE 304 2688 1232 2688
            WIRE 1232 2688 1248 2688
            WIRE 1056 2288 1232 2288
            WIRE 1232 2288 1232 2688
        END BRANCH
        INSTANCE XLXI_967 2560 1136 M0
        BEGIN BRANCH XLXN_1490
            WIRE 1552 1040 2304 1040
            WIRE 1552 1040 1552 1248
            WIRE 1552 1248 1552 1728
            WIRE 1552 1728 1568 1728
            WIRE 1552 1248 1632 1248
        END BRANCH
        BEGIN BRANCH XLXN_1496
            WIRE 2560 1008 2608 1008
            WIRE 2592 848 2608 848
            WIRE 2608 848 2608 1008
        END BRANCH
        BEGIN BRANCH ComEna(2)
            WIRE 2560 1072 2656 1072
            BEGIN DISPLAY 2656 1072 ATTR Name
                ALIGNMENT SOFT-LEFT
            END DISPLAY
        END BRANCH
        BEGIN BRANCH ComEna(1)
            WIRE 832 832 1216 832
            BEGIN DISPLAY 832 832 ATTR Name
                ALIGNMENT SOFT-RIGHT
            END DISPLAY
        END BRANCH
        INSTANCE XLXI_968 1216 960 R0
        BEGIN BRANCH XLXN_1498
            WIRE 1472 864 1664 864
        END BRANCH
        INSTANCE XLXI_969 1664 896 R0
        BEGIN BRANCH F_Int
            WIRE 3088 3808 3104 3808
            WIRE 3104 3712 3280 3712
            WIRE 3280 3712 3424 3712
            WIRE 3104 3712 3104 3808
            BEGIN DISPLAY 3280 3712 ATTR Name
                ALIGNMENT SOFT-BCENTER
            END DISPLAY
        END BRANCH
        BEGIN BRANCH TestLED
            WIRE 1856 1248 1904 1248
        END BRANCH
        INSTANCE XLXI_905 1632 1280 R0
        IOMARKER 1904 1248 TestLED R0 28
        BEGIN DISPLAY 2376 2004 TEXT "Glue Logic"
            FONT 56 "Arial"
        END DISPLAY
    END SHEET
END SCHEMATIC
