--
-- AutoIncrement-Adresszhler mit LC_WEN-Erzeugung
--
-- Generated by KCPSM3 Assembler 25Jan2009-15:35:03. 
--
-- Standard IEEE libraries
--
library ieee;
  use ieee.std_logic_1164.all;
  use ieee.std_logic_unsigned.all;
  use ieee.numeric_std.all;
--
-- The Unisim Library is used to define Xilinx primitives. It is also used during
-- simulation. The source can be viewed at %XILINX%\vhdl\src\unisims\unisim_VCOMP.vhd
--  
--library unisim;
--use unisim.vcomponents.all;
--
--
entity COUNT_LC is
    Port (	LC_ADDR : out std_logic_vector(18 downto 0);
				SYSCLK : in std_logic;
				CORERST : in std_logic;
				RAMINCR : in std_logic;
				START: in std_logic_vector(18 downto 0);
				LC_ENA : out std_logic;
				LC_WEN : out std_logic
			); 
    end COUNT_LC;

architecture behave of COUNT_LC is

signal 		delay_count	: std_logic_vector (2 downto 0 );
signal 		addr_count	: std_logic_vector (18 downto 0);
signal 		write_ena 	: std_logic;
signal 		lcinc_del 	: std_logic;

begin
	LC_ADDR <= addr_count;
	LC_WEN <= not write_ena;

	addr_counter : process (write_ena, CORERST )
	-- Adresszhler fr Auto-Increment
	begin
		if CORERST = '1' then
			addr_count <= START;
		elsif (write_ena'event and write_ena = '0') then
			addr_count<= addr_count+1;
		end if;
	end process;
		
	write_pulse : process (RAMINCR,SYSCLK,CORERST)
	-- Schreibimpuls fr langsames SRAM auf 80 ns verlngern 
	begin
		if CORERST = '1' then
			write_ena <= '0';
			delay_count <= (others =>'0');
			LC_ENA<='0';
		else
			if (SYSCLK'event and SYSCLK = '1') then
				lcinc_del<=RAMINCR; -- zustzliche Setup-Zeit
				if (RAMINCR ='1') then -- Counter-Freigabe sofort
					LC_ENA<='1';
				end if;
				if (write_ena='1') or (lcinc_del ='1') then -- Impuls und Zhler starten
					if delay_count(2) = '1' then
						write_ena <= '0';				
						delay_count <= (others =>'0');
					else
						write_ena <= '1';				
						delay_count <= delay_count+1;
					end if;
				end if;
			end if;		
		end if;
	end process;

end behave;
