-- 65C02 Core Wrapper
-- 09.12.2009 kommt bis jetzt nur bis zur BASIC-Statuszeile. IRQ/NMI-Fehler?


library ieee;
  use ieee.std_logic_1164.all;
  use ieee.std_logic_arith.all;
  use ieee.std_logic_unsigned.all;
library unisim;
use unisim.vcomponents.all;


entity r65c02_wrap is
  port (
    ADDR         : out   std_logic_vector(15 downto 0);
    DATA_O       : out   std_logic_vector(7 downto 0);
    DATA_I       : in   std_logic_vector(7 downto 0);
    --
    RST          : in    std_logic;
    IRQ          : in    std_logic;
    NMI          : in    std_logic;
	WR_N         : out    std_logic;
	BUSENA_N     : out    std_logic;
--	SYNC     : out    std_logic;
    HALT         : in    std_logic;
    HALTED       : out    std_logic;
    RD_N         : out    std_logic;
--    CLK_OUT       : out    std_logic;
    SYSCLK       : in    std_logic
    );
end;


architecture RTL of r65c02_wrap is

	signal clk_count		: std_logic_vector(3 downto 0) := (others => '0');

  -- cpu
	signal wr_intern		: std_logic:='1';
	signal rd_intern		: std_logic:='1';
	signal c_irq_l			: std_logic:='1';
	signal c_nmi_l			: std_logic:='1';
	signal reset_l			: std_logic:='1';
	signal busena_late		: std_logic;
	signal busena_early		: std_logic;
	signal clk_i			: std_logic;
	signal clk_cpu			: std_logic;
	signal sync_i			: std_logic;
	signal halt_del			: std_logic;
	signal addr_intern		: std_logic_vector(15 downto 0) := (others => '0');
	signal DATA_O_intern	: std_logic_vector(7 downto 0) := (others => '0');


	component core is
	port( 
		clk_clk_i   : in     std_logic;
		d_i         : in     std_logic_vector (7 downto 0);
		irq_n_i     : in     std_logic;
		nmi_n_i     : in     std_logic;
		rdy_i       : in     std_logic;
		rst_rst_n_i : in     std_logic;
		so_n_i      : in     std_logic;
		a_o         : out    std_logic_vector (15 downto 0);
		d_o         : out    std_logic_vector (7 downto 0);
		rd_o        : out    std_logic;
		sync_o      : out    std_logic;
		wr_o        : out    std_logic
	);
	end component;
	
	

begin

ADDR <= addr_intern;
DATA_O <= DATA_O_intern;

p_wait : process(clk_i,RST)  -- sync delay
	begin
		if RST='1' then
			halt_del<='0';
		elsif rising_edge(clk_i) then
-- HALT sync fr DMA-Zugriff
			halt_del <= HALT;
		end if;
	end process;

p_clk : process(SYSCLK)  -- clock divider for slow IO $0600
	begin
		if rising_edge(SYSCLK) then
			clk_count <= clk_count + 1;
			clk_i<=clk_count(1);
			if halt_del='0' then
				clk_cpu<= clk_count(1);
				busena_late<= clk_count(1);
				busena_early<= clk_count(1) xor clk_count(0);
			else
				busena_late<= '1';
				busena_early<= '1';
				clk_cpu<= '0';
			end if;
		end if;
	end process;

--p_del : process(SYSCLK,RST)  -- clock divider and delay
--	begin
--		if RST='1' then
--
--		elsif rising_edge(SYSCLK) then
--			if halt_del = '0' then	-- 
--				ADDR <= addr_intern;	-- um 1 SYSCLK verzgert fr SRAM Data Hold Time
--				DATA_O <= DATA_O_intern;
--			end if;
--		end if;
--	end process;


  cpu : core -- main cpu
      port map (
          rst_rst_n_i   => reset_l,
          clk_clk_i     => clk_cpu,
          rdy_i     => '1', -- not halt_i,
          irq_n_i   => c_irq_l,
          nmi_n_i   => c_nmi_l,
          so_n_i    => '1',
          wr_o   => wr_intern,
          rd_o   => rd_intern,
          sync_o    => sync_i,
          a_o  => addr_intern,
          d_i      => DATA_I,
          d_o      => DATA_O_intern
      );
		
	HALTED<= halt_del and HALT;
	c_irq_l <= not IRQ;
	c_nmi_l <= not NMI;
	WR_N <= (not wr_intern) or busena_early;
	RD_N <= (not rd_intern) or busena_late; -- RD_N <= (not rd_intern) or busclk_i  ...
	reset_l <= not RST;
	BUSENA_N <= busena_late;

end RTL;
