#!/usr/bin/ruby 

# Translate PSF (PostScript Font) files to XilinX COE file format 
# for embbed a console font into a ROM (Xilinx read-only BRAM)
#
# 2007 Javier Valcarce Garca, <javier.valcarce@gmail.com>
# $Id$

# Read header and retrieve font information
# Read the data
# Write the COE file

$i_filename = ARGV[0]
$o_filename = "output.coe"
if ARGV.length == 0
  puts "Usage: psf2coe file.psf"
  exit
end

str = IO.read($i_filename)

# Header
magic = str[0..1].unpack('H4')[0]
fmode = str[2].to_i
heigh = str[3].to_i
width = 8
pdata = str[4..str.length]

# Check magic numbers hdr[0]
if magic == "3604"
  puts "Format : PSF1"
  puts "Mode   : " + fmode.to_s
  puts "Width  : 8 pixels"
  puts "Heigh  : " + heigh.to_s + " pixels"
else 
  puts "I only understand PSF1 format file. Sorry"
  exit
end

# Write COE file
File.open($o_filename, "w") do |file|
  
  file.puts <<END_OF_STRING
; DO NOT EDIT THIS FILE BY HAND
; This file has been generated automaticaly by psf2coe utility.
; Original file: #{$i_filename}

  memory_initialization_radix  = 16;
  memory_initialization_vector =
END_OF_STRING
    
  # there is exactly 256 caracters in the file
  (256 * heigh).times do |i| 
    file.puts sprintf("%02X\n", pdata[i]) 
  end
  
  file.puts "; END"
end

puts "DONE."
