VERSION 6
BEGIN SCHEMATIC
    BEGIN ATTR DeviceFamilyName "spartan3"
        DELETE all:0
        EDITNAME all:0
        EDITTRAIT all:0
    END ATTR
    BEGIN NETLIST
        SIGNAL XLXN_892(3:0)
        SIGNAL F_MOSI
        SIGNAL F_DS
        SIGNAL F_SCK
        SIGNAL F_RS
        SIGNAL XLXN_917(31:0)
        SIGNAL LC_DATA(31:0)
        SIGNAL LC_ADR(18:0)
        SIGNAL LC_WEN
        SIGNAL P_ADDR(15:0)
        SIGNAL P_RD_N
        SIGNAL P_WR_N
        SIGNAL WEN
        SIGNAL VRAM_A(18:0)
        SIGNAL OEN
        SIGNAL VRAM_D(7:0)
        SIGNAL XLXN_1180(7:0)
        SIGNAL P_ADDR(11:0)
        SIGNAL ClkIn
        SIGNAL KBD_DWN
        SIGNAL XLXN_1239
        SIGNAL CPU_Do(7:0)
        SIGNAL LCDFRAME
        SIGNAL SYSCLK
        SIGNAL PS2_Clk
        SIGNAL PS2_Data
        SIGNAL PS2code(7:0)
        SIGNAL SPI_Key(7:0)
        SIGNAL SPI_KeyStrobe
        SIGNAL LC_ENA
        SIGNAL XLXN_1267
        SIGNAL CPU_RST
        SIGNAL ComRx(7:0)
        SIGNAL SPI_Key(31:0)
        SIGNAL ComRx(31:0)
        SIGNAL Strobe1
        SIGNAL IRQ_Source(7:0)
        SIGNAL ComTx(31:24)
        SIGNAL ComTx(31:0)
        SIGNAL F_Int
        SIGNAL ComEna(7:0)
        SIGNAL XLXN_1490
        SIGNAL XLXN_1492
        SIGNAL Strobe2
        SIGNAL IRQ_Source(3:0)
        SIGNAL IRQ_CLR
        SIGNAL IRQ_ACK
        SIGNAL F_MISO
        SIGNAL RAMD_RD(31:24)
        SIGNAL RAMD_RD(31:0)
        SIGNAL XLXN_1561
        SIGNAL LC_OEN
        SIGNAL PS2code(31:0)
        SIGNAL XLXN_1586
        SIGNAL LC_ADR(15)
        SIGNAL LC_ADR(14)
        SIGNAL XLXN_1585
        SIGNAL XLXN_1591
        SIGNAL XLXN_1592
        SIGNAL XLXN_1639(7:0)
        SIGNAL XLXN_1640
        SIGNAL XLXN_1641
        SIGNAL XLXN_1642
        SIGNAL XLXN_1645
        SIGNAL XLXN_1648
        SIGNAL XLXN_1650
        SIGNAL XLXN_1652
        SIGNAL ComEna(0)
        SIGNAL XLXN_1711
        SIGNAL XLXN_1712
        SIGNAL XLXN_1713
        SIGNAL IRQ_Source(7)
        SIGNAL TestLED
        SIGNAL IO600_Rdn
        SIGNAL IO600_WRn
        SIGNAL LCDDATA(3:0)
        SIGNAL LCDLOAD
        SIGNAL LCDCLK
        SIGNAL LCDON
        SIGNAL vsync
        SIGNAL Opto_Rx
        SIGNAL Opto_Tx
        SIGNAL XLXN_1723
        SIGNAL XLXN_1724
        SIGNAL Serial_Tx
        SIGNAL Serial_Rx
        SIGNAL XLXN_1727
        SIGNAL XLXN_1728(2:0)
        PORT Input F_MOSI
        PORT Input F_DS
        PORT Input F_SCK
        PORT Input F_RS
        PORT Output WEN
        PORT Output VRAM_A(18:0)
        PORT Output OEN
        PORT BiDirectional VRAM_D(7:0)
        PORT Input ClkIn
        PORT Output LCDFRAME
        PORT Input PS2_Clk
        PORT Input PS2_Data
        PORT Output F_Int
        PORT Output F_MISO
        PORT Output TestLED
        PORT Output IO600_Rdn
        PORT Output IO600_WRn
        PORT Output LCDDATA(3:0)
        PORT Output LCDLOAD
        PORT Output LCDCLK
        PORT Output LCDON
        PORT Input Opto_Rx
        PORT Output Opto_Tx
        PORT Output Serial_Tx
        PORT Input Serial_Rx
        BEGIN BLOCKDEF constant
            TIMESTAMP 2006 1 1 10 10 10
            RECTANGLE N 0 0 112 64 
            LINE N 144 32 112 32 
        END BLOCKDEF
        BEGIN BLOCKDEF ibufg
            TIMESTAMP 2000 1 1 10 10 10
            LINE N 64 0 64 -64 
            LINE N 128 -32 64 0 
            LINE N 64 -64 128 -32 
            LINE N 224 -32 128 -32 
            LINE N 0 -32 64 -32 
        END BLOCKDEF
        BEGIN BLOCKDEF inv
            TIMESTAMP 2000 1 1 10 10 10
            LINE N 0 -32 64 -32 
            LINE N 224 -32 160 -32 
            LINE N 64 -64 128 -32 
            LINE N 128 -32 64 0 
            LINE N 64 0 64 -64 
            CIRCLE N 128 -48 160 -16 
        END BLOCKDEF
        BEGIN BLOCKDEF ps2kbd
            TIMESTAMP 2009 2 23 21 5 14
            RECTANGLE N 64 -320 352 0 
            LINE N 64 -288 0 -288 
            LINE N 64 -224 0 -224 
            LINE N 64 -96 0 -96 
            LINE N 64 -32 0 -32 
            LINE N 352 -288 416 -288 
            LINE N 352 -224 416 -224 
            LINE N 352 -32 416 -32 
            RECTANGLE N 352 -172 416 -148 
            LINE N 352 -160 416 -160 
        END BLOCKDEF
        BEGIN BLOCKDEF or2
            TIMESTAMP 2000 1 1 10 10 10
            LINE N 0 -64 64 -64 
            LINE N 0 -128 64 -128 
            LINE N 256 -96 192 -96 
            ARC N 28 -224 204 -48 112 -48 192 -96 
            ARC N -40 -152 72 -40 48 -48 48 -144 
            LINE N 112 -144 48 -144 
            ARC N 28 -144 204 32 192 -96 112 -144 
            LINE N 112 -48 48 -48 
        END BLOCKDEF
        BEGIN BLOCKDEF buf
            TIMESTAMP 2000 1 1 10 10 10
            LINE N 0 -32 64 -32 
            LINE N 224 -32 128 -32 
            LINE N 64 0 128 -32 
            LINE N 128 -32 64 -64 
            LINE N 64 -64 64 0 
        END BLOCKDEF
        BEGIN BLOCKDEF IRQ_latch
            TIMESTAMP 2009 3 1 9 14 23
            LINE N 64 32 0 32 
            LINE N 64 -352 0 -352 
            LINE N 64 -288 0 -288 
            LINE N 64 -224 0 -224 
            LINE N 64 -160 0 -160 
            LINE N 64 -96 0 -96 
            LINE N 64 -32 0 -32 
            RECTANGLE N 320 -364 384 -340 
            LINE N 320 -352 384 -352 
            LINE N 320 -32 384 -32 
            RECTANGLE N 64 -384 320 64 
        END BLOCKDEF
        BEGIN BLOCKDEF SPI_LRC
            TIMESTAMP 2009 6 9 14 35 58
            RECTANGLE N 384 -108 448 -84 
            LINE N 384 -96 448 -96 
            RECTANGLE N 384 -44 448 -20 
            LINE N 384 -32 448 -32 
            LINE N 384 -992 448 -992 
            RECTANGLE N 384 -684 448 -660 
            LINE N 384 -672 448 -672 
            RECTANGLE N 384 -620 448 -596 
            LINE N 384 -608 448 -608 
            RECTANGLE N 384 -556 448 -532 
            LINE N 384 -544 448 -544 
            RECTANGLE N 384 -492 448 -468 
            LINE N 384 -480 448 -480 
            LINE N 384 -928 448 -928 
            LINE N 384 -864 448 -864 
            LINE N 384 -800 448 -800 
            LINE N 384 -736 448 -736 
            RECTANGLE N 0 -1024 384 0 
            LINE N 384 -160 448 -160 
            LINE N 384 -224 448 -224 
            RECTANGLE N 384 -300 448 -276 
            LINE N 384 -288 448 -288 
            LINE N 384 -352 448 -352 
            LINE N 0 -992 -64 -992 
            LINE N 0 -928 -64 -928 
            LINE N 0 -864 -64 -864 
            LINE N 0 -800 -64 -800 
            LINE N 0 -736 -64 -736 
            RECTANGLE N -64 -684 0 -660 
            LINE N 0 -672 -64 -672 
            RECTANGLE N -64 -620 0 -596 
            LINE N 0 -608 -64 -608 
            RECTANGLE N -64 -556 0 -532 
            LINE N 0 -544 -64 -544 
            RECTANGLE N -64 -492 0 -468 
            LINE N 0 -480 -64 -480 
            RECTANGLE N -64 -428 0 -404 
            LINE N 0 -416 -64 -416 
            RECTANGLE N -64 -108 0 -84 
            LINE N 0 -96 -64 -96 
        END BLOCKDEF
        BEGIN BLOCKDEF BASIC_glue
            TIMESTAMP 2009 9 25 6 22 48
            LINE N 448 592 512 592 
            LINE N 448 656 512 656 
            RECTANGLE N 448 708 512 732 
            LINE N 448 720 512 720 
            RECTANGLE N 448 772 512 796 
            LINE N 448 784 512 784 
            RECTANGLE N 448 836 512 860 
            LINE N 448 848 512 848 
            RECTANGLE N 448 900 512 924 
            LINE N 448 912 512 912 
            RECTANGLE N 0 -252 64 -228 
            LINE N 64 -240 0 -240 
            LINE N 64 -752 0 -752 
            LINE N 64 -688 0 -688 
            RECTANGLE N 0 -636 64 -612 
            LINE N 64 -624 0 -624 
            RECTANGLE N 0 -444 64 -420 
            LINE N 64 -432 0 -432 
            RECTANGLE N 448 -252 512 -228 
            LINE N 448 -240 512 -240 
            LINE N 448 -368 512 -368 
            LINE N 448 -304 512 -304 
            RECTANGLE N 448 -444 512 -420 
            LINE N 448 -432 512 -432 
            LINE N 64 -816 0 -816 
            LINE N 64 -48 0 -48 
            LINE N 64 16 0 16 
            RECTANGLE N 0 68 64 92 
            LINE N 64 80 0 80 
            LINE N 64 -880 0 -880 
            LINE N 448 208 512 208 
            LINE N 448 272 512 272 
            LINE N 64 208 0 208 
            LINE N 64 -496 0 -496 
            LINE N 64 -368 0 -368 
            LINE N 64 -304 0 -304 
            RECTANGLE N 0 388 64 412 
            LINE N 64 400 0 400 
            RECTANGLE N 0 452 64 476 
            LINE N 64 464 0 464 
            RECTANGLE N 0 516 64 540 
            LINE N 64 528 0 528 
            RECTANGLE N 448 388 512 412 
            LINE N 448 400 512 400 
            RECTANGLE N 448 452 512 476 
            LINE N 448 464 512 464 
            RECTANGLE N 448 -1020 512 -996 
            LINE N 512 -1008 448 -1008 
            LINE N 448 -944 512 -944 
            LINE N 448 -896 512 -896 
            LINE N 448 -848 512 -848 
            LINE N 448 -800 512 -800 
            LINE N 512 -672 448 -672 
            LINE N 512 -624 448 -624 
            LINE N 512 -720 448 -720 
            LINE N 448 -112 512 -112 
            LINE N 448 -48 512 -48 
            LINE N 448 16 512 16 
            RECTANGLE N 0 708 64 732 
            LINE N 64 720 0 720 
            RECTANGLE N 0 772 64 796 
            LINE N 64 784 0 784 
            RECTANGLE N 0 836 64 860 
            LINE N 64 848 0 848 
            RECTANGLE N 0 900 64 924 
            LINE N 64 912 0 912 
            RECTANGLE N 448 -1084 512 -1060 
            LINE N 448 -1072 512 -1072 
            RECTANGLE N 0 -1084 64 -1060 
            LINE N 64 -1072 0 -1072 
            LINE N 432 -1008 448 -1016 
            LINE N 432 -1008 448 -1000 
            LINE N 432 -720 448 -728 
            LINE N 432 -720 448 -712 
            LINE N 432 -672 448 -680 
            LINE N 432 -672 448 -664 
            LINE N 432 -624 448 -632 
            LINE N 432 -624 448 -616 
            RECTANGLE N 64 -1112 448 956 
            RECTANGLE N 448 -588 512 -564 
            LINE N 448 -576 512 -576 
            LINE N 448 -528 512 -528 
        END BLOCKDEF
        BEGIN BLOCKDEF fd
            TIMESTAMP 2000 1 1 10 10 10
            RECTANGLE N 64 -320 320 -64 
            LINE N 0 -128 64 -128 
            LINE N 0 -256 64 -256 
            LINE N 384 -256 320 -256 
            LINE N 80 -128 64 -144 
            LINE N 64 -112 80 -128 
        END BLOCKDEF
        BEGIN BLOCKDEF and3
            TIMESTAMP 2000 1 1 10 10 10
            LINE N 0 -64 64 -64 
            LINE N 0 -128 64 -128 
            LINE N 0 -192 64 -192 
            LINE N 256 -128 192 -128 
            LINE N 64 -176 144 -176 
            LINE N 144 -80 64 -80 
            ARC N 96 -176 192 -80 144 -80 144 -176 
            LINE N 64 -64 64 -192 
        END BLOCKDEF
        BEGIN BLOCKDEF UART
            TIMESTAMP 2009 9 25 6 5 4
            RECTANGLE N 0 68 64 92 
            LINE N 64 80 0 80 
            LINE N 64 -544 0 -544 
            RECTANGLE N 0 -492 64 -468 
            LINE N 64 -480 0 -480 
            LINE N 64 -240 0 -240 
            LINE N 64 -288 0 -288 
            LINE N 64 -192 0 -192 
            LINE N 64 -144 0 -144 
            LINE N 0 -16 64 -16 
            LINE N 52 -16 64 -24 
            LINE N 52 -16 64 -8 
            LINE N 64 -24 64 -8 
            LINE N 0 32 64 32 
            LINE N 52 32 64 24 
            LINE N 52 32 64 40 
            LINE N 64 24 64 40 
            LINE N 352 -288 416 -288 
            LINE N 352 -240 416 -240 
            RECTANGLE N 0 -364 64 -340 
            LINE N 0 -352 64 -352 
            LINE N 52 -352 64 -344 
            LINE N 52 -352 64 -360 
            LINE N 64 -344 64 -360 
            LINE N 0 -64 64 -64 
            LINE N 52 -64 64 -72 
            LINE N 52 -64 64 -56 
            LINE N 64 -72 64 -56 
            LINE N 336 -240 352 -248 
            LINE N 336 -240 352 -232 
            RECTANGLE N 64 -572 352 116 
        END BLOCKDEF
        BEGIN BLOCKDEF GTEXT_LCD320
            TIMESTAMP 2009 6 30 13 31 18
            LINE N 64 -1088 0 -1088 
            LINE N 64 -1024 0 -1024 
            LINE N 64 -880 0 -880 
            LINE N 64 -832 0 -832 
            LINE N 64 -928 0 -928 
            LINE N 416 -960 480 -960 
            RECTANGLE N 0 -748 64 -724 
            LINE N 64 -736 0 -736 
            RECTANGLE N 0 -684 64 -660 
            LINE N 64 -672 0 -672 
            RECTANGLE N 416 -748 480 -724 
            LINE N 416 -736 480 -736 
            LINE N 416 -672 480 -672 
            LINE N 416 -608 480 -608 
            LINE N 416 -544 480 -544 
            LINE N 416 -480 480 -480 
            LINE N 416 -864 480 -864 
            RECTANGLE N 64 -1128 416 -452 
            LINE N 416 -1088 480 -1088 
        END BLOCKDEF
        BEGIN BLOCKDEF COM_mux
            TIMESTAMP 2009 9 25 11 41 26
            RECTANGLE N 64 -268 320 -16 
            LINE N 64 -160 0 -160 
            LINE N 0 -112 64 -112 
            LINE N 320 -192 384 -192 
            LINE N 320 -96 384 -96 
            LINE N 384 -48 320 -48 
            LINE N 320 -240 384 -240 
            LINE N 64 -48 0 -48 
            LINE N 320 -40 304 -48 
            LINE N 320 -56 320 -40 
            LINE N 304 -48 320 -56 
            LINE N 304 -192 320 -200 
            LINE N 320 -200 320 -184 
            LINE N 304 -192 320 -184 
            LINE N 64 -112 80 -120 
            LINE N 64 -112 80 -104 
            LINE N 80 -104 80 -120 
        END BLOCKDEF
        BEGIN BLOCKDEF t65_wrap
            TIMESTAMP 2009 7 2 11 35 41
            LINE N 64 -288 0 -288 
            LINE N 64 -224 0 -224 
            LINE N 64 -160 0 -160 
            RECTANGLE N 0 -44 64 -20 
            LINE N 64 -32 0 -32 
            RECTANGLE N 368 -44 432 -20 
            LINE N 368 -32 432 -32 
            RECTANGLE N 368 -108 432 -84 
            LINE N 368 -96 432 -96 
            LINE N 368 -224 432 -224 
            LINE N 368 -160 432 -160 
            LINE N 64 -96 0 -96 
            LINE N 64 32 0 32 
            LINE N 368 32 432 32 
            RECTANGLE N 64 -320 368 64 
            LINE N 368 -288 432 -288 
        END BLOCKDEF
        BEGIN BLOCK XLXI_341 constant
            BEGIN ATTR CValue "4"
                DELETE all:1 sym:0
                EDITNAME all:1 sch:0
                VALUETYPE BitVector 32 Hexadecimal
            END ATTR
            PIN O XLXN_892(3:0)
        END BLOCK
        BEGIN BLOCK XLXI_759 constant
            BEGIN ATTR CValue "24042009"
                DELETE all:1 sym:0
                EDITNAME all:1 sch:0
                VALUETYPE BitVector 32 Hexadecimal
            END ATTR
            PIN O XLXN_917(31:0)
        END BLOCK
        BEGIN BLOCK XLXI_833 ibufg
            PIN I ClkIn
            PIN O SYSCLK
        END BLOCK
        BEGIN BLOCK XLXI_884 ps2kbd
            PIN Rst_n XLXN_1492
            PIN Clk SYSCLK
            PIN PS2_Clk PS2_Clk
            PIN PS2_Data PS2_Data
            PIN Press KBD_DWN
            PIN Release XLXN_1239
            PIN Reset XLXN_1267
            PIN ScanCode(7:0) PS2code(7:0)
        END BLOCK
        BEGIN BLOCK XLXI_894 or2
            PIN I0 XLXN_1586
            PIN I1 XLXN_1267
            PIN O CPU_RST
        END BLOCK
        BEGIN BLOCK XLXI_963 buf
            PIN I ComEna(0)
            PIN O F_Int
        END BLOCK
        BEGIN BLOCK XLXI_966 inv
            PIN I LC_ENA
            PIN O XLXN_1492
        END BLOCK
        BEGIN BLOCK XLXI_970 IRQ_latch
            PIN INT_0 XLXN_1591
            PIN INT_1 Strobe1
            PIN INT_2 Strobe2
            PIN INT_3 SPI_KeyStrobe
            PIN IRQ_CLR IRQ_CLR
            PIN IRQ_ACK IRQ_ACK
            PIN IRQ_SRC(3:0) IRQ_Source(3:0)
            PIN IRQ XLXN_1490
            PIN RST CPU_RST
        END BLOCK
        BEGIN BLOCK XLXI_978(7:0) buf
            PIN I VRAM_D(7:0)
            PIN O RAMD_RD(31:24)
        END BLOCK
        BEGIN BLOCK XLXI_980 SPI_LRC
            PIN Q0(31:0)
            PIN Q1(31:0) ComRx(31:0)
            PIN Q2(31:0)
            PIN Q3(31:0) SPI_Key(31:0)
            PIN STROBE0 XLXN_1591
            PIN STROBE1 Strobe1
            PIN STROBE2 Strobe2
            PIN STROBE3 SPI_KeyStrobe
            PIN RAMD_WR(31:0) LC_DATA(31:0)
            PIN CORESEL(7:0)
            PIN F_MISO F_MISO
            PIN LC_WEN LC_WEN
            PIN LC_OEN LC_OEN
            PIN LC_ADDR(18:0) LC_ADR(18:0)
            PIN LC_ENA
            PIN F_DS F_DS
            PIN F_RS F_RS
            PIN F_SCLK F_SCK
            PIN F_MOSI F_MOSI
            PIN D3(31:0) XLXN_917(31:0)
            PIN D2(31:0) PS2code(31:0)
            PIN D1(31:0)
            PIN D0(31:0) ComTx(31:0)
            PIN SYSCLK SYSCLK
            PIN BASEADR(3:0) XLXN_892(3:0)
            PIN RAMD_RD(31:0) RAMD_RD(31:0)
        END BLOCK
        BEGIN BLOCK XLXI_984 BASIC_glue
            PIN CLK_X4 SYSCLK
            PIN Rx_full XLXN_1648
            PIN Tx_full XLXN_1645
            PIN Rx_valid XLXN_1652
            PIN CPU_RST CPU_RST
            PIN CPU_RDn P_RD_N
            PIN CPU_WRn P_WR_N
            PIN LC_WEn LC_WEN
            PIN LC_OEn LC_OEN
            PIN LC_ENA XLXN_1561
            PIN VSYNC vsync
            PIN PS2_DWN KBD_DWN
            PIN PS2_UP XLXN_1239
            PIN Rx_DATAi(7:0) XLXN_1639(7:0)
            PIN CPU_ADR(15:0) P_ADDR(15:0)
            PIN LC_ADR(18:0) LC_ADR(18:0)
            PIN CPU_DATAi(7:0) CPU_Do(7:0)
            PIN LC_DATA(31:0) LC_DATA(31:0)
            PIN PS2_CODE(7:0) PS2code(7:0)
            PIN COMin(7:0) ComRx(7:0)
            PIN IRQsrc(7:0) IRQ_Source(7:0)
            PIN ASCII(7:0) SPI_Key(7:0)
            PIN PIN340(7:0)
            PIN PIN341(7:0)
            PIN PIN342(7:0)
            PIN PIN343(7:0)
            PIN RAM_DATAz(7:0) VRAM_D(7:0)
            PIN Tx_write XLXN_1642
            PIN Rx_ack XLXN_1650
            PIN Rx_flush XLXN_1641
            PIN Tx_reset XLXN_1640
            PIN RAM_OEn OEN
            PIN RAM_WEn WEN
            PIN VGA_WR XLXN_1711
            PIN GCMD_WR XLXN_1713
            PIN TCMD_WR XLXN_1712
            PIN IRQ_ACK IRQ_ACK
            PIN IRQ_CLR IRQ_CLR
            PIN IO600_WEn IO600_WRn
            PIN IO600_RDn IO600_Rdn
            PIN RAM_ADR(18:0) VRAM_A(18:0)
            PIN CPU_DATAo(7:0) XLXN_1180(7:0)
            PIN COMout(7:0) ComTx(31:24)
            PIN INTstr(7:0) ComEna(7:0)
            PIN PORT340(7:0)
            PIN PORT341(7:0)
            PIN PORT342(7:0)
            PIN PORT343(7:0)
            PIN Bd_SEL(2:0) XLXN_1728(2:0)
            PIN SER_SEL XLXN_1727
        END BLOCK
        BEGIN BLOCK XLXI_990 and3
            PIN I0 LC_ENA
            PIN I1 LC_ADR(15)
            PIN I2 LC_ADR(14)
            PIN O XLXN_1585
        END BLOCK
        BEGIN BLOCK XLXI_994 fd
            PIN C SYSCLK
            PIN D XLXN_1585
            PIN Q XLXN_1586
        END BLOCK
        BEGIN BLOCK XLXI_997 UART
            PIN RxD XLXN_1724
            PIN Tx_Data(7:0) CPU_Do(7:0)
            PIN Rx_flush XLXN_1641
            PIN Tx_write XLXN_1642
            PIN Rx_ack XLXN_1650
            PIN Tx_reset XLXN_1640
            PIN SYSCLK SYSCLK
            PIN Rx_Data(7:0) XLXN_1639(7:0)
            PIN Rx_valid XLXN_1652
            PIN TxD XLXN_1723
            PIN Tx_full XLXN_1645
            PIN Rx_full XLXN_1648
            PIN BaudSel(2:0) XLXN_1728(2:0)
        END BLOCK
        BEGIN BLOCK XLXI_905 inv
            PIN I XLXN_1561
            PIN O TestLED
        END BLOCK
        BEGIN BLOCK XLXI_1000 GTEXT_LCD320
            PIN SYSCLK50 SYSCLK
            PIN TXT_WR XLXN_1711
            PIN DATA(7:0) CPU_Do(7:0)
            PIN RESET CPU_RST
            PIN ADR(11:0) P_ADDR(11:0)
            PIN TCMD_WR XLXN_1712
            PIN GCMD_WR XLXN_1713
            PIN GDONE IRQ_Source(7)
            PIN BLINK
            PIN LCDFRAME LCDFRAME
            PIN LCDLOAD LCDLOAD
            PIN LCDCLK LCDCLK
            PIN LCDON LCDON
            PIN LCDDATA(3:0) LCDDATA(3:0)
            PIN VS_60Hz vsync
        END BLOCK
        BEGIN BLOCK XLXI_1001 buf
            PIN I vsync
            PIN O XLXN_1592
        END BLOCK
        BEGIN BLOCK XLXI_1005 COM_mux
            PIN UART_Tx XLXN_1723
            PIN UART_Rx XLXN_1724
            PIN COM0_Rx Opto_Rx
            PIN COM1_Tx Serial_Tx
            PIN COM1_Rx Serial_Rx
            PIN COM0_Tx Opto_Tx
            PIN SEL XLXN_1727
        END BLOCK
        BEGIN BLOCK XLXI_1011 t65_wrap
            PIN RST CPU_RST
            PIN IRQ XLXN_1490
            PIN NMI XLXN_1592
            PIN HALT LC_ENA
            PIN CLK_X4 SYSCLK
            PIN DATA_I(7:0) XLXN_1180(7:0)
            PIN WR_N P_WR_N
            PIN HALTED XLXN_1561
            PIN RD_N P_RD_N
            PIN ADDR(15:0) P_ADDR(15:0)
            PIN DATA_O(7:0) CPU_Do(7:0)
            PIN BUSENA_N
        END BLOCK
    END NETLIST
    BEGIN SHEET 1 7040 5440
        ATTR LengthUnitName "Inch"
        ATTR GridsPerUnit "10"
        BEGIN BRANCH XLXN_892(3:0)
            WIRE 224 2080 336 2080
            WIRE 336 2032 336 2080
            WIRE 336 2032 528 2032
        END BRANCH
        BEGIN BRANCH XLXN_917(31:0)
            WIRE 224 1968 528 1968
        END BRANCH
        BEGIN BRANCH P_ADDR(15:0)
            WIRE 2000 1856 2080 1856
            WIRE 2080 1856 2080 2432
            WIRE 2080 2432 2240 2432
            WIRE 2080 1312 2080 1360
            WIRE 2080 1360 2080 1856
        END BRANCH
        BEGIN BRANCH P_RD_N
            WIRE 2000 1792 2224 1792
            WIRE 2224 1792 2224 2304
            WIRE 2224 2304 2240 2304
            BEGIN DISPLAY 2224 1792 ATTR Name
                ALIGNMENT SOFT-BCENTER
            END DISPLAY
        END BRANCH
        BEGIN BRANCH P_WR_N
            WIRE 2000 1728 2176 1728
            WIRE 2176 1728 2176 2368
            WIRE 2176 2368 2240 2368
            BEGIN DISPLAY 2176 1728 ATTR Name
                ALIGNMENT SOFT-BCENTER
            END DISPLAY
        END BRANCH
        BEGIN BRANCH VRAM_A(18:0)
            WIRE 2752 2624 3264 2624
        END BRANCH
        BEGIN BRANCH OEN
            WIRE 2752 2688 3264 2688
        END BRANCH
        BEGIN BRANCH VRAM_D(7:0)
            WIRE 2752 2816 3120 2816
            WIRE 3120 2816 3248 2816
            WIRE 3120 2816 3120 2928
        END BRANCH
        BEGIN BRANCH XLXN_1180(7:0)
            WIRE 1488 1488 1488 1920
            WIRE 1488 1920 1568 1920
            WIRE 1488 1488 2800 1488
            WIRE 2800 1488 2800 1984
            WIRE 2752 1984 2800 1984
        END BRANCH
        BEGIN BRANCH P_ADDR(11:0)
            WIRE 2176 1360 2464 1360
            WIRE 2464 1360 3104 1360
            BEGIN DISPLAY 2464 1360 ATTR Name
                ALIGNMENT SOFT-BCENTER
            END DISPLAY
        END BRANCH
        BUSTAP 2080 1360 2176 1360
        BEGIN BRANCH ClkIn
            WIRE 192 1168 224 1168
        END BRANCH
        BEGIN BRANCH KBD_DWN
            WIRE 992 3008 2240 3008
        END BRANCH
        BEGIN BRANCH XLXN_1239
            WIRE 992 3072 2240 3072
        END BRANCH
        BEGIN BRANCH PS2_Clk
            WIRE 336 3200 576 3200
        END BRANCH
        BEGIN BRANCH PS2_Data
            WIRE 336 3264 576 3264
        END BRANCH
        BEGIN BRANCH PS2code(7:0)
            WIRE 992 3136 1648 3136
            WIRE 1648 3136 2240 3136
            BEGIN DISPLAY 1648 3136 ATTR Name
                ALIGNMENT SOFT-BCENTER
            END DISPLAY
        END BRANCH
        BEGIN BRANCH SPI_Key(7:0)
            WIRE 1968 3584 2240 3584
            BEGIN DISPLAY 1968 3584 ATTR Name
                ALIGNMENT SOFT-RIGHT
            END DISPLAY
        END BRANCH
        BEGIN BRANCH XLXN_1267
            WIRE 992 3264 1328 3264
        END BRANCH
        INSTANCE XLXI_894 1328 3392 R0
        BEGIN BRANCH ComRx(7:0)
            WIRE 1968 3456 2240 3456
            BEGIN DISPLAY 1968 3456 ATTR Name
                ALIGNMENT SOFT-RIGHT
            END DISPLAY
        END BRANCH
        BEGIN BRANCH SPI_Key(31:0)
            WIRE 1040 1968 1136 1968
            BEGIN DISPLAY 1136 1968 ATTR Name
                ALIGNMENT SOFT-LEFT
            END DISPLAY
        END BRANCH
        IOMARKER 272 1712 F_MOSI R180 28
        IOMARKER 272 1520 F_DS R180 28
        IOMARKER 272 1648 F_SCK R180 28
        IOMARKER 272 1584 F_RS R180 28
        IOMARKER 336 3200 PS2_Clk R180 28
        IOMARKER 336 3264 PS2_Data R180 28
        BEGIN BRANCH SPI_KeyStrobe
            WIRE 1040 1712 1184 1712
            WIRE 1184 1712 1216 1712
            WIRE 1184 768 1600 768
            WIRE 1184 768 1184 1712
            BEGIN DISPLAY 1216 1712 ATTR Name
                ALIGNMENT SOFT-LEFT
            END DISPLAY
        END BRANCH
        BEGIN BRANCH IRQ_Source(7:0)
            WIRE 1968 3520 2240 3520
            BEGIN DISPLAY 1968 3520 ATTR Name
                ALIGNMENT SOFT-RIGHT
            END DISPLAY
        END BRANCH
        BEGIN BRANCH ComTx(31:24)
            WIRE 2752 3456 3264 3456
            BEGIN DISPLAY 3264 3456 ATTR Name
                ALIGNMENT SOFT-LEFT
            END DISPLAY
        END BRANCH
        BEGIN BRANCH ComTx(31:0)
            WIRE 416 1776 528 1776
            BEGIN DISPLAY 416 1776 ATTR Name
                ALIGNMENT SOFT-RIGHT
            END DISPLAY
        END BRANCH
        BEGIN BRANCH ComRx(31:0)
            WIRE 1040 1840 1136 1840
            BEGIN DISPLAY 1136 1840 ATTR Name
                ALIGNMENT SOFT-LEFT
            END DISPLAY
        END BRANCH
        BEGIN BRANCH ComEna(7:0)
            WIRE 2752 3520 3136 3520
            WIRE 3136 3520 3264 3520
            BEGIN DISPLAY 3264 3520 ATTR Name
                ALIGNMENT SOFT-LEFT
            END DISPLAY
        END BRANCH
        BEGIN BRANCH CPU_RST
            WIRE 1360 960 1424 960
            WIRE 1424 960 1600 960
            WIRE 1424 960 1424 1072
            WIRE 1424 1072 1424 1664
            WIRE 1424 1664 1424 2176
            WIRE 1424 2176 2240 2176
            WIRE 1424 1664 1568 1664
            WIRE 1424 1072 3104 1072
            BEGIN DISPLAY 1360 960 ATTR Name
                ALIGNMENT SOFT-RIGHT
            END DISPLAY
        END BRANCH
        BEGIN BRANCH XLXN_1492
            WIRE 400 3008 576 3008
        END BRANCH
        BEGIN BRANCH F_Int
            WIRE 3792 3760 3904 3760
        END BRANCH
        BEGIN BRANCH Strobe1
            WIRE 1040 1584 1152 1584
            WIRE 1152 640 1152 1584
            WIRE 1152 640 1600 640
        END BRANCH
        BEGIN BRANCH Strobe2
            WIRE 1040 1648 1168 1648
            WIRE 1168 704 1168 1648
            WIRE 1168 704 1600 704
        END BRANCH
        BEGIN BRANCH IRQ_Source(3:0)
            WIRE 1984 576 2128 576
            BEGIN DISPLAY 2128 576 ATTR Name
                ALIGNMENT SOFT-LEFT
            END DISPLAY
        END BRANCH
        BEGIN INSTANCE XLXI_970 1600 928 R0
        END INSTANCE
        BEGIN BRANCH IRQ_CLR
            WIRE 1360 896 1600 896
            BEGIN DISPLAY 1360 896 ATTR Name
                ALIGNMENT SOFT-RIGHT
            END DISPLAY
        END BRANCH
        BEGIN BRANCH IRQ_ACK
            WIRE 1360 832 1600 832
            BEGIN DISPLAY 1360 832 ATTR Name
                ALIGNMENT SOFT-RIGHT
            END DISPLAY
        END BRANCH
        BEGIN BRANCH IRQ_CLR
            WIRE 2752 3328 3264 3328
            BEGIN DISPLAY 3264 3328 ATTR Name
                ALIGNMENT SOFT-LEFT
            END DISPLAY
        END BRANCH
        BEGIN BRANCH IRQ_ACK
            WIRE 2752 3264 3264 3264
            BEGIN DISPLAY 3264 3264 ATTR Name
                ALIGNMENT SOFT-LEFT
            END DISPLAY
        END BRANCH
        BEGIN BRANCH XLXN_1490
            WIRE 1552 1232 1552 1728
            WIRE 1552 1728 1568 1728
            WIRE 1552 1232 2080 1232
            WIRE 1984 896 2080 896
            WIRE 2080 896 2080 1232
        END BRANCH
        BEGIN DISPLAY 1648 1564 TEXT "6502 CPU"
            FONT 56 "Arial"
        END DISPLAY
        IOMARKER 3264 2752 WEN R0 28
        IOMARKER 3264 2624 VRAM_A(18:0) R0 28
        IOMARKER 3264 2688 OEN R0 28
        IOMARKER 3248 2816 VRAM_D(7:0) R0 28
        IOMARKER 256 1040 F_MISO R180 28
        BEGIN BRANCH F_MISO
            WIRE 256 1040 1088 1040
            WIRE 1088 1040 1088 1456
            WIRE 1040 1456 1088 1456
        END BRANCH
        INSTANCE XLXI_978(7:0) 3088 2928 R90
        BEGIN BRANCH RAMD_RD(31:24)
            WIRE 3120 3152 3120 3200
            WIRE 3120 3200 3264 3200
            BEGIN DISPLAY 3264 3200 ATTR Name
                ALIGNMENT SOFT-LEFT
            END DISPLAY
        END BRANCH
        BEGIN BRANCH F_MOSI
            WIRE 272 1712 528 1712
        END BRANCH
        BEGIN BRANCH F_SCK
            WIRE 272 1648 528 1648
        END BRANCH
        BEGIN BRANCH F_RS
            WIRE 272 1584 528 1584
        END BRANCH
        BEGIN BRANCH F_DS
            WIRE 272 1520 528 1520
        END BRANCH
        BEGIN BRANCH LC_DATA(31:0)
            WIRE 1040 2352 1136 2352
            WIRE 1136 2352 1136 2816
            WIRE 1136 2816 1472 2816
            WIRE 1472 2816 2240 2816
            BEGIN DISPLAY 1472 2816 ATTR Name
                ALIGNMENT SOFT-BCENTER
            END DISPLAY
        END BRANCH
        BEGIN BRANCH LC_ADR(18:0)
            WIRE 1040 2160 1280 2160
            WIRE 1280 2160 1280 2624
            WIRE 1280 2624 1472 2624
            WIRE 1472 2624 2240 2624
            BEGIN DISPLAY 1472 2624 ATTR Name
                ALIGNMENT SOFT-BCENTER
            END DISPLAY
        END BRANCH
        BEGIN BRANCH LC_ENA
            WIRE 160 2880 160 3008
            WIRE 160 3008 176 3008
            WIRE 160 2880 1360 2880
            WIRE 1040 2480 1360 2480
            WIRE 1360 2480 1360 2880
            WIRE 1360 1984 1360 2096
            WIRE 1360 2096 1360 2480
            WIRE 1360 1984 1568 1984
            BEGIN DISPLAY 1360 2096 ATTR Name
                ALIGNMENT SOFT-TVCENTER
            END DISPLAY
        END BRANCH
        IOMARKER 192 1168 ClkIn R180 28
        INSTANCE XLXI_833 224 1200 R0
        BEGIN INSTANCE XLXI_980 592 2448 R0
        END INSTANCE
        BEGIN BRANCH RAMD_RD(31:0)
            WIRE 384 2352 528 2352
            BEGIN DISPLAY 384 2352 ATTR Name
                ALIGNMENT SOFT-RIGHT
            END DISPLAY
        END BRANCH
        BEGIN INSTANCE XLXI_884 576 3296 R0
        END INSTANCE
        INSTANCE XLXI_966 176 3040 R0
        BEGIN BRANCH PS2code(31:0)
            WIRE 416 1904 528 1904
            BEGIN DISPLAY 416 1904 ATTR Name
                ALIGNMENT SOFT-RIGHT
            END DISPLAY
        END BRANCH
        BEGIN INSTANCE XLXI_759 80 1936 R0
        END INSTANCE
        BEGIN INSTANCE XLXI_341 80 2048 R0
        END INSTANCE
        BEGIN INSTANCE XLXI_984 2240 3056 R0
        END INSTANCE
        BEGIN BRANCH XLXN_1561
            WIRE 2000 1984 2032 1984
            WIRE 2032 1984 2032 2560
            WIRE 2032 2560 2240 2560
            WIRE 2032 2560 2032 4736
            WIRE 2032 4736 3376 4736
        END BRANCH
        BEGIN BRANCH LC_WEN
            WIRE 1040 2288 1184 2288
            WIRE 1184 2288 1184 2752
            WIRE 1184 2752 1472 2752
            WIRE 1472 2752 2240 2752
            BEGIN DISPLAY 1472 2752 ATTR Name
                ALIGNMENT SOFT-BCENTER
            END DISPLAY
        END BRANCH
        BEGIN BRANCH LC_OEN
            WIRE 1040 2224 1232 2224
            WIRE 1232 2224 1232 2688
            WIRE 1232 2688 1472 2688
            WIRE 1472 2688 2240 2688
            BEGIN DISPLAY 1472 2688 ATTR Name
                ALIGNMENT SOFT-BCENTER
            END DISPLAY
        END BRANCH
        BEGIN DISPLAY 3192 3124 TEXT "wg. 8-Bit-Transfer oberes Byte"
            FONT 40 "Arial"
        END DISPLAY
        BEGIN DISPLAY 1972 832 TEXT "IRQ Source Latch"
            FONT 56 "Arial"
        END DISPLAY
        BEGIN DISPLAY 268 4596 TEXT "AutoIncrement Counter"
            FONT 40 "Arial"
        END DISPLAY
        BEGIN DISPLAY 264 4676 TEXT "LC_WEN active low"
            FONT 32 "Arial"
        END DISPLAY
        BEGIN DISPLAY 264 4756 TEXT "LC_ENA active high from 1st RAMINCR pulse"
            FONT 32 "Arial"
        END DISPLAY
        BEGIN DISPLAY 264 4836 TEXT "(SPI SubCh 128), until CORERST (SPI SubCh 129)"
            FONT 32 "Arial"
        END DISPLAY
        BEGIN DISPLAY 264 4916 TEXT "new LC_ADDR valid after LC_WEN ends"
            FONT 32 "Arial"
        END DISPLAY
        BEGIN DISPLAY 260 5028 TEXT "RAMD valid before RAMINCR pulse"
            FONT 32 "Arial"
        END DISPLAY
        BEGIN BRANCH XLXN_1586
            WIRE 1232 3536 1312 3536
            WIRE 1312 3328 1328 3328
            WIRE 1312 3328 1312 3536
        END BRANCH
        BEGIN BRANCH LC_ENA
            WIRE 304 3600 576 3600
            BEGIN DISPLAY 304 3600 ATTR Name
                ALIGNMENT SOFT-RIGHT
            END DISPLAY
        END BRANCH
        BEGIN BRANCH LC_ADR(15)
            WIRE 304 3536 576 3536
            BEGIN DISPLAY 304 3536 ATTR Name
                ALIGNMENT SOFT-RIGHT
            END DISPLAY
        END BRANCH
        BEGIN BRANCH LC_ADR(14)
            WIRE 304 3472 576 3472
            BEGIN DISPLAY 304 3472 ATTR Name
                ALIGNMENT SOFT-RIGHT
            END DISPLAY
        END BRANCH
        BEGIN BRANCH XLXN_1585
            WIRE 832 3536 848 3536
        END BRANCH
        INSTANCE XLXI_994 848 3792 R0
        INSTANCE XLXI_990 576 3664 R0
        BEGIN DISPLAY 220 3744 TEXT "CPU_RST nur oberhalb xC000h"
            FONT 40 "Arial"
        END DISPLAY
        BEGIN BRANCH XLXN_1591
            WIRE 1040 1520 1136 1520
            WIRE 1136 576 1136 1520
            WIRE 1136 576 1600 576
        END BRANCH
        BEGIN BRANCH SYSCLK
            WIRE 448 1168 464 1168
            WIRE 464 1168 464 1456
            WIRE 464 1456 528 1456
            WIRE 464 1456 464 2656
            WIRE 464 2656 464 3072
            WIRE 464 3072 576 3072
            WIRE 464 3072 464 3664
            WIRE 464 3664 848 3664
            WIRE 464 1168 1456 1168
            WIRE 1456 1168 1456 1856
            WIRE 1456 1856 1456 2240
            WIRE 1456 2240 2240 2240
            WIRE 1456 1856 1568 1856
            WIRE 1456 1168 2304 1168
            WIRE 2304 1168 2880 1168
            WIRE 2880 1168 2880 1856
            WIRE 2880 1856 3152 1856
            WIRE 2880 1008 2880 1168
            WIRE 2880 1008 3104 1008
            BEGIN DISPLAY 464 2656 ATTR Name
                ALIGNMENT SOFT-TVCENTER
            END DISPLAY
            BEGIN DISPLAY 2304 1168 ATTR Name
                ALIGNMENT SOFT-BCENTER
            END DISPLAY
        END BRANCH
        BEGIN BRANCH XLXN_1592
            WIRE 1520 448 1520 1792
            WIRE 1520 1792 1568 1792
            WIRE 1520 448 3168 448
        END BRANCH
        BEGIN BRANCH CPU_Do(7:0)
            WIRE 2000 1920 2128 1920
            WIRE 2128 1920 3152 1920
            WIRE 2128 1920 2128 1984
            WIRE 2128 1984 2240 1984
            WIRE 2128 1424 2128 1920
            WIRE 2128 1424 2464 1424
            WIRE 2464 1424 3104 1424
            BEGIN DISPLAY 2464 1424 ATTR Name
                ALIGNMENT SOFT-BCENTER
            END DISPLAY
        END BRANCH
        BEGIN BRANCH XLXN_1639(7:0)
            WIRE 2752 2048 3152 2048
        END BRANCH
        BEGIN BRANCH WEN
            WIRE 2752 2752 3264 2752
        END BRANCH
        BEGIN BRANCH CPU_RST
            WIRE 1584 3296 1648 3296
            BEGIN DISPLAY 1648 3296 ATTR Name
                ALIGNMENT SOFT-LEFT
            END DISPLAY
        END BRANCH
        BEGIN DISPLAY 88 2176 TEXT "SPI 64..67"
            FONT 40 "Arial"
        END DISPLAY
        BEGIN BRANCH XLXN_1640
            WIRE 2752 2112 3152 2112
        END BRANCH
        BEGIN BRANCH XLXN_1641
            WIRE 2752 2160 3152 2160
        END BRANCH
        BEGIN BRANCH XLXN_1645
            WIRE 2752 2384 3152 2384
        END BRANCH
        BEGIN BRANCH XLXN_1648
            WIRE 2752 2432 3152 2432
        END BRANCH
        BEGIN INSTANCE XLXI_997 3152 2400 R0
        END INSTANCE
        IOMARKER 3904 3760 F_Int R0 28
        INSTANCE XLXI_963 3568 3792 R0
        BUSTAP 3136 3520 3136 3616
        BEGIN BRANCH ComEna(0)
            WIRE 3136 3616 3136 3648
            WIRE 3136 3648 3136 3760
            WIRE 3136 3760 3568 3760
            BEGIN DISPLAY 3136 3648 ATTR Name
                ALIGNMENT SOFT-TVCENTER
            END DISPLAY
        END BRANCH
        BEGIN BRANCH XLXN_1711
            WIRE 2752 2944 2944 2944
            WIRE 2944 1168 2944 2944
            WIRE 2944 1168 3104 1168
        END BRANCH
        BEGIN BRANCH XLXN_1712
            WIRE 2752 3008 2960 3008
            WIRE 2960 1216 3104 1216
            WIRE 2960 1216 2960 3008
        END BRANCH
        BEGIN BRANCH XLXN_1713
            WIRE 2752 3072 2976 3072
            WIRE 2976 1264 3104 1264
            WIRE 2976 1264 2976 3072
        END BRANCH
        BEGIN BRANCH IRQ_Source(7)
            WIRE 3584 1136 3856 1136
            BEGIN DISPLAY 3856 1136 ATTR Name
                ALIGNMENT SOFT-LEFT
            END DISPLAY
        END BRANCH
        BEGIN BRANCH TestLED
            WIRE 3600 4736 3808 4736
        END BRANCH
        INSTANCE XLXI_905 3376 4768 R0
        IOMARKER 3808 4736 TestLED R0 28
        BEGIN BRANCH IO600_Rdn
            WIRE 2752 3712 3040 3712
            WIRE 3040 3712 3040 3968
            WIRE 3040 3968 3280 3968
        END BRANCH
        IOMARKER 3280 3968 IO600_Rdn R0 28
        BEGIN BRANCH IO600_WRn
            WIRE 2752 3648 3088 3648
            WIRE 3088 3648 3088 3904
            WIRE 3088 3904 3280 3904
        END BRANCH
        IOMARKER 3280 3904 IO600_WRn R0 28
        BEGIN BRANCH XLXN_1652
            WIRE 2752 2336 3152 2336
        END BRANCH
        BEGIN BRANCH XLXN_1650
            WIRE 2752 2256 3152 2256
        END BRANCH
        BEGIN BRANCH XLXN_1642
            WIRE 2752 2208 3152 2208
        END BRANCH
        INSTANCE XLXI_1000 3104 2096 R0
        BEGIN BRANCH LCDDATA(3:0)
            WIRE 3584 1360 3840 1360
        END BRANCH
        BEGIN BRANCH LCDLOAD
            WIRE 3584 1424 3840 1424
        END BRANCH
        BEGIN BRANCH LCDCLK
            WIRE 3584 1488 3840 1488
        END BRANCH
        BEGIN BRANCH LCDON
            WIRE 3584 1616 3840 1616
        END BRANCH
        IOMARKER 3840 1360 LCDDATA(3:0) R0 28
        IOMARKER 3840 1424 LCDLOAD R0 28
        IOMARKER 3840 1488 LCDCLK R0 28
        IOMARKER 3840 1616 LCDON R0 28
        INSTANCE XLXI_1001 3392 416 R180
        BEGIN BRANCH LCDFRAME
            WIRE 3584 1552 3840 1552
        END BRANCH
        IOMARKER 3840 1552 LCDFRAME R0 28
        BEGIN BRANCH vsync
            WIRE 3392 448 3648 448
            WIRE 3648 448 3648 1008
            WIRE 3648 1008 3776 1008
            WIRE 3584 1008 3648 1008
            BEGIN DISPLAY 3776 1008 ATTR Name
                ALIGNMENT SOFT-LEFT
            END DISPLAY
        END BRANCH
        BEGIN BRANCH Opto_Tx
            WIRE 3984 2032 4000 2032
            WIRE 4000 2032 4048 2032
        END BRANCH
        BEGIN BRANCH XLXN_1723
            WIRE 3568 2112 3600 2112
        END BRANCH
        BEGIN BRANCH XLXN_1724
            WIRE 3568 2160 3600 2160
        END BRANCH
        BEGIN BRANCH Serial_Tx
            WIRE 3984 2176 4000 2176
            WIRE 4000 2176 4048 2176
        END BRANCH
        BEGIN BRANCH XLXN_1727
            WIRE 2752 2528 3584 2528
            WIRE 3584 2224 3584 2528
            WIRE 3584 2224 3600 2224
        END BRANCH
        BEGIN BRANCH Opto_Rx
            WIRE 3984 2080 4000 2080
            WIRE 4000 2080 4048 2080
        END BRANCH
        BEGIN BRANCH Serial_Rx
            WIRE 3984 2224 4000 2224
            WIRE 4000 2224 4048 2224
        END BRANCH
        BEGIN BRANCH vsync
            WIRE 2208 3264 2240 3264
            BEGIN DISPLAY 2208 3264 ATTR Name
                ALIGNMENT SOFT-RIGHT
            END DISPLAY
        END BRANCH
        BEGIN INSTANCE XLXI_1011 1568 1952 R0
        END INSTANCE
        BEGIN BRANCH XLXN_1728(2:0)
            WIRE 2752 2480 3152 2480
        END BRANCH
        BEGIN INSTANCE XLXI_1005 3600 2272 R0
        END INSTANCE
        IOMARKER 4048 2032 Opto_Tx R0 28
        IOMARKER 4048 2080 Opto_Rx R0 28
        IOMARKER 4048 2176 Serial_Tx R0 28
        IOMARKER 4048 2224 Serial_Rx R0 28
        BEGIN DISPLAY 3640 2500 TEXT "1=19200 Bd"
            FONT 40 "Arial"
        END DISPLAY
        BEGIN DISPLAY 3644 2548 TEXT "2=9600 Bd"
            FONT 40 "Arial"
        END DISPLAY
        BEGIN DISPLAY 3644 2596 TEXT "3=4800 Bd"
            FONT 40 "Arial"
        END DISPLAY
        BEGIN DISPLAY 3644 2644 TEXT "4=2400 Bd"
            FONT 40 "Arial"
        END DISPLAY
        BEGIN DISPLAY 3644 2692 TEXT "5=1200 Bd"
            FONT 40 "Arial"
        END DISPLAY
        BEGIN DISPLAY 3644 2740 TEXT "6=600 Bd"
            FONT 40 "Arial"
        END DISPLAY
        BEGIN DISPLAY 3644 2788 TEXT "7=300 Bd"
            FONT 40 "Arial"
        END DISPLAY
        BEGIN DISPLAY 3644 2452 TEXT "0=38400 Bd"
            FONT 40 "Arial"
        END DISPLAY
        BEGIN DISPLAY 3644 2404 TEXT "Bd_SEL $31E"
            FONT 40 "Arial"
        END DISPLAY
        BEGIN DISPLAY 3644 2356 TEXT "Ser_SEL $31F, 0=Opto, 1=RS232"
            FONT 40 "Arial"
        END DISPLAY
        BEGIN DISPLAY 2360 4084 TEXT "Ports auf $03XX"
            FONT 40 "Arial"
        END DISPLAY
    END SHEET
END SCHEMATIC
