VERSION 6
BEGIN SCHEMATIC
    BEGIN ATTR DeviceFamilyName "spartan3"
        DELETE all:0
        EDITNAME all:0
        EDITTRAIT all:0
    END ATTR
    BEGIN NETLIST
        SIGNAL XLXN_892(3:0)
        SIGNAL F_MOSI
        SIGNAL F_DS
        SIGNAL F_SCK
        SIGNAL F_RS
        SIGNAL XLXN_917(31:0)
        SIGNAL LC_DATA(31:0)
        SIGNAL LC_ADR(18:0)
        SIGNAL LC_WEN
        SIGNAL P_ADDR(15:0)
        SIGNAL P_RD_N
        SIGNAL P_WR_N
        SIGNAL WEN
        SIGNAL VRAM_A(18:0)
        SIGNAL OEN
        SIGNAL VRAM_D(7:0)
        SIGNAL XLXN_1180(7:0)
        SIGNAL P_ADDR(3:0)
        SIGNAL ClkIn
        SIGNAL CPU_Do(7:0)
        SIGNAL vs_out
        SIGNAL SYSCLK
        SIGNAL SPI_Key(7:0)
        SIGNAL SPI_KeyStrobe
        SIGNAL LC_ENA
        SIGNAL CPU_RST
        SIGNAL ComRx(7:0)
        SIGNAL SPI_Key(31:0)
        SIGNAL ComRx(31:0)
        SIGNAL Strobe1
        SIGNAL IRQ_Source(7:0)
        SIGNAL ComTx(31:24)
        SIGNAL ComTx(31:0)
        SIGNAL F_Int
        SIGNAL ComEna(7:0)
        SIGNAL XLXN_1490
        SIGNAL IRQ_Source(3:0)
        SIGNAL IRQ_CLR
        SIGNAL IRQ_ACK
        SIGNAL F_MISO
        SIGNAL RAMD_RD(31:24)
        SIGNAL RAMD_RD(31:0)
        SIGNAL LC_OEN
        SIGNAL PS2_RdRaw(31:0)
        SIGNAL XLXN_1586
        SIGNAL LC_ADR(15)
        SIGNAL LC_ADR(14)
        SIGNAL XLXN_1585
        SIGNAL XLXN_1592
        SIGNAL XLXN_1639(7:0)
        SIGNAL XLXN_1640
        SIGNAL XLXN_1641
        SIGNAL XLXN_1642
        SIGNAL XLXN_1645
        SIGNAL XLXN_1648
        SIGNAL XLXN_1650
        SIGNAL ComEna(0)
        SIGNAL hs_out
        SIGNAL red_out(2:0)
        SIGNAL green_out(2:0)
        SIGNAL blue_out(2:0)
        SIGNAL XLXN_1712
        SIGNAL XLXN_1713
        SIGNAL IRQ_Source(7)
        SIGNAL XLXN_1714(2:0)
        SIGNAL IO600_Rdn
        SIGNAL IO600_WRn
        SIGNAL Rx_data_present
        SIGNAL TestLED
        SIGNAL XLXN_1723
        SIGNAL XLXN_1724
        SIGNAL XLXN_1725(7:0)
        SIGNAL XLXN_1726
        SIGNAL XLXN_1727
        SIGNAL Opto_Tx
        SIGNAL Opto_Rx
        SIGNAL Serial_Tx
        SIGNAL Serial_Rx
        SIGNAL XLXN_1728
        SIGNAL PS2_Clk
        SIGNAL PS2_Data
        SIGNAL PS2_TxBusy
        SIGNAL PS2_TxData(7:0)
        SIGNAL PS2_TxStr
        SIGNAL XLXN_1741
        SIGNAL XLXN_1742
        SIGNAL PS2_RdRaw(7:0)
        PORT Input F_MOSI
        PORT Input F_DS
        PORT Input F_SCK
        PORT Input F_RS
        PORT Output WEN
        PORT Output VRAM_A(18:0)
        PORT Output OEN
        PORT BiDirectional VRAM_D(7:0)
        PORT Input ClkIn
        PORT Output vs_out
        PORT Output F_Int
        PORT Output F_MISO
        PORT Output hs_out
        PORT Output red_out(2:0)
        PORT Output green_out(2:0)
        PORT Output blue_out(2:0)
        PORT Output IO600_Rdn
        PORT Output IO600_WRn
        PORT Output TestLED
        PORT Output Opto_Tx
        PORT Input Opto_Rx
        PORT Output Serial_Tx
        PORT Input Serial_Rx
        PORT BiDirectional PS2_Clk
        PORT BiDirectional PS2_Data
        BEGIN BLOCKDEF constant
            TIMESTAMP 2006 1 1 10 10 10
            RECTANGLE N 0 0 112 64 
            LINE N 144 32 112 32 
        END BLOCKDEF
        BEGIN BLOCKDEF ibufg
            TIMESTAMP 2000 1 1 10 10 10
            LINE N 64 0 64 -64 
            LINE N 128 -32 64 0 
            LINE N 64 -64 128 -32 
            LINE N 224 -32 128 -32 
            LINE N 0 -32 64 -32 
        END BLOCKDEF
        BEGIN BLOCKDEF inv
            TIMESTAMP 2000 1 1 10 10 10
            LINE N 0 -32 64 -32 
            LINE N 224 -32 160 -32 
            LINE N 64 -64 128 -32 
            LINE N 128 -32 64 0 
            LINE N 64 0 64 -64 
            CIRCLE N 128 -48 160 -16 
        END BLOCKDEF
        BEGIN BLOCKDEF or2
            TIMESTAMP 2000 1 1 10 10 10
            LINE N 0 -64 64 -64 
            LINE N 0 -128 64 -128 
            LINE N 256 -96 192 -96 
            ARC N 28 -224 204 -48 112 -48 192 -96 
            ARC N -40 -152 72 -40 48 -48 48 -144 
            LINE N 112 -144 48 -144 
            ARC N 28 -144 204 32 192 -96 112 -144 
            LINE N 112 -48 48 -48 
        END BLOCKDEF
        BEGIN BLOCKDEF buf
            TIMESTAMP 2000 1 1 10 10 10
            LINE N 0 -32 64 -32 
            LINE N 224 -32 128 -32 
            LINE N 64 0 128 -32 
            LINE N 128 -32 64 -64 
            LINE N 64 -64 64 0 
        END BLOCKDEF
        BEGIN BLOCKDEF IRQ_latch
            TIMESTAMP 2009 3 1 9 14 23
            LINE N 64 32 0 32 
            LINE N 64 -352 0 -352 
            LINE N 64 -288 0 -288 
            LINE N 64 -224 0 -224 
            LINE N 64 -160 0 -160 
            LINE N 64 -96 0 -96 
            LINE N 64 -32 0 -32 
            RECTANGLE N 320 -364 384 -340 
            LINE N 320 -352 384 -352 
            LINE N 320 -32 384 -32 
            RECTANGLE N 64 -384 320 64 
        END BLOCKDEF
        BEGIN BLOCKDEF SPI_LRC
            TIMESTAMP 2009 6 9 14 35 58
            LINE N 384 32 448 32 
            LINE N 384 96 448 96 
            LINE N 384 160 448 160 
            LINE N 384 224 448 224 
            RECTANGLE N 384 -108 448 -84 
            LINE N 384 -96 448 -96 
            LINE N 384 -992 448 -992 
            RECTANGLE N 384 -684 448 -660 
            LINE N 384 -672 448 -672 
            RECTANGLE N 384 -620 448 -596 
            LINE N 384 -608 448 -608 
            RECTANGLE N 384 -556 448 -532 
            LINE N 384 -544 448 -544 
            RECTANGLE N 384 -492 448 -468 
            LINE N 384 -480 448 -480 
            LINE N 384 -928 448 -928 
            LINE N 384 -864 448 -864 
            LINE N 384 -800 448 -800 
            LINE N 384 -736 448 -736 
            LINE N 384 -160 448 -160 
            LINE N 384 -224 448 -224 
            RECTANGLE N 384 -300 448 -276 
            LINE N 384 -288 448 -288 
            LINE N 0 -992 -64 -992 
            LINE N 0 -928 -64 -928 
            LINE N 0 -864 -64 -864 
            LINE N 0 -800 -64 -800 
            LINE N 0 -736 -64 -736 
            RECTANGLE N -64 -684 0 -660 
            LINE N 0 -672 -64 -672 
            RECTANGLE N -64 -620 0 -596 
            LINE N 0 -608 -64 -608 
            RECTANGLE N -64 -556 0 -532 
            LINE N 0 -544 -64 -544 
            RECTANGLE N -64 -492 0 -468 
            LINE N 0 -480 -64 -480 
            RECTANGLE N -64 -428 0 -404 
            LINE N 0 -416 -64 -416 
            RECTANGLE N -64 -108 0 -84 
            LINE N 0 -96 -64 -96 
            RECTANGLE N 0 -1024 384 256 
        END BLOCKDEF
        BEGIN BLOCKDEF BASIC_glue
            TIMESTAMP 2009 12 12 8 58 41
            LINE N 448 976 512 976 
            LINE N 448 592 512 592 
            LINE N 448 656 512 656 
            RECTANGLE N 448 708 512 732 
            LINE N 448 720 512 720 
            RECTANGLE N 448 772 512 796 
            LINE N 448 784 512 784 
            RECTANGLE N 448 836 512 860 
            LINE N 448 848 512 848 
            RECTANGLE N 448 900 512 924 
            LINE N 448 912 512 912 
            RECTANGLE N 0 -252 64 -228 
            LINE N 64 -240 0 -240 
            LINE N 64 -752 0 -752 
            LINE N 64 -688 0 -688 
            RECTANGLE N 0 -636 64 -612 
            LINE N 64 -624 0 -624 
            RECTANGLE N 0 -444 64 -420 
            LINE N 64 -432 0 -432 
            RECTANGLE N 448 -252 512 -228 
            LINE N 448 -240 512 -240 
            LINE N 448 -368 512 -368 
            LINE N 448 -304 512 -304 
            RECTANGLE N 448 -444 512 -420 
            LINE N 448 -432 512 -432 
            LINE N 64 -816 0 -816 
            LINE N 64 -880 0 -880 
            LINE N 448 208 512 208 
            LINE N 448 272 512 272 
            LINE N 64 208 0 208 
            LINE N 64 -496 0 -496 
            LINE N 64 -368 0 -368 
            LINE N 64 -304 0 -304 
            RECTANGLE N 0 388 64 412 
            LINE N 64 400 0 400 
            RECTANGLE N 0 452 64 476 
            LINE N 64 464 0 464 
            RECTANGLE N 0 516 64 540 
            LINE N 64 528 0 528 
            RECTANGLE N 448 388 512 412 
            LINE N 448 400 512 400 
            RECTANGLE N 448 452 512 476 
            LINE N 448 464 512 464 
            RECTANGLE N 448 -1020 512 -996 
            LINE N 512 -1008 448 -1008 
            LINE N 448 -944 512 -944 
            LINE N 448 -896 512 -896 
            LINE N 448 -848 512 -848 
            LINE N 448 -800 512 -800 
            LINE N 512 -672 448 -672 
            LINE N 512 -624 448 -624 
            LINE N 512 -720 448 -720 
            RECTANGLE N 0 708 64 732 
            LINE N 64 720 0 720 
            RECTANGLE N 0 772 64 796 
            LINE N 64 784 0 784 
            RECTANGLE N 0 836 64 860 
            LINE N 64 848 0 848 
            RECTANGLE N 0 900 64 924 
            LINE N 64 912 0 912 
            RECTANGLE N 448 -1084 512 -1060 
            LINE N 448 -1072 512 -1072 
            RECTANGLE N 0 -1084 64 -1060 
            LINE N 64 -1072 0 -1072 
            LINE N 432 -1008 448 -1016 
            LINE N 432 -1008 448 -1000 
            LINE N 432 -720 448 -728 
            LINE N 432 -720 448 -712 
            LINE N 432 -672 448 -680 
            LINE N 432 -672 448 -664 
            LINE N 432 -624 448 -632 
            LINE N 432 -624 448 -616 
            RECTANGLE N 448 -588 512 -564 
            LINE N 448 -576 512 -576 
            LINE N 448 -528 512 -528 
            LINE N 64 272 0 272 
            RECTANGLE N 0 964 64 988 
            LINE N 64 976 0 976 
            LINE N 64 144 0 144 
            RECTANGLE N 0 68 64 92 
            LINE N 64 80 0 80 
            RECTANGLE N 448 68 512 92 
            LINE N 448 80 512 80 
            LINE N 448 -176 512 -176 
            LINE N 448 -112 512 -112 
            RECTANGLE N 64 -1112 448 1016 
            LINE N 64 16 0 16 
            LINE N 448 16 512 16 
        END BLOCKDEF
        BEGIN BLOCKDEF fd
            TIMESTAMP 2000 1 1 10 10 10
            RECTANGLE N 64 -320 320 -64 
            LINE N 0 -128 64 -128 
            LINE N 0 -256 64 -256 
            LINE N 384 -256 320 -256 
            LINE N 80 -128 64 -144 
            LINE N 64 -112 80 -128 
        END BLOCKDEF
        BEGIN BLOCKDEF and3
            TIMESTAMP 2000 1 1 10 10 10
            LINE N 0 -64 64 -64 
            LINE N 0 -128 64 -128 
            LINE N 0 -192 64 -192 
            LINE N 256 -128 192 -128 
            LINE N 64 -176 144 -176 
            LINE N 144 -80 64 -80 
            ARC N 96 -176 192 -80 144 -80 144 -176 
            LINE N 64 -64 64 -192 
        END BLOCKDEF
        BEGIN BLOCKDEF UART
            TIMESTAMP 2009 12 4 10 18 0
            LINE N 64 -544 0 -544 
            RECTANGLE N 0 -492 64 -468 
            LINE N 64 -480 0 -480 
            LINE N 64 -240 0 -240 
            LINE N 64 -288 0 -288 
            LINE N 64 -192 0 -192 
            LINE N 64 -144 0 -144 
            LINE N 0 -16 64 -16 
            LINE N 52 -16 64 -24 
            LINE N 52 -16 64 -8 
            LINE N 64 -24 64 -8 
            LINE N 0 32 64 32 
            LINE N 52 32 64 24 
            LINE N 52 32 64 40 
            LINE N 64 24 64 40 
            RECTANGLE N 0 -364 64 -340 
            LINE N 0 -352 64 -352 
            LINE N 52 -352 64 -344 
            LINE N 52 -352 64 -360 
            LINE N 64 -344 64 -360 
            LINE N 0 -64 64 -64 
            LINE N 52 -64 64 -72 
            LINE N 52 -64 64 -56 
            LINE N 64 -72 64 -56 
            RECTANGLE N 64 -572 352 156 
            LINE N 64 80 0 80 
            RECTANGLE N 0 68 64 92 
            LINE N 64 128 0 128 
            LINE N 336 -240 352 -248 
            LINE N 336 -240 352 -232 
            LINE N 416 -240 352 -240 
            LINE N 352 -288 416 -288 
            LINE N 336 -144 352 -152 
            LINE N 336 -144 352 -136 
            LINE N 416 -144 352 -144 
            LINE N 352 -192 416 -192 
        END BLOCKDEF
        BEGIN BLOCKDEF GTEXT
            TIMESTAMP 2009 11 3 15 19 28
            RECTANGLE N 416 -284 480 -260 
            LINE N 416 -272 480 -272 
            LINE N 416 -336 480 -336 
            LINE N 64 -864 0 -864 
            LINE N 64 -800 0 -800 
            LINE N 416 -736 480 -736 
            RECTANGLE N 416 -492 480 -468 
            LINE N 416 -480 480 -480 
            LINE N 416 -864 480 -864 
            LINE N 416 -800 480 -800 
            RECTANGLE N 416 -412 480 -388 
            LINE N 416 -400 480 -400 
            RECTANGLE N 416 -572 480 -548 
            LINE N 416 -560 480 -560 
            RECTANGLE N 0 -524 64 -500 
            LINE N 64 -512 0 -512 
            RECTANGLE N 0 -460 64 -436 
            LINE N 64 -448 0 -448 
            LINE N 64 -656 0 -656 
            LINE N 64 -608 0 -608 
            LINE N 416 -640 480 -640 
            RECTANGLE N 64 -896 416 -240 
        END BLOCKDEF
        BEGIN BLOCKDEF t65_wrap
            TIMESTAMP 2009 12 11 11 35 22
            LINE N 368 96 432 96 
            LINE N 64 -288 0 -288 
            LINE N 64 -224 0 -224 
            LINE N 64 -160 0 -160 
            RECTANGLE N 0 -44 64 -20 
            LINE N 64 -32 0 -32 
            RECTANGLE N 368 -44 432 -20 
            LINE N 368 -32 432 -32 
            RECTANGLE N 368 -108 432 -84 
            LINE N 368 -96 432 -96 
            LINE N 368 -224 432 -224 
            LINE N 368 -160 432 -160 
            LINE N 64 32 0 32 
            LINE N 368 32 432 32 
            LINE N 368 -288 432 -288 
            LINE N 64 -96 0 -96 
            RECTANGLE N 64 -320 368 128 
        END BLOCKDEF
        BEGIN BLOCKDEF ps2if
            TIMESTAMP 2009 12 12 8 54 38
            LINE N 432 32 496 32 
            LINE N 64 -352 0 -352 
            LINE N 432 -96 496 -96 
            LINE N 432 -32 496 -32 
            LINE N 64 -288 0 -288 
            RECTANGLE N 0 -172 64 -148 
            LINE N 64 -160 0 -160 
            LINE N 64 -96 0 -96 
            LINE N 432 -224 496 -224 
            RECTANGLE N 64 -384 432 64 
            RECTANGLE N 432 -172 496 -148 
            LINE N 432 -160 496 -160 
            LINE N 432 -352 496 -352 
        END BLOCKDEF
        BEGIN BLOCK XLXI_341 constant
            BEGIN ATTR CValue "4"
                DELETE all:1 sym:0
                EDITNAME all:1 sch:0
                VALUETYPE BitVector 32 Hexadecimal
            END ATTR
            PIN O XLXN_892(3:0)
        END BLOCK
        BEGIN BLOCK XLXI_759 constant
            BEGIN ATTR CValue "10122009"
                DELETE all:1 sym:0
                EDITNAME all:1 sch:0
                VALUETYPE BitVector 32 Hexadecimal
            END ATTR
            PIN O XLXN_917(31:0)
        END BLOCK
        BEGIN BLOCK XLXI_833 ibufg
            PIN I ClkIn
            PIN O SYSCLK
        END BLOCK
        BEGIN BLOCK XLXI_894 or2
            PIN I0 XLXN_1586
            PIN I1 XLXN_1741
            PIN O CPU_RST
        END BLOCK
        BEGIN BLOCK XLXI_963 buf
            PIN I ComEna(0)
            PIN O F_Int
        END BLOCK
        BEGIN BLOCK XLXI_970 IRQ_latch
            PIN INT_0 XLXN_1742
            PIN INT_1 Strobe1
            PIN INT_2 Rx_data_present
            PIN INT_3 SPI_KeyStrobe
            PIN IRQ_CLR IRQ_CLR
            PIN IRQ_ACK IRQ_ACK
            PIN IRQ_SRC(3:0) IRQ_Source(3:0)
            PIN IRQ XLXN_1490
            PIN RST CPU_RST
        END BLOCK
        BEGIN BLOCK XLXI_978(7:0) buf
            PIN I VRAM_D(7:0)
            PIN O RAMD_RD(31:24)
        END BLOCK
        BEGIN BLOCK XLXI_980 SPI_LRC
            PIN F_DS F_DS
            PIN F_RS F_RS
            PIN F_SCLK F_SCK
            PIN F_MOSI F_MOSI
            PIN D3(31:0) XLXN_917(31:0)
            PIN D2(31:0) PS2_RdRaw(31:0)
            PIN D1(31:0)
            PIN D0(31:0) ComTx(31:0)
            PIN SYSCLK SYSCLK
            PIN BASEADR(3:0) XLXN_892(3:0)
            PIN RAMD_RD(31:0) RAMD_RD(31:0)
            PIN Q0(31:0)
            PIN Q1(31:0) ComRx(31:0)
            PIN Q2(31:0)
            PIN Q3(31:0) SPI_Key(31:0)
            PIN STROBE0
            PIN STROBE1 Strobe1
            PIN STROBE2
            PIN STROBE3 SPI_KeyStrobe
            PIN LC_OEN LC_OEN
            PIN LC_WEN LC_WEN
            PIN LC_ADDR(18:0) LC_ADR(18:0)
            PIN RAMD_WR(31:0) LC_DATA(31:0)
            PIN F_MISO F_MISO
            PIN LC_ENA_0 LC_ENA
            PIN LC_ENA_1
            PIN LC_ENA_2
            PIN LC_ENA_3
        END BLOCK
        BEGIN BLOCK XLXI_984 BASIC_glue
            PIN CLK_X4 XLXN_1728
            PIN SYSCLK SYSCLK
            PIN Rx_full XLXN_1648
            PIN Tx_full XLXN_1645
            PIN Rx_valid Rx_data_present
            PIN CPU_RST CPU_RST
            PIN CPU_RDn P_RD_N
            PIN CPU_WRn P_WR_N
            PIN LC_WEn LC_WEN
            PIN LC_OEn LC_OEN
            PIN LC_ENA XLXN_1726
            PIN VSYNC vs_out
            PIN PLOTSYNC XLXN_1724
            PIN PS2_TxBusy PS2_TxBusy
            PIN Rx_DATAi(7:0) XLXN_1639(7:0)
            PIN CPU_ADR(15:0) P_ADDR(15:0)
            PIN LC_ADR(18:0) LC_ADR(18:0)
            PIN CPU_DATAi(7:0) CPU_Do(7:0)
            PIN TEXTREAD(7:0) XLXN_1725(7:0)
            PIN LC_DATA(31:0) LC_DATA(31:0)
            PIN COMin(7:0) ComRx(7:0)
            PIN IRQsrc(7:0) IRQ_Source(7:0)
            PIN ASCII(7:0) SPI_Key(7:0)
            PIN PIN340(7:0)
            PIN PIN341(7:0)
            PIN PIN342(7:0)
            PIN PIN343(7:0)
            PIN PS2_RxData(7:0) PS2_RdRaw(7:0)
            PIN RAM_DATAz(7:0) VRAM_D(7:0)
            PIN Tx_write XLXN_1642
            PIN Rx_ack XLXN_1650
            PIN Rx_flush XLXN_1641
            PIN Tx_reset XLXN_1640
            PIN RAM_OEn OEN
            PIN RAM_WEn WEN
            PIN GCMD_WR XLXN_1713
            PIN TCMD_WR XLXN_1712
            PIN IRQ_ACK IRQ_ACK
            PIN IRQ_CLR IRQ_CLR
            PIN SER_SEL XLXN_1727
            PIN DMA XLXN_1723
            PIN IO600_WEn IO600_WRn
            PIN IO600_RDn IO600_Rdn
            PIN RAM_ADR(18:0) VRAM_A(18:0)
            PIN CPU_DATAo(7:0) XLXN_1180(7:0)
            PIN Bd_SEL(2:0) XLXN_1714(2:0)
            PIN COMout(7:0) ComTx(31:24)
            PIN INTstr(7:0) ComEna(7:0)
            PIN PORT340(7:0)
            PIN PORT341(7:0)
            PIN PORT342(7:0)
            PIN PORT343(7:0)
            PIN PS2_TxData(7:0) PS2_TxData(7:0)
            PIN PS2_TxStr PS2_TxStr
        END BLOCK
        BEGIN BLOCK XLXI_990 and3
            PIN I0 LC_ENA
            PIN I1 LC_ADR(15)
            PIN I2 LC_ADR(14)
            PIN O XLXN_1585
        END BLOCK
        BEGIN BLOCK XLXI_994 fd
            PIN C SYSCLK
            PIN D XLXN_1585
            PIN Q XLXN_1586
        END BLOCK
        BEGIN BLOCK XLXI_985 inv
            PIN I vs_out
            PIN O XLXN_1592
        END BLOCK
        BEGIN BLOCK XLXI_905 inv
            PIN I XLXN_1723
            PIN O TestLED
        END BLOCK
        BEGIN BLOCK XLXI_1002 GTEXT
            PIN SYSCLK50 SYSCLK
            PIN RST CPU_RST
            PIN DATA(7:0) CPU_Do(7:0)
            PIN ADR(3:0) P_ADDR(3:0)
            PIN GCMD_WR XLXN_1713
            PIN TCMD_WR XLXN_1712
            PIN VSYNC vs_out
            PIN BLINK
            PIN HSYNC hs_out
            PIN RED(2:0) red_out(2:0)
            PIN GREEN(2:0) green_out(2:0)
            PIN BLUE(2:0) blue_out(2:0)
            PIN GDONE IRQ_Source(7)
            PIN PLOTSYNC XLXN_1724
            PIN TEXTREAD(7:0) XLXN_1725(7:0)
        END BLOCK
        BEGIN BLOCK XLXI_997 UART
            PIN Tx_Data(7:0) CPU_Do(7:0)
            PIN Rx_flush XLXN_1641
            PIN Tx_write XLXN_1642
            PIN Rx_ack XLXN_1650
            PIN Tx_reset XLXN_1640
            PIN SYSCLK SYSCLK
            PIN Rx_Data(7:0) XLXN_1639(7:0)
            PIN Rx_valid Rx_data_present
            PIN Tx_full XLXN_1645
            PIN Rx_full XLXN_1648
            PIN BaudSel(2:0) XLXN_1714(2:0)
            PIN SEL XLXN_1727
            PIN Opto_Rx Opto_Rx
            PIN Opto_Tx Opto_Tx
            PIN Serial_Rx Serial_Rx
            PIN Serial_Tx Serial_Tx
        END BLOCK
        BEGIN BLOCK XLXI_1004 t65_wrap
            PIN RST CPU_RST
            PIN IRQ XLXN_1490
            PIN NMI XLXN_1592
            PIN HALT LC_ENA
            PIN SYSCLK SYSCLK
            PIN DATA_I(7:0) XLXN_1180(7:0)
            PIN WR_N P_WR_N
            PIN BUSENA_N
            PIN CLK_X4 XLXN_1728
            PIN HALTED XLXN_1726
            PIN RD_N P_RD_N
            PIN ADDR(15:0) P_ADDR(15:0)
            PIN DATA_O(7:0) CPU_Do(7:0)
        END BLOCK
        BEGIN BLOCK XLXI_1006 ps2if
            PIN SYSCLK SYSCLK
            PIN RST LC_ENA
            PIN TxData(7:0) PS2_TxData(7:0)
            PIN TxWrStr PS2_TxStr
            PIN PS2data PS2_Data
            PIN PS2clk PS2_Clk
            PIN PauseKey XLXN_1741
            PIN TxBusy PS2_TxBusy
            PIN RxData(7:0) PS2_RdRaw(7:0)
            PIN RxIRQ XLXN_1742
        END BLOCK
    END NETLIST
    BEGIN SHEET 1 7040 5440
        ATTR LengthUnitName "Inch"
        ATTR GridsPerUnit "10"
        BEGIN BRANCH XLXN_892(3:0)
            WIRE 224 2080 336 2080
            WIRE 336 2032 336 2080
            WIRE 336 2032 528 2032
        END BRANCH
        BEGIN BRANCH XLXN_917(31:0)
            WIRE 224 1968 528 1968
        END BRANCH
        BEGIN BRANCH P_ADDR(15:0)
            WIRE 2000 1856 2080 1856
            WIRE 2080 1856 2080 2432
            WIRE 2080 2432 2240 2432
            WIRE 2080 1312 2080 1360
            WIRE 2080 1360 2080 1856
        END BRANCH
        BEGIN BRANCH P_RD_N
            WIRE 2000 1792 2224 1792
            WIRE 2224 1792 2224 2080
            WIRE 2224 2080 2224 2304
            WIRE 2224 2304 2240 2304
            BEGIN DISPLAY 2224 2080 ATTR Name
                ALIGNMENT SOFT-TVCENTER
            END DISPLAY
        END BRANCH
        BEGIN BRANCH P_WR_N
            WIRE 2000 1728 2176 1728
            WIRE 2176 1728 2176 2080
            WIRE 2176 2080 2176 2368
            WIRE 2176 2368 2240 2368
            BEGIN DISPLAY 2176 2080 ATTR Name
                ALIGNMENT SOFT-TVCENTER
            END DISPLAY
        END BRANCH
        BEGIN BRANCH VRAM_A(18:0)
            WIRE 2752 2624 3264 2624
        END BRANCH
        BEGIN BRANCH OEN
            WIRE 2752 2688 3264 2688
        END BRANCH
        BEGIN BRANCH VRAM_D(7:0)
            WIRE 2752 2816 3120 2816
            WIRE 3120 2816 3248 2816
            WIRE 3120 2816 3120 2928
        END BRANCH
        BEGIN BRANCH XLXN_1180(7:0)
            WIRE 1488 1488 1488 1920
            WIRE 1488 1920 1568 1920
            WIRE 1488 1488 2800 1488
            WIRE 2800 1488 2800 1984
            WIRE 2752 1984 2800 1984
        END BRANCH
        BEGIN BRANCH P_ADDR(3:0)
            WIRE 2176 1360 2464 1360
            WIRE 2464 1360 3104 1360
            BEGIN DISPLAY 2464 1360 ATTR Name
                ALIGNMENT SOFT-BCENTER
            END DISPLAY
        END BRANCH
        BUSTAP 2080 1360 2176 1360
        BEGIN BRANCH ClkIn
            WIRE 192 1168 224 1168
        END BRANCH
        BEGIN BRANCH SPI_Key(7:0)
            WIRE 1968 3584 2240 3584
            BEGIN DISPLAY 1968 3584 ATTR Name
                ALIGNMENT SOFT-RIGHT
            END DISPLAY
        END BRANCH
        BEGIN BRANCH ComRx(7:0)
            WIRE 1968 3456 2240 3456
            BEGIN DISPLAY 1968 3456 ATTR Name
                ALIGNMENT SOFT-RIGHT
            END DISPLAY
        END BRANCH
        BEGIN BRANCH SPI_Key(31:0)
            WIRE 1040 1968 1136 1968
            BEGIN DISPLAY 1136 1968 ATTR Name
                ALIGNMENT SOFT-LEFT
            END DISPLAY
        END BRANCH
        IOMARKER 272 1712 F_MOSI R180 28
        IOMARKER 272 1520 F_DS R180 28
        IOMARKER 272 1648 F_SCK R180 28
        IOMARKER 272 1584 F_RS R180 28
        BEGIN BRANCH SPI_KeyStrobe
            WIRE 1040 1712 1184 1712
            WIRE 1184 1712 1216 1712
            WIRE 1184 768 1600 768
            WIRE 1184 768 1184 1712
            BEGIN DISPLAY 1216 1712 ATTR Name
                ALIGNMENT SOFT-LEFT
            END DISPLAY
        END BRANCH
        BEGIN BRANCH IRQ_Source(7:0)
            WIRE 1968 3520 2240 3520
            BEGIN DISPLAY 1968 3520 ATTR Name
                ALIGNMENT SOFT-RIGHT
            END DISPLAY
        END BRANCH
        BEGIN BRANCH ComTx(31:24)
            WIRE 2752 3456 3264 3456
            BEGIN DISPLAY 3264 3456 ATTR Name
                ALIGNMENT SOFT-LEFT
            END DISPLAY
        END BRANCH
        BEGIN BRANCH ComTx(31:0)
            WIRE 416 1776 528 1776
            BEGIN DISPLAY 416 1776 ATTR Name
                ALIGNMENT SOFT-RIGHT
            END DISPLAY
        END BRANCH
        BEGIN BRANCH ComRx(31:0)
            WIRE 1040 1840 1136 1840
            BEGIN DISPLAY 1136 1840 ATTR Name
                ALIGNMENT SOFT-LEFT
            END DISPLAY
        END BRANCH
        BEGIN BRANCH ComEna(7:0)
            WIRE 2752 3520 3136 3520
            WIRE 3136 3520 3264 3520
            BEGIN DISPLAY 3264 3520 ATTR Name
                ALIGNMENT SOFT-LEFT
            END DISPLAY
        END BRANCH
        BEGIN BRANCH CPU_RST
            WIRE 1360 960 1424 960
            WIRE 1424 960 1600 960
            WIRE 1424 960 1424 1072
            WIRE 1424 1072 1424 1664
            WIRE 1424 1664 1568 1664
            WIRE 1424 1664 1424 2176
            WIRE 1424 2176 2240 2176
            WIRE 1424 1072 3104 1072
            BEGIN DISPLAY 1360 960 ATTR Name
                ALIGNMENT SOFT-RIGHT
            END DISPLAY
        END BRANCH
        BEGIN BRANCH F_Int
            WIRE 3456 3760 3584 3760
        END BRANCH
        BEGIN BRANCH Strobe1
            WIRE 1040 1584 1152 1584
            WIRE 1152 640 1152 1584
            WIRE 1152 640 1600 640
        END BRANCH
        BEGIN BRANCH IRQ_Source(3:0)
            WIRE 1984 576 2128 576
            BEGIN DISPLAY 2128 576 ATTR Name
                ALIGNMENT SOFT-LEFT
            END DISPLAY
        END BRANCH
        BEGIN INSTANCE XLXI_970 1600 928 R0
        END INSTANCE
        BEGIN BRANCH IRQ_CLR
            WIRE 1360 896 1600 896
            BEGIN DISPLAY 1360 896 ATTR Name
                ALIGNMENT SOFT-RIGHT
            END DISPLAY
        END BRANCH
        BEGIN BRANCH IRQ_ACK
            WIRE 1360 832 1600 832
            BEGIN DISPLAY 1360 832 ATTR Name
                ALIGNMENT SOFT-RIGHT
            END DISPLAY
        END BRANCH
        BEGIN BRANCH IRQ_CLR
            WIRE 2752 3328 3264 3328
            BEGIN DISPLAY 3264 3328 ATTR Name
                ALIGNMENT SOFT-LEFT
            END DISPLAY
        END BRANCH
        BEGIN BRANCH IRQ_ACK
            WIRE 2752 3264 3264 3264
            BEGIN DISPLAY 3264 3264 ATTR Name
                ALIGNMENT SOFT-LEFT
            END DISPLAY
        END BRANCH
        BEGIN BRANCH XLXN_1490
            WIRE 1552 1232 1552 1728
            WIRE 1552 1728 1568 1728
            WIRE 1552 1232 2016 1232
            WIRE 1984 896 2016 896
            WIRE 2016 896 2016 1232
        END BRANCH
        IOMARKER 3264 2752 WEN R0 28
        IOMARKER 3264 2624 VRAM_A(18:0) R0 28
        IOMARKER 3264 2688 OEN R0 28
        IOMARKER 3248 2816 VRAM_D(7:0) R0 28
        BEGIN BRANCH vs_out
            WIRE 1968 3264 2240 3264
            BEGIN DISPLAY 1968 3264 ATTR Name
                ALIGNMENT SOFT-RIGHT
            END DISPLAY
        END BRANCH
        IOMARKER 256 1040 F_MISO R180 28
        BEGIN BRANCH F_MISO
            WIRE 256 1040 1088 1040
            WIRE 1088 1040 1088 1456
            WIRE 1040 1456 1088 1456
        END BRANCH
        INSTANCE XLXI_978(7:0) 3088 2928 R90
        BEGIN BRANCH RAMD_RD(31:24)
            WIRE 3120 3152 3120 3200
            WIRE 3120 3200 3264 3200
            BEGIN DISPLAY 3264 3200 ATTR Name
                ALIGNMENT SOFT-LEFT
            END DISPLAY
        END BRANCH
        BEGIN BRANCH F_MOSI
            WIRE 272 1712 528 1712
        END BRANCH
        BEGIN BRANCH F_SCK
            WIRE 272 1648 528 1648
        END BRANCH
        BEGIN BRANCH F_RS
            WIRE 272 1584 528 1584
        END BRANCH
        BEGIN BRANCH F_DS
            WIRE 272 1520 528 1520
        END BRANCH
        BEGIN BRANCH LC_DATA(31:0)
            WIRE 1040 2352 1136 2352
            WIRE 1136 2352 1136 2816
            WIRE 1136 2816 1648 2816
            WIRE 1648 2816 2240 2816
            BEGIN DISPLAY 1648 2816 ATTR Name
                ALIGNMENT SOFT-BCENTER
            END DISPLAY
        END BRANCH
        BEGIN BRANCH LC_ADR(18:0)
            WIRE 1040 2160 1280 2160
            WIRE 1280 2160 1280 2624
            WIRE 1280 2624 1648 2624
            WIRE 1648 2624 2240 2624
            BEGIN DISPLAY 1648 2624 ATTR Name
                ALIGNMENT SOFT-BCENTER
            END DISPLAY
        END BRANCH
        IOMARKER 192 1168 ClkIn R180 28
        INSTANCE XLXI_833 224 1200 R0
        BEGIN INSTANCE XLXI_980 592 2448 R0
        END INSTANCE
        BEGIN BRANCH RAMD_RD(31:0)
            WIRE 384 2352 528 2352
            BEGIN DISPLAY 384 2352 ATTR Name
                ALIGNMENT SOFT-RIGHT
            END DISPLAY
        END BRANCH
        BEGIN BRANCH PS2_RdRaw(31:0)
            WIRE 416 1904 528 1904
            BEGIN DISPLAY 416 1904 ATTR Name
                ALIGNMENT SOFT-RIGHT
            END DISPLAY
        END BRANCH
        BEGIN INSTANCE XLXI_759 80 1936 R0
        END INSTANCE
        BEGIN INSTANCE XLXI_341 80 2048 R0
        END INSTANCE
        BEGIN INSTANCE XLXI_984 2240 3056 R0
        END INSTANCE
        BEGIN BRANCH LC_WEN
            WIRE 1040 2288 1184 2288
            WIRE 1184 2288 1184 2752
            WIRE 1184 2752 1648 2752
            WIRE 1648 2752 2240 2752
            BEGIN DISPLAY 1648 2752 ATTR Name
                ALIGNMENT SOFT-BCENTER
            END DISPLAY
        END BRANCH
        BEGIN BRANCH LC_OEN
            WIRE 1040 2224 1232 2224
            WIRE 1232 2224 1232 2688
            WIRE 1232 2688 1648 2688
            WIRE 1648 2688 2240 2688
            BEGIN DISPLAY 1648 2688 ATTR Name
                ALIGNMENT SOFT-BCENTER
            END DISPLAY
        END BRANCH
        BEGIN DISPLAY 3192 3124 TEXT "wg. 8-Bit-Transfer oberes Byte"
            FONT 40 "Arial"
        END DISPLAY
        BEGIN DISPLAY 1972 832 TEXT "IRQ Source Latch"
            FONT 56 "Arial"
        END DISPLAY
        BEGIN DISPLAY 268 4596 TEXT "AutoIncrement Counter"
            FONT 40 "Arial"
        END DISPLAY
        BEGIN DISPLAY 264 4676 TEXT "LC_WEN active low"
            FONT 32 "Arial"
        END DISPLAY
        BEGIN DISPLAY 264 4756 TEXT "LC_ENA active high from 1st RAMINCR pulse"
            FONT 32 "Arial"
        END DISPLAY
        BEGIN DISPLAY 264 4836 TEXT "(SPI SubCh 128), until CORERST (SPI SubCh 129)"
            FONT 32 "Arial"
        END DISPLAY
        BEGIN DISPLAY 264 4916 TEXT "new LC_ADDR valid after LC_WEN ends"
            FONT 32 "Arial"
        END DISPLAY
        BEGIN DISPLAY 260 5028 TEXT "RAMD valid before RAMINCR pulse"
            FONT 32 "Arial"
        END DISPLAY
        BEGIN BRANCH LC_ENA
            WIRE 304 3600 512 3600
            BEGIN DISPLAY 304 3600 ATTR Name
                ALIGNMENT SOFT-RIGHT
            END DISPLAY
        END BRANCH
        BEGIN BRANCH LC_ADR(15)
            WIRE 304 3536 512 3536
            BEGIN DISPLAY 304 3536 ATTR Name
                ALIGNMENT SOFT-RIGHT
            END DISPLAY
        END BRANCH
        BEGIN BRANCH LC_ADR(14)
            WIRE 304 3472 512 3472
            BEGIN DISPLAY 304 3472 ATTR Name
                ALIGNMENT SOFT-RIGHT
            END DISPLAY
        END BRANCH
        BEGIN BRANCH XLXN_1585
            WIRE 768 3536 784 3536
        END BRANCH
        BEGIN DISPLAY 220 3744 TEXT "CPU_RST nur oberhalb xC000h"
            FONT 40 "Arial"
        END DISPLAY
        BEGIN BRANCH XLXN_1592
            WIRE 1520 448 1520 1792
            WIRE 1520 1792 1568 1792
            WIRE 1520 448 3168 448
        END BRANCH
        BEGIN BRANCH CPU_Do(7:0)
            WIRE 2000 1920 2128 1920
            WIRE 2128 1920 3152 1920
            WIRE 2128 1920 2128 1984
            WIRE 2128 1984 2240 1984
            WIRE 2128 1424 2128 1920
            WIRE 2128 1424 2464 1424
            WIRE 2464 1424 3104 1424
            BEGIN DISPLAY 2464 1424 ATTR Name
                ALIGNMENT SOFT-BCENTER
            END DISPLAY
        END BRANCH
        BEGIN BRANCH XLXN_1639(7:0)
            WIRE 2752 2048 3152 2048
        END BRANCH
        BEGIN BRANCH WEN
            WIRE 2752 2752 3264 2752
        END BRANCH
        BEGIN DISPLAY 88 2176 TEXT "SPI 64..67"
            FONT 40 "Arial"
        END DISPLAY
        INSTANCE XLXI_985 3392 480 M0
        BEGIN BRANCH XLXN_1640
            WIRE 2752 2112 3152 2112
        END BRANCH
        BEGIN BRANCH XLXN_1641
            WIRE 2752 2160 3152 2160
        END BRANCH
        BEGIN BRANCH XLXN_1645
            WIRE 2752 2384 3152 2384
        END BRANCH
        BEGIN BRANCH XLXN_1648
            WIRE 2752 2432 3152 2432
        END BRANCH
        BEGIN BRANCH vs_out
            WIRE 3392 448 3680 448
            WIRE 3680 448 3680 1008
            WIRE 3680 1008 3920 1008
            WIRE 3584 1008 3680 1008
        END BRANCH
        BUSTAP 3136 3520 3136 3616
        BEGIN BRANCH ComEna(0)
            WIRE 3136 3616 3136 3648
            WIRE 3136 3648 3136 3760
            WIRE 3136 3760 3232 3760
            BEGIN DISPLAY 3136 3648 ATTR Name
                ALIGNMENT SOFT-TVCENTER
            END DISPLAY
        END BRANCH
        BEGIN BRANCH hs_out
            WIRE 3584 1072 3920 1072
        END BRANCH
        IOMARKER 3920 1072 hs_out R0 28
        IOMARKER 3920 1008 vs_out R0 28
        BEGIN BRANCH red_out(2:0)
            WIRE 3584 1312 3888 1312
        END BRANCH
        IOMARKER 3888 1312 red_out(2:0) R0 28
        BEGIN BRANCH green_out(2:0)
            WIRE 3584 1392 3888 1392
        END BRANCH
        IOMARKER 3888 1392 green_out(2:0) R0 28
        BEGIN BRANCH blue_out(2:0)
            WIRE 3584 1472 3888 1472
        END BRANCH
        IOMARKER 3888 1472 blue_out(2:0) R0 28
        BEGIN BRANCH IRQ_Source(7)
            WIRE 3584 1136 3904 1136
            BEGIN DISPLAY 3904 1136 ATTR Name
                ALIGNMENT SOFT-LEFT
            END DISPLAY
        END BRANCH
        BEGIN BRANCH XLXN_1714(2:0)
            WIRE 2752 2480 3152 2480
        END BRANCH
        BEGIN BRANCH XLXN_1650
            WIRE 2752 2256 3152 2256
        END BRANCH
        BEGIN BRANCH XLXN_1642
            WIRE 2752 2208 3152 2208
        END BRANCH
        BEGIN BRANCH IO600_Rdn
            WIRE 2752 3712 3008 3712
            WIRE 3008 3712 3008 4192
            WIRE 3008 4192 3584 4192
        END BRANCH
        BEGIN BRANCH IO600_WRn
            WIRE 2752 3648 3072 3648
            WIRE 3072 3648 3072 4128
            WIRE 3072 4128 3584 4128
        END BRANCH
        BEGIN BRANCH TestLED
            WIRE 3376 4032 3584 4032
        END BRANCH
        INSTANCE XLXI_905 3152 4064 R0
        IOMARKER 3584 4032 TestLED R0 28
        BEGIN BRANCH XLXN_1723
            WIRE 2752 4032 3152 4032
        END BRANCH
        IOMARKER 3584 4192 IO600_Rdn R0 28
        IOMARKER 3584 4128 IO600_WRn R0 28
        INSTANCE XLXI_963 3232 3792 R0
        IOMARKER 3584 3760 F_Int R0 28
        BEGIN BRANCH Rx_data_present
            WIRE 1552 704 1600 704
            WIRE 1552 704 1552 1120
            WIRE 1552 1120 2272 1120
            WIRE 2272 1120 2912 1120
            WIRE 2912 1120 2912 2336
            WIRE 2912 2336 3152 2336
            WIRE 2752 2336 2912 2336
            BEGIN DISPLAY 2280 1120 ATTR Name
                ALIGNMENT SOFT-BCENTER
            END DISPLAY
        END BRANCH
        BEGIN INSTANCE XLXI_1002 3104 1872 R0
        END INSTANCE
        BEGIN BRANCH XLXN_1724
            WIRE 2144 3328 2240 3328
            WIRE 2144 3328 2144 4400
            WIRE 2144 4400 4368 4400
            WIRE 3584 1536 4368 1536
            WIRE 4368 1536 4368 4400
        END BRANCH
        BEGIN BRANCH XLXN_1725(7:0)
            WIRE 2176 4032 2240 4032
            WIRE 2176 4032 2176 4352
            WIRE 2176 4352 4336 4352
            WIRE 3584 1600 4336 1600
            WIRE 4336 1600 4336 4352
        END BRANCH
        BEGIN BRANCH LC_ENA
            WIRE 416 2832 416 3008
            WIRE 416 3008 528 3008
            WIRE 416 2832 1344 2832
            WIRE 1040 2480 1344 2480
            WIRE 1344 2480 1344 2832
            WIRE 1344 1984 1568 1984
            WIRE 1344 1984 1344 2112
            WIRE 1344 2112 1344 2480
            BEGIN DISPLAY 1344 2112 ATTR Name
                ALIGNMENT SOFT-TVCENTER
            END DISPLAY
        END BRANCH
        BEGIN BRANCH XLXN_1726
            WIRE 2000 1984 2032 1984
            WIRE 2032 1984 2032 2560
            WIRE 2032 2560 2240 2560
        END BRANCH
        BEGIN DISPLAY 1664 1548 TEXT "6502 CPU"
            FONT 56 "Arial"
        END DISPLAY
        BEGIN BRANCH XLXN_1727
            WIRE 2752 2528 3152 2528
        END BRANCH
        BEGIN BRANCH Opto_Tx
            WIRE 3568 2112 3680 2112
        END BRANCH
        BEGIN BRANCH Opto_Rx
            WIRE 3568 2160 3680 2160
        END BRANCH
        IOMARKER 3680 2112 Opto_Tx R0 28
        IOMARKER 3680 2160 Opto_Rx R0 28
        BEGIN BRANCH Serial_Tx
            WIRE 3568 2208 3680 2208
        END BRANCH
        BEGIN BRANCH Serial_Rx
            WIRE 3568 2256 3680 2256
        END BRANCH
        IOMARKER 3680 2256 Serial_Rx R0 28
        IOMARKER 3680 2208 Serial_Tx R0 28
        BEGIN DISPLAY 3612 2472 TEXT "1=19200 Bd"
            FONT 40 "Arial"
        END DISPLAY
        BEGIN DISPLAY 3616 2520 TEXT "2=9600 Bd"
            FONT 40 "Arial"
        END DISPLAY
        BEGIN DISPLAY 3616 2568 TEXT "3=4800 Bd"
            FONT 40 "Arial"
        END DISPLAY
        BEGIN DISPLAY 3616 2616 TEXT "4=2400 Bd"
            FONT 40 "Arial"
        END DISPLAY
        BEGIN DISPLAY 3616 2664 TEXT "5=1200 Bd"
            FONT 40 "Arial"
        END DISPLAY
        BEGIN DISPLAY 3616 2712 TEXT "6=600 Bd"
            FONT 40 "Arial"
        END DISPLAY
        BEGIN DISPLAY 3616 2760 TEXT "7=300 Bd"
            FONT 40 "Arial"
        END DISPLAY
        BEGIN DISPLAY 3616 2424 TEXT "0=38400 Bd"
            FONT 40 "Arial"
        END DISPLAY
        BEGIN DISPLAY 3616 2376 TEXT "Bd_SEL $31E"
            FONT 40 "Arial"
        END DISPLAY
        BEGIN DISPLAY 3616 2328 TEXT "Ser_SEL $31F, 0=Opto, 1=RS232"
            FONT 40 "Arial"
        END DISPLAY
        BEGIN INSTANCE XLXI_997 3152 2400 R0
        END INSTANCE
        BEGIN INSTANCE XLXI_1004 1568 1952 R0
        END INSTANCE
        BEGIN BRANCH SYSCLK
            WIRE 448 1168 464 1168
            WIRE 464 1168 464 1456
            WIRE 464 1456 528 1456
            WIRE 464 1456 464 2656
            WIRE 464 2656 464 2944
            WIRE 464 2944 528 2944
            WIRE 464 2944 464 3664
            WIRE 464 3664 784 3664
            WIRE 464 1168 1456 1168
            WIRE 1456 1168 2880 1168
            WIRE 2880 1168 2880 1856
            WIRE 2880 1856 3152 1856
            WIRE 1456 1168 1456 1856
            WIRE 1456 1856 1568 1856
            WIRE 1456 1856 1456 3200
            WIRE 1456 3200 2240 3200
            WIRE 2880 1008 3104 1008
            WIRE 2880 1008 2880 1168
            BEGIN DISPLAY 464 2656 ATTR Name
                ALIGNMENT SOFT-TVCENTER
            END DISPLAY
        END BRANCH
        BEGIN BRANCH XLXN_1728
            WIRE 2000 2048 2112 2048
            WIRE 2112 2048 2112 2240
            WIRE 2112 2240 2240 2240
        END BRANCH
        BEGIN DISPLAY 2368 4480 TEXT "Ports auf $03XX"
            FONT 40 "Arial"
        END DISPLAY
        BEGIN BRANCH PS2_Clk
            WIRE 1024 3264 1216 3264
        END BRANCH
        BEGIN BRANCH PS2_Data
            WIRE 1024 3200 1216 3200
        END BRANCH
        BEGIN INSTANCE XLXI_1006 528 3296 R0
        END INSTANCE
        INSTANCE XLXI_994 784 3792 R0
        BEGIN BRANCH XLXN_1586
            WIRE 1168 3536 1328 3536
        END BRANCH
        BEGIN BRANCH CPU_RST
            WIRE 1584 3504 1616 3504
            BEGIN DISPLAY 1616 3504 ATTR Name
                ALIGNMENT SOFT-LEFT
            END DISPLAY
        END BRANCH
        BEGIN BRANCH XLXN_1712
            WIRE 2752 2880 2976 2880
            WIRE 2976 1216 3104 1216
            WIRE 2976 1216 2976 2880
        END BRANCH
        BEGIN BRANCH XLXN_1713
            WIRE 2752 2944 3008 2944
            WIRE 3008 1264 3104 1264
            WIRE 3008 1264 3008 2944
        END BRANCH
        BEGIN BRANCH PS2_TxBusy
            WIRE 1024 3072 1600 3072
            WIRE 1600 3072 2240 3072
            BEGIN DISPLAY 1600 3072 ATTR Name
                ALIGNMENT SOFT-BCENTER
            END DISPLAY
        END BRANCH
        BEGIN BRANCH PS2_TxData(7:0)
            WIRE 2752 3136 2816 3136
            BEGIN DISPLAY 2816 3136 ATTR Name
                ALIGNMENT SOFT-LEFT
            END DISPLAY
        END BRANCH
        BEGIN BRANCH PS2_TxStr
            WIRE 2752 3072 2816 3072
            BEGIN DISPLAY 2816 3072 ATTR Name
                ALIGNMENT SOFT-LEFT
            END DISPLAY
        END BRANCH
        BEGIN BRANCH PS2_TxData(7:0)
            WIRE 352 3136 528 3136
            BEGIN DISPLAY 352 3136 ATTR Name
                ALIGNMENT SOFT-RIGHT
            END DISPLAY
        END BRANCH
        BEGIN BRANCH PS2_TxStr
            WIRE 352 3200 528 3200
            BEGIN DISPLAY 352 3200 ATTR Name
                ALIGNMENT SOFT-RIGHT
            END DISPLAY
        END BRANCH
        INSTANCE XLXI_990 512 3664 R0
        INSTANCE XLXI_894 1328 3600 R0
        BEGIN BRANCH XLXN_1741
            WIRE 1024 3328 1296 3328
            WIRE 1296 3328 1296 3472
            WIRE 1296 3472 1328 3472
        END BRANCH
        IOMARKER 1216 3264 PS2_Clk R0 28
        IOMARKER 1216 3200 PS2_Data R0 28
        BEGIN BRANCH XLXN_1742
            WIRE 1024 2944 1392 2944
            WIRE 1392 576 1600 576
            WIRE 1392 576 1392 2944
        END BRANCH
        BEGIN BRANCH PS2_RdRaw(7:0)
            WIRE 1024 3136 1616 3136
            WIRE 1616 3136 2240 3136
            BEGIN DISPLAY 1624 3136 ATTR Name
                ALIGNMENT SOFT-BCENTER
            END DISPLAY
        END BRANCH
    END SHEET
END SCHEMATIC
