----------------------------------------------------------------------------------
-- Company: 
-- Engineer:       Carsten Meyer, cm@ct.de
-- 
-- Create Date:    12:41:05 04/09/2009 
-- Design Name: 
-- Module Name:    kcbaud - Behavioral 
-- Project Name: 
-- Target Devices: 
-- Tool versions: 
-- Description:    configurable Baud Rate generator
--
-- Dependencies: 
--
-- Revision: 
-- Revision 0.01 - File Created
-- Additional Comments: 
--
----------------------------------------------------------------------------------
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;

---- Uncomment the following library declaration if instantiating
---- any Xilinx primitives in this code.
--library UNISIM;
--use UNISIM.VComponents.all;

entity kcbaud is
    Port ( 
		SYSCLK : in  STD_LOGIC;
		BaudSel: in STD_LOGIC_VECTOR (2 downto 0);
		BAUDx16 : out  STD_LOGIC);
end kcbaud;

architecture Behavioral of kcbaud is

signal baud_count: integer range 0 to 16383 :=0;
signal baud_max: integer range 0 to 16383 :=0;


begin

  -- Set baud rate to 38400 or derivates for the UART communications -cm
  -- Requires en_16_x_baud to be 614400Hz which is a single cycle pulse every 81 cycles at 50MHz 

with BaudSel select 
	baud_max <= 162 when "001",
		325 when "010",
		650 when "011",
		1301 when "100",
		2603 when "101",
		5207 when "110",
		10416 when "111",
		80 when others;

baud_timer: process(SYSCLK)
begin
	if SYSCLK'event and SYSCLK='1' then
		if baud_count = baud_max then
			baud_count <= 0;
			BAUDx16 <= '1';
		else
			baud_count <= baud_count + 1;
			BAUDx16 <= '0';
		end if;
	end if;
end process baud_timer;

end Behavioral;

