-- VHDL Entity R65C02_TC.FSM_Execution_Unit.symbol
--
-- Created:
--          by - eda.UNKNOWN (ENTWICKL4-XP-PR)
--          at - 15:22:30 25.02.2009
--
-- Generated by Mentor Graphics' HDL Designer(TM) 2007.1a (Build 13)
--
LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;

entity FSM_Execution_Unit is
   port( 
      adr_nxt_pc_i  : in     std_logic_vector (15 downto 0);
      adr_pc_i      : in     std_logic_vector (15 downto 0);
      adr_sp_i      : in     std_logic_vector (15 downto 0);
      alu_dec_val_i : in     std_logic_vector ( 7 downto 0 );
      clk_clk_i     : in     std_logic;
      d_alu_i       : in     std_logic_vector ( 7 downto 0 );
      d_i           : in     std_logic_vector ( 7 downto 0 );
      d_regs_out_i  : in     std_logic_vector ( 7 downto 0 );
      irq_n_i       : in     std_logic;
      nmi_i         : in     std_logic;
      q_a_i         : in     std_logic_vector ( 7 downto 0 );
      q_x_i         : in     std_logic_vector ( 7 downto 0 );
      q_y_i         : in     std_logic_vector ( 7 downto 0 );
      rdy_i         : in     std_logic;
      reg_0flag_i   : in     std_logic;
      reg_1flag_i   : in     std_logic;
      reg_7flag_i   : in     std_logic;
      rst_rst_n_i   : in     std_logic;
      so_n_i        : in     std_logic;
      a_o           : out    std_logic_vector (15 downto 0);
      adr_o         : out    std_logic_vector (15 downto 0);
      ch_a_o        : out    std_logic_vector ( 7 downto 0 );
      ch_b_o        : out    std_logic_vector ( 7 downto 0 );
      d_o           : out    std_logic_vector ( 7 downto 0 );
      d_regs_in_o   : out    std_logic_vector ( 7 downto 0 );
      fetch_o       : out    std_logic;
      ld_o          : out    std_logic_vector ( 1 downto 0 );
      ld_pc_o       : out    std_logic;
      ld_sp_o       : out    std_logic;
      load_regs_o   : out    std_logic;
      offset_o      : out    std_logic_vector ( 15 downto 0 );
      rd_o          : out    std_logic;
      sel_pc_in_o   : out    std_logic;
      sel_pc_val_o  : out    std_logic_vector ( 1 downto 0 );
      sel_rb_in_o   : out    std_logic_vector ( 1 downto 0 );
      sel_rb_out_o  : out    std_logic_vector ( 1 downto 0 );
      sel_reg_o     : out    std_logic_vector ( 1 downto 0 );
      sel_sp_as_o   : out    std_logic;
      sel_sp_in_o   : out    std_logic;
      sync_o        : out    std_logic;
      wr_o          : out    std_logic
   );

-- Declarations

end FSM_Execution_Unit ;

-- Jens-D. Gutschmidt     Project:  R65C02_TC  

-- scantara2003@yahoo.de                       

-- COPYRIGHT (C) 2008-2009 by Jens Gutschmidt and OPENCORES.ORG                                                                                

--                                                                                                                                             

-- This program is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by   

-- the Free Software Foundation, either version 3 of the License, or any later version.                                                        

--                                                                                                                                             

-- This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of              

-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more details.                                  

--                                                                                                                                             

-- You should have received a copy of the GNU General Public License along with this program.  If not, see <http://www.gnu.org/licenses/>.     

--                                                                                                                                             

-- CVS Revisins History                                                                                                                        

--                                                                                                                                             

-- $Log: not supported by cvs2svn $                                                                                                                            

--   <<-- more -->>                                                                                                                            

-- Title:  FSM Execution Unit for all op codes  

-- Path:  R65C02_TC/FSM_Execution_Unit/fsm  

-- Edited:  by eda on 25 Feb 2009  

--
-- VHDL Architecture R65C02_TC.FSM_Execution_Unit.fsm
--
-- Created:
--          by - eda.UNKNOWN (ENTWICKL4-XP-PR)
--          at - 15:22:32 25.02.2009
--
-- Generated by Mentor Graphics' HDL Designer(TM) 2007.1a (Build 13)
--
LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
 
architecture fsm of FSM_Execution_Unit is

   -- Architecture Declarations
   signal reg_F : std_logic_vector( 7 DOWNTO 0 );  
   signal reg_PC : std_logic_vector(15 DOWNTO 0);  
   signal reg_PC1 : std_logic_vector( 15 DOWNTO 0 );  
   signal reg_sel_pc_in : std_logic;  
   signal reg_sel_pc_val : std_logic_vector( 1 DOWNTO 0 );  
   signal reg_sel_rb_in : std_logic_vector( 1 DOWNTO 0 );  
   signal reg_sel_rb_out : std_logic_vector( 1 DOWNTO 0 );  
   signal reg_sel_reg : std_logic_vector( 1 DOWNTO 0 );  
   signal reg_sel_sp_as : std_logic;  
   signal reg_sel_sp_in : std_logic;  
   signal sig_D_OUT : std_logic_vector( 7 DOWNTO 0 );  
   signal sig_PC : std_logic_vector(15 DOWNTO 0);  
   signal sig_SYNC : std_logic;  
   signal sig_WR : std_logic;  
   signal zw_ALU : std_logic_vector( 8 DOWNTO 0 );  
   signal zw_ALU1 : std_logic_vector( 4 DOWNTO 0 );  
   signal zw_ALU2 : std_logic_vector( 4 DOWNTO 0 );  
   signal zw_ALU3 : std_logic_vector( 4 DOWNTO 0 );  
   signal zw_ALU4 : std_logic_vector( 4 DOWNTO 0 );  
   signal zw_ALU5 : std_logic_vector( 3 DOWNTO 0 );  
   signal zw_ALU6 : std_logic_vector( 3 DOWNTO 0 );  
   signal zw_PC : std_logic_vector( 15 DOWNTO 0 );  
   signal zw_REG_ALU : std_logic_vector( 8 DOWNTO 0 );  
   signal zw_REG_NMI : std_logic;  
   signal zw_REG_OP : std_logic_vector( 7 DOWNTO 0 );  
   signal zw_REG_sig_PC : std_logic_vector(15 DOWNTO 0);  
   signal zw_b1 : std_logic_vector( 7 DOWNTO 0 );  
   signal zw_b2 : std_logic_vector( 7 DOWNTO 0 );  
   signal zw_b3 : std_logic_vector( 7 DOWNTO 0 );  
   signal zw_b4 : std_logic_vector( 7 DOWNTO 0 );  
   signal zw_so : std_logic;  
   signal zw_w1 : std_logic_vector( 15 DOWNTO 0 );  
   signal zw_w2 : std_logic_vector( 15 DOWNTO 0 );  
   signal zw_w3 : std_logic_vector( 15 DOWNTO 0 );  

   subtype state_type is 
      std_logic_vector(7 downto 0);
 
   -- State vector declaration
   attribute state_vector : string;
   attribute state_vector of fsm : architecture is "current_state";

   -- Hard encoding
   constant G30_1 : state_type := "00000000";
   constant G30_3 : state_type := "00000001";
   constant G30_4 : state_type := "00000010";
   constant G30_5 : state_type := "00000011";
   constant G30_e : state_type := "00000100";
   constant G30_2 : state_type := "00000101";
   constant RES : state_type := "00000110";
   constant G28_1 : state_type := "00000111";
   constant G28_2 : state_type := "00001000";
   constant G28_3 : state_type := "00001001";
   constant G28_5 : state_type := "00001010";
   constant G28_4 : state_type := "00001011";
   constant G28_e : state_type := "00001100";
   constant G29_1 : state_type := "00001101";
   constant G29_2 : state_type := "00001110";
   constant G29_3 : state_type := "00001111";
   constant G29_5 : state_type := "00010000";
   constant G29_4 : state_type := "00010001";
   constant G29_e : state_type := "00010010";
   constant FETCH : state_type := "00010011";
   constant G1_1 : state_type := "00010100";
   constant G2_1 : state_type := "00010101";
   constant G3_1 : state_type := "00010110";
   constant G4_1 : state_type := "00010111";
   constant G9_1 : state_type := "00011000";
   constant G5_1 : state_type := "00011001";
   constant G6_1 : state_type := "00011010";
   constant G7_1 : state_type := "00011011";
   constant G8_1 : state_type := "00011100";
   constant G19_1 : state_type := "00011101";
   constant G15_1 : state_type := "00011110";
   constant G15_3 : state_type := "00011111";
   constant G15_4 : state_type := "00100000";
   constant G15_5 : state_type := "00100001";
   constant G15_2 : state_type := "00100010";
   constant G15_7 : state_type := "00100011";
   constant G15_e3 : state_type := "00100100";
   constant G15_6 : state_type := "00100101";
   constant G15_e2 : state_type := "00100110";
   constant G15_e1 : state_type := "00100111";
   constant G15_8 : state_type := "00101000";
   constant G10_1 : state_type := "00101001";
   constant G10_3 : state_type := "00101010";
   constant G10_4 : state_type := "00101011";
   constant G10_5 : state_type := "00101100";
   constant G10_2 : state_type := "00101101";
   constant G10_7 : state_type := "00101110";
   constant G10_e3 : state_type := "00101111";
   constant G10_e1 : state_type := "00110000";
   constant G10_e2 : state_type := "00110001";
   constant G10_6 : state_type := "00110010";
   constant G10_8 : state_type := "00110011";
   constant G17_1 : state_type := "00110100";
   constant G17_4 : state_type := "00110101";
   constant G17_6 : state_type := "00110110";
   constant G17_3 : state_type := "00110111";
   constant G17_2 : state_type := "00111000";
   constant G17_8 : state_type := "00111001";
   constant G17_9 : state_type := "00111010";
   constant G17_7 : state_type := "00111011";
   constant G17_5 : state_type := "00111100";
   constant G17_10 : state_type := "00111101";
   constant G17_e : state_type := "00111110";
   constant G17_11 : state_type := "00111111";
   constant G16_1 : state_type := "01000000";
   constant G16_3 : state_type := "01000001";
   constant G16_4 : state_type := "01000010";
   constant G16_5 : state_type := "01000011";
   constant G16_2 : state_type := "01000100";
   constant G16_7 : state_type := "01000101";
   constant G16_6 : state_type := "01000110";
   constant G16_e3 : state_type := "01000111";
   constant G16_e1 : state_type := "01001000";
   constant G16_e2 : state_type := "01001001";
   constant G16_8 : state_type := "01001010";
   constant G11_1 : state_type := "01001011";
   constant G11_5 : state_type := "01001100";
   constant G11_6 : state_type := "01001101";
   constant G11_2 : state_type := "01001110";
   constant G11_7 : state_type := "01001111";
   constant G11_3 : state_type := "01010000";
   constant G11_4 : state_type := "01010001";
   constant G11_e : state_type := "01010010";
   constant G31_1 : state_type := "01010011";
   constant G34_1 : state_type := "01010100";
   constant G32_1 : state_type := "01010101";
   constant G33_1 : state_type := "01010110";
   constant G12_1 : state_type := "01010111";
   constant G12_e1 : state_type := "01011000";
   constant G12_e2 : state_type := "01011001";
   constant G12_2 : state_type := "01011010";
   constant G12_3 : state_type := "01011011";
   constant G12_4 : state_type := "01011100";
   constant G20_1 : state_type := "01011101";
   constant G20_2 : state_type := "01011110";
   constant G20_5 : state_type := "01011111";
   constant G20_e : state_type := "01100000";
   constant G20_3 : state_type := "01100001";
   constant G20_4 : state_type := "01100010";
   constant G21_1 : state_type := "01100011";
   constant G21_2 : state_type := "01100100";
   constant G21_3 : state_type := "01100101";
   constant G21_4 : state_type := "01100110";
   constant G21_e : state_type := "01100111";
   constant G13_3 : state_type := "01101000";
   constant G13_1 : state_type := "01101001";
   constant G13_4 : state_type := "01101010";
   constant G13_2 : state_type := "01101011";
   constant G13_e1 : state_type := "01101100";
   constant G13_e2 : state_type := "01101101";
   constant G18_1 : state_type := "01101110";
   constant G18_2 : state_type := "01101111";
   constant G18_3 : state_type := "01110000";
   constant G18_4 : state_type := "01110001";
   constant G18_e : state_type := "01110010";
   constant G18_5 : state_type := "01110011";
   constant G26_1 : state_type := "01110100";
   constant G26_2 : state_type := "01110101";
   constant G26_3 : state_type := "01110110";
   constant G26_4 : state_type := "01110111";
   constant G26_e : state_type := "01111000";
   constant G27_1 : state_type := "01111001";
   constant G27_2 : state_type := "01111010";
   constant G27_3 : state_type := "01111011";
   constant G27_4 : state_type := "01111100";
   constant G27_e : state_type := "01111101";
   constant G14_1 : state_type := "01111110";
   constant G14_5 : state_type := "01111111";
   constant G14_6 : state_type := "10000000";
   constant G14_2 : state_type := "10000001";
   constant G14_7 : state_type := "10000010";
   constant G14_3 : state_type := "10000011";
   constant G14_4 : state_type := "10000100";
   constant G14_e : state_type := "10000101";
   constant G22_1 : state_type := "10000110";
   constant G22_e : state_type := "10000111";
   constant G23_1 : state_type := "10001000";
   constant G23_e : state_type := "10001001";
   constant G24_1 : state_type := "10001010";
   constant G24_2 : state_type := "10001011";
   constant G24_e : state_type := "10001100";
   constant G25_1 : state_type := "10001101";
   constant G25_2 : state_type := "10001110";
   constant G25_e : state_type := "10001111";

   -- Declare current and next state signals
   signal current_state : state_type;
   signal next_state : state_type;

   -- Declare any pre-registered internal signals
   signal d_o_cld : std_logic_vector ( 7 downto 0 );
   signal rd_o_cld : std_logic ;
   signal sync_o_cld : std_logic ;
   signal wr_o_cld : std_logic ;

begin

   -----------------------------------------------------------------
   clocked_proc : process ( 
      clk_clk_i,
      rst_rst_n_i
   )
   -----------------------------------------------------------------
   begin
      if (rst_rst_n_i = '0') then
         current_state <= RES;
         -- Default Reset Values
         d_o_cld <= X"00";
         rd_o_cld <= '0';
         sync_o_cld <= '0';
         wr_o_cld <= '0';
         reg_F <= "00000100";
         reg_PC <= X"0000";
         reg_PC1 <= X"0000";
         reg_sel_pc_in <= '0';
         reg_sel_pc_val <= "00";
         reg_sel_rb_in <= "00";
         reg_sel_rb_out <= "00";
         reg_sel_reg <= "00";
         reg_sel_sp_as <= '0';
         reg_sel_sp_in <= '0';
         sig_PC <= X"0000";
         zw_PC <= X"0000";
         zw_REG_ALU <= '0' & X"00";
         zw_REG_NMI <= '0';
         zw_REG_OP <= X"00";
         zw_REG_sig_PC <= X"0000";
         zw_b1 <= X"00";
         zw_b2 <= X"00";
         zw_b3 <= X"00";
         zw_b4 <= X"00";
         zw_so <= '0';
         zw_w1 <= X"0000";
         zw_w2 <= X"0000";
         zw_w3 <= X"0000";
      elsif (clk_clk_i'event and clk_clk_i = '1') then
         current_state <= next_state;
         -- Default Assignment To Internals
         reg_F <= reg_F(7) & (zw_so OR reg_F(6)) & reg_F(5 downto 0);
         reg_PC <= reg_PC;
         reg_PC1 <= reg_PC1;
         reg_sel_pc_in <= reg_sel_pc_in;
         reg_sel_pc_val <= reg_sel_pc_val;
         reg_sel_rb_in <= reg_sel_rb_in;
         reg_sel_rb_out <= reg_sel_rb_out;
         reg_sel_reg <= reg_sel_reg;
         reg_sel_sp_as <= reg_sel_sp_as;
         reg_sel_sp_in <= reg_sel_sp_in;
         sig_PC <= sig_PC;
         zw_PC <= zw_PC;
         zw_REG_ALU <= zw_REG_ALU;
         zw_REG_NMI <= zw_REG_NMI or nmi_i;
         zw_REG_OP <= zw_REG_OP;
         zw_REG_sig_PC <= zw_REG_sig_PC;
         zw_b1 <= zw_b1;
         zw_b2 <= zw_b2;
         zw_b3 <= zw_b3;
         zw_b4 <= zw_b4;
         zw_so <= (zw_so OR (NOT(so_n_i))) AND (NOT(reg_F(6)));
         zw_w1 <= zw_w1;
         zw_w2 <= zw_w2;
         zw_w3 <= zw_w3;
         d_o_cld <= sig_D_OUT;
         rd_o_cld <= NOT(sig_WR);
         sync_o_cld <= sig_SYNC;
         wr_o_cld <= sig_WR;

         -- Combined Actions
         case current_state is
            when G30_1 => 
               sig_PC <= adr_sp_i;
            when G30_3 => 
               sig_PC <= adr_sp_i;
               reg_sel_pc_in <= '0';
               reg_sel_pc_val <= "00";
            when G30_4 => 
               sig_PC <= adr_pc_i;
            when G30_5 => 
               if (rdy_i = '1') then 
                  sig_PC <= adr_pc_i;
                  zw_w1 (7 downto 0) <= d_i;
                  reg_sel_pc_in <= '1';
                  reg_sel_pc_val <= "11";
               end if;
            when G30_e => 
               if (rdy_i = '1') then 
                  sig_PC  <= d_i & zw_w1 (7 downto 0);
                  reg_sel_pc_in <= '0';
                  reg_sel_pc_val <= "00";
                  reg_sel_sp_in <= '0';
                  reg_sel_sp_as <= '1';
               end if;
            when G30_2 => 
               sig_PC <= adr_sp_i;
               reg_sel_pc_in <= '1';
               reg_sel_pc_val <= "00";
            when RES => 
               reg_sel_pc_in <= '0';
               reg_sel_pc_val <= "00";
               sig_PC <= adr_nxt_pc_i;
               reg_sel_pc_in <= '0';
               reg_sel_pc_val <= "00";
               reg_sel_sp_in <= '0';
               reg_sel_sp_as <= '1';
            when G28_1 => 
               if (rdy_i = '1') then 
                  sig_PC <= adr_sp_i;
               end if;
            when G28_2 => 
               sig_PC <= adr_sp_i;
            when G28_3 => 
               sig_PC <= adr_sp_i;
            when G28_5 => 
               if (rdy_i = '1') then 
                  sig_PC <= X"FFFF";
                  zw_b1 <= d_i;
               end if;
            when G28_4 => 
               sig_PC <= X"FFFE";
            when G28_e => 
               if (rdy_i = '1') then 
                  sig_PC <= d_i & zw_b1;
                  reg_F(2) <= '1';
                  reg_sel_pc_in <= '0';
                  reg_sel_pc_val <= "00";
                  reg_sel_sp_in <= '0';
                  reg_sel_sp_as <= '1';
               end if;
            when G29_1 => 
               if (rdy_i = '1') then 
                  sig_PC <= adr_sp_i;
               end if;
            when G29_2 => 
               sig_PC <= adr_sp_i;
            when G29_3 => 
               sig_PC <= adr_sp_i;
            when G29_5 => 
               if (rdy_i = '1') then 
                  sig_PC <= X"FFFB";
                  reg_sel_pc_in <= '1';
                  reg_sel_pc_val <= "11";
                  zw_b1 <= d_i;
               end if;
            when G29_4 => 
               sig_PC <= X"FFFA";
            when G29_e => 
               if (rdy_i = '1') then 
                  sig_PC <= d_i & zw_b1;
                  reg_sel_pc_in <= '0';
                  reg_sel_pc_val <= "00";
                  reg_sel_sp_in <= '0';
                  reg_sel_sp_as <= '1';
               end if;
            when FETCH => 
               zw_REG_OP <= d_i;
               if ((zw_REG_NMI = '1') and (rdy_i = '1')) then 
                  sig_PC <= adr_nxt_pc_i;
                  zw_REG_NMI <= '0';
               elsif ((irq_n_i = '0' and
                      reg_F(2) = '0') and (rdy_i = '1')) then 
                  sig_PC <= adr_nxt_pc_i;
               elsif ((d_i = X"69" or
                      d_i = X"65" or
                      d_i = X"75" or
                      d_i = X"6D" or
                      d_i = X"7D" or
                      d_i = X"79" or
                      d_i = X"61" or
                      d_i = X"71" or
                      d_i = X"72") and (rdy_i = '1')) then 
                  sig_PC <= adr_nxt_pc_i;
                  reg_sel_reg <= "00";
                  reg_sel_rb_in <= "11";
                  zw_b1(0) <= reg_F(7);
               elsif ((d_i = X"06" or
                      d_i = X"16" or
                      d_i = X"0E" or
                      d_i = X"1E" or
                      d_i (3 downto 0) = X"7" or
                      d_i = X"14" or
                      d_i = X"04" or
                      d_i = X"0C" or
                      d_i = X"1C") and (rdy_i = '1')) then 
                  sig_PC <= adr_nxt_pc_i;
               elsif ((d_i = X"90" or
                      d_i = X"B0" or
                      d_i = X"F0" or
                      d_i = X"30" or
                      d_i = X"D0" or
                      d_i = X"10" or
                      d_i = X"50" or
                      d_i = X"70" or
                      d_i = X"80" or
                      d_i (3 downto 0) = X"F") and (rdy_i = '1')) then 
                  sig_PC <= adr_nxt_pc_i;
                  zw_b3 <= adr_nxt_pc_i (15 downto 8);
               elsif ((d_i = X"24" or
                      d_i = X"2C" or
                      d_i = X"3C" or
                      d_i = X"34" or
                      d_i = X"89") and (rdy_i = '1')) then 
                  sig_PC <= adr_nxt_pc_i;
               elsif ((d_i = X"00") and (rdy_i = '1')) then 
                  sig_PC <= adr_nxt_pc_i;
               elsif ((d_i = X"18") and (rdy_i = '1')) then 
               elsif ((d_i = X"D8") and (rdy_i = '1')) then 
               elsif ((d_i = X"58") and (rdy_i = '1')) then 
               elsif ((d_i = X"B8") and (rdy_i = '1')) then 
               elsif ((d_i = X"E0" or
                      d_i = X"E4" or
                      d_i = X"EC") and (rdy_i = '1')) then 
                  reg_sel_rb_out <= "01";
                  sig_PC <= adr_nxt_pc_i;
               elsif ((d_i = X"C0" or
                      d_i = X"C4" or
                      d_i = X"CC") and (rdy_i = '1')) then 
                  reg_sel_rb_out <= "10";
                  sig_PC <= adr_nxt_pc_i;
               elsif ((d_i = X"C6" or
                      d_i = X"D6" or
                      d_i = X"CE" or
                      d_i = X"DE") and (rdy_i = '1')) then 
                  zw_b4 <= X"FF";
                  sig_PC <= adr_nxt_pc_i;
               elsif ((d_i = X"CA") and (rdy_i = '1')) then 
                  reg_sel_rb_out <= "01";
                  reg_sel_reg <= "01";
                  reg_sel_rb_in <= "11";
                  zw_b4 <= X"FF";
               elsif ((d_i = X"88") and (rdy_i = '1')) then 
                  reg_sel_rb_out <= "10";
                  reg_sel_reg <= "10";
                  reg_sel_rb_in <= "11";
                  zw_b4 <= X"FF";
               elsif ((d_i = X"49" or
                      d_i = X"45" or
                      d_i = X"55" or
                      d_i = X"4D" or
                      d_i = X"5D" or
                      d_i = X"59" or
                      d_i = X"41" or
                      d_i = X"51" or
                      d_i = X"09" or
                      d_i = X"05" or
                      d_i = X"15" or
                      d_i = X"0D" or
                      d_i = X"1D" or
                      d_i = X"19" or
                      d_i = X"01" or
                      d_i = X"11" or
                      d_i = X"29" or
                      d_i = X"25" or
                      d_i = X"35" or
                      d_i = X"2D" or
                      d_i = X"3D" or
                      d_i = X"39" or
                      d_i = X"21" or
                      d_i = X"31" or
                      d_i = X"C9" or
                      d_i = X"C5" or
                      d_i = X"D5" or
                      d_i = X"CD" or
                      d_i = X"DD" or
                      d_i = X"D9" or
                      d_i = X"C1" or
                      d_i = X"D1" or
                      d_i = X"32" or
                      d_i = X"D2" or
                      d_i = X"52" or
                      d_i = X"12") and (rdy_i = '1')) then 
                  reg_sel_rb_out <= "00";
                  reg_sel_reg <= "00";
                  reg_sel_rb_in <= "11";
                  sig_PC <= adr_nxt_pc_i;
               elsif ((d_i = X"E6" or
                      d_i = X"F6" or
                      d_i = X"EE" or
                      d_i = X"FE") and (rdy_i = '1')) then 
                  zw_b4 <= X"01";
                  sig_PC <= adr_nxt_pc_i;
               elsif ((d_i = X"E8") and (rdy_i = '1')) then 
                  reg_sel_rb_out <= "01";
                  reg_sel_reg <= "01";
                  reg_sel_rb_in <= "11";
                  zw_b4 <= X"01";
               elsif ((d_i = X"C8") and (rdy_i = '1')) then 
                  reg_sel_rb_out <= "10";
                  reg_sel_reg <= "10";
                  reg_sel_rb_in <= "11";
                  zw_b4 <= X"01";
               elsif ((d_i = X"4C" or
                      d_i = X"6C" or
                      d_i = X"7C") and (rdy_i = '1')) then 
                  sig_PC <= adr_nxt_pc_i;
               elsif ((d_i = X"20") and (rdy_i = '1')) then 
                  sig_PC <= adr_nxt_pc_i;
               elsif ((d_i = X"A9" or
                      d_i = X"A5" or
                      d_i = X"B5" or
                      d_i = X"AD" or
                      d_i = X"BD" or
                      d_i = X"B9" or
                      d_i = X"A1" or
                      d_i = X"B1" or
                      d_i = X"B2") and (rdy_i = '1')) then 
                  reg_sel_reg <= "00";
                  reg_sel_rb_in <= "11";
                  sig_PC <= adr_nxt_pc_i;
               elsif ((d_i = X"A2" or
                      d_i = X"A6" or
                      d_i = X"B6" or
                      d_i = X"AE" or
                      d_i = X"BE") and (rdy_i = '1')) then 
                  reg_sel_reg <= "01";
                  reg_sel_rb_in <= "11";
                  sig_PC <= adr_nxt_pc_i;
               elsif ((d_i = X"A0" or
                      d_i = X"A4" or
                      d_i = X"B4" or
                      d_i = X"AC" or
                      d_i = X"BC") and (rdy_i = '1')) then 
                  reg_sel_reg <= "10";
                  reg_sel_rb_in <= "11";
                  sig_PC <= adr_nxt_pc_i;
               elsif ((d_i = X"46" or
                      d_i = X"56" or
                      d_i = X"4E" or
                      d_i = X"5E") and (rdy_i = '1')) then 
                  sig_PC <= adr_nxt_pc_i;
               elsif ((d_i = X"EA") and (rdy_i = '1')) then 
               elsif ((d_i = X"48") and (rdy_i = '1')) then 
                  reg_sel_rb_out <= "00";
                  sig_PC <= adr_nxt_pc_i;
               elsif ((d_i = X"08") and (rdy_i = '1')) then 
                  sig_PC <= adr_nxt_pc_i;
               elsif ((d_i = X"7A") and (rdy_i = '1')) then 
                  reg_sel_reg <= "10";
                  reg_sel_rb_in <= "11";
                  reg_sel_sp_in <= '0';
                  reg_sel_sp_as <= '0';
               elsif ((d_i = X"28") and (rdy_i = '1')) then 
                  reg_sel_sp_in <= '0';
                  reg_sel_sp_as <= '0';
               elsif ((d_i = X"26" or
                      d_i = X"36" or
                      d_i = X"2E" or
                      d_i = X"3E") and (rdy_i = '1')) then 
                  sig_PC <= adr_nxt_pc_i;
               elsif ((d_i = X"66" or
                      d_i = X"76" or
                      d_i = X"6E" or
                      d_i = X"7E") and (rdy_i = '1')) then 
                  sig_PC <= adr_nxt_pc_i;
               elsif ((d_i = X"40") and (rdy_i = '1')) then 
                  sig_PC <= adr_nxt_pc_i;
                  reg_sel_sp_in <= '0';
                  reg_sel_sp_as <= '0';
               elsif ((d_i = X"60") and (rdy_i = '1')) then 
                  sig_PC <= adr_nxt_pc_i;
                  reg_sel_sp_in <= '0';
                  reg_sel_sp_as <= '0';
               elsif ((d_i = X"E9" or
                      d_i = X"E5" or
                      d_i = X"F5" or
                      d_i = X"ED" or
                      d_i = X"FD" or
                      d_i = X"F9" or
                      d_i = X"E1" or
                      d_i = X"F1" or
                      d_i = X"F2") and (rdy_i = '1')) then 
                  sig_PC <= adr_nxt_pc_i;
                  reg_sel_reg <= "00";
                  reg_sel_rb_in <= "11";
                  zw_b1(0) <= reg_F(7);
               elsif ((d_i = X"38") and (rdy_i = '1')) then 
               elsif ((d_i = X"F8") and (rdy_i = '1')) then 
               elsif ((d_i = X"78") and (rdy_i = '1')) then 
               elsif ((d_i = X"85" or
                      d_i = X"95" or
                      d_i = X"8D" or
                      d_i = X"9D" or
                      d_i = X"99" or
                      d_i = X"81" or
                      d_i = X"91") and (rdy_i = '1')) then 
                  reg_sel_rb_out <= "00";
                  sig_PC <= adr_nxt_pc_i;
               elsif ((d_i = X"86" or
                      d_i = X"96" or
                      d_i = X"8E") and (rdy_i = '1')) then 
                  reg_sel_rb_out <= "01";
                  sig_PC <= adr_nxt_pc_i;
               elsif ((d_i = X"84" or
                      d_i = X"94" or
                      d_i = X"8C") and (rdy_i = '1')) then 
                  reg_sel_rb_out <= "10";
                  sig_PC <= adr_nxt_pc_i;
               elsif ((d_i = X"AA") and (rdy_i = '1')) then 
                  reg_sel_rb_out <= "00";
                  reg_sel_reg <= "01";
                  reg_sel_rb_in <= "00";
                  reg_sel_sp_in <= '1';
                  reg_sel_sp_as <= '0';
               elsif ((d_i = X"0A") and (rdy_i = '1')) then 
                  reg_sel_rb_out <= "00";
                  reg_sel_reg <= "00";
                  reg_sel_rb_in <= "11";
               elsif ((d_i = X"4A") and (rdy_i = '1')) then 
                  reg_sel_rb_out <= "00";
                  reg_sel_reg <= "00";
                  reg_sel_rb_in <= "11";
               elsif ((d_i = X"2A") and (rdy_i = '1')) then 
                  reg_sel_rb_out <= "00";
                  reg_sel_reg <= "00";
                  reg_sel_rb_in <= "11";
               elsif ((d_i = X"6A") and (rdy_i = '1')) then 
                  reg_sel_rb_out <= "00";
                  reg_sel_reg <= "00";
                  reg_sel_rb_in <= "11";
               elsif ((d_i = X"A8") and (rdy_i = '1')) then 
                  reg_sel_rb_out <= "00";
                  reg_sel_reg <= "10";
                  reg_sel_rb_in <= "00";
                  reg_sel_sp_in <= '1';
                  reg_sel_sp_as <= '0';
               elsif ((d_i = X"98") and (rdy_i = '1')) then 
                  reg_sel_rb_out <= "10";
                  reg_sel_reg <= "00";
                  reg_sel_rb_in <= "01";
                  reg_sel_sp_in <= '1';
                  reg_sel_sp_as <= '0';
               elsif ((d_i = X"BA") and (rdy_i = '1')) then 
                  reg_sel_rb_out <= "01";
                  reg_sel_reg <= "01";
                  reg_sel_rb_in <= "11";
                  reg_sel_sp_in <= '1';
                  reg_sel_sp_as <= '0';
               elsif ((d_i = X"8A") and (rdy_i = '1')) then 
                  reg_sel_rb_out <= "01";
                  reg_sel_reg <= "00";
                  reg_sel_rb_in <= "10";
                  reg_sel_sp_in <= '1';
                  reg_sel_sp_as <= '0';
               elsif ((d_i = X"9A") and (rdy_i = '1')) then 
                  reg_sel_rb_out <= "01";
                  reg_sel_reg <= "11";
                  reg_sel_rb_in <= "11";
                  reg_sel_sp_in <= '1';
                  reg_sel_sp_as <= '0';
               elsif ((d_i = X"DA") and (rdy_i = '1')) then 
                  reg_sel_rb_out <= "01";
                  sig_PC <= adr_nxt_pc_i;
               elsif ((d_i = X"5A") and (rdy_i = '1')) then 
                  reg_sel_rb_out <= "10";
                  sig_PC <= adr_nxt_pc_i;
               elsif ((d_i = X"68") and (rdy_i = '1')) then 
                  reg_sel_reg <= "00";
                  reg_sel_rb_in <= "11";
                  reg_sel_sp_in <= '0';
                  reg_sel_sp_as <= '0';
               elsif ((d_i = X"FA") and (rdy_i = '1')) then 
                  reg_sel_reg <= "01";
                  reg_sel_rb_in <= "11";
                  reg_sel_sp_in <= '0';
                  reg_sel_sp_as <= '0';
               elsif ((d_i = X"9C" or
                      d_i = X"9E" or
                      d_i = X"64" or
                      d_i = X"74") and (rdy_i = '1')) then 
                  reg_sel_rb_out <= "11";
                  sig_PC <= adr_nxt_pc_i;
               elsif ((d_i = X"3A") and (rdy_i = '1')) then 
                  reg_sel_rb_out <= "00";
                  reg_sel_reg <= "00";
                  reg_sel_rb_in <= "11";
                  zw_b4 <= X"FF";
               elsif ((d_i = X"1A") and (rdy_i = '1')) then 
                  reg_sel_rb_out <= "00";
                  reg_sel_reg <= "00";
                  reg_sel_rb_in <= "11";
                  zw_b4 <= X"01";
               end if;
            when G1_1 => 
               if (rdy_i = '1') then 
                  sig_PC <= adr_pc_i;
                  reg_sel_pc_in <= '0';
                  reg_sel_pc_val <= "00";
                  reg_sel_sp_in <= '0';
                  reg_sel_sp_as <= '1';
               end if;
            when G2_1 => 
               if (rdy_i = '1') then 
                  sig_PC <= adr_pc_i;
                  reg_F(0) <= '1';
                  reg_sel_pc_in <= '0';
                  reg_sel_pc_val <= "00";
                  reg_sel_sp_in <= '0';
                  reg_sel_sp_as <= '1';
               end if;
            when G3_1 => 
               if (rdy_i = '1') then 
                  sig_PC <= adr_pc_i;
                  reg_F(3) <= '1';
                  reg_sel_pc_in <= '0';
                  reg_sel_pc_val <= "00";
                  reg_sel_sp_in <= '0';
                  reg_sel_sp_as <= '1';
               end if;
            when G4_1 => 
               if (rdy_i = '1') then 
                  sig_PC <= adr_pc_i;
                  reg_F(2) <= '1';
                  reg_sel_pc_in <= '0';
                  reg_sel_pc_val <= "00";
                  reg_sel_sp_in <= '0';
                  reg_sel_sp_as <= '1';
               end if;
            when G9_1 => 
               if (rdy_i = '1' and
                   zw_REG_OP = X"9A") then 
                  sig_PC <= adr_pc_i;
                  reg_sel_pc_in <= '0';
                  reg_sel_pc_val <= "00";
                  reg_sel_sp_in <= '0';
                  reg_sel_sp_as <= '1';
               elsif (rdy_i = '1' and
                      zw_REG_OP = X"BA") then 
                  sig_PC <= adr_pc_i;
                  reg_F(7) <= reg_7flag_i;
                  reg_F(1) <= reg_1flag_i;
                  reg_sel_pc_in <= '0';
                  reg_sel_pc_val <= "00";
                  reg_sel_sp_in <= '0';
                  reg_sel_sp_as <= '1';
               elsif (rdy_i = '1') then 
                  sig_PC <= adr_pc_i;
                  reg_F(7) <= reg_7flag_i;
                  reg_F(1) <= reg_1flag_i;
                  reg_sel_pc_in <= '0';
                  reg_sel_pc_val <= "00";
                  reg_sel_sp_in <= '0';
                  reg_sel_sp_as <= '1';
               end if;
            when G5_1 => 
               if (rdy_i = '1') then 
                  sig_PC <= adr_pc_i;
                  reg_F(0) <= '0';
                  reg_sel_pc_in <= '0';
                  reg_sel_pc_val <= "00";
                  reg_sel_sp_in <= '0';
                  reg_sel_sp_as <= '1';
               end if;
            when G6_1 => 
               if (rdy_i = '1') then 
                  sig_PC <= adr_pc_i;
                  reg_F(3) <= '0';
                  reg_sel_pc_in <= '0';
                  reg_sel_pc_val <= "00";
                  reg_sel_sp_in <= '0';
                  reg_sel_sp_as <= '1';
               end if;
            when G7_1 => 
               if (rdy_i = '1') then 
                  sig_PC <= adr_pc_i;
                  reg_F(2) <= '0';
                  reg_sel_pc_in <= '0';
                  reg_sel_pc_val <= "00";
                  reg_sel_sp_in <= '0';
                  reg_sel_sp_as <= '1';
               end if;
            when G8_1 => 
               if (rdy_i = '1') then 
                  sig_PC <= adr_pc_i;
                  reg_F(6) <= '0';
                  reg_sel_pc_in <= '0';
                  reg_sel_pc_val <= "00";
                  reg_sel_sp_in <= '0';
                  reg_sel_sp_as <= '1';
               end if;
            when G19_1 => 
               if (rdy_i = '1') then 
                  sig_PC <= adr_pc_i;
                  reg_F(7) <= reg_7flag_i;
                  reg_F(1) <= reg_1flag_i;
                  reg_sel_pc_in <= '0';
                  reg_sel_pc_val <= "00";
                  reg_sel_sp_in <= '0';
                  reg_sel_sp_as <= '1';
               end if;
            when G15_1 => 
               if (rdy_i = '1' and
                   (zw_REG_OP = X"A5" OR zw_REG_OP = X"A6" OR
                   zw_REG_OP = X"A4" OR zw_REG_OP = X"45" OR
                   zw_REG_OP = X"05" OR zw_REG_OP = X"25" OR
                   zw_REG_OP = X"C5" OR zw_REG_OP = X"E4" OR zw_REG_OP = X"C4")) then 
                  sig_PC <= X"00" & d_i;
               elsif ((rdy_i = '1' and
                      (zw_REG_OP = X"A9" OR zw_REG_OP = X"A2" OR zw_REG_OP = X"A0" OR zw_REG_OP = X"E0" OR zw_REG_OP = X"C0" OR
                      zw_REG_OP = X"49" or zw_REG_OP = X"09" or zw_REG_OP = X"29" or zw_REG_OP = X"C9")) and (zw_REG_OP = X"09" or zw_REG_OP = X"05" or
                      zw_REG_OP = X"15" or zw_REG_OP = X"0D" or
                      zw_REG_OP = X"1D" or zw_REG_OP = X"19" or 
                      zw_REG_OP = X"01" or zw_REG_OP = X"11" or
                      zw_REG_OP = X"12")) then 
                  sig_PC <= adr_nxt_pc_i;
                  reg_F(7) <= reg_7flag_i;
                  reg_F(1) <= reg_1flag_i;
                  reg_sel_pc_in <= '0';
                  reg_sel_pc_val <= "00";
                  reg_sel_sp_in <= '0';
                  reg_sel_sp_as <= '1';
               elsif ((rdy_i = '1' and
                      (zw_REG_OP = X"A9" OR zw_REG_OP = X"A2" OR zw_REG_OP = X"A0" OR zw_REG_OP = X"E0" OR zw_REG_OP = X"C0" OR
                      zw_REG_OP = X"49" or zw_REG_OP = X"09" or zw_REG_OP = X"29" or zw_REG_OP = X"C9")) and (zw_REG_OP = X"49" or zw_REG_OP = X"45" or
                      zw_REG_OP = X"55" or zw_REG_OP = X"4D" or
                      zw_REG_OP = X"5D" or zw_REG_OP = X"59" or
                      zw_REG_OP = X"41" or zw_REG_OP = X"51" or
                      zw_REG_OP = X"52")) then 
                  sig_PC <= adr_nxt_pc_i;
                  reg_F(7) <= reg_7flag_i;
                  reg_F(1) <= reg_1flag_i;
                  reg_sel_pc_in <= '0';
                  reg_sel_pc_val <= "00";
                  reg_sel_sp_in <= '0';
                  reg_sel_sp_as <= '1';
               elsif ((rdy_i = '1' and
                      (zw_REG_OP = X"A9" OR zw_REG_OP = X"A2" OR zw_REG_OP = X"A0" OR zw_REG_OP = X"E0" OR zw_REG_OP = X"C0" OR
                      zw_REG_OP = X"49" or zw_REG_OP = X"09" or zw_REG_OP = X"29" or zw_REG_OP = X"C9")) and (zw_REG_OP = X"29" or zw_REG_OP = X"25" or
                      zw_REG_OP = X"35" or zw_REG_OP = X"2D" or
                      zw_REG_OP = X"3D" or zw_REG_OP = X"39" or
                      zw_REG_OP = X"21" or zw_REG_OP = X"31" or
                      zw_REG_OP = X"32" or zw_REG_OP = X"D2")) then 
                  sig_PC <= adr_nxt_pc_i;
                  reg_F(7) <= reg_7flag_i;
                  reg_F(1) <= reg_1flag_i;
                  reg_sel_pc_in <= '0';
                  reg_sel_pc_val <= "00";
                  reg_sel_sp_in <= '0';
                  reg_sel_sp_as <= '1';
               elsif ((rdy_i = '1' and
                      (zw_REG_OP = X"A9" OR zw_REG_OP = X"A2" OR zw_REG_OP = X"A0" OR zw_REG_OP = X"E0" OR zw_REG_OP = X"C0" OR
                      zw_REG_OP = X"49" or zw_REG_OP = X"09" or zw_REG_OP = X"29" or zw_REG_OP = X"C9")) and (zw_REG_OP = X"C9" or zw_REG_OP = X"C5" or
                      zw_REG_OP = X"D5" or zw_REG_OP = X"CD" or
                      zw_REG_OP = X"DD" or zw_REG_OP = X"D9" or
                      zw_REG_OP = X"C1" or zw_REG_OP = X"D1" or
                       zw_REG_OP = X"C0" or zw_REG_OP = X"E0" or
                       zw_REG_OP = X"C4" or zw_REG_OP = X"E4" or
                       zw_REG_OP = X"CC" or zw_REG_OP = X"EC")) then 
                  sig_PC <= adr_nxt_pc_i;
                  reg_F(7) <= zw_ALU(7);
                  reg_F(0) <= zw_ALU(8);
                  reg_F(1) <= NOT ((zw_ALU(7)) OR (zw_ALU(6)) OR (zw_ALU(5)) OR 
                  (zw_ALU(4)) OR (zw_ALU(3)) OR (zw_ALU(2)) OR (zw_ALU(1)) OR 
                  (zw_ALU(0)));
                  reg_sel_pc_in <= '0';
                  reg_sel_pc_val <= "00";
                  reg_sel_sp_in <= '0';
                  reg_sel_sp_as <= '1';
               elsif (rdy_i = '1' and
                      (zw_REG_OP = X"A9" OR zw_REG_OP = X"A2" OR zw_REG_OP = X"A0" OR zw_REG_OP = X"E0" OR zw_REG_OP = X"C0" OR
                      zw_REG_OP = X"49" or zw_REG_OP = X"09" or zw_REG_OP = X"29" or zw_REG_OP = X"C9")) then 
                  sig_PC <= adr_nxt_pc_i;
                  reg_F(7) <= reg_7flag_i;
                  reg_F(1) <= reg_1flag_i;
                  reg_sel_pc_in <= '0';
                  reg_sel_pc_val <= "00";
                  reg_sel_sp_in <= '0';
                  reg_sel_sp_as <= '1';
               elsif (rdy_i = '1' and
                      (zw_REG_OP = X"B5" OR
                      zw_REG_OP = X"B4" OR
                      zw_REG_OP = X"55" OR zw_REG_OP = X"15" OR
                      zw_REG_OP = X"35" OR
                      zw_REG_OP = X"D5")) then 
                  sig_PC <= X"00" & d_i;
                  zw_b1 <= d_alu_i;
               elsif (rdy_i = '1' and
                      (zw_REG_OP = X"AD" OR
                      zw_REG_OP = X"AE" OR
                      zw_REG_OP = X"AC" OR
                      zw_REG_OP = X"4D" OR
                      zw_REG_OP = X"0D" OR
                      zw_REG_OP = X"2D" OR
                      zw_REG_OP = X"CD" OR
                      zw_REG_OP = X"EC" OR
                      zw_REG_OP = X"CC")) then 
                  sig_PC <= adr_nxt_pc_i;
                  zw_b1 <= d_i;
               elsif (rdy_i = '1' and
                      (zw_REG_OP = X"BD" OR
                      zw_REG_OP = X"BC" OR
                      zw_REG_OP = X"5D" OR
                      zw_REG_OP = X"1D" OR
                      zw_REG_OP = X"3D" OR
                      zw_REG_OP = X"DD")) then 
                  sig_PC <= adr_nxt_pc_i;
                  zw_b1 <= d_alu_i;
                  zw_b2(0) <= reg_0flag_i;
               elsif (rdy_i = '1' and
                      (zw_REG_OP = X"B9" OR
                      zw_REG_OP = X"BE" OR
                      zw_REG_OP = X"59" OR
                      zw_REG_OP = X"19" OR
                      zw_REG_OP = X"39" OR
                      zw_REG_OP = X"D9")) then 
                  sig_PC <= adr_nxt_pc_i;
                  zw_b1 <= d_alu_i;
                  zw_b2(0) <= reg_0flag_i;
               elsif (rdy_i = '1' and
                      (zw_REG_OP = X"B1" OR
                      zw_REG_OP = X"51" OR
                      zw_REG_OP = X"11" OR
                      zw_REG_OP = X"31" OR
                      zw_REG_OP = X"D1")) then 
                  sig_PC <= X"00" & d_i;
                  zw_b1 <= d_alu_i;
               elsif (rdy_i = '1' and
                      (zw_REG_OP = X"A1" OR
                      zw_REG_OP = X"41" OR
                      zw_REG_OP = X"01" OR
                      zw_REG_OP = X"21" OR
                      zw_REG_OP = X"C1")) then 
                  sig_PC <= X"00" & d_i;
                  zw_b1 <= d_alu_i;
               elsif (rdy_i = '1' and
                      zw_REG_OP = X"B6") then 
                  sig_PC <= X"00" & d_i;
                  zw_b1 <= d_alu_i;
               elsif (rdy_i = '1' and
                      (zw_REG_OP = X"32" OR
                      zw_REG_OP = X"D2" OR
                      zw_REG_OP = X"52" OR
                      zw_REG_OP = X"B2" OR
                      zw_REG_OP = X"12")) then 
                  sig_PC <= X"00" & d_i;
                  zw_b1 <= d_alu_i;
               end if;
            when G15_3 => 
               if (rdy_i = '1') then 
                  sig_PC <= d_i & zw_b1;
               end if;
            when G15_4 => 
               if (rdy_i = '1') then 
                  sig_PC <= d_i & zw_b1;
                  zw_b3 <= d_alu_i;
               end if;
            when G15_5 => 
               if (rdy_i = '1') then 
                  sig_PC <= X"00" & zw_b1;
                  zw_b1 <= d_alu_i;
                  zw_b2(0) <= reg_0flag_i;
               end if;
            when G15_2 => 
               if (rdy_i = '1') then 
                  sig_PC <= X"00" & zw_b1;
               end if;
            when G15_7 => 
               if (rdy_i = '1') then 
                  sig_PC <= X"00" & zw_b1;
               end if;
            when G15_e3 => 
               if (rdy_i = '1') then 
                  sig_PC <= X"00" & d_alu_i;
                  zw_b1 <= d_i;
               end if;
            when G15_6 => 
               if (rdy_i = '1') then 
                  sig_PC <= d_i & zw_b1;
                  zw_b3 <= d_alu_i;
               end if;
            when G15_e2 => 
               if ((rdy_i = '1') and (zw_REG_OP = X"09" or zw_REG_OP = X"05" or
                   zw_REG_OP = X"15" or zw_REG_OP = X"0D" or
                   zw_REG_OP = X"1D" or zw_REG_OP = X"19" or 
                   zw_REG_OP = X"01" or zw_REG_OP = X"11" or
                   zw_REG_OP = X"12")) then 
                  sig_PC <= adr_pc_i;
                  reg_F(7) <= reg_7flag_i;
                  reg_F(1) <= reg_1flag_i;
                  reg_sel_pc_in <= '0';
                  reg_sel_pc_val <= "00";
                  reg_sel_sp_in <= '0';
                  reg_sel_sp_as <= '1';
               elsif ((rdy_i = '1') and (zw_REG_OP = X"49" or zw_REG_OP = X"45" or
                      zw_REG_OP = X"55" or zw_REG_OP = X"4D" or
                      zw_REG_OP = X"5D" or zw_REG_OP = X"59" or
                      zw_REG_OP = X"41" or zw_REG_OP = X"51" or
                      zw_REG_OP = X"52")) then 
                  sig_PC <= adr_pc_i;
                  reg_F(7) <= reg_7flag_i;
                  reg_F(1) <= reg_1flag_i;
                  reg_sel_pc_in <= '0';
                  reg_sel_pc_val <= "00";
                  reg_sel_sp_in <= '0';
                  reg_sel_sp_as <= '1';
               elsif ((rdy_i = '1') and (zw_REG_OP = X"29" or zw_REG_OP = X"25" or
                      zw_REG_OP = X"35" or zw_REG_OP = X"2D" or
                      zw_REG_OP = X"3D" or zw_REG_OP = X"39" or
                      zw_REG_OP = X"21" or zw_REG_OP = X"31" or
                      zw_REG_OP = X"32" or zw_REG_OP = X"D2")) then 
                  sig_PC <= adr_pc_i;
                  reg_F(7) <= reg_7flag_i;
                  reg_F(1) <= reg_1flag_i;
                  reg_sel_pc_in <= '0';
                  reg_sel_pc_val <= "00";
                  reg_sel_sp_in <= '0';
                  reg_sel_sp_as <= '1';
               elsif ((rdy_i = '1') and (zw_REG_OP = X"C9" or zw_REG_OP = X"C5" or
                      zw_REG_OP = X"D5" or zw_REG_OP = X"CD" or
                      zw_REG_OP = X"DD" or zw_REG_OP = X"D9" or
                      zw_REG_OP = X"C1" or zw_REG_OP = X"D1" or
                       zw_REG_OP = X"C0" or zw_REG_OP = X"E0" or
                       zw_REG_OP = X"C4" or zw_REG_OP = X"E4" or
                       zw_REG_OP = X"CC" or zw_REG_OP = X"EC")) then 
                  sig_PC <= adr_pc_i;
                  reg_F(7) <= zw_ALU(7);
                  reg_F(0) <= zw_ALU(8);
                  reg_F(1) <= NOT ((zw_ALU(7)) OR (zw_ALU(6)) OR (zw_ALU(5)) OR 
                  (zw_ALU(4)) OR (zw_ALU(3)) OR (zw_ALU(2)) OR (zw_ALU(1)) OR 
                  (zw_ALU(0)));
                  reg_sel_pc_in <= '0';
                  reg_sel_pc_val <= "00";
                  reg_sel_sp_in <= '0';
                  reg_sel_sp_as <= '1';
               elsif (rdy_i = '1') then 
                  sig_PC <= adr_pc_i;
                  reg_F(7) <= reg_7flag_i;
                  reg_F(1) <= reg_1flag_i;
                  reg_sel_pc_in <= '0';
                  reg_sel_pc_val <= "00";
                  reg_sel_sp_in <= '0';
                  reg_sel_sp_as <= '1';
               end if;
            when G15_e1 => 
               if ((rdy_i = '1' AND
                   zw_b2(0) = '0') and (zw_REG_OP = X"09" or zw_REG_OP = X"05" or
                   zw_REG_OP = X"15" or zw_REG_OP = X"0D" or
                   zw_REG_OP = X"1D" or zw_REG_OP = X"19" or 
                   zw_REG_OP = X"01" or zw_REG_OP = X"11" or
                   zw_REG_OP = X"12")) then 
                  sig_PC <= adr_pc_i;
                  reg_F(7) <= reg_7flag_i;
                  reg_F(1) <= reg_1flag_i;
                  reg_sel_pc_in <= '0';
                  reg_sel_pc_val <= "00";
                  reg_sel_sp_in <= '0';
                  reg_sel_sp_as <= '1';
               elsif ((rdy_i = '1' AND
                      zw_b2(0) = '0') and (zw_REG_OP = X"49" or zw_REG_OP = X"45" or
                      zw_REG_OP = X"55" or zw_REG_OP = X"4D" or
                      zw_REG_OP = X"5D" or zw_REG_OP = X"59" or
                      zw_REG_OP = X"41" or zw_REG_OP = X"51" or
                      zw_REG_OP = X"52")) then 
                  sig_PC <= adr_pc_i;
                  reg_F(7) <= reg_7flag_i;
                  reg_F(1) <= reg_1flag_i;
                  reg_sel_pc_in <= '0';
                  reg_sel_pc_val <= "00";
                  reg_sel_sp_in <= '0';
                  reg_sel_sp_as <= '1';
               elsif ((rdy_i = '1' AND
                      zw_b2(0) = '0') and (zw_REG_OP = X"29" or zw_REG_OP = X"25" or
                      zw_REG_OP = X"35" or zw_REG_OP = X"2D" or
                      zw_REG_OP = X"3D" or zw_REG_OP = X"39" or
                      zw_REG_OP = X"21" or zw_REG_OP = X"31" or
                      zw_REG_OP = X"32" or zw_REG_OP = X"D2")) then 
                  sig_PC <= adr_pc_i;
                  reg_F(7) <= reg_7flag_i;
                  reg_F(1) <= reg_1flag_i;
                  reg_sel_pc_in <= '0';
                  reg_sel_pc_val <= "00";
                  reg_sel_sp_in <= '0';
                  reg_sel_sp_as <= '1';
               elsif ((rdy_i = '1' AND
                      zw_b2(0) = '0') and (zw_REG_OP = X"C9" or zw_REG_OP = X"C5" or
                      zw_REG_OP = X"D5" or zw_REG_OP = X"CD" or
                      zw_REG_OP = X"DD" or zw_REG_OP = X"D9" or
                      zw_REG_OP = X"C1" or zw_REG_OP = X"D1" or
                       zw_REG_OP = X"C0" or zw_REG_OP = X"E0" or
                       zw_REG_OP = X"C4" or zw_REG_OP = X"E4" or
                       zw_REG_OP = X"CC" or zw_REG_OP = X"EC")) then 
                  sig_PC <= adr_pc_i;
                  reg_F(7) <= zw_ALU(7);
                  reg_F(0) <= zw_ALU(8);
                  reg_F(1) <= NOT ((zw_ALU(7)) OR (zw_ALU(6)) OR (zw_ALU(5)) OR 
                  (zw_ALU(4)) OR (zw_ALU(3)) OR (zw_ALU(2)) OR (zw_ALU(1)) OR 
                  (zw_ALU(0)));
                  reg_sel_pc_in <= '0';
                  reg_sel_pc_val <= "00";
                  reg_sel_sp_in <= '0';
                  reg_sel_sp_as <= '1';
               elsif (rdy_i = '1' AND
                      zw_b2(0) = '0') then 
                  sig_PC <= adr_pc_i;
                  reg_F(7) <= reg_7flag_i;
                  reg_F(1) <= reg_1flag_i;
                  reg_sel_pc_in <= '0';
                  reg_sel_pc_val <= "00";
                  reg_sel_sp_in <= '0';
                  reg_sel_sp_as <= '1';
               elsif (rdy_i = '1') then 
                  sig_PC <= zw_b3 & zw_b1;
               end if;
            when G15_8 => 
               if (rdy_i = '1') then 
                  sig_PC <= X"00" & zw_b1;
                  zw_b1 <= d_i;
               end if;
            when G10_1 => 
               if (rdy_i = '1' and
                   zw_REG_OP = X"65") then 
                  sig_PC <= X"00" & d_i;
               elsif (rdy_i = '1' and
                      zw_REG_OP = X"69" and
                      reg_F(3) = '0') then 
                  sig_PC <= adr_nxt_pc_i;
                  
                  reg_F(7) <= zw_ALU(7);
                  reg_F(6) <= zw_b1(0) XOR zw_ALU(7);
                  reg_F(1) <= NOT ((zw_ALU(7)) OR (zw_ALU(6)) OR (zw_ALU(5)) OR 
                  (zw_ALU(4)) OR (zw_ALU(3)) OR (zw_ALU(2)) OR (zw_ALU(1)) OR 
                  (zw_ALU(0)));
                  reg_F(0) <= zw_ALU(8);
                  reg_sel_pc_in <= '0';
                  reg_sel_pc_val <= "00";
                  reg_sel_sp_in <= '0';
                  reg_sel_sp_as <= '1';
               elsif (rdy_i = '1' and
                      zw_REG_OP = X"75") then 
                  sig_PC <= X"00" & d_i;
                  zw_b1 <= d_alu_i;
               elsif (rdy_i = '1' and
                      zw_REG_OP = X"6D") then 
                  sig_PC <= adr_nxt_pc_i;
                  zw_b1 <= d_i;
               elsif (rdy_i = '1' and
                      zw_REG_OP = X"7D") then 
                  sig_PC <= adr_nxt_pc_i;
                  zw_b1 <= d_alu_i;
                  zw_b2(0) <= reg_0flag_i;
               elsif (rdy_i = '1' and
                      zw_REG_OP = X"79") then 
                  sig_PC <= adr_nxt_pc_i;
                  zw_b1 <= d_alu_i;
                  zw_b2(0) <= reg_0flag_i;
               elsif (rdy_i = '1' and
                      zw_REG_OP = X"71") then 
                  sig_PC <= X"00" & d_i;
                  zw_b1 <= d_alu_i;
               elsif (rdy_i = '1' and
                      zw_REG_OP = X"61") then 
                  sig_PC <= X"00" & d_i;
                  zw_b1 <= d_alu_i;
               elsif (rdy_i = '1' and
                      zw_REG_OP = X"69" and
                      reg_F(3) = '1') then 
                  sig_PC <= adr_nxt_pc_i;
                  
                  reg_F(7) <= zw_ALU(7);
                  reg_F(6) <= zw_b1(0) XOR zw_ALU(7);
                  reg_F(1) <= NOT ((zw_ALU(7)) OR (zw_ALU(6)) OR (zw_ALU(5)) OR 
                  (zw_ALU(4)) OR (zw_ALU(3)) OR (zw_ALU(2)) OR (zw_ALU(1)) OR 
                  (zw_ALU(0)));
                  reg_F(0) <= zw_ALU4(4);
                  reg_sel_pc_in <= '0';
                  reg_sel_pc_val <= "00";
                  reg_sel_sp_in <= '0';
                  reg_sel_sp_as <= '1';
               elsif (rdy_i = '1' and
                      zw_REG_OP = X"72") then 
                  sig_PC <= X"00" & d_i;
                  zw_b1 <= d_alu_i;
               end if;
            when G10_3 => 
               if (rdy_i = '1') then 
                  sig_PC <= d_i & zw_b1;
               end if;
            when G10_4 => 
               if (rdy_i = '1') then 
                  sig_PC <= d_i & zw_b1;
                  zw_b3 <= d_alu_i;
               end if;
            when G10_5 => 
               if (rdy_i = '1') then 
                  sig_PC <= X"00" & zw_b1;
                  zw_b1 <= d_alu_i;
                  zw_b2(0) <= reg_0flag_i;
               end if;
            when G10_2 => 
               if (rdy_i = '1') then 
                  sig_PC <= X"00" & zw_b1;
               end if;
            when G10_7 => 
               if (rdy_i = '1') then 
                  sig_PC <= X"00" & zw_b1;
               end if;
            when G10_e3 => 
               if (rdy_i = '1') then 
                  sig_PC <= X"00" & d_alu_i;
                  zw_b1 <= d_i;
               end if;
            when G10_e1 => 
               if (rdy_i = '1' AND
                   zw_b2(0) = '0' and
                   reg_F(3) = '0') then 
                  sig_PC <= adr_pc_i;
                  
                  reg_F(7) <= zw_ALU(7);
                  reg_F(6) <= zw_b1(0) XOR zw_ALU(7);
                  reg_F(1) <= NOT ((zw_ALU(7)) OR (zw_ALU(6)) OR (zw_ALU(5)) OR 
                  (zw_ALU(4)) OR (zw_ALU(3)) OR (zw_ALU(2)) OR (zw_ALU(1)) OR 
                  (zw_ALU(0)));
                  reg_F(0) <= zw_ALU(8);
                  reg_sel_pc_in <= '0';
                  reg_sel_pc_val <= "00";
                  reg_sel_sp_in <= '0';
                  reg_sel_sp_as <= '1';
               elsif (rdy_i = '1' AND
                      zw_b2(0) = '0' and
                      reg_F(3) = '1') then 
                  sig_PC <= adr_pc_i;
                  
                  reg_F(7) <= zw_ALU(7);
                  reg_F(6) <= zw_b1(0) XOR zw_ALU(7);
                  reg_F(1) <= NOT ((zw_ALU(7)) OR (zw_ALU(6)) OR (zw_ALU(5)) OR 
                  (zw_ALU(4)) OR (zw_ALU(3)) OR (zw_ALU(2)) OR (zw_ALU(1)) OR 
                  (zw_ALU(0)));
                  reg_F(0) <= zw_ALU4(4);
                  reg_sel_pc_in <= '0';
                  reg_sel_pc_val <= "00";
                  reg_sel_sp_in <= '0';
                  reg_sel_sp_as <= '1';
               elsif (rdy_i = '1') then 
                  sig_PC <= zw_b3 & zw_b1;
               end if;
            when G10_e2 => 
               if (rdy_i = '1' and
                   reg_F(3) = '0') then 
                  sig_PC <= adr_pc_i;
                  
                  reg_F(7) <= zw_ALU(7);
                  reg_F(6) <= zw_b1(0) XOR zw_ALU(7);
                  reg_F(1) <= NOT ((zw_ALU(7)) OR (zw_ALU(6)) OR (zw_ALU(5)) OR 
                  (zw_ALU(4)) OR (zw_ALU(3)) OR (zw_ALU(2)) OR (zw_ALU(1)) OR 
                  (zw_ALU(0)));
                  reg_F(0) <= zw_ALU(8);
                  reg_sel_pc_in <= '0';
                  reg_sel_pc_val <= "00";
                  reg_sel_sp_in <= '0';
                  reg_sel_sp_as <= '1';
               elsif (rdy_i = '1' and
                      reg_F(3) = '1') then 
                  sig_PC <= adr_pc_i;
                  
                  reg_F(7) <= zw_ALU(7);
                  reg_F(6) <= zw_b1(0) XOR zw_ALU(7);
                  reg_F(1) <= NOT ((zw_ALU(7)) OR (zw_ALU(6)) OR (zw_ALU(5)) OR 
                  (zw_ALU(4)) OR (zw_ALU(3)) OR (zw_ALU(2)) OR (zw_ALU(1)) OR 
                  (zw_ALU(0)));
                  reg_F(0) <= zw_ALU4(4);
                  reg_sel_pc_in <= '0';
                  reg_sel_pc_val <= "00";
                  reg_sel_sp_in <= '0';
                  reg_sel_sp_as <= '1';
               end if;
            when G10_6 => 
               if (rdy_i = '1') then 
                  sig_PC <= d_i & zw_b1;
                  zw_b3 <= d_alu_i;
               end if;
            when G10_8 => 
               if (rdy_i = '1') then 
                  sig_PC <= X"00" & zw_b1;
                  zw_b1 <= d_i;
               end if;
            when G17_1 => 
               if (rdy_i = '1' and
                   (zw_REG_OP = X"85" OR
                   zw_REG_OP = X"86" OR
                   zw_REG_OP = X"64" OR
                   zw_REG_OP = X"84")) then 
                  sig_PC <= X"00" & d_i;
               elsif (rdy_i = '1' and
                      (zw_REG_OP = X"95" OR
                      zw_REG_OP = X"74" OR
                      zw_REG_OP = X"94")) then 
                  sig_PC <= X"00" & d_i;
                  zw_b1 <= d_alu_i;
               elsif (rdy_i = '1' and
                      (zw_REG_OP = X"8D" OR
                      zw_REG_OP = X"8E" OR
                      zw_REG_OP = X"9C" OR
                      zw_REG_OP = X"8C")) then 
                  sig_PC <= adr_nxt_pc_i;
                  zw_b1 <= d_i;
               elsif (rdy_i = '1' and
                      (zw_REG_OP = X"9D" OR
                      zw_REG_OP = X"9E")) then 
                  sig_PC <= adr_nxt_pc_i;
                  zw_b1 <= d_alu_i;
                  zw_b2(0) <= reg_0flag_i;
               elsif (rdy_i = '1' and
                      zw_REG_OP = X"99") then 
                  sig_PC <= adr_nxt_pc_i;
                  zw_b1 <= d_alu_i;
                  zw_b2(0) <= reg_0flag_i;
               elsif (rdy_i = '1' and
                      zw_REG_OP = X"91") then 
                  sig_PC <= X"00" & d_i;
                  zw_b1 <= d_alu_i;
               elsif (rdy_i = '1' and
                      zw_REG_OP = X"81") then 
                  sig_PC <= X"00" & d_i;
                  zw_b1 <= d_alu_i;
               elsif (rdy_i = '1' and
                      zw_REG_OP = X"96") then 
                  sig_PC <= X"00" & d_i;
                  zw_b1 <= d_alu_i;
               elsif (rdy_i = '1' and
                      zw_REG_OP = X"92") then 
                  sig_PC <= X"00" & d_i;
                  zw_b1 <= d_alu_i;
               end if;
            when G17_4 => 
               if (rdy_i = '1') then 
                  sig_PC <= d_i & zw_b1;
                  zw_b3 <= d_alu_i;
               end if;
            when G17_6 => 
               if (rdy_i = '1') then 
                  sig_PC <= X"00" & zw_b1;
                  zw_b1 <= d_alu_i;
                  zw_b2(0) <= reg_0flag_i;
               end if;
            when G17_3 => 
               if (rdy_i = '1') then 
                  sig_PC <= d_i & zw_b1;
               end if;
            when G17_2 => 
               if (rdy_i = '1') then 
                  sig_PC <= X"00" & zw_b1;
               end if;
            when G17_8 => 
               if (rdy_i = '1') then 
                  sig_PC <= X"00" & zw_b1;
               end if;
            when G17_9 => 
               if (rdy_i = '1') then 
                  sig_PC <= X"00" & d_alu_i;
                  zw_b1 <= d_i;
               end if;
            when G17_7 => 
               if (rdy_i = '1') then 
                  sig_PC <= d_i & zw_b1;
                  zw_b3 <= d_alu_i;
               end if;
            when G17_5 => 
               sig_PC <= zw_b3 & zw_b1;
            when G17_10 => 
               sig_PC <= d_i & zw_b1;
            when G17_e => 
               sig_PC <= adr_pc_i;
               reg_sel_pc_in <= '0';
               reg_sel_pc_val <= "00";
               reg_sel_sp_in <= '0';
               reg_sel_sp_as <= '1';
            when G17_11 => 
               if (rdy_i = '1') then 
                  sig_PC <= X"00" & zw_b1;
                  zw_b1 <= d_i;
               end if;
            when G16_1 => 
               if (rdy_i = '1' and
                   zw_REG_OP = X"E5") then 
                  sig_PC <= X"00" & d_i;
               elsif (rdy_i = '1' and
                      zw_REG_OP = X"E9" and
                      reg_F(3) = '0') then 
                  sig_PC <= adr_nxt_pc_i;
                  
                  reg_F(7) <= zw_ALU(7);
                  reg_F(6) <= zw_b1(0) XOR zw_ALU(7);
                  reg_F(1) <= NOT ((zw_ALU(7)) OR (zw_ALU(6)) OR (zw_ALU(5)) OR 
                  (zw_ALU(4)) OR (zw_ALU(3)) OR (zw_ALU(2)) OR (zw_ALU(1)) OR 
                  (zw_ALU(0)));
                  reg_F(0) <= zw_ALU(8);
                  reg_sel_pc_in <= '0';
                  reg_sel_pc_val <= "00";
                  reg_sel_sp_in <= '0';
                  reg_sel_sp_as <= '1';
               elsif (rdy_i = '1' and
                      zw_REG_OP = X"F5") then 
                  sig_PC <= X"00" & d_i;
                  zw_b1 <= d_alu_i;
               elsif (rdy_i = '1' and
                      zw_REG_OP = X"ED") then 
                  sig_PC <= adr_nxt_pc_i;
                  zw_b1 <= d_i;
               elsif (rdy_i = '1' and
                      zw_REG_OP = X"FD") then 
                  sig_PC <= adr_nxt_pc_i;
                  zw_b1 <= d_alu_i;
                  zw_b2(0) <= reg_0flag_i;
               elsif (rdy_i = '1' and
                      zw_REG_OP = X"F9") then 
                  sig_PC <= adr_nxt_pc_i;
                  zw_b1 <= d_alu_i;
                  zw_b2(0) <= reg_0flag_i;
               elsif (rdy_i = '1' and
                      zw_REG_OP = X"F1") then 
                  sig_PC <= X"00" & d_i;
                  zw_b1 <= d_alu_i;
               elsif (rdy_i = '1' and
                      zw_REG_OP = X"E1") then 
                  sig_PC <= X"00" & d_i;
                  zw_b1 <= d_alu_i;
               elsif (rdy_i = '1' and
                      zw_REG_OP = X"E9" and
                      reg_F(3) = '1') then 
                  sig_PC <= adr_nxt_pc_i;
                  
                  reg_F(7) <= zw_ALU(7);
                  reg_F(6) <= zw_b1(0) XOR zw_ALU(7);
                  reg_F(1) <= NOT ((zw_ALU(7)) OR (zw_ALU(6)) OR (zw_ALU(5)) OR 
                  (zw_ALU(4)) OR (zw_ALU(3)) OR (zw_ALU(2)) OR (zw_ALU(1)) OR 
                  (zw_ALU(0)));
                  reg_F(0) <= zw_ALU2(4);
                  reg_sel_pc_in <= '0';
                  reg_sel_pc_val <= "00";
                  reg_sel_sp_in <= '0';
                  reg_sel_sp_as <= '1';
               elsif (rdy_i = '1' and
                      zw_REG_OP = X"F2") then 
                  sig_PC <= X"00" & d_i;
                  zw_b1 <= d_alu_i;
               end if;
            when G16_3 => 
               if (rdy_i = '1') then 
                  sig_PC <= d_i & zw_b1;
               end if;
            when G16_4 => 
               if (rdy_i = '1') then 
                  sig_PC <= d_i & zw_b1;
                  zw_b3 <= d_alu_i;
               end if;
            when G16_5 => 
               if (rdy_i = '1') then 
                  sig_PC <= X"00" & zw_b1;
                  zw_b1 <= d_alu_i;
                  zw_b2(0) <= reg_0flag_i;
               end if;
            when G16_2 => 
               if (rdy_i = '1') then 
                  sig_PC <= X"00" & zw_b1;
               end if;
            when G16_7 => 
               if (rdy_i = '1') then 
                  sig_PC <= X"00" & zw_b1;
               end if;
            when G16_6 => 
               if (rdy_i = '1') then 
                  sig_PC <= d_i & zw_b1;
                  zw_b3 <= d_alu_i;
               end if;
            when G16_e3 => 
               if (rdy_i = '1') then 
                  sig_PC <= X"00" & d_alu_i;
                  zw_b1 <= d_i;
               end if;
            when G16_e1 => 
               if (rdy_i = '1' AND
                   zw_b2(0) = '0' and
                   reg_F(3) = '0') then 
                  sig_PC <= adr_pc_i;
                  
                  reg_F(7) <= zw_ALU(7);
                  reg_F(6) <= zw_b1(0) XOR zw_ALU(7);
                  reg_F(1) <= NOT ((zw_ALU(7)) OR (zw_ALU(6)) OR (zw_ALU(5)) OR 
                  (zw_ALU(4)) OR (zw_ALU(3)) OR (zw_ALU(2)) OR (zw_ALU(1)) OR 
                  (zw_ALU(0)));
                  reg_F(0) <= zw_ALU(8);
                  reg_sel_pc_in <= '0';
                  reg_sel_pc_val <= "00";
                  reg_sel_sp_in <= '0';
                  reg_sel_sp_as <= '1';
               elsif (rdy_i = '1' AND
                      zw_b2(0) = '0' and
                      reg_F(3) = '1') then 
                  sig_PC <= adr_pc_i;
                  
                  reg_F(7) <= zw_ALU(7);
                  reg_F(6) <= zw_b1(0) XOR zw_ALU(7);
                  reg_F(1) <= NOT ((zw_ALU(7)) OR (zw_ALU(6)) OR (zw_ALU(5)) OR 
                  (zw_ALU(4)) OR (zw_ALU(3)) OR (zw_ALU(2)) OR (zw_ALU(1)) OR 
                  (zw_ALU(0)));
                  reg_F(0) <= zw_ALU2(4);
                  reg_sel_pc_in <= '0';
                  reg_sel_pc_val <= "00";
                  reg_sel_sp_in <= '0';
                  reg_sel_sp_as <= '1';
               elsif (rdy_i = '1') then 
                  sig_PC <= zw_b3 & zw_b1;
               end if;
            when G16_e2 => 
               if (rdy_i = '1' and
                   reg_F(3) = '0') then 
                  sig_PC <= adr_pc_i;
                  
                  reg_F(7) <= zw_ALU(7);
                  reg_F(6) <= zw_b1(0) XOR zw_ALU(7);
                  reg_F(1) <= NOT ((zw_ALU(7)) OR (zw_ALU(6)) OR (zw_ALU(5)) OR 
                  (zw_ALU(4)) OR (zw_ALU(3)) OR (zw_ALU(2)) OR (zw_ALU(1)) OR 
                  (zw_ALU(0)));
                  reg_F(0) <= zw_ALU(8);
                  reg_sel_pc_in <= '0';
                  reg_sel_pc_val <= "00";
                  reg_sel_sp_in <= '0';
                  reg_sel_sp_as <= '1';
               elsif (rdy_i = '1' and
                      reg_F(3) = '1') then 
                  sig_PC <= adr_pc_i;
                  
                  reg_F(7) <= zw_ALU(7);
                  reg_F(6) <= zw_b1(0) XOR zw_ALU(7);
                  reg_F(1) <= NOT ((zw_ALU(7)) OR (zw_ALU(6)) OR (zw_ALU(5)) OR 
                  (zw_ALU(4)) OR (zw_ALU(3)) OR (zw_ALU(2)) OR (zw_ALU(1)) OR 
                  (zw_ALU(0)));
                  reg_F(0) <= zw_ALU2(4);
                  reg_sel_pc_in <= '0';
                  reg_sel_pc_val <= "00";
                  reg_sel_sp_in <= '0';
                  reg_sel_sp_as <= '1';
               end if;
            when G16_8 => 
               if (rdy_i = '1') then 
                  sig_PC <= X"00" & zw_b1;
                  zw_b1 <= d_i;
               end if;
            when G11_1 => 
               if (rdy_i = '1' and
                   (zw_REG_OP = X"1E" or
                   zw_REG_OP = X"7E" or
                   zw_REG_OP = X"3E" or
                   zw_REG_OP = X"5E")) then 
                  sig_PC <= adr_nxt_pc_i;
                  zw_b1 <= d_alu_i;
                  zw_b2(0) <= reg_0flag_i;
               elsif (rdy_i = '1' and
                      (zw_REG_OP = X"06" or zw_REG_OP = X"66" or
                      zw_REG_OP = X"26" or zw_REG_OP = X"46" or
                      zw_REG_OP = X"04" or zw_REG_OP = X"14")) then 
                  sig_PC <= X"00" & d_i;
               elsif (rdy_i = '1' and
                      (zw_REG_OP = X"16" or
                      zw_REG_OP = X"76" or
                      zw_REG_OP = X"36" or
                      zw_REG_OP = X"56")) then 
                  sig_PC <= X"00" & d_i;
                  zw_b1 <= d_alu_i;
               elsif (rdy_i = '1' and
                      (zw_REG_OP = X"0E" or
                      zw_REG_OP = X"6E" or
                      zw_REG_OP = X"2E" or
                      zw_REG_OP = X"4E"or
                      zw_REG_OP = X"0C" or
                      zw_REG_OP = X"1C")) then 
                  sig_PC <= adr_nxt_pc_i;
                  zw_b1 <= d_i;
               elsif (rdy_i = '1' and
                      zw_REG_OP (3 downto 0) = X"7") then 
                  sig_PC <= X"00" & d_i;
               end if;
            when G11_5 => 
               if (rdy_i = '1') then 
                  sig_PC <= d_i & zw_b1;
               end if;
            when G11_6 => 
               if (rdy_i = '1') then 
                  sig_PC <= d_i & zw_b1;
                  zw_b3 <= d_alu_i;
               end if;
            when G11_2 => 
               if (rdy_i = '1') then 
                  sig_PC <= X"00" & zw_b1;
               end if;
            when G11_7 => 
               if (rdy_i = '1') then 
                  sig_PC <= zw_b3 & zw_b1;
               end if;
            when G11_4 => 
               if (rdy_i = '1' and
                   (zw_REG_OP = X"06" or
                   zw_REG_OP = X"16" or
                   zw_REG_OP = X"0E" or
                   zw_REG_OP = X"1E")) then 
                  zw_b1 <= d_i(6 downto 0) & '0';
                  zw_b2(0) <= d_i(7);
               elsif (rdy_i = '1' and
                      (zw_REG_OP = X"46" or
                      zw_REG_OP = X"56" or
                      zw_REG_OP = X"4E" or
                      zw_REG_OP = X"5E")) then 
                  zw_b1 <= '0' & d_i(7 downto 1);
                  zw_b2(0) <= d_i(0);
               elsif (rdy_i = '1' and
                      (zw_REG_OP = X"26" or
                      zw_REG_OP = X"36" or
                      zw_REG_OP = X"2E" or
                      zw_REG_OP = X"3E")) then 
                  zw_b1 <= d_i(6 downto 0) & reg_F(0);
                  zw_b2(0) <= d_i(7);
               elsif (rdy_i = '1' and
                      (zw_REG_OP = X"66" or
                      zw_REG_OP = X"76" or
                      zw_REG_OP = X"6E" or
                      zw_REG_OP = X"7E")) then 
                  zw_b1 <= reg_F(0) & d_i(7 downto 1);
                  zw_b2(0) <= d_i(0);
               elsif (rdy_i = '1' and
                      zw_REG_OP (7) = '0' and
                      zw_REG_OP (3 downto 0) = X"7") then 
               elsif (rdy_i = '1' and
                      zw_REG_OP (7) = '1' and
                      zw_REG_OP (3 downto 0) = X"7") then 
               elsif (rdy_i = '1' and
                      (zw_REG_OP = X"14" or
                      zw_REG_OP = X"1C")) then 
                  zw_b1 <= d_i and q_a_i;
               elsif (rdy_i = '1' and
                      (zw_REG_OP = X"04" or
                      zw_REG_OP = X"0C")) then 
                  zw_b1 <= d_i and q_a_i;
               end if;
            when G11_e => 
               if (zw_REG_OP (3 downto 0) = X"7") then 
                  sig_PC <= adr_pc_i;
                  reg_sel_pc_in <= '0';
                  reg_sel_pc_val <= "00";
                  reg_sel_sp_in <= '0';
                  reg_sel_sp_as <= '1';
               elsif ((zw_REG_OP = X"14" or
                      zw_REG_OP = X"04" or
                      zw_REG_OP = X"0C" or
                      zw_REG_OP = X"1C")) then 
                  reg_F(1) <= reg_1flag_i;
                  sig_PC <= adr_pc_i;
                  reg_sel_pc_in <= '0';
                  reg_sel_pc_val <= "00";
                  reg_sel_sp_in <= '0';
                  reg_sel_sp_as <= '1';
               else
                  reg_F(0) <= zw_b2(0);
                  reg_F(7) <= reg_7flag_i;
                  reg_F(1) <= reg_1flag_i;
                  sig_PC <= adr_pc_i;
                  reg_sel_pc_in <= '0';
                  reg_sel_pc_val <= "00";
                  reg_sel_sp_in <= '0';
                  reg_sel_sp_as <= '1';
               end if;
            when G31_1 => 
               if (rdy_i = '1') then 
                  sig_PC <= adr_pc_i;
                  reg_F(0) <= q_a_i(7);
                  reg_F(7) <= reg_7flag_i;
                  reg_F(1) <= reg_1flag_i;
                  reg_sel_pc_in <= '0';
                  reg_sel_pc_val <= "00";
                  reg_sel_sp_in <= '0';
                  reg_sel_sp_as <= '1';
               end if;
            when G34_1 => 
               if (rdy_i = '1') then 
                  sig_PC <= adr_pc_i;
                  reg_F(0) <= q_a_i(0);
                  reg_F(7) <= reg_7flag_i;
                  reg_F(1) <= reg_1flag_i;
                  reg_sel_pc_in <= '0';
                  reg_sel_pc_val <= "00";
                  reg_sel_sp_in <= '0';
                  reg_sel_sp_as <= '1';
               end if;
            when G32_1 => 
               if (rdy_i = '1') then 
                  sig_PC <= adr_pc_i;
                  reg_F(0) <= q_a_i(0);
                  reg_F(7) <= reg_7flag_i;
                  reg_F(1) <= reg_1flag_i;
                  reg_sel_pc_in <= '0';
                  reg_sel_pc_val <= "00";
                  reg_sel_sp_in <= '0';
                  reg_sel_sp_as <= '1';
               end if;
            when G33_1 => 
               if (rdy_i = '1') then 
                  sig_PC <= adr_pc_i;
                  reg_F(0) <= q_a_i(7);
                  reg_F(0) <= q_a_i(7);
                  reg_F(7) <= reg_7flag_i;
                  reg_F(1) <= reg_1flag_i;
                  reg_sel_pc_in <= '0';
                  reg_sel_pc_val <= "00";
                  reg_sel_sp_in <= '0';
                  reg_sel_sp_as <= '1';
               end if;
            when G12_1 => 
               if (rdy_i = '1' and (
                   (reg_F(0) = '1' and zw_REG_OP = X"90") or (reg_F(0) = '0' and zw_REG_OP = X"B0") or
                   (reg_F(1) = '0' and zw_REG_OP = X"F0") or (reg_F(7) = '0' and zw_REG_OP = X"30") or
                   (reg_F(1) = '1' and zw_REG_OP = X"D0") or (reg_F(7) = '1' and zw_REG_OP = X"10") or
                   (reg_F(6) = '1' and zw_REG_OP = X"50") or (reg_F(6) = '0' and zw_REG_OP = X"70"))) then 
                  sig_PC <= adr_nxt_pc_i;
                  reg_sel_pc_in <= '0';
                  reg_sel_pc_val <= "00";
                  reg_sel_sp_in <= '0';
                  reg_sel_sp_as <= '1';
               elsif (rdy_i = '1' and (
                      zw_REG_OP = X"8F" or
                      zw_REG_OP = X"9F" or
                      zw_REG_OP = X"AF" or
                      zw_REG_OP = X"BF" or
                      zw_REG_OP = X"CF" or
                      zw_REG_OP = X"DF" or
                      zw_REG_OP = X"EF" or
                      zw_REG_OP = X"FF" or
                      zw_REG_OP = X"0F" or
                      zw_REG_OP = X"1F" or
                      zw_REG_OP = X"2F" or
                      zw_REG_OP = X"3F" or
                      zw_REG_OP = X"4F" or
                      zw_REG_OP = X"5F" or
                      zw_REG_OP = X"6F" or
                      zw_REG_OP = X"7F")) then 
                  sig_PC <= adr_nxt_pc_i;
                  zw_b1 <= d_i;
               elsif (rdy_i = '1') then 
                  sig_PC <= adr_nxt_pc_i;
                  reg_sel_pc_in <= '0';
                  reg_sel_pc_val <= "10";
                  zw_b2 <= d_i;
               end if;
            when G12_e1 => 
               if (rdy_i = '1' and
                   zw_b3 = adr_nxt_pc_i (15 downto 8)) then 
                  sig_PC <= adr_nxt_pc_i;
                  reg_sel_pc_in <= '0';
                  reg_sel_pc_val <= "00";
                  reg_sel_sp_in <= '0';
                  reg_sel_sp_as <= '1';
               elsif (rdy_i = '1') then 
                  sig_PC <= zw_b3 & adr_nxt_pc_i (7 downto 0);
               end if;
            when G12_e2 => 
               if (rdy_i = '1') then 
                  sig_PC <= adr_pc_i;
                  reg_sel_pc_in <= '0';
                  reg_sel_pc_val <= "00";
                  reg_sel_sp_in <= '0';
                  reg_sel_sp_as <= '1';
               end if;
            when G12_2 => 
               if (rdy_i = '1') then 
                  sig_PC <= X"00" & zw_b1;
                  zw_b2 <= d_i;
               end if;
            when G12_3 => 
               if (rdy_i = '1' and (
                   (d_i(0) = '1' and zw_REG_OP = X"8F") or
                   (d_i(1) = '1' and zw_REG_OP = X"9F") or
                   (d_i(2) = '1' and zw_REG_OP = X"AF") or
                   (d_i(3) = '1' and zw_REG_OP = X"BF") or
                   (d_i(4) = '1' and zw_REG_OP = X"CF") or
                   (d_i(5) = '1' and zw_REG_OP = X"DF") or
                   (d_i(6) = '1' and zw_REG_OP = X"EF") or
                   (d_i(7) = '1' and zw_REG_OP = X"FF") or
                   (d_i(0) = '0' and zw_REG_OP = X"0F") or
                   (d_i(1) = '0' and zw_REG_OP = X"1F") or
                   (d_i(2) = '0' and zw_REG_OP = X"2F") or
                   (d_i(3) = '0' and zw_REG_OP = X"3F") or
                   (d_i(4) = '0' and zw_REG_OP = X"4F") or
                   (d_i(5) = '0' and zw_REG_OP = X"5F") or
                   (d_i(6) = '0' and zw_REG_OP = X"6F") or
                   (d_i(7) = '0' and zw_REG_OP = X"7F"))) then 
                  sig_PC <= adr_nxt_pc_i;
               elsif (rdy_i = '1') then 
                  sig_PC <= adr_nxt_pc_i;
               end if;
            when G12_4 => 
               if (rdy_i = '1') then 
                  reg_sel_pc_in <= '0';
                  reg_sel_pc_val <= "10";
               end if;
            when G20_1 => 
               if (rdy_i = '1' and
                   zw_REG_OP = X"4C") then 
                  sig_PC <= adr_nxt_pc_i;
                  reg_sel_pc_in <= '1';
                  reg_sel_pc_val <= "11";
                  zw_b1 <= d_i;
               elsif (rdy_i = '1' and
                      zw_REG_OP = X"6C") then 
                  sig_PC <= adr_nxt_pc_i;
                  reg_sel_pc_in <= '1';
                  reg_sel_pc_val <= "00";
                  zw_b1 <= d_i;
               elsif (rdy_i = '1' and
                      zw_REG_OP = X"7C") then 
                  sig_PC <= adr_nxt_pc_i;
                  reg_sel_pc_in <= '1';
                  reg_sel_pc_val <= "10";
                  zw_b1 <= d_i;
               end if;
            when G20_2 => 
               if (rdy_i = '1') then 
                  sig_PC <= d_i & zw_b1;
                  reg_sel_pc_in <= '0';
                  reg_sel_pc_val <= "00";
               end if;
            when G20_5 => 
               if (rdy_i = '1') then 
                  sig_PC <= adr_pc_i;
                  reg_sel_pc_in <= '1';
                  reg_sel_pc_val <= "11";
                  zw_b1 <= d_i;
               end if;
            when G20_e => 
               if (rdy_i = '1') then 
                  sig_PC <= d_i & zw_b1;
                  reg_sel_pc_in <= '0';
                  reg_sel_pc_val <= "00";
                  reg_sel_sp_in <= '0';
                  reg_sel_sp_as <= '1';
               end if;
            when G20_3 => 
               if (rdy_i = '1') then 
                  sig_PC <= adr_nxt_pc_i;
                  reg_sel_pc_in <= '0';
                  reg_sel_pc_val <= "00";
               end if;
            when G21_1 => 
               if (rdy_i = '1') then 
                  sig_PC <= adr_sp_i;
                  zw_b1 <= d_i;
               end if;
            when G21_3 => 
               sig_PC <= adr_sp_i;
            when G21_4 => 
               sig_PC <= adr_pc_i;
               reg_sel_pc_in <= '1';
               reg_sel_pc_val <= "11";
            when G21_e => 
               if (rdy_i = '1') then 
                  sig_PC <= d_i & zw_b1 (7 downto 0);
                  reg_sel_pc_in <= '0';
                  reg_sel_pc_val <= "00";
                  reg_sel_sp_in <= '0';
                  reg_sel_sp_as <= '1';
               end if;
            when G13_3 => 
               if (rdy_i = '1') then 
                  sig_PC <= d_i & zw_b1;
               end if;
            when G13_1 => 
               if (rdy_i = '1' and
                   zw_REG_OP = X"34") then 
                  sig_PC <= X"00" & d_i;
                  zw_b1 <= d_alu_i;
               elsif (rdy_i = '1' and
                      zw_REG_OP = X"3C") then 
                  sig_PC <= adr_nxt_pc_i;
                  zw_b1 <= d_alu_i;
                  zw_b2(0) <= reg_0flag_i;
               elsif (rdy_i = '1' and
                      zw_REG_OP = X"24") then 
                  sig_PC <= X"00" & d_i;
               elsif (rdy_i = '1' and
                      zw_REG_OP = X"2C") then 
                  sig_PC <= adr_nxt_pc_i;
                  zw_b1 <= d_i;
               elsif (rdy_i = '1' and
                      zw_REG_OP = X"89") then 
                  sig_PC <= adr_nxt_pc_i;
                  reg_F(1) <= reg_1flag_i;
                  reg_sel_pc_in <= '0';
                  reg_sel_pc_val <= "00";
                  reg_sel_sp_in <= '0';
                  reg_sel_sp_as <= '1';
               end if;
            when G13_4 => 
               if (rdy_i = '1') then 
                  sig_PC <= d_i & zw_b1;
                  zw_b3 <= d_alu_i;
               end if;
            when G13_2 => 
               if (rdy_i = '1') then 
                  sig_PC <= X"00" & zw_b1;
               end if;
            when G13_e1 => 
               if (rdy_i = '1') then 
                  sig_PC <= adr_pc_i;
                  reg_F(7) <= d_i(7);
                  reg_F(6) <= d_i(6);
                  reg_F(1) <= reg_1flag_i;
                  reg_sel_pc_in <= '0';
                  reg_sel_pc_val <= "00";
                  reg_sel_sp_in <= '0';
                  reg_sel_sp_as <= '1';
               end if;
            when G13_e2 => 
               if (rdy_i = '1' AND
                   zw_b2(0) = '0') then 
                  sig_PC <= adr_pc_i;
                  reg_F(7) <= d_i(7);
                  reg_F(6) <= d_i(6);
                  reg_F(1) <= reg_1flag_i;
                  reg_sel_pc_in <= '0';
                  reg_sel_pc_val <= "00";
                  reg_sel_sp_in <= '0';
                  reg_sel_sp_as <= '1';
               elsif (rdy_i = '1') then 
                  sig_PC <= zw_b3 & zw_b1;
               end if;
            when G18_1 => 
               if (rdy_i = '1') then 
                  sig_PC <= adr_sp_i;
               end if;
            when G18_2 => 
               sig_PC <= adr_sp_i;
            when G18_3 => 
               sig_PC <= adr_sp_i;
            when G18_4 => 
               sig_PC <= X"FFFE";
            when G18_e => 
               if (rdy_i = '1') then 
                  sig_PC <= d_i & zw_b1;
                  reg_F(2) <= '1';
                  reg_sel_pc_in <= '0';
                  reg_sel_pc_val <= "00";
                  reg_sel_sp_in <= '0';
                  reg_sel_sp_as <= '1';
               end if;
            when G18_5 => 
               if (rdy_i = '1') then 
                  sig_PC <= X"FFFF";
                  reg_sel_pc_in <= '1';
                  reg_sel_pc_val <= "11";
                  zw_b1 <= d_i;
               end if;
            when G26_1 => 
               if (rdy_i = '1') then 
                  sig_PC <= adr_sp_i;
               end if;
            when G26_2 => 
               if (rdy_i = '1') then 
                  sig_PC <= adr_sp_i;
               end if;
            when G26_3 => 
               if (rdy_i = '1') then 
                  sig_PC <= adr_sp_i;
                  reg_F <= d_i;
                  reg_sel_pc_in <= '1';
                  reg_sel_pc_val <= "11";
               end if;
            when G26_4 => 
               if (rdy_i = '1') then 
                  sig_PC <= adr_sp_i;
                  zw_b1 <= d_i;
               end if;
            when G26_e => 
               if (rdy_i = '1') then 
                  sig_PC <= d_i & zw_b1;
                  reg_sel_pc_in <= '0';
                  reg_sel_pc_val <= "00";
                  reg_sel_sp_in <= '0';
                  reg_sel_sp_as <= '1';
               end if;
            when G27_1 => 
               if (rdy_i = '1') then 
                  sig_PC <= adr_sp_i;
               end if;
            when G27_2 => 
               if (rdy_i = '1') then 
                  sig_PC <= adr_sp_i;
               end if;
            when G27_3 => 
               if (rdy_i = '1') then 
                  sig_PC <= adr_sp_i;
                  zw_b1 <= d_i;
                  reg_sel_pc_in <= '1';
                  reg_sel_pc_val <= "00";
               end if;
            when G27_4 => 
               if (rdy_i = '1') then 
                  sig_PC <= d_i & zw_b1;
               end if;
            when G27_e => 
               if (rdy_i = '1') then 
                  sig_PC <= adr_pc_i;
                  reg_sel_pc_in <= '0';
                  reg_sel_pc_val <= "00";
                  reg_sel_sp_in <= '0';
                  reg_sel_sp_as <= '1';
               end if;
            when G14_1 => 
               if (rdy_i = '1' and
                   (zw_REG_OP = X"C6" OR
                   zw_REG_OP = X"E6")) then 
                  sig_PC <= X"00" & d_i;
               elsif (rdy_i = '1' and
                      (zw_REG_OP = X"D6" OR
                      zw_REG_OP = X"F6")) then 
                  sig_PC <= X"00" & d_i;
                  zw_b1 <= d_alu_i;
               elsif (rdy_i = '1' and
                      (zw_REG_OP = X"CE" OR
                      zw_REG_OP = X"EE")) then 
                  sig_PC <= adr_nxt_pc_i;
                  zw_b1 <= d_i;
               elsif (rdy_i = '1' and
                      (zw_REG_OP = X"DE" OR
                      zw_REG_OP = X"FE")) then 
                  sig_PC <= adr_nxt_pc_i;
                  zw_b1 <= d_alu_i;
                  zw_b2(0) <= reg_0flag_i;
               end if;
            when G14_5 => 
               if (rdy_i = '1') then 
                  sig_PC <= d_i & zw_b1;
               end if;
            when G14_6 => 
               if (rdy_i = '1') then 
                  sig_PC <= d_i & zw_b1;
                  zw_b3 <= d_alu_i;
               end if;
            when G14_2 => 
               if (rdy_i = '1') then 
                  sig_PC <= X"00" & zw_b1;
               end if;
            when G14_7 => 
               if (rdy_i = '1') then 
                  sig_PC <= zw_b3 & zw_b1;
               end if;
            when G14_3 => 
               if (rdy_i = '1') then 
                  zw_b1 <= d_alu_i;
               end if;
            when G14_e => 
               reg_F(7) <= reg_7flag_i;
               reg_F(1) <= reg_1flag_i;
               sig_PC <= adr_pc_i;
               reg_sel_pc_in <= '0';
               reg_sel_pc_val <= "00";
               reg_sel_sp_in <= '0';
               reg_sel_sp_as <= '1';
            when G22_1 => 
               if (rdy_i = '1') then 
                  sig_PC <= adr_sp_i;
               end if;
            when G22_e => 
               sig_PC <= adr_pc_i;
               reg_sel_pc_in <= '0';
               reg_sel_pc_val <= "00";
               reg_sel_sp_in <= '0';
               reg_sel_sp_as <= '1';
            when G23_1 => 
               if (rdy_i = '1') then 
                  sig_PC <= adr_sp_i;
               end if;
            when G23_e => 
               sig_PC <= adr_pc_i;
               reg_sel_pc_in <= '0';
               reg_sel_pc_val <= "00";
               reg_sel_sp_in <= '0';
               reg_sel_sp_as <= '1';
            when G24_2 => 
               if (rdy_i = '1') then 
                  sig_PC <= adr_sp_i;
               end if;
            when G24_e => 
               if (rdy_i = '1') then 
                  sig_PC <= adr_pc_i;
                  reg_F(7) <= reg_7flag_i;
                  reg_F(1) <= reg_1flag_i;
                  reg_sel_pc_in <= '0';
                  reg_sel_pc_val <= "00";
                  reg_sel_sp_in <= '0';
                  reg_sel_sp_as <= '1';
               end if;
            when G25_2 => 
               if (rdy_i = '1') then 
                  sig_PC <= adr_sp_i;
               end if;
            when G25_e => 
               if (rdy_i = '1') then 
                  sig_PC <= adr_pc_i;
                  reg_F <= d_i;
                  reg_sel_pc_in <= '0';
                  reg_sel_pc_val <= "00";
                  reg_sel_sp_in <= '0';
                  reg_sel_sp_as <= '1';
               end if;
            when others =>
               null;
         end case;
      end if;
   end process clocked_proc;
 
   -----------------------------------------------------------------
   nextstate_proc : process ( 
      adr_nxt_pc_i,
      current_state,
      d_i,
      irq_n_i,
      rdy_i,
      reg_F,
      zw_REG_NMI,
      zw_REG_OP,
      zw_b2,
      zw_b3
   )
   -----------------------------------------------------------------
   begin
      case current_state is
         when G30_1 => 
            next_state <= G30_2;
         when G30_3 => 
            next_state <= G30_4;
         when G30_4 => 
            next_state <= G30_5;
         when G30_5 => 
            if (rdy_i = '1') then 
               next_state <= G30_e;
            else
               next_state <= G30_5;
            end if;
         when G30_e => 
            if (rdy_i = '1') then 
               next_state <= FETCH;
            else
               next_state <= G30_e;
            end if;
         when G30_2 => 
            next_state <= G30_3;
         when RES => 
            next_state <= G30_1;
         when G28_1 => 
            if (rdy_i = '1') then 
               next_state <= G28_2;
            else
               next_state <= G28_1;
            end if;
         when G28_2 => 
            next_state <= G28_3;
         when G28_3 => 
            next_state <= G28_4;
         when G28_5 => 
            if (rdy_i = '1') then 
               next_state <= G28_e;
            else
               next_state <= G28_5;
            end if;
         when G28_4 => 
            next_state <= G28_5;
         when G28_e => 
            if (rdy_i = '1') then 
               next_state <= FETCH;
            else
               next_state <= G28_e;
            end if;
         when G29_1 => 
            if (rdy_i = '1') then 
               next_state <= G29_2;
            else
               next_state <= G29_1;
            end if;
         when G29_2 => 
            next_state <= G29_3;
         when G29_3 => 
            next_state <= G29_4;
         when G29_5 => 
            if (rdy_i = '1') then 
               next_state <= G29_e;
            else
               next_state <= G29_5;
            end if;
         when G29_4 => 
            next_state <= G29_5;
         when G29_e => 
            if (rdy_i = '1') then 
               next_state <= FETCH;
            else
               next_state <= G29_e;
            end if;
         when FETCH => 
            if ((zw_REG_NMI = '1') and (rdy_i = '1')) then 
               next_state <= G29_1;
            elsif ((irq_n_i = '0' and
                   reg_F(2) = '0') and (rdy_i = '1')) then 
               next_state <= G28_1;
            elsif ((d_i = X"69" or
                   d_i = X"65" or
                   d_i = X"75" or
                   d_i = X"6D" or
                   d_i = X"7D" or
                   d_i = X"79" or
                   d_i = X"61" or
                   d_i = X"71" or
                   d_i = X"72") and (rdy_i = '1')) then 
               next_state <= G10_1;
            elsif ((d_i = X"06" or
                   d_i = X"16" or
                   d_i = X"0E" or
                   d_i = X"1E" or
                   d_i (3 downto 0) = X"7" or
                   d_i = X"14" or
                   d_i = X"04" or
                   d_i = X"0C" or
                   d_i = X"1C") and (rdy_i = '1')) then 
               next_state <= G11_1;
            elsif ((d_i = X"90" or
                   d_i = X"B0" or
                   d_i = X"F0" or
                   d_i = X"30" or
                   d_i = X"D0" or
                   d_i = X"10" or
                   d_i = X"50" or
                   d_i = X"70" or
                   d_i = X"80" or
                   d_i (3 downto 0) = X"F") and (rdy_i = '1')) then 
               next_state <= G12_1;
            elsif ((d_i = X"24" or
                   d_i = X"2C" or
                   d_i = X"3C" or
                   d_i = X"34" or
                   d_i = X"89") and (rdy_i = '1')) then 
               next_state <= G13_1;
            elsif ((d_i = X"00") and (rdy_i = '1')) then 
               next_state <= G18_1;
            elsif ((d_i = X"18") and (rdy_i = '1')) then 
               next_state <= G5_1;
            elsif ((d_i = X"D8") and (rdy_i = '1')) then 
               next_state <= G6_1;
            elsif ((d_i = X"58") and (rdy_i = '1')) then 
               next_state <= G7_1;
            elsif ((d_i = X"B8") and (rdy_i = '1')) then 
               next_state <= G8_1;
            elsif ((d_i = X"E0" or
                   d_i = X"E4" or
                   d_i = X"EC") and (rdy_i = '1')) then 
               next_state <= G15_1;
            elsif ((d_i = X"C0" or
                   d_i = X"C4" or
                   d_i = X"CC") and (rdy_i = '1')) then 
               next_state <= G15_1;
            elsif ((d_i = X"C6" or
                   d_i = X"D6" or
                   d_i = X"CE" or
                   d_i = X"DE") and (rdy_i = '1')) then 
               next_state <= G14_1;
            elsif ((d_i = X"CA") and (rdy_i = '1')) then 
               next_state <= G19_1;
            elsif ((d_i = X"88") and (rdy_i = '1')) then 
               next_state <= G19_1;
            elsif ((d_i = X"49" or
                   d_i = X"45" or
                   d_i = X"55" or
                   d_i = X"4D" or
                   d_i = X"5D" or
                   d_i = X"59" or
                   d_i = X"41" or
                   d_i = X"51" or
                   d_i = X"09" or
                   d_i = X"05" or
                   d_i = X"15" or
                   d_i = X"0D" or
                   d_i = X"1D" or
                   d_i = X"19" or
                   d_i = X"01" or
                   d_i = X"11" or
                   d_i = X"29" or
                   d_i = X"25" or
                   d_i = X"35" or
                   d_i = X"2D" or
                   d_i = X"3D" or
                   d_i = X"39" or
                   d_i = X"21" or
                   d_i = X"31" or
                   d_i = X"C9" or
                   d_i = X"C5" or
                   d_i = X"D5" or
                   d_i = X"CD" or
                   d_i = X"DD" or
                   d_i = X"D9" or
                   d_i = X"C1" or
                   d_i = X"D1" or
                   d_i = X"32" or
                   d_i = X"D2" or
                   d_i = X"52" or
                   d_i = X"12") and (rdy_i = '1')) then 
               next_state <= G15_1;
            elsif ((d_i = X"E6" or
                   d_i = X"F6" or
                   d_i = X"EE" or
                   d_i = X"FE") and (rdy_i = '1')) then 
               next_state <= G14_1;
            elsif ((d_i = X"E8") and (rdy_i = '1')) then 
               next_state <= G19_1;
            elsif ((d_i = X"C8") and (rdy_i = '1')) then 
               next_state <= G19_1;
            elsif ((d_i = X"4C" or
                   d_i = X"6C" or
                   d_i = X"7C") and (rdy_i = '1')) then 
               next_state <= G20_1;
            elsif ((d_i = X"20") and (rdy_i = '1')) then 
               next_state <= G21_1;
            elsif ((d_i = X"A9" or
                   d_i = X"A5" or
                   d_i = X"B5" or
                   d_i = X"AD" or
                   d_i = X"BD" or
                   d_i = X"B9" or
                   d_i = X"A1" or
                   d_i = X"B1" or
                   d_i = X"B2") and (rdy_i = '1')) then 
               next_state <= G15_1;
            elsif ((d_i = X"A2" or
                   d_i = X"A6" or
                   d_i = X"B6" or
                   d_i = X"AE" or
                   d_i = X"BE") and (rdy_i = '1')) then 
               next_state <= G15_1;
            elsif ((d_i = X"A0" or
                   d_i = X"A4" or
                   d_i = X"B4" or
                   d_i = X"AC" or
                   d_i = X"BC") and (rdy_i = '1')) then 
               next_state <= G15_1;
            elsif ((d_i = X"46" or
                   d_i = X"56" or
                   d_i = X"4E" or
                   d_i = X"5E") and (rdy_i = '1')) then 
               next_state <= G11_1;
            elsif ((d_i = X"EA") and (rdy_i = '1')) then 
               next_state <= G1_1;
            elsif ((d_i = X"48") and (rdy_i = '1')) then 
               next_state <= G22_1;
            elsif ((d_i = X"08") and (rdy_i = '1')) then 
               next_state <= G23_1;
            elsif ((d_i = X"7A") and (rdy_i = '1')) then 
               next_state <= G24_1;
            elsif ((d_i = X"28") and (rdy_i = '1')) then 
               next_state <= G25_1;
            elsif ((d_i = X"26" or
                   d_i = X"36" or
                   d_i = X"2E" or
                   d_i = X"3E") and (rdy_i = '1')) then 
               next_state <= G11_1;
            elsif ((d_i = X"66" or
                   d_i = X"76" or
                   d_i = X"6E" or
                   d_i = X"7E") and (rdy_i = '1')) then 
               next_state <= G11_1;
            elsif ((d_i = X"40") and (rdy_i = '1')) then 
               next_state <= G26_1;
            elsif ((d_i = X"60") and (rdy_i = '1')) then 
               next_state <= G27_1;
            elsif ((d_i = X"E9" or
                   d_i = X"E5" or
                   d_i = X"F5" or
                   d_i = X"ED" or
                   d_i = X"FD" or
                   d_i = X"F9" or
                   d_i = X"E1" or
                   d_i = X"F1" or
                   d_i = X"F2") and (rdy_i = '1')) then 
               next_state <= G16_1;
            elsif ((d_i = X"38") and (rdy_i = '1')) then 
               next_state <= G2_1;
            elsif ((d_i = X"F8") and (rdy_i = '1')) then 
               next_state <= G3_1;
            elsif ((d_i = X"78") and (rdy_i = '1')) then 
               next_state <= G4_1;
            elsif ((d_i = X"85" or
                   d_i = X"95" or
                   d_i = X"8D" or
                   d_i = X"9D" or
                   d_i = X"99" or
                   d_i = X"81" or
                   d_i = X"91") and (rdy_i = '1')) then 
               next_state <= G17_1;
            elsif ((d_i = X"86" or
                   d_i = X"96" or
                   d_i = X"8E") and (rdy_i = '1')) then 
               next_state <= G17_1;
            elsif ((d_i = X"84" or
                   d_i = X"94" or
                   d_i = X"8C") and (rdy_i = '1')) then 
               next_state <= G17_1;
            elsif ((d_i = X"AA") and (rdy_i = '1')) then 
               next_state <= G9_1;
            elsif ((d_i = X"0A") and (rdy_i = '1')) then 
               next_state <= G31_1;
            elsif ((d_i = X"4A") and (rdy_i = '1')) then 
               next_state <= G32_1;
            elsif ((d_i = X"2A") and (rdy_i = '1')) then 
               next_state <= G33_1;
            elsif ((d_i = X"6A") and (rdy_i = '1')) then 
               next_state <= G34_1;
            elsif ((d_i = X"A8") and (rdy_i = '1')) then 
               next_state <= G9_1;
            elsif ((d_i = X"98") and (rdy_i = '1')) then 
               next_state <= G9_1;
            elsif ((d_i = X"BA") and (rdy_i = '1')) then 
               next_state <= G9_1;
            elsif ((d_i = X"8A") and (rdy_i = '1')) then 
               next_state <= G9_1;
            elsif ((d_i = X"9A") and (rdy_i = '1')) then 
               next_state <= G9_1;
            elsif ((d_i = X"DA") and (rdy_i = '1')) then 
               next_state <= G22_1;
            elsif ((d_i = X"5A") and (rdy_i = '1')) then 
               next_state <= G22_1;
            elsif ((d_i = X"68") and (rdy_i = '1')) then 
               next_state <= G24_1;
            elsif ((d_i = X"FA") and (rdy_i = '1')) then 
               next_state <= G24_1;
            elsif ((d_i = X"9C" or
                   d_i = X"9E" or
                   d_i = X"64" or
                   d_i = X"74") and (rdy_i = '1')) then 
               next_state <= G17_1;
            elsif ((d_i = X"3A") and (rdy_i = '1')) then 
               next_state <= G19_1;
            elsif ((d_i = X"1A") and (rdy_i = '1')) then 
               next_state <= G19_1;
            elsif (rdy_i = '1') then 
               next_state <= G1_1;
            else
               next_state <= FETCH;
            end if;
         when G1_1 => 
            if (rdy_i = '1') then 
               next_state <= FETCH;
            else
               next_state <= G1_1;
            end if;
         when G2_1 => 
            if (rdy_i = '1') then 
               next_state <= FETCH;
            else
               next_state <= G2_1;
            end if;
         when G3_1 => 
            if (rdy_i = '1') then 
               next_state <= FETCH;
            else
               next_state <= G3_1;
            end if;
         when G4_1 => 
            if (rdy_i = '1') then 
               next_state <= FETCH;
            else
               next_state <= G4_1;
            end if;
         when G9_1 => 
            if (rdy_i = '1' and
                zw_REG_OP = X"9A") then 
               next_state <= FETCH;
            elsif (rdy_i = '1' and
                   zw_REG_OP = X"BA") then 
               next_state <= FETCH;
            elsif (rdy_i = '1') then 
               next_state <= FETCH;
            else
               next_state <= G9_1;
            end if;
         when G5_1 => 
            if (rdy_i = '1') then 
               next_state <= FETCH;
            else
               next_state <= G5_1;
            end if;
         when G6_1 => 
            if (rdy_i = '1') then 
               next_state <= FETCH;
            else
               next_state <= G6_1;
            end if;
         when G7_1 => 
            if (rdy_i = '1') then 
               next_state <= FETCH;
            else
               next_state <= G7_1;
            end if;
         when G8_1 => 
            if (rdy_i = '1') then 
               next_state <= FETCH;
            else
               next_state <= G8_1;
            end if;
         when G19_1 => 
            if (rdy_i = '1') then 
               next_state <= FETCH;
            else
               next_state <= G19_1;
            end if;
         when G15_1 => 
            if (rdy_i = '1' and
                (zw_REG_OP = X"A5" OR zw_REG_OP = X"A6" OR
                zw_REG_OP = X"A4" OR zw_REG_OP = X"45" OR
                zw_REG_OP = X"05" OR zw_REG_OP = X"25" OR
                zw_REG_OP = X"C5" OR zw_REG_OP = X"E4" OR zw_REG_OP = X"C4")) then 
               next_state <= G15_e2;
            elsif ((rdy_i = '1' and
                   (zw_REG_OP = X"A9" OR zw_REG_OP = X"A2" OR zw_REG_OP = X"A0" OR zw_REG_OP = X"E0" OR zw_REG_OP = X"C0" OR
                   zw_REG_OP = X"49" or zw_REG_OP = X"09" or zw_REG_OP = X"29" or zw_REG_OP = X"C9")) and (zw_REG_OP = X"09" or zw_REG_OP = X"05" or
                   zw_REG_OP = X"15" or zw_REG_OP = X"0D" or
                   zw_REG_OP = X"1D" or zw_REG_OP = X"19" or 
                   zw_REG_OP = X"01" or zw_REG_OP = X"11" or
                   zw_REG_OP = X"12")) then 
               next_state <= FETCH;
            elsif ((rdy_i = '1' and
                   (zw_REG_OP = X"A9" OR zw_REG_OP = X"A2" OR zw_REG_OP = X"A0" OR zw_REG_OP = X"E0" OR zw_REG_OP = X"C0" OR
                   zw_REG_OP = X"49" or zw_REG_OP = X"09" or zw_REG_OP = X"29" or zw_REG_OP = X"C9")) and (zw_REG_OP = X"49" or zw_REG_OP = X"45" or
                   zw_REG_OP = X"55" or zw_REG_OP = X"4D" or
                   zw_REG_OP = X"5D" or zw_REG_OP = X"59" or
                   zw_REG_OP = X"41" or zw_REG_OP = X"51" or
                   zw_REG_OP = X"52")) then 
               next_state <= FETCH;
            elsif ((rdy_i = '1' and
                   (zw_REG_OP = X"A9" OR zw_REG_OP = X"A2" OR zw_REG_OP = X"A0" OR zw_REG_OP = X"E0" OR zw_REG_OP = X"C0" OR
                   zw_REG_OP = X"49" or zw_REG_OP = X"09" or zw_REG_OP = X"29" or zw_REG_OP = X"C9")) and (zw_REG_OP = X"29" or zw_REG_OP = X"25" or
                   zw_REG_OP = X"35" or zw_REG_OP = X"2D" or
                   zw_REG_OP = X"3D" or zw_REG_OP = X"39" or
                   zw_REG_OP = X"21" or zw_REG_OP = X"31" or
                   zw_REG_OP = X"32" or zw_REG_OP = X"D2")) then 
               next_state <= FETCH;
            elsif ((rdy_i = '1' and
                   (zw_REG_OP = X"A9" OR zw_REG_OP = X"A2" OR zw_REG_OP = X"A0" OR zw_REG_OP = X"E0" OR zw_REG_OP = X"C0" OR
                   zw_REG_OP = X"49" or zw_REG_OP = X"09" or zw_REG_OP = X"29" or zw_REG_OP = X"C9")) and (zw_REG_OP = X"C9" or zw_REG_OP = X"C5" or
                   zw_REG_OP = X"D5" or zw_REG_OP = X"CD" or
                   zw_REG_OP = X"DD" or zw_REG_OP = X"D9" or
                   zw_REG_OP = X"C1" or zw_REG_OP = X"D1" or
                    zw_REG_OP = X"C0" or zw_REG_OP = X"E0" or
                    zw_REG_OP = X"C4" or zw_REG_OP = X"E4" or
                    zw_REG_OP = X"CC" or zw_REG_OP = X"EC")) then 
               next_state <= FETCH;
            elsif (rdy_i = '1' and
                   (zw_REG_OP = X"A9" OR zw_REG_OP = X"A2" OR zw_REG_OP = X"A0" OR zw_REG_OP = X"E0" OR zw_REG_OP = X"C0" OR
                   zw_REG_OP = X"49" or zw_REG_OP = X"09" or zw_REG_OP = X"29" or zw_REG_OP = X"C9")) then 
               next_state <= FETCH;
            elsif (rdy_i = '1' and
                   (zw_REG_OP = X"B5" OR
                   zw_REG_OP = X"B4" OR
                   zw_REG_OP = X"55" OR zw_REG_OP = X"15" OR
                   zw_REG_OP = X"35" OR
                   zw_REG_OP = X"D5")) then 
               next_state <= G15_2;
            elsif (rdy_i = '1' and
                   (zw_REG_OP = X"AD" OR
                   zw_REG_OP = X"AE" OR
                   zw_REG_OP = X"AC" OR
                   zw_REG_OP = X"4D" OR
                   zw_REG_OP = X"0D" OR
                   zw_REG_OP = X"2D" OR
                   zw_REG_OP = X"CD" OR
                   zw_REG_OP = X"EC" OR
                   zw_REG_OP = X"CC")) then 
               next_state <= G15_3;
            elsif (rdy_i = '1' and
                   (zw_REG_OP = X"BD" OR
                   zw_REG_OP = X"BC" OR
                   zw_REG_OP = X"5D" OR
                   zw_REG_OP = X"1D" OR
                   zw_REG_OP = X"3D" OR
                   zw_REG_OP = X"DD")) then 
               next_state <= G15_4;
            elsif (rdy_i = '1' and
                   (zw_REG_OP = X"B9" OR
                   zw_REG_OP = X"BE" OR
                   zw_REG_OP = X"59" OR
                   zw_REG_OP = X"19" OR
                   zw_REG_OP = X"39" OR
                   zw_REG_OP = X"D9")) then 
               next_state <= G15_4;
            elsif (rdy_i = '1' and
                   (zw_REG_OP = X"B1" OR
                   zw_REG_OP = X"51" OR
                   zw_REG_OP = X"11" OR
                   zw_REG_OP = X"31" OR
                   zw_REG_OP = X"D1")) then 
               next_state <= G15_5;
            elsif (rdy_i = '1' and
                   (zw_REG_OP = X"A1" OR
                   zw_REG_OP = X"41" OR
                   zw_REG_OP = X"01" OR
                   zw_REG_OP = X"21" OR
                   zw_REG_OP = X"C1")) then 
               next_state <= G15_7;
            elsif (rdy_i = '1' and
                   zw_REG_OP = X"B6") then 
               next_state <= G15_2;
            elsif (rdy_i = '1' and
                   (zw_REG_OP = X"32" OR
                   zw_REG_OP = X"D2" OR
                   zw_REG_OP = X"52" OR
                   zw_REG_OP = X"B2" OR
                   zw_REG_OP = X"12")) then 
               next_state <= G15_8;
            else
               next_state <= G15_1;
            end if;
         when G15_3 => 
            if (rdy_i = '1') then 
               next_state <= G15_e2;
            else
               next_state <= G15_3;
            end if;
         when G15_4 => 
            if (rdy_i = '1') then 
               next_state <= G15_e1;
            else
               next_state <= G15_4;
            end if;
         when G15_5 => 
            if (rdy_i = '1') then 
               next_state <= G15_6;
            else
               next_state <= G15_5;
            end if;
         when G15_2 => 
            if (rdy_i = '1') then 
               next_state <= G15_e2;
            else
               next_state <= G15_2;
            end if;
         when G15_7 => 
            if (rdy_i = '1') then 
               next_state <= G15_e3;
            else
               next_state <= G15_7;
            end if;
         when G15_e3 => 
            if (rdy_i = '1') then 
               next_state <= G15_3;
            else
               next_state <= G15_e3;
            end if;
         when G15_6 => 
            if (rdy_i = '1') then 
               next_state <= G15_e1;
            else
               next_state <= G15_6;
            end if;
         when G15_e2 => 
            if ((rdy_i = '1') and (zw_REG_OP = X"09" or zw_REG_OP = X"05" or
                zw_REG_OP = X"15" or zw_REG_OP = X"0D" or
                zw_REG_OP = X"1D" or zw_REG_OP = X"19" or 
                zw_REG_OP = X"01" or zw_REG_OP = X"11" or
                zw_REG_OP = X"12")) then 
               next_state <= FETCH;
            elsif ((rdy_i = '1') and (zw_REG_OP = X"49" or zw_REG_OP = X"45" or
                   zw_REG_OP = X"55" or zw_REG_OP = X"4D" or
                   zw_REG_OP = X"5D" or zw_REG_OP = X"59" or
                   zw_REG_OP = X"41" or zw_REG_OP = X"51" or
                   zw_REG_OP = X"52")) then 
               next_state <= FETCH;
            elsif ((rdy_i = '1') and (zw_REG_OP = X"29" or zw_REG_OP = X"25" or
                   zw_REG_OP = X"35" or zw_REG_OP = X"2D" or
                   zw_REG_OP = X"3D" or zw_REG_OP = X"39" or
                   zw_REG_OP = X"21" or zw_REG_OP = X"31" or
                   zw_REG_OP = X"32" or zw_REG_OP = X"D2")) then 
               next_state <= FETCH;
            elsif ((rdy_i = '1') and (zw_REG_OP = X"C9" or zw_REG_OP = X"C5" or
                   zw_REG_OP = X"D5" or zw_REG_OP = X"CD" or
                   zw_REG_OP = X"DD" or zw_REG_OP = X"D9" or
                   zw_REG_OP = X"C1" or zw_REG_OP = X"D1" or
                    zw_REG_OP = X"C0" or zw_REG_OP = X"E0" or
                    zw_REG_OP = X"C4" or zw_REG_OP = X"E4" or
                    zw_REG_OP = X"CC" or zw_REG_OP = X"EC")) then 
               next_state <= FETCH;
            elsif (rdy_i = '1') then 
               next_state <= FETCH;
            else
               next_state <= G15_e2;
            end if;
         when G15_e1 => 
            if ((rdy_i = '1' AND
                zw_b2(0) = '0') and (zw_REG_OP = X"09" or zw_REG_OP = X"05" or
                zw_REG_OP = X"15" or zw_REG_OP = X"0D" or
                zw_REG_OP = X"1D" or zw_REG_OP = X"19" or 
                zw_REG_OP = X"01" or zw_REG_OP = X"11" or
                zw_REG_OP = X"12")) then 
               next_state <= FETCH;
            elsif ((rdy_i = '1' AND
                   zw_b2(0) = '0') and (zw_REG_OP = X"49" or zw_REG_OP = X"45" or
                   zw_REG_OP = X"55" or zw_REG_OP = X"4D" or
                   zw_REG_OP = X"5D" or zw_REG_OP = X"59" or
                   zw_REG_OP = X"41" or zw_REG_OP = X"51" or
                   zw_REG_OP = X"52")) then 
               next_state <= FETCH;
            elsif ((rdy_i = '1' AND
                   zw_b2(0) = '0') and (zw_REG_OP = X"29" or zw_REG_OP = X"25" or
                   zw_REG_OP = X"35" or zw_REG_OP = X"2D" or
                   zw_REG_OP = X"3D" or zw_REG_OP = X"39" or
                   zw_REG_OP = X"21" or zw_REG_OP = X"31" or
                   zw_REG_OP = X"32" or zw_REG_OP = X"D2")) then 
               next_state <= FETCH;
            elsif ((rdy_i = '1' AND
                   zw_b2(0) = '0') and (zw_REG_OP = X"C9" or zw_REG_OP = X"C5" or
                   zw_REG_OP = X"D5" or zw_REG_OP = X"CD" or
                   zw_REG_OP = X"DD" or zw_REG_OP = X"D9" or
                   zw_REG_OP = X"C1" or zw_REG_OP = X"D1" or
                    zw_REG_OP = X"C0" or zw_REG_OP = X"E0" or
                    zw_REG_OP = X"C4" or zw_REG_OP = X"E4" or
                    zw_REG_OP = X"CC" or zw_REG_OP = X"EC")) then 
               next_state <= FETCH;
            elsif (rdy_i = '1' AND
                   zw_b2(0) = '0') then 
               next_state <= FETCH;
            elsif (rdy_i = '1') then 
               next_state <= G15_e2;
            else
               next_state <= G15_e1;
            end if;
         when G15_8 => 
            if (rdy_i = '1') then 
               next_state <= G15_3;
            else
               next_state <= G15_8;
            end if;
         when G10_1 => 
            if (rdy_i = '1' and
                zw_REG_OP = X"65") then 
               next_state <= G10_e2;
            elsif (rdy_i = '1' and
                   zw_REG_OP = X"69" and
                   reg_F(3) = '0') then 
               next_state <= FETCH;
            elsif (rdy_i = '1' and
                   zw_REG_OP = X"75") then 
               next_state <= G10_2;
            elsif (rdy_i = '1' and
                   zw_REG_OP = X"6D") then 
               next_state <= G10_3;
            elsif (rdy_i = '1' and
                   zw_REG_OP = X"7D") then 
               next_state <= G10_4;
            elsif (rdy_i = '1' and
                   zw_REG_OP = X"79") then 
               next_state <= G10_4;
            elsif (rdy_i = '1' and
                   zw_REG_OP = X"71") then 
               next_state <= G10_5;
            elsif (rdy_i = '1' and
                   zw_REG_OP = X"61") then 
               next_state <= G10_7;
            elsif (rdy_i = '1' and
                   zw_REG_OP = X"69" and
                   reg_F(3) = '1') then 
               next_state <= FETCH;
            elsif (rdy_i = '1' and
                   zw_REG_OP = X"72") then 
               next_state <= G10_8;
            else
               next_state <= G10_1;
            end if;
         when G10_3 => 
            if (rdy_i = '1') then 
               next_state <= G10_e2;
            else
               next_state <= G10_3;
            end if;
         when G10_4 => 
            if (rdy_i = '1') then 
               next_state <= G10_e1;
            else
               next_state <= G10_4;
            end if;
         when G10_5 => 
            if (rdy_i = '1') then 
               next_state <= G10_6;
            else
               next_state <= G10_5;
            end if;
         when G10_2 => 
            if (rdy_i = '1') then 
               next_state <= G10_e2;
            else
               next_state <= G10_2;
            end if;
         when G10_7 => 
            if (rdy_i = '1') then 
               next_state <= G10_e3;
            else
               next_state <= G10_7;
            end if;
         when G10_e3 => 
            if (rdy_i = '1') then 
               next_state <= G10_3;
            else
               next_state <= G10_e3;
            end if;
         when G10_e1 => 
            if (rdy_i = '1' AND
                zw_b2(0) = '0' and
                reg_F(3) = '0') then 
               next_state <= FETCH;
            elsif (rdy_i = '1' AND
                   zw_b2(0) = '0' and
                   reg_F(3) = '1') then 
               next_state <= FETCH;
            elsif (rdy_i = '1') then 
               next_state <= G10_e2;
            else
               next_state <= G10_e1;
            end if;
         when G10_e2 => 
            if (rdy_i = '1' and
                reg_F(3) = '0') then 
               next_state <= FETCH;
            elsif (rdy_i = '1' and
                   reg_F(3) = '1') then 
               next_state <= FETCH;
            else
               next_state <= G10_e2;
            end if;
         when G10_6 => 
            if (rdy_i = '1') then 
               next_state <= G10_e1;
            else
               next_state <= G10_6;
            end if;
         when G10_8 => 
            if (rdy_i = '1') then 
               next_state <= G10_3;
            else
               next_state <= G10_8;
            end if;
         when G17_1 => 
            if (rdy_i = '1' and
                (zw_REG_OP = X"85" OR
                zw_REG_OP = X"86" OR
                zw_REG_OP = X"64" OR
                zw_REG_OP = X"84")) then 
               next_state <= G17_e;
            elsif (rdy_i = '1' and
                   (zw_REG_OP = X"95" OR
                   zw_REG_OP = X"74" OR
                   zw_REG_OP = X"94")) then 
               next_state <= G17_2;
            elsif (rdy_i = '1' and
                   (zw_REG_OP = X"8D" OR
                   zw_REG_OP = X"8E" OR
                   zw_REG_OP = X"9C" OR
                   zw_REG_OP = X"8C")) then 
               next_state <= G17_3;
            elsif (rdy_i = '1' and
                   (zw_REG_OP = X"9D" OR
                   zw_REG_OP = X"9E")) then 
               next_state <= G17_4;
            elsif (rdy_i = '1' and
                   zw_REG_OP = X"99") then 
               next_state <= G17_4;
            elsif (rdy_i = '1' and
                   zw_REG_OP = X"91") then 
               next_state <= G17_6;
            elsif (rdy_i = '1' and
                   zw_REG_OP = X"81") then 
               next_state <= G17_8;
            elsif (rdy_i = '1' and
                   zw_REG_OP = X"96") then 
               next_state <= G17_2;
            elsif (rdy_i = '1' and
                   zw_REG_OP = X"92") then 
               next_state <= G17_11;
            else
               next_state <= G17_1;
            end if;
         when G17_4 => 
            if (rdy_i = '1') then 
               next_state <= G17_5;
            else
               next_state <= G17_4;
            end if;
         when G17_6 => 
            if (rdy_i = '1') then 
               next_state <= G17_7;
            else
               next_state <= G17_6;
            end if;
         when G17_3 => 
            if (rdy_i = '1') then 
               next_state <= G17_e;
            else
               next_state <= G17_3;
            end if;
         when G17_2 => 
            if (rdy_i = '1') then 
               next_state <= G17_e;
            else
               next_state <= G17_2;
            end if;
         when G17_8 => 
            if (rdy_i = '1') then 
               next_state <= G17_9;
            else
               next_state <= G17_8;
            end if;
         when G17_9 => 
            if (rdy_i = '1') then 
               next_state <= G17_10;
            else
               next_state <= G17_9;
            end if;
         when G17_7 => 
            if (rdy_i = '1') then 
               next_state <= G17_5;
            else
               next_state <= G17_7;
            end if;
         when G17_5 => 
            next_state <= G17_e;
         when G17_10 => 
            next_state <= G17_e;
         when G17_e => 
            next_state <= FETCH;
         when G17_11 => 
            if (rdy_i = '1') then 
               next_state <= G17_3;
            else
               next_state <= G17_11;
            end if;
         when G16_1 => 
            if (rdy_i = '1' and
                zw_REG_OP = X"E5") then 
               next_state <= G16_e2;
            elsif (rdy_i = '1' and
                   zw_REG_OP = X"E9" and
                   reg_F(3) = '0') then 
               next_state <= FETCH;
            elsif (rdy_i = '1' and
                   zw_REG_OP = X"F5") then 
               next_state <= G16_2;
            elsif (rdy_i = '1' and
                   zw_REG_OP = X"ED") then 
               next_state <= G16_3;
            elsif (rdy_i = '1' and
                   zw_REG_OP = X"FD") then 
               next_state <= G16_4;
            elsif (rdy_i = '1' and
                   zw_REG_OP = X"F9") then 
               next_state <= G16_4;
            elsif (rdy_i = '1' and
                   zw_REG_OP = X"F1") then 
               next_state <= G16_5;
            elsif (rdy_i = '1' and
                   zw_REG_OP = X"E1") then 
               next_state <= G16_7;
            elsif (rdy_i = '1' and
                   zw_REG_OP = X"E9" and
                   reg_F(3) = '1') then 
               next_state <= FETCH;
            elsif (rdy_i = '1' and
                   zw_REG_OP = X"F2") then 
               next_state <= G16_8;
            else
               next_state <= G16_1;
            end if;
         when G16_3 => 
            if (rdy_i = '1') then 
               next_state <= G16_e2;
            else
               next_state <= G16_3;
            end if;
         when G16_4 => 
            if (rdy_i = '1') then 
               next_state <= G16_e1;
            else
               next_state <= G16_4;
            end if;
         when G16_5 => 
            if (rdy_i = '1') then 
               next_state <= G16_6;
            else
               next_state <= G16_5;
            end if;
         when G16_2 => 
            if (rdy_i = '1') then 
               next_state <= G16_e2;
            else
               next_state <= G16_2;
            end if;
         when G16_7 => 
            if (rdy_i = '1') then 
               next_state <= G16_e3;
            else
               next_state <= G16_7;
            end if;
         when G16_6 => 
            if (rdy_i = '1') then 
               next_state <= G16_e1;
            else
               next_state <= G16_6;
            end if;
         when G16_e3 => 
            if (rdy_i = '1') then 
               next_state <= G16_3;
            else
               next_state <= G16_e3;
            end if;
         when G16_e1 => 
            if (rdy_i = '1' AND
                zw_b2(0) = '0' and
                reg_F(3) = '0') then 
               next_state <= FETCH;
            elsif (rdy_i = '1' AND
                   zw_b2(0) = '0' and
                   reg_F(3) = '1') then 
               next_state <= FETCH;
            elsif (rdy_i = '1') then 
               next_state <= G16_e2;
            else
               next_state <= G16_e1;
            end if;
         when G16_e2 => 
            if (rdy_i = '1' and
                reg_F(3) = '0') then 
               next_state <= FETCH;
            elsif (rdy_i = '1' and
                   reg_F(3) = '1') then 
               next_state <= FETCH;
            else
               next_state <= G16_e2;
            end if;
         when G16_8 => 
            if (rdy_i = '1') then 
               next_state <= G16_3;
            else
               next_state <= G16_8;
            end if;
         when G11_1 => 
            if (rdy_i = '1' and
                (zw_REG_OP = X"1E" or
                zw_REG_OP = X"7E" or
                zw_REG_OP = X"3E" or
                zw_REG_OP = X"5E")) then 
               next_state <= G11_6;
            elsif (rdy_i = '1' and
                   (zw_REG_OP = X"06" or zw_REG_OP = X"66" or
                   zw_REG_OP = X"26" or zw_REG_OP = X"46" or
                   zw_REG_OP = X"04" or zw_REG_OP = X"14")) then 
               next_state <= G11_3;
            elsif (rdy_i = '1' and
                   (zw_REG_OP = X"16" or
                   zw_REG_OP = X"76" or
                   zw_REG_OP = X"36" or
                   zw_REG_OP = X"56")) then 
               next_state <= G11_2;
            elsif (rdy_i = '1' and
                   (zw_REG_OP = X"0E" or
                   zw_REG_OP = X"6E" or
                   zw_REG_OP = X"2E" or
                   zw_REG_OP = X"4E"or
                   zw_REG_OP = X"0C" or
                   zw_REG_OP = X"1C")) then 
               next_state <= G11_5;
            elsif (rdy_i = '1' and
                   zw_REG_OP (3 downto 0) = X"7") then 
               next_state <= G11_3;
            else
               next_state <= G11_1;
            end if;
         when G11_5 => 
            if (rdy_i = '1') then 
               next_state <= G11_3;
            else
               next_state <= G11_5;
            end if;
         when G11_6 => 
            if (rdy_i = '1') then 
               next_state <= G11_7;
            else
               next_state <= G11_6;
            end if;
         when G11_2 => 
            if (rdy_i = '1') then 
               next_state <= G11_3;
            else
               next_state <= G11_2;
            end if;
         when G11_7 => 
            if (rdy_i = '1') then 
               next_state <= G11_4;
            else
               next_state <= G11_7;
            end if;
         when G11_3 => 
            if (rdy_i = '1') then 
               next_state <= G11_4;
            else
               next_state <= G11_3;
            end if;
         when G11_4 => 
            if (rdy_i = '1' and
                (zw_REG_OP = X"06" or
                zw_REG_OP = X"16" or
                zw_REG_OP = X"0E" or
                zw_REG_OP = X"1E")) then 
               next_state <= G11_e;
            elsif (rdy_i = '1' and
                   (zw_REG_OP = X"46" or
                   zw_REG_OP = X"56" or
                   zw_REG_OP = X"4E" or
                   zw_REG_OP = X"5E")) then 
               next_state <= G11_e;
            elsif (rdy_i = '1' and
                   (zw_REG_OP = X"26" or
                   zw_REG_OP = X"36" or
                   zw_REG_OP = X"2E" or
                   zw_REG_OP = X"3E")) then 
               next_state <= G11_e;
            elsif (rdy_i = '1' and
                   (zw_REG_OP = X"66" or
                   zw_REG_OP = X"76" or
                   zw_REG_OP = X"6E" or
                   zw_REG_OP = X"7E")) then 
               next_state <= G11_e;
            elsif (rdy_i = '1' and
                   zw_REG_OP (7) = '0' and
                   zw_REG_OP (3 downto 0) = X"7") then 
               next_state <= G11_e;
            elsif (rdy_i = '1' and
                   zw_REG_OP (7) = '1' and
                   zw_REG_OP (3 downto 0) = X"7") then 
               next_state <= G11_e;
            elsif (rdy_i = '1' and
                   (zw_REG_OP = X"14" or
                   zw_REG_OP = X"1C")) then 
               next_state <= G11_e;
            elsif (rdy_i = '1' and
                   (zw_REG_OP = X"04" or
                   zw_REG_OP = X"0C")) then 
               next_state <= G11_e;
            else
               next_state <= G11_4;
            end if;
         when G11_e => 
            if (zw_REG_OP (3 downto 0) = X"7") then 
               next_state <= FETCH;
            elsif ((zw_REG_OP = X"14" or
                   zw_REG_OP = X"04" or
                   zw_REG_OP = X"0C" or
                   zw_REG_OP = X"1C")) then 
               next_state <= FETCH;
            else
               next_state <= FETCH;
            end if;
         when G31_1 => 
            if (rdy_i = '1') then 
               next_state <= FETCH;
            else
               next_state <= G31_1;
            end if;
         when G34_1 => 
            if (rdy_i = '1') then 
               next_state <= FETCH;
            else
               next_state <= G34_1;
            end if;
         when G32_1 => 
            if (rdy_i = '1') then 
               next_state <= FETCH;
            else
               next_state <= G32_1;
            end if;
         when G33_1 => 
            if (rdy_i = '1') then 
               next_state <= FETCH;
            else
               next_state <= G33_1;
            end if;
         when G12_1 => 
            if (rdy_i = '1' and (
                (reg_F(0) = '1' and zw_REG_OP = X"90") or (reg_F(0) = '0' and zw_REG_OP = X"B0") or
                (reg_F(1) = '0' and zw_REG_OP = X"F0") or (reg_F(7) = '0' and zw_REG_OP = X"30") or
                (reg_F(1) = '1' and zw_REG_OP = X"D0") or (reg_F(7) = '1' and zw_REG_OP = X"10") or
                (reg_F(6) = '1' and zw_REG_OP = X"50") or (reg_F(6) = '0' and zw_REG_OP = X"70"))) then 
               next_state <= FETCH;
            elsif (rdy_i = '1' and (
                   zw_REG_OP = X"8F" or
                   zw_REG_OP = X"9F" or
                   zw_REG_OP = X"AF" or
                   zw_REG_OP = X"BF" or
                   zw_REG_OP = X"CF" or
                   zw_REG_OP = X"DF" or
                   zw_REG_OP = X"EF" or
                   zw_REG_OP = X"FF" or
                   zw_REG_OP = X"0F" or
                   zw_REG_OP = X"1F" or
                   zw_REG_OP = X"2F" or
                   zw_REG_OP = X"3F" or
                   zw_REG_OP = X"4F" or
                   zw_REG_OP = X"5F" or
                   zw_REG_OP = X"6F" or
                   zw_REG_OP = X"7F")) then 
               next_state <= G12_2;
            elsif (rdy_i = '1') then 
               next_state <= G12_e1;
            else
               next_state <= G12_1;
            end if;
         when G12_e1 => 
            if (rdy_i = '1' and
                zw_b3 = adr_nxt_pc_i (15 downto 8)) then 
               next_state <= FETCH;
            elsif (rdy_i = '1') then 
               next_state <= G12_e2;
            else
               next_state <= G12_e1;
            end if;
         when G12_e2 => 
            if (rdy_i = '1') then 
               next_state <= FETCH;
            else
               next_state <= G12_e2;
            end if;
         when G12_2 => 
            if (rdy_i = '1') then 
               next_state <= G12_3;
            else
               next_state <= G12_2;
            end if;
         when G12_3 => 
            if (rdy_i = '1' and (
                (d_i(0) = '1' and zw_REG_OP = X"8F") or
                (d_i(1) = '1' and zw_REG_OP = X"9F") or
                (d_i(2) = '1' and zw_REG_OP = X"AF") or
                (d_i(3) = '1' and zw_REG_OP = X"BF") or
                (d_i(4) = '1' and zw_REG_OP = X"CF") or
                (d_i(5) = '1' and zw_REG_OP = X"DF") or
                (d_i(6) = '1' and zw_REG_OP = X"EF") or
                (d_i(7) = '1' and zw_REG_OP = X"FF") or
                (d_i(0) = '0' and zw_REG_OP = X"0F") or
                (d_i(1) = '0' and zw_REG_OP = X"1F") or
                (d_i(2) = '0' and zw_REG_OP = X"2F") or
                (d_i(3) = '0' and zw_REG_OP = X"3F") or
                (d_i(4) = '0' and zw_REG_OP = X"4F") or
                (d_i(5) = '0' and zw_REG_OP = X"5F") or
                (d_i(6) = '0' and zw_REG_OP = X"6F") or
                (d_i(7) = '0' and zw_REG_OP = X"7F"))) then 
               next_state <= G12_4;
            elsif (rdy_i = '1') then 
               next_state <= G12_e2;
            else
               next_state <= G12_3;
            end if;
         when G12_4 => 
            if (rdy_i = '1') then 
               next_state <= G12_e1;
            else
               next_state <= G12_4;
            end if;
         when G20_1 => 
            if (rdy_i = '1' and
                zw_REG_OP = X"4C") then 
               next_state <= G20_e;
            elsif (rdy_i = '1' and
                   zw_REG_OP = X"6C") then 
               next_state <= G20_2;
            elsif (rdy_i = '1' and
                   zw_REG_OP = X"7C") then 
               next_state <= G20_3;
            else
               next_state <= G20_1;
            end if;
         when G20_2 => 
            if (rdy_i = '1') then 
               next_state <= G20_4;
            else
               next_state <= G20_2;
            end if;
         when G20_5 => 
            if (rdy_i = '1') then 
               next_state <= G20_e;
            else
               next_state <= G20_5;
            end if;
         when G20_e => 
            if (rdy_i = '1') then 
               next_state <= FETCH;
            else
               next_state <= G20_e;
            end if;
         when G20_3 => 
            if (rdy_i = '1') then 
               next_state <= G20_4;
            else
               next_state <= G20_3;
            end if;
         when G20_4 => 
            if (rdy_i = '1') then 
               next_state <= G20_5;
            else
               next_state <= G20_4;
            end if;
         when G21_1 => 
            if (rdy_i = '1') then 
               next_state <= G21_2;
            else
               next_state <= G21_1;
            end if;
         when G21_2 => 
            if (rdy_i = '1') then 
               next_state <= G21_3;
            else
               next_state <= G21_2;
            end if;
         when G21_3 => 
            next_state <= G21_4;
         when G21_4 => 
            next_state <= G21_e;
         when G21_e => 
            if (rdy_i = '1') then 
               next_state <= FETCH;
            else
               next_state <= G21_e;
            end if;
         when G13_3 => 
            if (rdy_i = '1') then 
               next_state <= G13_e1;
            else
               next_state <= G13_3;
            end if;
         when G13_1 => 
            if (rdy_i = '1' and
                zw_REG_OP = X"34") then 
               next_state <= G13_2;
            elsif (rdy_i = '1' and
                   zw_REG_OP = X"3C") then 
               next_state <= G13_4;
            elsif (rdy_i = '1' and
                   zw_REG_OP = X"24") then 
               next_state <= G13_e1;
            elsif (rdy_i = '1' and
                   zw_REG_OP = X"2C") then 
               next_state <= G13_3;
            elsif (rdy_i = '1' and
                   zw_REG_OP = X"89") then 
               next_state <= FETCH;
            else
               next_state <= G13_1;
            end if;
         when G13_4 => 
            if (rdy_i = '1') then 
               next_state <= G13_e2;
            else
               next_state <= G13_4;
            end if;
         when G13_2 => 
            if (rdy_i = '1') then 
               next_state <= G13_e1;
            else
               next_state <= G13_2;
            end if;
         when G13_e1 => 
            if (rdy_i = '1') then 
               next_state <= FETCH;
            else
               next_state <= G13_e1;
            end if;
         when G13_e2 => 
            if (rdy_i = '1' AND
                zw_b2(0) = '0') then 
               next_state <= FETCH;
            elsif (rdy_i = '1') then 
               next_state <= G13_e1;
            else
               next_state <= G13_e2;
            end if;
         when G18_1 => 
            if (rdy_i = '1') then 
               next_state <= G18_2;
            else
               next_state <= G18_1;
            end if;
         when G18_2 => 
            next_state <= G18_3;
         when G18_3 => 
            next_state <= G18_4;
         when G18_4 => 
            next_state <= G18_5;
         when G18_e => 
            if (rdy_i = '1') then 
               next_state <= FETCH;
            else
               next_state <= G18_e;
            end if;
         when G18_5 => 
            if (rdy_i = '1') then 
               next_state <= G18_e;
            else
               next_state <= G18_5;
            end if;
         when G26_1 => 
            if (rdy_i = '1') then 
               next_state <= G26_2;
            else
               next_state <= G26_1;
            end if;
         when G26_2 => 
            if (rdy_i = '1') then 
               next_state <= G26_3;
            else
               next_state <= G26_2;
            end if;
         when G26_3 => 
            if (rdy_i = '1') then 
               next_state <= G26_4;
            else
               next_state <= G26_3;
            end if;
         when G26_4 => 
            if (rdy_i = '1') then 
               next_state <= G26_e;
            else
               next_state <= G26_4;
            end if;
         when G26_e => 
            if (rdy_i = '1') then 
               next_state <= FETCH;
            else
               next_state <= G26_e;
            end if;
         when G27_1 => 
            if (rdy_i = '1') then 
               next_state <= G27_2;
            else
               next_state <= G27_1;
            end if;
         when G27_2 => 
            if (rdy_i = '1') then 
               next_state <= G27_3;
            else
               next_state <= G27_2;
            end if;
         when G27_3 => 
            if (rdy_i = '1') then 
               next_state <= G27_4;
            else
               next_state <= G27_3;
            end if;
         when G27_4 => 
            if (rdy_i = '1') then 
               next_state <= G27_e;
            else
               next_state <= G27_4;
            end if;
         when G27_e => 
            if (rdy_i = '1') then 
               next_state <= FETCH;
            else
               next_state <= G27_e;
            end if;
         when G14_1 => 
            if (rdy_i = '1' and
                (zw_REG_OP = X"C6" OR
                zw_REG_OP = X"E6")) then 
               next_state <= G14_3;
            elsif (rdy_i = '1' and
                   (zw_REG_OP = X"D6" OR
                   zw_REG_OP = X"F6")) then 
               next_state <= G14_2;
            elsif (rdy_i = '1' and
                   (zw_REG_OP = X"CE" OR
                   zw_REG_OP = X"EE")) then 
               next_state <= G14_5;
            elsif (rdy_i = '1' and
                   (zw_REG_OP = X"DE" OR
                   zw_REG_OP = X"FE")) then 
               next_state <= G14_6;
            else
               next_state <= G14_1;
            end if;
         when G14_5 => 
            if (rdy_i = '1') then 
               next_state <= G14_3;
            else
               next_state <= G14_5;
            end if;
         when G14_6 => 
            if (rdy_i = '1') then 
               next_state <= G14_7;
            else
               next_state <= G14_6;
            end if;
         when G14_2 => 
            if (rdy_i = '1') then 
               next_state <= G14_3;
            else
               next_state <= G14_2;
            end if;
         when G14_7 => 
            if (rdy_i = '1') then 
               next_state <= G14_3;
            else
               next_state <= G14_7;
            end if;
         when G14_3 => 
            if (rdy_i = '1') then 
               next_state <= G14_4;
            else
               next_state <= G14_3;
            end if;
         when G14_4 => 
            if (rdy_i = '1') then 
               next_state <= G14_e;
            else
               next_state <= G14_4;
            end if;
         when G14_e => 
            next_state <= FETCH;
         when G22_1 => 
            if (rdy_i = '1') then 
               next_state <= G22_e;
            else
               next_state <= G22_1;
            end if;
         when G22_e => 
            next_state <= FETCH;
         when G23_1 => 
            if (rdy_i = '1') then 
               next_state <= G23_e;
            else
               next_state <= G23_1;
            end if;
         when G23_e => 
            next_state <= FETCH;
         when G24_1 => 
            if (rdy_i = '1') then 
               next_state <= G24_2;
            else
               next_state <= G24_1;
            end if;
         when G24_2 => 
            if (rdy_i = '1') then 
               next_state <= G24_e;
            else
               next_state <= G24_2;
            end if;
         when G24_e => 
            if (rdy_i = '1') then 
               next_state <= FETCH;
            else
               next_state <= G24_e;
            end if;
         when G25_1 => 
            if (rdy_i = '1') then 
               next_state <= G25_2;
            else
               next_state <= G25_1;
            end if;
         when G25_2 => 
            if (rdy_i = '1') then 
               next_state <= G25_e;
            else
               next_state <= G25_2;
            end if;
         when G25_e => 
            if (rdy_i = '1') then 
               next_state <= FETCH;
            else
               next_state <= G25_e;
            end if;
         when others =>
            next_state <= RES;
      end case;
   end process nextstate_proc;
 
   -----------------------------------------------------------------
   output_proc : process ( 
      adr_nxt_pc_i,
      adr_pc_i,
      adr_sp_i,
      alu_dec_val_i,
      current_state,
      d_alu_i,
      d_i,
      d_regs_out_i,
      irq_n_i,
      q_a_i,
      q_x_i,
      q_y_i,
      rdy_i,
      reg_F,
      reg_sel_pc_in,
      reg_sel_pc_val,
      reg_sel_rb_in,
      reg_sel_rb_out,
      reg_sel_reg,
      reg_sel_sp_as,
      reg_sel_sp_in,
      sig_PC,
      zw_ALU,
      zw_ALU1,
      zw_ALU2,
      zw_ALU3,
      zw_ALU4,
      zw_ALU5,
      zw_ALU6,
      zw_REG_NMI,
      zw_REG_OP,
      zw_b1,
      zw_b2,
      zw_b3,
      zw_b4,
      zw_w1
   )
   -----------------------------------------------------------------
   begin
      -- Default Assignment
      a_o <= sig_PC;
      adr_o <= X"0000";
      ch_a_o <= X"00";
      ch_b_o <= X"00";
      d_regs_in_o <= X"00";
      fetch_o <= '0';
      ld_o <= "00";
      ld_pc_o <= '0';
      ld_sp_o <= '0';
      load_regs_o <= '0';
      offset_o <= X"0000";
      sel_pc_in_o <= reg_sel_pc_in;
      sel_pc_val_o <= reg_sel_pc_val;
      sel_rb_in_o <= reg_sel_rb_in;
      sel_rb_out_o <= reg_sel_rb_out;
      sel_reg_o <= reg_sel_reg;
      sel_sp_as_o <= reg_sel_sp_as;
      sel_sp_in_o <= reg_sel_sp_in;
      -- Default Assignment To Internals
      sig_D_OUT <= X"00";
      sig_SYNC <= '0';
      sig_WR <= '0';
      zw_ALU <= '0' & X"00";
      zw_ALU1 <= '0' & X"0";
      zw_ALU2 <= '0' & X"0";
      zw_ALU3 <= '0' & X"0";
      zw_ALU4 <= '0' & X"0";
      zw_ALU5 <= X"0";
      zw_ALU6 <= X"0";

      -- Combined Actions
      case current_state is
         when G30_1 => 
            ld_o <= "11";
            ld_sp_o <= '1';
         when G30_3 => 
            adr_o <= X"FFFB";
            ld_o <= "11";
            ld_pc_o <= '1';
         when G30_4 => 
            ld_o <= "11";
            ld_pc_o <= '1';
         when G30_e => 
            if (rdy_i = '1') then 
               adr_o <= d_i & zw_w1 (7 downto 0);
               ld_o <= "11";
               ld_pc_o <= '1';
               sig_SYNC <= '1';
               fetch_o <= '1';
            end if;
         when G30_2 => 
            ld_o <= "11";
            ld_sp_o <= '1';
         when RES => 
            ld_o <= "11";
            ld_pc_o <= '1';
            ld_sp_o <= '1';
         when G28_1 => 
            if (rdy_i = '1') then 
               ld_o <= "11";
               ld_sp_o <= '1';
               ld_pc_o <= '1';
               sig_WR <= '1';
               sig_D_OUT <= adr_pc_i (15 downto 8);
            end if;
         when G28_2 => 
            ld_o <= "11";
            ld_sp_o <= '1';
            sig_WR <= '1';
            sig_D_OUT <= adr_pc_i (7 downto 0);
         when G28_3 => 
            ld_o <= "11";
            ld_sp_o <= '1';
            sig_WR <= '1';
            sig_D_OUT <= reg_F;
         when G28_e => 
            if (rdy_i = '1') then 
               sig_SYNC <= '1';
               fetch_o <= '1';
            end if;
         when G29_1 => 
            if (rdy_i = '1') then 
               ld_o <= "11";
               ld_sp_o <= '1';
               ld_pc_o <= '1';
               sig_WR <= '1';
               sig_D_OUT <= adr_pc_i (15 downto 8);
            end if;
         when G29_2 => 
            ld_o <= "11";
            ld_sp_o <= '1';
            sig_WR <= '1';
            sig_D_OUT <= adr_pc_i (7 downto 0);
         when G29_3 => 
            ld_o <= "11";
            ld_sp_o <= '1';
            sig_WR <= '1';
            sig_D_OUT <= reg_F;
         when G29_e => 
            if (rdy_i = '1') then 
               adr_o <= d_i & zw_b1;
               ld_o <= "11";
               ld_pc_o <= '1';
               sig_SYNC <= '1';
               fetch_o <= '1';
            end if;
         when FETCH => 
            sig_SYNC <= NOT (rdy_i);
            if ((zw_REG_NMI = '1') and (rdy_i = '1')) then 
               ld_o <= "11";
               ld_pc_o <= '1';
            elsif ((irq_n_i = '0' and
                   reg_F(2) = '0') and (rdy_i = '1')) then 
               ld_o <= "11";
               ld_pc_o <= '1';
            elsif ((d_i = X"69" or
                   d_i = X"65" or
                   d_i = X"75" or
                   d_i = X"6D" or
                   d_i = X"7D" or
                   d_i = X"79" or
                   d_i = X"61" or
                   d_i = X"71" or
                   d_i = X"72") and (rdy_i = '1')) then 
               ld_o <= "11";
               ld_pc_o <= '1';
            elsif ((d_i = X"06" or
                   d_i = X"16" or
                   d_i = X"0E" or
                   d_i = X"1E" or
                   d_i (3 downto 0) = X"7" or
                   d_i = X"14" or
                   d_i = X"04" or
                   d_i = X"0C" or
                   d_i = X"1C") and (rdy_i = '1')) then 
               ld_o <= "11";
               ld_pc_o <= '1';
            elsif ((d_i = X"90" or
                   d_i = X"B0" or
                   d_i = X"F0" or
                   d_i = X"30" or
                   d_i = X"D0" or
                   d_i = X"10" or
                   d_i = X"50" or
                   d_i = X"70" or
                   d_i = X"80" or
                   d_i (3 downto 0) = X"F") and (rdy_i = '1')) then 
               ld_o <= "11";
               ld_pc_o <= '1';
            elsif ((d_i = X"24" or
                   d_i = X"2C" or
                   d_i = X"3C" or
                   d_i = X"34" or
                   d_i = X"89") and (rdy_i = '1')) then 
               ld_o <= "11";
               ld_pc_o <= '1';
            elsif ((d_i = X"00") and (rdy_i = '1')) then 
               ld_o <= "11";
               ld_pc_o <= '1';
            elsif ((d_i = X"18") and (rdy_i = '1')) then 
               ld_o <= "11";
               ld_pc_o <= '1';
            elsif ((d_i = X"D8") and (rdy_i = '1')) then 
               ld_o <= "11";
               ld_pc_o <= '1';
            elsif ((d_i = X"58") and (rdy_i = '1')) then 
               ld_o <= "11";
               ld_pc_o <= '1';
            elsif ((d_i = X"B8") and (rdy_i = '1')) then 
               ld_o <= "11";
               ld_pc_o <= '1';
            elsif ((d_i = X"E0" or
                   d_i = X"E4" or
                   d_i = X"EC") and (rdy_i = '1')) then 
               ld_o <= "11";
               ld_pc_o <= '1';
            elsif ((d_i = X"C0" or
                   d_i = X"C4" or
                   d_i = X"CC") and (rdy_i = '1')) then 
               ld_o <= "11";
               ld_pc_o <= '1';
            elsif ((d_i = X"C6" or
                   d_i = X"D6" or
                   d_i = X"CE" or
                   d_i = X"DE") and (rdy_i = '1')) then 
               ld_o <= "11";
               ld_pc_o <= '1';
            elsif ((d_i = X"CA") and (rdy_i = '1')) then 
               ld_o <= "11";
               ld_pc_o <= '1';
            elsif ((d_i = X"88") and (rdy_i = '1')) then 
               ld_o <= "11";
               ld_pc_o <= '1';
            elsif ((d_i = X"49" or
                   d_i = X"45" or
                   d_i = X"55" or
                   d_i = X"4D" or
                   d_i = X"5D" or
                   d_i = X"59" or
                   d_i = X"41" or
                   d_i = X"51" or
                   d_i = X"09" or
                   d_i = X"05" or
                   d_i = X"15" or
                   d_i = X"0D" or
                   d_i = X"1D" or
                   d_i = X"19" or
                   d_i = X"01" or
                   d_i = X"11" or
                   d_i = X"29" or
                   d_i = X"25" or
                   d_i = X"35" or
                   d_i = X"2D" or
                   d_i = X"3D" or
                   d_i = X"39" or
                   d_i = X"21" or
                   d_i = X"31" or
                   d_i = X"C9" or
                   d_i = X"C5" or
                   d_i = X"D5" or
                   d_i = X"CD" or
                   d_i = X"DD" or
                   d_i = X"D9" or
                   d_i = X"C1" or
                   d_i = X"D1" or
                   d_i = X"32" or
                   d_i = X"D2" or
                   d_i = X"52" or
                   d_i = X"12") and (rdy_i = '1')) then 
               ld_o <= "11";
               ld_pc_o <= '1';
            elsif ((d_i = X"E6" or
                   d_i = X"F6" or
                   d_i = X"EE" or
                   d_i = X"FE") and (rdy_i = '1')) then 
               ld_o <= "11";
               ld_pc_o <= '1';
            elsif ((d_i = X"E8") and (rdy_i = '1')) then 
               ld_o <= "11";
               ld_pc_o <= '1';
            elsif ((d_i = X"C8") and (rdy_i = '1')) then 
               ld_o <= "11";
               ld_pc_o <= '1';
            elsif ((d_i = X"4C" or
                   d_i = X"6C" or
                   d_i = X"7C") and (rdy_i = '1')) then 
               ld_o <= "11";
               ld_pc_o <= '1';
            elsif ((d_i = X"20") and (rdy_i = '1')) then 
               ld_o <= "11";
               ld_pc_o <= '1';
            elsif ((d_i = X"A9" or
                   d_i = X"A5" or
                   d_i = X"B5" or
                   d_i = X"AD" or
                   d_i = X"BD" or
                   d_i = X"B9" or
                   d_i = X"A1" or
                   d_i = X"B1" or
                   d_i = X"B2") and (rdy_i = '1')) then 
               ld_o <= "11";
               ld_pc_o <= '1';
            elsif ((d_i = X"A2" or
                   d_i = X"A6" or
                   d_i = X"B6" or
                   d_i = X"AE" or
                   d_i = X"BE") and (rdy_i = '1')) then 
               ld_o <= "11";
               ld_pc_o <= '1';
            elsif ((d_i = X"A0" or
                   d_i = X"A4" or
                   d_i = X"B4" or
                   d_i = X"AC" or
                   d_i = X"BC") and (rdy_i = '1')) then 
               ld_o <= "11";
               ld_pc_o <= '1';
            elsif ((d_i = X"46" or
                   d_i = X"56" or
                   d_i = X"4E" or
                   d_i = X"5E") and (rdy_i = '1')) then 
               ld_o <= "11";
               ld_pc_o <= '1';
            elsif ((d_i = X"EA") and (rdy_i = '1')) then 
               ld_o <= "11";
               ld_pc_o <= '1';
            elsif ((d_i = X"48") and (rdy_i = '1')) then 
               ld_o <= "11";
               ld_pc_o <= '1';
            elsif ((d_i = X"08") and (rdy_i = '1')) then 
               ld_o <= "11";
               ld_pc_o <= '1';
            elsif ((d_i = X"7A") and (rdy_i = '1')) then 
               ld_o <= "11";
               ld_pc_o <= '1';
            elsif ((d_i = X"28") and (rdy_i = '1')) then 
               ld_o <= "11";
               ld_pc_o <= '1';
            elsif ((d_i = X"26" or
                   d_i = X"36" or
                   d_i = X"2E" or
                   d_i = X"3E") and (rdy_i = '1')) then 
               ld_o <= "11";
               ld_pc_o <= '1';
            elsif ((d_i = X"66" or
                   d_i = X"76" or
                   d_i = X"6E" or
                   d_i = X"7E") and (rdy_i = '1')) then 
               ld_o <= "11";
               ld_pc_o <= '1';
            elsif ((d_i = X"40") and (rdy_i = '1')) then 
               ld_o <= "11";
               ld_pc_o <= '1';
            elsif ((d_i = X"60") and (rdy_i = '1')) then 
               ld_o <= "11";
               ld_pc_o <= '1';
            elsif ((d_i = X"E9" or
                   d_i = X"E5" or
                   d_i = X"F5" or
                   d_i = X"ED" or
                   d_i = X"FD" or
                   d_i = X"F9" or
                   d_i = X"E1" or
                   d_i = X"F1" or
                   d_i = X"F2") and (rdy_i = '1')) then 
               ld_o <= "11";
               ld_pc_o <= '1';
            elsif ((d_i = X"38") and (rdy_i = '1')) then 
               ld_o <= "11";
               ld_pc_o <= '1';
            elsif ((d_i = X"F8") and (rdy_i = '1')) then 
               ld_o <= "11";
               ld_pc_o <= '1';
            elsif ((d_i = X"78") and (rdy_i = '1')) then 
               ld_o <= "11";
               ld_pc_o <= '1';
            elsif ((d_i = X"85" or
                   d_i = X"95" or
                   d_i = X"8D" or
                   d_i = X"9D" or
                   d_i = X"99" or
                   d_i = X"81" or
                   d_i = X"91") and (rdy_i = '1')) then 
               ld_o <= "11";
               ld_pc_o <= '1';
            elsif ((d_i = X"86" or
                   d_i = X"96" or
                   d_i = X"8E") and (rdy_i = '1')) then 
               ld_o <= "11";
               ld_pc_o <= '1';
            elsif ((d_i = X"84" or
                   d_i = X"94" or
                   d_i = X"8C") and (rdy_i = '1')) then 
               ld_o <= "11";
               ld_pc_o <= '1';
            elsif ((d_i = X"AA") and (rdy_i = '1')) then 
               
               ld_o <= "11";
               ld_pc_o <= '1';
            elsif ((d_i = X"0A") and (rdy_i = '1')) then 
               ld_o <= "11";
               ld_pc_o <= '1';
            elsif ((d_i = X"4A") and (rdy_i = '1')) then 
               ld_o <= "11";
               ld_pc_o <= '1';
            elsif ((d_i = X"2A") and (rdy_i = '1')) then 
               ld_o <= "11";
               ld_pc_o <= '1';
            elsif ((d_i = X"6A") and (rdy_i = '1')) then 
               ld_o <= "11";
               ld_pc_o <= '1';
            elsif ((d_i = X"A8") and (rdy_i = '1')) then 
               
               ld_o <= "11";
               ld_pc_o <= '1';
            elsif ((d_i = X"98") and (rdy_i = '1')) then 
               
               ld_o <= "11";
               ld_pc_o <= '1';
            elsif ((d_i = X"BA") and (rdy_i = '1')) then 
               
               ld_o <= "11";
               ld_pc_o <= '1';
            elsif ((d_i = X"8A") and (rdy_i = '1')) then 
               
               ld_o <= "11";
               ld_pc_o <= '1';
            elsif ((d_i = X"9A") and (rdy_i = '1')) then 
               
               ld_o <= "11";
               ld_pc_o <= '1';
            elsif ((d_i = X"DA") and (rdy_i = '1')) then 
               ld_o <= "11";
               ld_pc_o <= '1';
            elsif ((d_i = X"5A") and (rdy_i = '1')) then 
               ld_o <= "11";
               ld_pc_o <= '1';
            elsif ((d_i = X"68") and (rdy_i = '1')) then 
               ld_o <= "11";
               ld_pc_o <= '1';
            elsif ((d_i = X"FA") and (rdy_i = '1')) then 
               ld_o <= "11";
               ld_pc_o <= '1';
            elsif ((d_i = X"9C" or
                   d_i = X"9E" or
                   d_i = X"64" or
                   d_i = X"74") and (rdy_i = '1')) then 
               ld_o <= "11";
               ld_pc_o <= '1';
            elsif ((d_i = X"3A") and (rdy_i = '1')) then 
               ld_o <= "11";
               ld_pc_o <= '1';
            elsif ((d_i = X"1A") and (rdy_i = '1')) then 
               ld_o <= "11";
               ld_pc_o <= '1';
            elsif (rdy_i = '1') then 
               ld_o <= "11";
               ld_pc_o <= '1';
            end if;
         when G1_1 => 
            if (rdy_i = '1') then 
               sig_SYNC <= '1';
               fetch_o <= '1';
            end if;
         when G2_1 => 
            if (rdy_i = '1') then 
               sig_SYNC <= '1';
               fetch_o <= '1';
            end if;
         when G3_1 => 
            if (rdy_i = '1') then 
               sig_SYNC <= '1';
               fetch_o <= '1';
            end if;
         when G4_1 => 
            if (rdy_i = '1') then 
               sig_SYNC <= '1';
               fetch_o <= '1';
            end if;
         when G9_1 => 
            if (rdy_i = '1' and
                zw_REG_OP = X"9A") then 
               adr_o <= X"01" & d_regs_out_i;
               ld_o <= "11";
               ld_sp_o <= '1';
               sig_SYNC <= '1';
               fetch_o <= '1';
            elsif (rdy_i = '1' and
                   zw_REG_OP = X"BA") then 
               d_regs_in_o <= adr_sp_i (7 downto 0);
               ch_a_o <= adr_sp_i (7 downto 0);
               ch_b_o <= X"00";
               load_regs_o <= '1';
               sig_SYNC <= '1';
               fetch_o <= '1';
            elsif (rdy_i = '1') then 
               ch_a_o <= d_regs_out_i;
               ch_b_o <= X"00";
               load_regs_o <= '1';
               sig_SYNC <= '1';
               fetch_o <= '1';
            end if;
         when G5_1 => 
            if (rdy_i = '1') then 
               sig_SYNC <= '1';
               fetch_o <= '1';
            end if;
         when G6_1 => 
            if (rdy_i = '1') then 
               sig_SYNC <= '1';
               fetch_o <= '1';
            end if;
         when G7_1 => 
            if (rdy_i = '1') then 
               sig_SYNC <= '1';
               fetch_o <= '1';
            end if;
         when G8_1 => 
            if (rdy_i = '1') then 
               sig_SYNC <= '1';
               fetch_o <= '1';
            end if;
         when G19_1 => 
            if (rdy_i = '1') then 
               d_regs_in_o <= d_alu_i;
               ch_a_o <= d_regs_out_i;
               ch_b_o <= zw_b4;
               load_regs_o <= '1';
               sig_SYNC <= '1';
               fetch_o <= '1';
            end if;
         when G15_1 => 
            if (rdy_i = '1' and
                (zw_REG_OP = X"A5" OR zw_REG_OP = X"A6" OR
                zw_REG_OP = X"A4" OR zw_REG_OP = X"45" OR
                zw_REG_OP = X"05" OR zw_REG_OP = X"25" OR
                zw_REG_OP = X"C5" OR zw_REG_OP = X"E4" OR zw_REG_OP = X"C4")) then 
               ld_o <= "11";
               ld_pc_o <= '1';
            elsif ((rdy_i = '1' and
                   (zw_REG_OP = X"A9" OR zw_REG_OP = X"A2" OR zw_REG_OP = X"A0" OR zw_REG_OP = X"E0" OR zw_REG_OP = X"C0" OR
                   zw_REG_OP = X"49" or zw_REG_OP = X"09" or zw_REG_OP = X"29" or zw_REG_OP = X"C9")) and (zw_REG_OP = X"09" or zw_REG_OP = X"05" or
                   zw_REG_OP = X"15" or zw_REG_OP = X"0D" or
                   zw_REG_OP = X"1D" or zw_REG_OP = X"19" or 
                   zw_REG_OP = X"01" or zw_REG_OP = X"11" or
                   zw_REG_OP = X"12")) then 
               ld_o <= "11";
               ld_pc_o <= '1';
               d_regs_in_o <= d_i OR q_a_i;
               load_regs_o <= '1';
               ch_a_o <= d_i OR q_a_i;
               ch_b_o <= X"00";
               sig_SYNC <= '1';
               fetch_o <= '1';
            elsif ((rdy_i = '1' and
                   (zw_REG_OP = X"A9" OR zw_REG_OP = X"A2" OR zw_REG_OP = X"A0" OR zw_REG_OP = X"E0" OR zw_REG_OP = X"C0" OR
                   zw_REG_OP = X"49" or zw_REG_OP = X"09" or zw_REG_OP = X"29" or zw_REG_OP = X"C9")) and (zw_REG_OP = X"49" or zw_REG_OP = X"45" or
                   zw_REG_OP = X"55" or zw_REG_OP = X"4D" or
                   zw_REG_OP = X"5D" or zw_REG_OP = X"59" or
                   zw_REG_OP = X"41" or zw_REG_OP = X"51" or
                   zw_REG_OP = X"52")) then 
               ld_o <= "11";
               ld_pc_o <= '1';
               d_regs_in_o <= d_i XOR q_a_i;
               load_regs_o <= '1';
               ch_a_o <= d_i XOR q_a_i;
               ch_b_o <= X"00";
               sig_SYNC <= '1';
               fetch_o <= '1';
            elsif ((rdy_i = '1' and
                   (zw_REG_OP = X"A9" OR zw_REG_OP = X"A2" OR zw_REG_OP = X"A0" OR zw_REG_OP = X"E0" OR zw_REG_OP = X"C0" OR
                   zw_REG_OP = X"49" or zw_REG_OP = X"09" or zw_REG_OP = X"29" or zw_REG_OP = X"C9")) and (zw_REG_OP = X"29" or zw_REG_OP = X"25" or
                   zw_REG_OP = X"35" or zw_REG_OP = X"2D" or
                   zw_REG_OP = X"3D" or zw_REG_OP = X"39" or
                   zw_REG_OP = X"21" or zw_REG_OP = X"31" or
                   zw_REG_OP = X"32" or zw_REG_OP = X"D2")) then 
               ld_o <= "11";
               ld_pc_o <= '1';
               d_regs_in_o <= d_i AND q_a_i;
               load_regs_o <= '1';
               ch_a_o <= d_i AND q_a_i;
               ch_b_o <= X"00";
               sig_SYNC <= '1';
               fetch_o <= '1';
            elsif ((rdy_i = '1' and
                   (zw_REG_OP = X"A9" OR zw_REG_OP = X"A2" OR zw_REG_OP = X"A0" OR zw_REG_OP = X"E0" OR zw_REG_OP = X"C0" OR
                   zw_REG_OP = X"49" or zw_REG_OP = X"09" or zw_REG_OP = X"29" or zw_REG_OP = X"C9")) and (zw_REG_OP = X"C9" or zw_REG_OP = X"C5" or
                   zw_REG_OP = X"D5" or zw_REG_OP = X"CD" or
                   zw_REG_OP = X"DD" or zw_REG_OP = X"D9" or
                   zw_REG_OP = X"C1" or zw_REG_OP = X"D1" or
                    zw_REG_OP = X"C0" or zw_REG_OP = X"E0" or
                    zw_REG_OP = X"C4" or zw_REG_OP = X"E4" or
                    zw_REG_OP = X"CC" or zw_REG_OP = X"EC")) then 
               ld_o <= "11";
               ld_pc_o <= '1';
               zw_ALU <= unsigned ('0' & d_regs_out_i) + unsigned ('0' & NOT (d_i)) + 1;
               sig_SYNC <= '1';
               fetch_o <= '1';
            elsif (rdy_i = '1' and
                   (zw_REG_OP = X"A9" OR zw_REG_OP = X"A2" OR zw_REG_OP = X"A0" OR zw_REG_OP = X"E0" OR zw_REG_OP = X"C0" OR
                   zw_REG_OP = X"49" or zw_REG_OP = X"09" or zw_REG_OP = X"29" or zw_REG_OP = X"C9")) then 
               ld_o <= "11";
               ld_pc_o <= '1';
               d_regs_in_o <= d_i;
               load_regs_o <= '1';
               ch_a_o <= d_i;
               ch_b_o <= X"00";
               sig_SYNC <= '1';
               fetch_o <= '1';
            elsif (rdy_i = '1' and
                   (zw_REG_OP = X"B5" OR
                   zw_REG_OP = X"B4" OR
                   zw_REG_OP = X"55" OR zw_REG_OP = X"15" OR
                   zw_REG_OP = X"35" OR
                   zw_REG_OP = X"D5")) then 
               ch_a_o <=  d_i;
               ch_b_o <= q_x_i;
            elsif (rdy_i = '1' and
                   (zw_REG_OP = X"AD" OR
                   zw_REG_OP = X"AE" OR
                   zw_REG_OP = X"AC" OR
                   zw_REG_OP = X"4D" OR
                   zw_REG_OP = X"0D" OR
                   zw_REG_OP = X"2D" OR
                   zw_REG_OP = X"CD" OR
                   zw_REG_OP = X"EC" OR
                   zw_REG_OP = X"CC")) then 
               ld_o <= "11";
               ld_pc_o <= '1';
            elsif (rdy_i = '1' and
                   (zw_REG_OP = X"BD" OR
                   zw_REG_OP = X"BC" OR
                   zw_REG_OP = X"5D" OR
                   zw_REG_OP = X"1D" OR
                   zw_REG_OP = X"3D" OR
                   zw_REG_OP = X"DD")) then 
               ld_o <= "11";
               ld_pc_o <= '1';
               ch_a_o <= d_i;
               ch_b_o <= q_x_i;
            elsif (rdy_i = '1' and
                   (zw_REG_OP = X"B9" OR
                   zw_REG_OP = X"BE" OR
                   zw_REG_OP = X"59" OR
                   zw_REG_OP = X"19" OR
                   zw_REG_OP = X"39" OR
                   zw_REG_OP = X"D9")) then 
               ld_o <= "11";
               ld_pc_o <= '1';
               ch_a_o <= d_i;
               ch_b_o <= q_y_i;
            elsif (rdy_i = '1' and
                   (zw_REG_OP = X"B1" OR
                   zw_REG_OP = X"51" OR
                   zw_REG_OP = X"11" OR
                   zw_REG_OP = X"31" OR
                   zw_REG_OP = X"D1")) then 
               ch_a_o <= d_i;
               ch_b_o <= X"01";
            elsif (rdy_i = '1' and
                   (zw_REG_OP = X"A1" OR
                   zw_REG_OP = X"41" OR
                   zw_REG_OP = X"01" OR
                   zw_REG_OP = X"21" OR
                   zw_REG_OP = X"C1")) then 
               ch_a_o <=  d_i;
               ch_b_o <= q_x_i;
            elsif (rdy_i = '1' and
                   zw_REG_OP = X"B6") then 
               ch_a_o <=  d_i;
               ch_b_o <= q_y_i;
            elsif (rdy_i = '1' and
                   (zw_REG_OP = X"32" OR
                   zw_REG_OP = X"D2" OR
                   zw_REG_OP = X"52" OR
                   zw_REG_OP = X"B2" OR
                   zw_REG_OP = X"12")) then 
               ch_a_o <= d_i;
               ch_b_o <= X"01";
            end if;
         when G15_3 => 
            if (rdy_i = '1') then 
               ld_o <= "11";
               ld_pc_o <= '1';
            end if;
         when G15_4 => 
            if (rdy_i = '1') then 
               ch_a_o <= d_i;
               ch_b_o <= "0000000" & zw_b2(0);
               ld_o <= "11";
               ld_pc_o <= '1';
            end if;
         when G15_5 => 
            if (rdy_i = '1') then 
               ch_a_o <= d_i;
               ch_b_o <= q_y_i;
            end if;
         when G15_2 => 
            if (rdy_i = '1') then 
               ld_o <= "11";
               ld_pc_o <= '1';
            end if;
         when G15_e3 => 
            if (rdy_i = '1') then 
               ch_a_o <=  zw_b1;
               ch_b_o <= X"01";
            end if;
         when G15_6 => 
            if (rdy_i = '1') then 
               ch_a_o <= d_i;
               ch_b_o <= "0000000" & zw_b2(0);
               ld_o <= "11";
               ld_pc_o <= '1';
            end if;
         when G15_e2 => 
            if ((rdy_i = '1') and (zw_REG_OP = X"09" or zw_REG_OP = X"05" or
                zw_REG_OP = X"15" or zw_REG_OP = X"0D" or
                zw_REG_OP = X"1D" or zw_REG_OP = X"19" or 
                zw_REG_OP = X"01" or zw_REG_OP = X"11" or
                zw_REG_OP = X"12")) then 
               d_regs_in_o <= d_i OR q_a_i;
               load_regs_o <= '1';
               ch_a_o <= d_i OR q_a_i;
               ch_b_o <= X"00";
               sig_SYNC <= '1';
               fetch_o <= '1';
            elsif ((rdy_i = '1') and (zw_REG_OP = X"49" or zw_REG_OP = X"45" or
                   zw_REG_OP = X"55" or zw_REG_OP = X"4D" or
                   zw_REG_OP = X"5D" or zw_REG_OP = X"59" or
                   zw_REG_OP = X"41" or zw_REG_OP = X"51" or
                   zw_REG_OP = X"52")) then 
               d_regs_in_o <= d_i XOR q_a_i;
               load_regs_o <= '1';
               ch_a_o <= d_i XOR q_a_i;
               ch_b_o <= X"00";
               sig_SYNC <= '1';
               fetch_o <= '1';
            elsif ((rdy_i = '1') and (zw_REG_OP = X"29" or zw_REG_OP = X"25" or
                   zw_REG_OP = X"35" or zw_REG_OP = X"2D" or
                   zw_REG_OP = X"3D" or zw_REG_OP = X"39" or
                   zw_REG_OP = X"21" or zw_REG_OP = X"31" or
                   zw_REG_OP = X"32" or zw_REG_OP = X"D2")) then 
               d_regs_in_o <= d_i AND q_a_i;
               load_regs_o <= '1';
               ch_a_o <= d_i AND q_a_i;
               ch_b_o <= X"00";
               sig_SYNC <= '1';
               fetch_o <= '1';
            elsif ((rdy_i = '1') and (zw_REG_OP = X"C9" or zw_REG_OP = X"C5" or
                   zw_REG_OP = X"D5" or zw_REG_OP = X"CD" or
                   zw_REG_OP = X"DD" or zw_REG_OP = X"D9" or
                   zw_REG_OP = X"C1" or zw_REG_OP = X"D1" or
                    zw_REG_OP = X"C0" or zw_REG_OP = X"E0" or
                    zw_REG_OP = X"C4" or zw_REG_OP = X"E4" or
                    zw_REG_OP = X"CC" or zw_REG_OP = X"EC")) then 
               zw_ALU <= unsigned ('0' & d_regs_out_i) + unsigned ('0' & NOT (d_i)) + 1;
               sig_SYNC <= '1';
               fetch_o <= '1';
            elsif (rdy_i = '1') then 
               d_regs_in_o <= d_i;
               load_regs_o <= '1';
               ch_a_o <= d_i;
               ch_b_o <= X"00";
               sig_SYNC <= '1';
               fetch_o <= '1';
            end if;
         when G15_e1 => 
            if ((rdy_i = '1' AND
                zw_b2(0) = '0') and (zw_REG_OP = X"09" or zw_REG_OP = X"05" or
                zw_REG_OP = X"15" or zw_REG_OP = X"0D" or
                zw_REG_OP = X"1D" or zw_REG_OP = X"19" or 
                zw_REG_OP = X"01" or zw_REG_OP = X"11" or
                zw_REG_OP = X"12")) then 
               d_regs_in_o <= d_i OR q_a_i;
               load_regs_o <= '1';
               ch_a_o <= d_i OR q_a_i;
               ch_b_o <= X"00";
               sig_SYNC <= '1';
               fetch_o <= '1';
            elsif ((rdy_i = '1' AND
                   zw_b2(0) = '0') and (zw_REG_OP = X"49" or zw_REG_OP = X"45" or
                   zw_REG_OP = X"55" or zw_REG_OP = X"4D" or
                   zw_REG_OP = X"5D" or zw_REG_OP = X"59" or
                   zw_REG_OP = X"41" or zw_REG_OP = X"51" or
                   zw_REG_OP = X"52")) then 
               d_regs_in_o <= d_i XOR q_a_i;
               load_regs_o <= '1';
               ch_a_o <= d_i XOR q_a_i;
               ch_b_o <= X"00";
               sig_SYNC <= '1';
               fetch_o <= '1';
            elsif ((rdy_i = '1' AND
                   zw_b2(0) = '0') and (zw_REG_OP = X"29" or zw_REG_OP = X"25" or
                   zw_REG_OP = X"35" or zw_REG_OP = X"2D" or
                   zw_REG_OP = X"3D" or zw_REG_OP = X"39" or
                   zw_REG_OP = X"21" or zw_REG_OP = X"31" or
                   zw_REG_OP = X"32" or zw_REG_OP = X"D2")) then 
               d_regs_in_o <= d_i AND q_a_i;
               load_regs_o <= '1';
               ch_a_o <= d_i AND q_a_i;
               ch_b_o <= X"00";
               sig_SYNC <= '1';
               fetch_o <= '1';
            elsif ((rdy_i = '1' AND
                   zw_b2(0) = '0') and (zw_REG_OP = X"C9" or zw_REG_OP = X"C5" or
                   zw_REG_OP = X"D5" or zw_REG_OP = X"CD" or
                   zw_REG_OP = X"DD" or zw_REG_OP = X"D9" or
                   zw_REG_OP = X"C1" or zw_REG_OP = X"D1" or
                    zw_REG_OP = X"C0" or zw_REG_OP = X"E0" or
                    zw_REG_OP = X"C4" or zw_REG_OP = X"E4" or
                    zw_REG_OP = X"CC" or zw_REG_OP = X"EC")) then 
               zw_ALU <= unsigned ('0' & d_regs_out_i) + unsigned ('0' & NOT (d_i)) + 1;
               sig_SYNC <= '1';
               fetch_o <= '1';
            elsif (rdy_i = '1' AND
                   zw_b2(0) = '0') then 
               d_regs_in_o <= d_i;
               load_regs_o <= '1';
               ch_a_o <= d_i;
               ch_b_o <= X"00";
               sig_SYNC <= '1';
               fetch_o <= '1';
            end if;
         when G10_1 => 
            if (rdy_i = '1' and
                zw_REG_OP = X"65") then 
               ld_o <= "11";
               ld_pc_o <= '1';
            elsif (rdy_i = '1' and
                   zw_REG_OP = X"69" and
                   reg_F(3) = '0') then 
               ld_o <= "11";
               ld_pc_o <= '1';
               d_regs_in_o <= zw_ALU(7 downto 0);
               load_regs_o <= '1';
               zw_ALU <= unsigned ('0' & q_a_i) + unsigned ('0' & d_i) + reg_F(0);
               sig_SYNC <= '1';
               fetch_o <= '1';
            elsif (rdy_i = '1' and
                   zw_REG_OP = X"75") then 
               ch_a_o <=  d_i;
               ch_b_o <= q_x_i;
            elsif (rdy_i = '1' and
                   zw_REG_OP = X"6D") then 
               ld_o <= "11";
               ld_pc_o <= '1';
            elsif (rdy_i = '1' and
                   zw_REG_OP = X"7D") then 
               ld_o <= "11";
               ld_pc_o <= '1';
               ch_a_o <= d_i;
               ch_b_o <= q_x_i;
            elsif (rdy_i = '1' and
                   zw_REG_OP = X"79") then 
               ld_o <= "11";
               ld_pc_o <= '1';
               ch_a_o <= d_i;
               ch_b_o <= q_y_i;
            elsif (rdy_i = '1' and
                   zw_REG_OP = X"71") then 
               ch_a_o <= d_i;
               ch_b_o <= X"01";
            elsif (rdy_i = '1' and
                   zw_REG_OP = X"61") then 
               ch_a_o <=  d_i;
               ch_b_o <= q_x_i;
            elsif (rdy_i = '1' and
                   zw_REG_OP = X"69" and
                   reg_F(3) = '1') then 
               ld_o <= "11";
               ld_pc_o <= '1';
               d_regs_in_o <= zw_ALU(7 downto 0);
               load_regs_o <= '1';
               zw_ALU(7 downto 4) <= unsigned (zw_ALU2(3 downto 0)) + unsigned (zw_ALU6(2 downto 0));
               zw_ALU(3 downto 0) <= unsigned (zw_ALU1(3 downto 0)) + unsigned (zw_ALU5(2 downto 0));
               
               zw_ALU6(2 downto 0) <=  (zw_ALU2(4) OR (zw_ALU4(4))) & (zw_ALU2(4) OR (zw_ALU4(4))) & '0';
               zw_ALU5(2 downto 0) <=  (zw_ALU1(4) OR (zw_ALU3(4))) & (zw_ALU1(4) OR (zw_ALU3(4))) & '0';
               
               zw_ALU4 <= unsigned ('0' & zw_ALU2(3 downto 0)) + 6;
               zw_ALU2 <= unsigned ('0' & q_a_i(7 downto 4)) + unsigned ('0' & d_i(7 downto 4)) + (zw_ALU1(4) OR zw_ALU3(4));
               
               zw_ALU3 <= unsigned ('0' & zw_ALU1(3 downto 0)) + 6;
               zw_ALU1 <= unsigned ('0' & q_a_i(3 downto 0)) + unsigned ('0' & d_i(3 downto 0)) + reg_F(0);
               sig_SYNC <= '1';
               fetch_o <= '1';
            elsif (rdy_i = '1' and
                   zw_REG_OP = X"72") then 
               ch_a_o <= d_i;
               ch_b_o <= X"01";
            end if;
         when G10_3 => 
            if (rdy_i = '1') then 
               ld_o <= "11";
               ld_pc_o <= '1';
            end if;
         when G10_4 => 
            if (rdy_i = '1') then 
               ch_a_o <= d_i;
               ch_b_o <= X"01";
               ld_o <= "11";
               ld_pc_o <= '1';
            end if;
         when G10_5 => 
            if (rdy_i = '1') then 
               ch_a_o <= d_i;
               ch_b_o <= q_y_i;
            end if;
         when G10_2 => 
            if (rdy_i = '1') then 
               ld_o <= "11";
               ld_pc_o <= '1';
            end if;
         when G10_e3 => 
            if (rdy_i = '1') then 
               ch_a_o <=  zw_b1;
               ch_b_o <= X"01";
            end if;
         when G10_e1 => 
            if (rdy_i = '1' AND
                zw_b2(0) = '0' and
                reg_F(3) = '0') then 
               d_regs_in_o <= zw_ALU(7 downto 0);
               load_regs_o <= '1';
               zw_ALU <= unsigned ('0' & q_a_i) + unsigned ('0' & d_i) + reg_F(0);
               sig_SYNC <= '1';
               fetch_o <= '1';
            elsif (rdy_i = '1' AND
                   zw_b2(0) = '0' and
                   reg_F(3) = '1') then 
               d_regs_in_o <= zw_ALU(7 downto 0);
               load_regs_o <= '1';
               zw_ALU(7 downto 4) <= unsigned (zw_ALU2(3 downto 0)) + unsigned (zw_ALU6(2 downto 0));
               zw_ALU(3 downto 0) <= unsigned (zw_ALU1(3 downto 0)) + unsigned (zw_ALU5(2 downto 0));
               
               zw_ALU6(2 downto 0) <=  (zw_ALU2(4) OR (zw_ALU4(4))) & (zw_ALU2(4) OR (zw_ALU4(4))) & '0';
               zw_ALU5(2 downto 0) <=  (zw_ALU1(4) OR (zw_ALU3(4))) & (zw_ALU1(4) OR (zw_ALU3(4))) & '0';
               
               zw_ALU4 <= unsigned ('0' & zw_ALU2(3 downto 0)) + 6;
               zw_ALU2 <= unsigned ('0' & q_a_i(7 downto 4)) + unsigned ('0' & d_i(7 downto 4)) + (zw_ALU1(4) OR zw_ALU3(4));
               
               zw_ALU3 <= unsigned ('0' & zw_ALU1(3 downto 0)) + 6;
               zw_ALU1 <= unsigned ('0' & q_a_i(3 downto 0)) + unsigned ('0' & d_i(3 downto 0)) + reg_F(0);
               sig_SYNC <= '1';
               fetch_o <= '1';
            end if;
         when G10_e2 => 
            if (rdy_i = '1' and
                reg_F(3) = '0') then 
               d_regs_in_o <= zw_ALU(7 downto 0);
               load_regs_o <= '1';
               zw_ALU <= unsigned ('0' & q_a_i) + unsigned ('0' & d_i) + reg_F(0);
               sig_SYNC <= '1';
               fetch_o <= '1';
            elsif (rdy_i = '1' and
                   reg_F(3) = '1') then 
               d_regs_in_o <= zw_ALU(7 downto 0);
               load_regs_o <= '1';
               zw_ALU(7 downto 4) <= unsigned (zw_ALU2(3 downto 0)) + unsigned (zw_ALU6(2 downto 0));
               zw_ALU(3 downto 0) <= unsigned (zw_ALU1(3 downto 0)) + unsigned (zw_ALU5(2 downto 0));
               
               zw_ALU6(2 downto 0) <=  (zw_ALU2(4) OR (zw_ALU4(4))) & (zw_ALU2(4) OR (zw_ALU4(4))) & '0';
               zw_ALU5(2 downto 0) <=  (zw_ALU1(4) OR (zw_ALU3(4))) & (zw_ALU1(4) OR (zw_ALU3(4))) & '0';
               
               zw_ALU4 <= unsigned ('0' & zw_ALU2(3 downto 0)) + 6;
               zw_ALU2 <= unsigned ('0' & q_a_i(7 downto 4)) + unsigned ('0' & d_i(7 downto 4)) + (zw_ALU1(4) OR zw_ALU3(4));
               
               zw_ALU3 <= unsigned ('0' & zw_ALU1(3 downto 0)) + 6;
               zw_ALU1 <= unsigned ('0' & q_a_i(3 downto 0)) + unsigned ('0' & d_i(3 downto 0)) + reg_F(0);
               sig_SYNC <= '1';
               fetch_o <= '1';
            end if;
         when G10_6 => 
            if (rdy_i = '1') then 
               ch_a_o <= d_i;
               ch_b_o <= X"01";
               ld_o <= "11";
               ld_pc_o <= '1';
            end if;
         when G17_1 => 
            if (rdy_i = '1' and
                (zw_REG_OP = X"85" OR
                zw_REG_OP = X"86" OR
                zw_REG_OP = X"64" OR
                zw_REG_OP = X"84")) then 
               
               
               sig_WR <= '1';
               sig_D_OUT <= d_regs_out_i;
               ld_o <= "11";
               ld_pc_o <= '1';
            elsif (rdy_i = '1' and
                   (zw_REG_OP = X"95" OR
                   zw_REG_OP = X"74" OR
                   zw_REG_OP = X"94")) then 
               ch_a_o <=  d_i;
               ch_b_o <= q_x_i;
            elsif (rdy_i = '1' and
                   (zw_REG_OP = X"8D" OR
                   zw_REG_OP = X"8E" OR
                   zw_REG_OP = X"9C" OR
                   zw_REG_OP = X"8C")) then 
               ld_o <= "11";
               ld_pc_o <= '1';
            elsif (rdy_i = '1' and
                   (zw_REG_OP = X"9D" OR
                   zw_REG_OP = X"9E")) then 
               ld_o <= "11";
               ld_pc_o <= '1';
               ch_a_o <= d_i;
               ch_b_o <= q_x_i;
            elsif (rdy_i = '1' and
                   zw_REG_OP = X"99") then 
               ld_o <= "11";
               ld_pc_o <= '1';
               ch_a_o <= d_i;
               ch_b_o <= q_y_i;
            elsif (rdy_i = '1' and
                   zw_REG_OP = X"91") then 
               ch_a_o <= d_i;
               ch_b_o <= X"01";
            elsif (rdy_i = '1' and
                   zw_REG_OP = X"81") then 
               ch_a_o <=  d_i;
               ch_b_o <= q_x_i;
            elsif (rdy_i = '1' and
                   zw_REG_OP = X"96") then 
               ch_a_o <=  d_i;
               ch_b_o <= q_y_i;
            elsif (rdy_i = '1' and
                   zw_REG_OP = X"92") then 
               ch_a_o <= d_i;
               ch_b_o <= X"01";
            end if;
         when G17_4 => 
            if (rdy_i = '1') then 
               ch_a_o <= d_i;
               ch_b_o <= "0000000" & zw_b2(0);
               ld_o <= "11";
               ld_pc_o <= '1';
            end if;
         when G17_6 => 
            if (rdy_i = '1') then 
               ch_a_o <= d_i;
               ch_b_o <= q_y_i;
            end if;
         when G17_3 => 
            if (rdy_i = '1') then 
               sig_WR <= '1';
               sig_D_OUT <= d_regs_out_i;
               ld_o <= "11";
               ld_pc_o <= '1';
            end if;
         when G17_2 => 
            if (rdy_i = '1') then 
               sig_WR <= '1';
               sig_D_OUT <= d_regs_out_i;
               ld_o <= "11";
               ld_pc_o <= '1';
            end if;
         when G17_9 => 
            if (rdy_i = '1') then 
               ch_a_o <=  zw_b1;
               ch_b_o <= X"01";
            end if;
         when G17_7 => 
            if (rdy_i = '1') then 
               ch_a_o <= d_i;
               ch_b_o <= "0000000" & zw_b2(0);
               ld_o <= "11";
               ld_pc_o <= '1';
            end if;
         when G17_5 => 
            sig_WR <= '1';
            sig_D_OUT <= d_regs_out_i;
         when G17_10 => 
            sig_WR <= '1';
            sig_D_OUT <= d_regs_out_i;
            ld_o <= "11";
            ld_pc_o <= '1';
         when G17_e => 
            sig_SYNC <= '1';
            fetch_o <= '1';
         when G16_1 => 
            if (rdy_i = '1' and
                zw_REG_OP = X"E5") then 
               ld_o <= "11";
               ld_pc_o <= '1';
            elsif (rdy_i = '1' and
                   zw_REG_OP = X"E9" and
                   reg_F(3) = '0') then 
               ld_o <= "11";
               ld_pc_o <= '1';
               d_regs_in_o <= zw_ALU(7 downto 0);
               load_regs_o <= '1';
               zw_ALU <= unsigned ('0' & q_a_i) + unsigned ('0' & NOT (d_i)) + reg_F(0);
               sig_SYNC <= '1';
               fetch_o <= '1';
            elsif (rdy_i = '1' and
                   zw_REG_OP = X"F5") then 
               ch_a_o <=  d_i;
               ch_b_o <= q_x_i;
            elsif (rdy_i = '1' and
                   zw_REG_OP = X"ED") then 
               ld_o <= "11";
               ld_pc_o <= '1';
            elsif (rdy_i = '1' and
                   zw_REG_OP = X"FD") then 
               ld_o <= "11";
               ld_pc_o <= '1';
               ch_a_o <= d_i;
               ch_b_o <= q_x_i;
            elsif (rdy_i = '1' and
                   zw_REG_OP = X"F9") then 
               ld_o <= "11";
               ld_pc_o <= '1';
               ch_a_o <= d_i;
               ch_b_o <= q_y_i;
            elsif (rdy_i = '1' and
                   zw_REG_OP = X"F1") then 
               ch_a_o <= d_i;
               ch_b_o <= X"01";
            elsif (rdy_i = '1' and
                   zw_REG_OP = X"E1") then 
               ch_a_o <=  d_i;
               ch_b_o <= q_x_i;
            elsif (rdy_i = '1' and
                   zw_REG_OP = X"E9" and
                   reg_F(3) = '1') then 
               ld_o <= "11";
               ld_pc_o <= '1';
               d_regs_in_o <= zw_ALU(7 downto 0);
               load_regs_o <= '1';
               zw_ALU(7 downto 4) <= unsigned (zw_ALU2(3 downto 0)) + unsigned (zw_ALU6);
               zw_ALU(3 downto 0) <= unsigned (zw_ALU1(3 downto 0)) + unsigned (zw_ALU5);
               
               zw_ALU6 <= (zw_ALU4(4) OR NOT (zw_ALU2(4))) & '0' & (zw_ALU4(4) OR NOT (zw_ALU2(4))) & '0';
               zw_ALU5 <= (zw_ALU3(4) OR NOT (zw_ALU1(4))) & '0' & (zw_ALU3(4) OR NOT (zw_ALU1(4))) & '0' ;
               
               zw_ALU4 <= unsigned ('0' & zw_ALU2(3 downto 0)) + 6;
               zw_ALU2 <= unsigned ('0' & q_a_i(7 downto 4)) + unsigned ('0' & NOT (d_i(7 downto 4))) + zw_ALU1(4);
               
               zw_ALU3 <= unsigned ('0' & zw_ALU1(3 downto 0)) + 6;
               zw_ALU1 <= unsigned ('0' & q_a_i(3 downto 0)) + unsigned ('0' & NOT (d_i(3 downto 0))) + reg_F(0);
               sig_SYNC <= '1';
               fetch_o <= '1';
            elsif (rdy_i = '1' and
                   zw_REG_OP = X"F2") then 
               ch_a_o <= d_i;
               ch_b_o <= X"01";
            end if;
         when G16_3 => 
            if (rdy_i = '1') then 
               ld_o <= "11";
               ld_pc_o <= '1';
            end if;
         when G16_4 => 
            if (rdy_i = '1') then 
               ch_a_o <= d_i;
               ch_b_o <= X"01";
               ld_o <= "11";
               ld_pc_o <= '1';
            end if;
         when G16_5 => 
            if (rdy_i = '1') then 
               ch_a_o <= d_i;
               ch_b_o <= q_y_i;
            end if;
         when G16_2 => 
            if (rdy_i = '1') then 
               ld_o <= "11";
               ld_pc_o <= '1';
            end if;
         when G16_6 => 
            if (rdy_i = '1') then 
               ch_a_o <= d_i;
               ch_b_o <= X"01";
               ld_o <= "11";
               ld_pc_o <= '1';
            end if;
         when G16_e3 => 
            if (rdy_i = '1') then 
               ch_a_o <=  zw_b1;
               ch_b_o <= X"01";
            end if;
         when G16_e1 => 
            if (rdy_i = '1' AND
                zw_b2(0) = '0' and
                reg_F(3) = '0') then 
               d_regs_in_o <= zw_ALU(7 downto 0);
               load_regs_o <= '1';
               zw_ALU <= unsigned ('0' & q_a_i) + unsigned ('0' & NOT (d_i)) + reg_F(0);
               sig_SYNC <= '1';
               fetch_o <= '1';
            elsif (rdy_i = '1' AND
                   zw_b2(0) = '0' and
                   reg_F(3) = '1') then 
               d_regs_in_o <= zw_ALU(7 downto 0);
               load_regs_o <= '1';
               zw_ALU(7 downto 4) <= unsigned (zw_ALU2(3 downto 0)) + unsigned (zw_ALU6);
               zw_ALU(3 downto 0) <= unsigned (zw_ALU1(3 downto 0)) + unsigned (zw_ALU5);
               
               zw_ALU6 <= (zw_ALU4(4) OR NOT (zw_ALU2(4))) & '0' & (zw_ALU4(4) OR NOT (zw_ALU2(4))) & '0';
               zw_ALU5 <= (zw_ALU3(4) OR NOT (zw_ALU1(4))) & '0' & (zw_ALU3(4) OR NOT (zw_ALU1(4))) & '0' ;
               
               zw_ALU4 <= unsigned ('0' & zw_ALU2(3 downto 0)) + 6;
               zw_ALU2 <= unsigned ('0' & q_a_i(7 downto 4)) + unsigned ('0' & NOT (d_i(7 downto 4))) + zw_ALU1(4);
               
               zw_ALU3 <= unsigned ('0' & zw_ALU1(3 downto 0)) + 6;
               zw_ALU1 <= unsigned ('0' & q_a_i(3 downto 0)) + unsigned ('0' & NOT (d_i(3 downto 0))) + reg_F(0);
               sig_SYNC <= '1';
               fetch_o <= '1';
            end if;
         when G16_e2 => 
            if (rdy_i = '1' and
                reg_F(3) = '0') then 
               d_regs_in_o <= zw_ALU(7 downto 0);
               load_regs_o <= '1';
               zw_ALU <= unsigned ('0' & q_a_i) + unsigned ('0' & NOT (d_i)) + reg_F(0);
               sig_SYNC <= '1';
               fetch_o <= '1';
            elsif (rdy_i = '1' and
                   reg_F(3) = '1') then 
               d_regs_in_o <= zw_ALU(7 downto 0);
               load_regs_o <= '1';
               zw_ALU(7 downto 4) <= unsigned (zw_ALU2(3 downto 0)) + unsigned (zw_ALU6);
               zw_ALU(3 downto 0) <= unsigned (zw_ALU1(3 downto 0)) + unsigned (zw_ALU5);
               
               zw_ALU6 <= (zw_ALU4(4) OR NOT (zw_ALU2(4))) & '0' & (zw_ALU4(4) OR NOT (zw_ALU2(4))) & '0';
               zw_ALU5 <= (zw_ALU3(4) OR NOT (zw_ALU1(4))) & '0' & (zw_ALU3(4) OR NOT (zw_ALU1(4))) & '0' ;
               
               zw_ALU4 <= unsigned ('0' & zw_ALU2(3 downto 0)) + 6;
               zw_ALU2 <= unsigned ('0' & q_a_i(7 downto 4)) + unsigned ('0' & NOT (d_i(7 downto 4))) + zw_ALU1(4);
               
               zw_ALU3 <= unsigned ('0' & zw_ALU1(3 downto 0)) + 6;
               zw_ALU1 <= unsigned ('0' & q_a_i(3 downto 0)) + unsigned ('0' & NOT (d_i(3 downto 0))) + reg_F(0);
               sig_SYNC <= '1';
               fetch_o <= '1';
            end if;
         when G11_1 => 
            if (rdy_i = '1' and
                (zw_REG_OP = X"1E" or
                zw_REG_OP = X"7E" or
                zw_REG_OP = X"3E" or
                zw_REG_OP = X"5E")) then 
               ld_o <= "11";
               ld_pc_o <= '1';
               ch_a_o <= d_i;
               ch_b_o <= q_x_i;
            elsif (rdy_i = '1' and
                   (zw_REG_OP = X"06" or zw_REG_OP = X"66" or
                   zw_REG_OP = X"26" or zw_REG_OP = X"46" or
                   zw_REG_OP = X"04" or zw_REG_OP = X"14")) then 
               ld_o <= "11";
               ld_pc_o <= '1';
            elsif (rdy_i = '1' and
                   (zw_REG_OP = X"16" or
                   zw_REG_OP = X"76" or
                   zw_REG_OP = X"36" or
                   zw_REG_OP = X"56")) then 
               ch_a_o <=  d_i;
               ch_b_o <= q_x_i;
            elsif (rdy_i = '1' and
                   (zw_REG_OP = X"0E" or
                   zw_REG_OP = X"6E" or
                   zw_REG_OP = X"2E" or
                   zw_REG_OP = X"4E"or
                   zw_REG_OP = X"0C" or
                   zw_REG_OP = X"1C")) then 
               ld_o <= "11";
               ld_pc_o <= '1';
            elsif (rdy_i = '1' and
                   zw_REG_OP (3 downto 0) = X"7") then 
               ld_o <= "11";
               ld_pc_o <= '1';
            end if;
         when G11_5 => 
            if (rdy_i = '1') then 
               ld_o <= "11";
               ld_pc_o <= '1';
            end if;
         when G11_6 => 
            if (rdy_i = '1') then 
               ch_a_o <= d_i;
               ch_b_o <= "0000000" & zw_b2(0);
               ld_o <= "11";
               ld_pc_o <= '1';
            end if;
         when G11_2 => 
            if (rdy_i = '1') then 
               ld_o <= "11";
               ld_pc_o <= '1';
            end if;
         when G11_4 => 
            if (rdy_i = '1' and
                (zw_REG_OP = X"06" or
                zw_REG_OP = X"16" or
                zw_REG_OP = X"0E" or
                zw_REG_OP = X"1E")) then 
               sig_D_OUT <= d_i(6 downto 0) & '0';
               sig_WR <= '1';
            elsif (rdy_i = '1' and
                   (zw_REG_OP = X"46" or
                   zw_REG_OP = X"56" or
                   zw_REG_OP = X"4E" or
                   zw_REG_OP = X"5E")) then 
               sig_D_OUT <= '0' & d_i(7 downto 1);
               sig_WR <= '1';
            elsif (rdy_i = '1' and
                   (zw_REG_OP = X"26" or
                   zw_REG_OP = X"36" or
                   zw_REG_OP = X"2E" or
                   zw_REG_OP = X"3E")) then 
               sig_D_OUT <= d_i(6 downto 0) & reg_F(0);
               sig_WR <= '1';
            elsif (rdy_i = '1' and
                   (zw_REG_OP = X"66" or
                   zw_REG_OP = X"76" or
                   zw_REG_OP = X"6E" or
                   zw_REG_OP = X"7E")) then 
               sig_D_OUT <= reg_F(0) & d_i(7 downto 1);
               sig_WR <= '1';
            elsif (rdy_i = '1' and
                   zw_REG_OP (7) = '0' and
                   zw_REG_OP (3 downto 0) = X"7") then 
               sig_D_OUT <= d_i and NOT (alu_dec_val_i);
               ch_a_o <= "00000" & zw_REG_OP (6 downto 4) ;
               sig_WR <= '1';
            elsif (rdy_i = '1' and
                   zw_REG_OP (7) = '1' and
                   zw_REG_OP (3 downto 0) = X"7") then 
               sig_D_OUT <= d_i or alu_dec_val_i;
               ch_a_o <= "00000" & zw_REG_OP (6 downto 4) ;
               sig_WR <= '1';
            elsif (rdy_i = '1' and
                   (zw_REG_OP = X"14" or
                   zw_REG_OP = X"1C")) then 
               sig_D_OUT <= d_i and NOT (q_a_i);
               sig_WR <= '1';
            elsif (rdy_i = '1' and
                   (zw_REG_OP = X"04" or
                   zw_REG_OP = X"0C")) then 
               sig_D_OUT <= d_i or q_a_i;
               sig_WR <= '1';
            end if;
         when G11_e => 
            if (zw_REG_OP (3 downto 0) = X"7") then 
               sig_SYNC <= '1';
               fetch_o <= '1';
            elsif ((zw_REG_OP = X"14" or
                   zw_REG_OP = X"04" or
                   zw_REG_OP = X"0C" or
                   zw_REG_OP = X"1C")) then 
               ch_a_o <= zw_b1;
               ch_b_o <= X"00";
               sig_SYNC <= '1';
               fetch_o <= '1';
            else
               ch_a_o <= zw_b1;
               ch_b_o <= X"00";
               sig_SYNC <= '1';
               fetch_o <= '1';
            end if;
         when G31_1 => 
            if (rdy_i = '1') then 
               ch_a_o <= q_a_i (6 downto 0) & '0';
               ch_b_o <= X"00";
               d_regs_in_o <= q_a_i (6 downto 0) & '0';
               load_regs_o <= '1';
               sig_SYNC <= '1';
               fetch_o <= '1';
            end if;
         when G34_1 => 
            if (rdy_i = '1') then 
               ch_a_o <= reg_F(0) & q_a_i (7 downto 1);
               ch_b_o <= X"00";
               d_regs_in_o <= reg_F(0) & q_a_i (7 downto 1);
               load_regs_o <= '1';
               sig_SYNC <= '1';
               fetch_o <= '1';
            end if;
         when G32_1 => 
            if (rdy_i = '1') then 
               ch_a_o <= '0' & q_a_i (7 downto 1);
               ch_b_o <= X"00";
               d_regs_in_o <= '0' & q_a_i (7 downto 1);
               load_regs_o <= '1';
               sig_SYNC <= '1';
               fetch_o <= '1';
            end if;
         when G33_1 => 
            if (rdy_i = '1') then 
               ch_a_o <= q_a_i (6 downto 0) & reg_F(0);
               ch_b_o <= X"00";
               d_regs_in_o <= q_a_i (6 downto 0) & reg_F(0);
               load_regs_o <= '1';
               sig_SYNC <= '1';
               fetch_o <= '1';
            end if;
         when G12_1 => 
            if (rdy_i = '1' and (
                (reg_F(0) = '1' and zw_REG_OP = X"90") or (reg_F(0) = '0' and zw_REG_OP = X"B0") or
                (reg_F(1) = '0' and zw_REG_OP = X"F0") or (reg_F(7) = '0' and zw_REG_OP = X"30") or
                (reg_F(1) = '1' and zw_REG_OP = X"D0") or (reg_F(7) = '1' and zw_REG_OP = X"10") or
                (reg_F(6) = '1' and zw_REG_OP = X"50") or (reg_F(6) = '0' and zw_REG_OP = X"70"))) then 
               ld_o <= "11";
               ld_pc_o <= '1';
               sig_SYNC <= '1';
               fetch_o <= '1';
            elsif (rdy_i = '1' and (
                   zw_REG_OP = X"8F" or
                   zw_REG_OP = X"9F" or
                   zw_REG_OP = X"AF" or
                   zw_REG_OP = X"BF" or
                   zw_REG_OP = X"CF" or
                   zw_REG_OP = X"DF" or
                   zw_REG_OP = X"EF" or
                   zw_REG_OP = X"FF" or
                   zw_REG_OP = X"0F" or
                   zw_REG_OP = X"1F" or
                   zw_REG_OP = X"2F" or
                   zw_REG_OP = X"3F" or
                   zw_REG_OP = X"4F" or
                   zw_REG_OP = X"5F" or
                   zw_REG_OP = X"6F" or
                   zw_REG_OP = X"7F")) then 
               ld_o <= "11";
               ld_pc_o <= '1';
            elsif (rdy_i = '1') then 
               ld_o <= "11";
               ld_pc_o <= '1';
            end if;
         when G12_e1 => 
            if (rdy_i = '1' and
                zw_b3 = adr_nxt_pc_i (15 downto 8)) then 
               offset_o <= (zw_b2(7) & zw_b2(7) &
               zw_b2(7) & zw_b2(7) & zw_b2(7) & 
               zw_b2(7) & zw_b2(7) & zw_b2(7) &
               zw_b2(7) & zw_b2(6 downto 0));
               ld_o <= "11";
               ld_pc_o <= '1';
               sig_SYNC <= '1';
               fetch_o <= '1';
            elsif (rdy_i = '1') then 
               offset_o <= (zw_b2(7) & zw_b2(7) & zw_b2(7) &
               zw_b2(7) & zw_b2(7) & zw_b2(7) & zw_b2(7) &
               zw_b2(7) & zw_b2(7) & zw_b2(6 downto 0));
               ld_o <= "11";
               ld_pc_o <= '1';
            end if;
         when G12_e2 => 
            if (rdy_i = '1') then 
               sig_SYNC <= '1';
               fetch_o <= '1';
            end if;
         when G12_3 => 
            if (rdy_i = '1' and (
                (d_i(0) = '1' and zw_REG_OP = X"8F") or
                (d_i(1) = '1' and zw_REG_OP = X"9F") or
                (d_i(2) = '1' and zw_REG_OP = X"AF") or
                (d_i(3) = '1' and zw_REG_OP = X"BF") or
                (d_i(4) = '1' and zw_REG_OP = X"CF") or
                (d_i(5) = '1' and zw_REG_OP = X"DF") or
                (d_i(6) = '1' and zw_REG_OP = X"EF") or
                (d_i(7) = '1' and zw_REG_OP = X"FF") or
                (d_i(0) = '0' and zw_REG_OP = X"0F") or
                (d_i(1) = '0' and zw_REG_OP = X"1F") or
                (d_i(2) = '0' and zw_REG_OP = X"2F") or
                (d_i(3) = '0' and zw_REG_OP = X"3F") or
                (d_i(4) = '0' and zw_REG_OP = X"4F") or
                (d_i(5) = '0' and zw_REG_OP = X"5F") or
                (d_i(6) = '0' and zw_REG_OP = X"6F") or
                (d_i(7) = '0' and zw_REG_OP = X"7F"))) then 
            elsif (rdy_i = '1') then 
               ld_o <= "11";
               ld_pc_o <= '1';
            end if;
         when G12_4 => 
            if (rdy_i = '1') then 
               ld_o <= "11";
               ld_pc_o <= '1';
            end if;
         when G20_2 => 
            if (rdy_i = '1') then 
               adr_o <= d_i & zw_b1;
               ld_o <= "11";
               ld_pc_o <= '1';
            end if;
         when G20_e => 
            if (rdy_i = '1') then 
               adr_o <= d_i & zw_b1;
               ld_o <= "11";
               ld_pc_o <= '1';
               sig_SYNC <= '1';
               fetch_o <= '1';
            end if;
         when G20_3 => 
            if (rdy_i = '1') then 
               adr_o <= d_i & zw_b1;
               offset_o <= (X"00" & q_x_i);
               ld_o <= "11";
               ld_pc_o <= '1';
            end if;
         when G21_1 => 
            if (rdy_i = '1') then 
               ld_o <= "11";
               ld_sp_o <= '1';
               ld_pc_o <= '1';
            end if;
         when G21_2 => 
            if (rdy_i = '1') then 
               sig_WR <= '1';
               sig_D_OUT <= adr_pc_i (15 downto 8);
            end if;
         when G21_3 => 
            ld_o <= "11";
            ld_sp_o <= '1';
            sig_WR <= '1';
            sig_D_OUT <= adr_pc_i (7 downto 0);
         when G21_e => 
            if (rdy_i = '1') then 
               adr_o <= d_i & zw_b1;
               ld_o <= "11";
               ld_pc_o <= '1';
               sig_SYNC <= '1';
               fetch_o <= '1';
            end if;
         when G13_3 => 
            if (rdy_i = '1') then 
               ld_o <= "11";
               ld_pc_o <= '1';
            end if;
         when G13_1 => 
            if (rdy_i = '1' and
                zw_REG_OP = X"34") then 
               ch_a_o <=  d_i;
               ch_b_o <= q_x_i;
            elsif (rdy_i = '1' and
                   zw_REG_OP = X"3C") then 
               ld_o <= "11";
               ld_pc_o <= '1';
               ch_a_o <= d_i;
               ch_b_o <= q_x_i;
            elsif (rdy_i = '1' and
                   zw_REG_OP = X"24") then 
               ld_o <= "11";
               ld_pc_o <= '1';
            elsif (rdy_i = '1' and
                   zw_REG_OP = X"2C") then 
               ld_o <= "11";
               ld_pc_o <= '1';
            elsif (rdy_i = '1' and
                   zw_REG_OP = X"89") then 
               ch_a_o <= q_a_i AND d_i;
               ch_b_o <= X"00";
               ld_o <= "11";
               ld_pc_o <= '1';
               sig_SYNC <= '1';
               fetch_o <= '1';
            end if;
         when G13_4 => 
            if (rdy_i = '1') then 
               ch_a_o <= d_i;
               ch_b_o <= "0000000" & zw_b2(0);
               ld_o <= "11";
               ld_pc_o <= '1';
            end if;
         when G13_2 => 
            if (rdy_i = '1') then 
               ld_o <= "11";
               ld_pc_o <= '1';
            end if;
         when G13_e1 => 
            if (rdy_i = '1') then 
               ch_a_o <= q_a_i AND d_i;
               ch_b_o <= X"00";
               sig_SYNC <= '1';
               fetch_o <= '1';
            end if;
         when G13_e2 => 
            if (rdy_i = '1' AND
                zw_b2(0) = '0') then 
               ch_a_o <= q_a_i AND d_i;
               ch_b_o <= X"00";
               sig_SYNC <= '1';
               fetch_o <= '1';
            end if;
         when G18_1 => 
            if (rdy_i = '1') then 
               ld_o <= "11";
               ld_sp_o <= '1';
               sig_WR <= '1';
               sig_D_OUT <= adr_nxt_pc_i (15 downto 8);
            end if;
         when G18_2 => 
            ld_o <= "11";
            ld_sp_o <= '1';
            sig_WR <= '1';
            sig_D_OUT <= adr_nxt_pc_i (7 downto 0);
         when G18_3 => 
            ld_o <= "11";
            ld_sp_o <= '1';
            sig_WR <= '1';
            sig_D_OUT <= reg_F OR X"10";
         when G18_e => 
            if (rdy_i = '1') then 
               adr_o <= d_i & zw_b1;
               ld_o <= "11";
               ld_pc_o <= '1';
               sig_SYNC <= '1';
               fetch_o <= '1';
            end if;
         when G26_1 => 
            if (rdy_i = '1') then 
               ld_o <= "11";
               ld_sp_o <= '1';
            end if;
         when G26_2 => 
            if (rdy_i = '1') then 
               ld_o <= "11";
               ld_sp_o <= '1';
            end if;
         when G26_3 => 
            if (rdy_i = '1') then 
               ld_o <= "11";
               ld_sp_o <= '1';
            end if;
         when G26_e => 
            if (rdy_i = '1') then 
               adr_o <= d_i & zw_b1;
               ld_o <= "11";
               ld_pc_o <= '1';
               sig_SYNC <= '1';
               fetch_o <= '1';
            end if;
         when G27_1 => 
            if (rdy_i = '1') then 
               ld_o <= "11";
               ld_sp_o <= '1';
            end if;
         when G27_2 => 
            if (rdy_i = '1') then 
               ld_o <= "11";
               ld_sp_o <= '1';
            end if;
         when G27_4 => 
            if (rdy_i = '1') then 
               adr_o <= d_i & zw_b1;
               ld_o <= "11";
               ld_pc_o <= '1';
            end if;
         when G27_e => 
            if (rdy_i = '1') then 
               sig_SYNC <= '1';
               fetch_o <= '1';
            end if;
         when G14_1 => 
            if (rdy_i = '1' and
                (zw_REG_OP = X"C6" OR
                zw_REG_OP = X"E6")) then 
               ld_o <= "11";
               ld_pc_o <= '1';
            elsif (rdy_i = '1' and
                   (zw_REG_OP = X"D6" OR
                   zw_REG_OP = X"F6")) then 
               ch_a_o <=  d_i;
               ch_b_o <= q_x_i;
            elsif (rdy_i = '1' and
                   (zw_REG_OP = X"CE" OR
                   zw_REG_OP = X"EE")) then 
               ld_o <= "11";
               ld_pc_o <= '1';
            elsif (rdy_i = '1' and
                   (zw_REG_OP = X"DE" OR
                   zw_REG_OP = X"FE")) then 
               ld_o <= "11";
               ld_pc_o <= '1';
               ch_a_o <= d_i;
               ch_b_o <= q_x_i;
            end if;
         when G14_5 => 
            if (rdy_i = '1') then 
               ld_o <= "11";
               ld_pc_o <= '1';
            end if;
         when G14_6 => 
            if (rdy_i = '1') then 
               ch_a_o <= d_i;
               ch_b_o <= "0000000" & zw_b2(0);
               ld_o <= "11";
               ld_pc_o <= '1';
            end if;
         when G14_2 => 
            if (rdy_i = '1') then 
               ld_o <= "11";
               ld_pc_o <= '1';
            end if;
         when G14_3 => 
            if (rdy_i = '1') then 
               ch_a_o <= d_i;
               ch_b_o <= zw_b4;
            end if;
         when G14_4 => 
            if (rdy_i = '1') then 
               sig_WR <= '1';
               sig_D_OUT <= zw_b1;
            end if;
         when G14_e => 
            ch_a_o <= zw_b1;
            ch_b_o <= X"00";
            sig_SYNC <= '1';
            fetch_o <= '1';
         when G22_1 => 
            if (rdy_i = '1') then 
               sig_WR <= '1';
               sig_D_OUT <= d_regs_out_i;
               ld_o <= "11";
               ld_sp_o <= '1';
            end if;
         when G22_e => 
            sig_SYNC <= '1';
            fetch_o <= '1';
         when G23_1 => 
            if (rdy_i = '1') then 
               sig_WR <= '1';
               sig_D_OUT <= reg_F;
               ld_o <= "11";
               ld_sp_o <= '1';
            end if;
         when G23_e => 
            sig_SYNC <= '1';
            fetch_o <= '1';
         when G24_1 => 
            if (rdy_i = '1') then 
               ld_o <= "11";
               ld_sp_o <= '1';
            end if;
         when G24_e => 
            if (rdy_i = '1') then 
               d_regs_in_o <= d_i;
               load_regs_o <= '1';
               ch_a_o <= d_i;
               ch_b_o <= X"00";
               sig_SYNC <= '1';
               fetch_o <= '1';
            end if;
         when G25_1 => 
            if (rdy_i = '1') then 
               ld_o <= "11";
               ld_sp_o <= '1';
            end if;
         when G25_e => 
            if (rdy_i = '1') then 
               sig_SYNC <= '1';
               fetch_o <= '1';
            end if;
         when others =>
            null;
      end case;
   end process output_proc;
 
   -- Concurrent Statements
   -- Clocked output assignments
   d_o <= d_o_cld;
   rd_o <= rd_o_cld;
   sync_o <= sync_o_cld;
   wr_o <= wr_o_cld;
end fsm;
