-- VHDL Entity R65C02_TC.Core.symbol
--
-- Created:
--          by - eda.UNKNOWN (ENTWICKL4-XP-PR)
--          at - 15:22:45 25.02.2009
--
-- Generated by Mentor Graphics' HDL Designer(TM) 2007.1a (Build 13)
--
LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;

entity Core is
   port( 
      clk_clk_i   : in     std_logic;
      d_i         : in     std_logic_vector (7 downto 0);
      irq_n_i     : in     std_logic;
      nmi_n_i     : in     std_logic;
      rdy_i       : in     std_logic;
      rst_rst_n_i : in     std_logic;
      so_n_i      : in     std_logic;
      a_o         : out    std_logic_vector (15 downto 0);
      d_o         : out    std_logic_vector (7 downto 0);
      rd_o        : out    std_logic;
      sync_o      : out    std_logic;
      wr_o        : out    std_logic
   );

-- Declarations

end Core ;

-- Jens-D. Gutschmidt     Project:  R65C02_TC  
-- scantara2003@yahoo.de                       
-- COPYRIGHT (C) 2008-2009 by Jens Gutschmidt and OPENCORES.ORG                                                                                                                             
--                                                                                                                                                                                          
-- This program is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, either version   
-- 3 of the License, or any later version.                                                                                                                                                  
--                                                                                                                                                                                          
-- This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A                          
-- PARTICULAR PURPOSE.  See the GNU General Public License for more details.                                                                                                                
--                                                                                                                                                                                          
-- You should have received a copy of the GNU General Public License along with this program.  If not, see <http://www.gnu.org/licenses/>.                                                  
--                                                                                                                                                                                          
-- CVS Revisins History                                                                                                                                                                     
--                                                                                                                                                                                          
-- $Log: not supported by cvs2svn $                                                                                                                                                                      
--   <<-- more -->>                                                                                                                                                                         
-- Title:  Core  
-- Path:  R65C02_TC/Core/struct  
-- Edited:  by eda on 23 Feb 2009  
--
-- VHDL Architecture R65C02_TC.Core.struct
--
-- Created:
--          by - eda.UNKNOWN (ENTWICKL4-XP-PR)
--          at - 15:22:46 25.02.2009
--
-- Generated by Mentor Graphics' HDL Designer(TM) 2007.1a (Build 13)
--
LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;

--library R65C02_TC;

architecture struct of Core is

   -- Architecture declarations

   -- Internal signal declarations
   signal adr_nxt_pc_o_i  : std_logic_vector(15 downto 0);
   signal adr_o_i         : std_logic_vector(15 downto 0);
   signal adr_pc_o_i      : std_logic_vector(15 downto 0);
   signal adr_sp_o_i      : std_logic_vector(15 downto 0);
   signal alu_dec_val_o_i : std_logic_vector(7 downto 0);
   signal ch_a_o_i        : std_logic_vector(7 downto 0);
   signal ch_b_o_i        : std_logic_vector(7 downto 0);
   signal d_alu_n_o_i     : std_logic;
   signal d_alu_o_i       : std_logic_vector(7 downto 0);
   signal d_alu_or_o_i    : std_logic;
   signal d_regs_in_o_i   : std_logic_vector(7 downto 0);
   signal d_regs_out_o_i  : std_logic_vector(7 downto 0);
   signal fetch_o_i       : std_logic;
   signal ld_o_i          : std_logic_vector(1 downto 0);
   signal ld_pc_o_i       : std_logic;
   signal ld_sp_o_i       : std_logic;
   signal load_regs_o_i   : std_logic;
   signal nmi_o_i         : std_logic;
   signal offset_o_i      : std_logic_vector(15 downto 0);
   signal q_a_o_i         : std_logic_vector(7 downto 0);
   signal q_x_o_i         : std_logic_vector(7 downto 0);
   signal q_y_o_i         : std_logic_vector(7 downto 0);
   signal reg_0flag_o_i   : std_logic;
   signal reg_1flag_o_i   : std_logic;
   signal reg_7flag_o_i   : std_logic;
   signal sel_pc_in_o_i   : std_logic;
   signal sel_pc_val_o_i  : std_logic_vector(1 downto 0);
   signal sel_rb_in_o_i   : std_logic_vector(1 downto 0);
   signal sel_rb_out_o_i  : std_logic_vector(1 downto 0);
   signal sel_reg_o_i     : std_logic_vector(1 downto 0);
   signal sel_sp_as_o_i   : std_logic;
   signal sel_sp_in_o_i   : std_logic;


   -- ModuleWare signal declarations(v1.9) for instance 'U_11' of 'add'
   signal mw_U_11temp_din0 : std_logic_vector(8 downto 0);
   signal mw_U_11temp_din1 : std_logic_vector(8 downto 0);
   signal mw_U_11sum : unsigned(8 downto 0);

   -- Component Declarations
   component FSM_Execution_Unit
   port (
      adr_nxt_pc_i  : in     std_logic_vector (15 downto 0);
      adr_pc_i      : in     std_logic_vector (15 downto 0);
      adr_sp_i      : in     std_logic_vector (15 downto 0);
      alu_dec_val_i : in     std_logic_vector ( 7 downto 0 );
      clk_clk_i     : in     std_logic ;
      d_alu_i       : in     std_logic_vector ( 7 downto 0 );
      d_i           : in     std_logic_vector ( 7 downto 0 );
      d_regs_out_i  : in     std_logic_vector ( 7 downto 0 );
      irq_n_i       : in     std_logic ;
      nmi_i         : in     std_logic ;
      q_a_i         : in     std_logic_vector ( 7 downto 0 );
      q_x_i         : in     std_logic_vector ( 7 downto 0 );
      q_y_i         : in     std_logic_vector ( 7 downto 0 );
      rdy_i         : in     std_logic ;
      reg_0flag_i   : in     std_logic ;
      reg_1flag_i   : in     std_logic ;
      reg_7flag_i   : in     std_logic ;
      rst_rst_n_i   : in     std_logic ;
      so_n_i        : in     std_logic ;
      a_o           : out    std_logic_vector (15 downto 0);
      adr_o         : out    std_logic_vector (15 downto 0);
      ch_a_o        : out    std_logic_vector ( 7 downto 0 );
      ch_b_o        : out    std_logic_vector ( 7 downto 0 );
      d_o           : out    std_logic_vector ( 7 downto 0 );
      d_regs_in_o   : out    std_logic_vector ( 7 downto 0 );
      fetch_o       : out    std_logic ;
      ld_o          : out    std_logic_vector ( 1 downto 0 );
      ld_pc_o       : out    std_logic ;
      ld_sp_o       : out    std_logic ;
      load_regs_o   : out    std_logic ;
      offset_o      : out    std_logic_vector ( 15 downto 0 );
      rd_o          : out    std_logic ;
      sel_pc_in_o   : out    std_logic ;
      sel_pc_val_o  : out    std_logic_vector ( 1 downto 0 );
      sel_rb_in_o   : out    std_logic_vector ( 1 downto 0 );
      sel_rb_out_o  : out    std_logic_vector ( 1 downto 0 );
      sel_reg_o     : out    std_logic_vector ( 1 downto 0 );
      sel_sp_as_o   : out    std_logic ;
      sel_sp_in_o   : out    std_logic ;
      sync_o        : out    std_logic ;
      wr_o          : out    std_logic 
   );
   end component;
   component FSM_NMI
   port (
      clk_clk_i   : in     std_logic ;
      fetch_i     : in     std_logic ;
      nmi_n_i     : in     std_logic ;
      rst_rst_n_i : in     std_logic ;
      nmi_o       : out    std_logic 
   );
   end component;
   component RegBank_AXY
   port (
      clk_clk_i    : in     std_logic ;
      d_regs_in_i  : in     std_logic_vector (7 downto 0);
      load_regs_i  : in     std_logic ;
      rst_rst_n_i  : in     std_logic ;
      sel_rb_in_i  : in     std_logic_vector (1 downto 0);
      sel_rb_out_i : in     std_logic_vector (1 downto 0);
      sel_reg_i    : in     std_logic_vector (1 downto 0);
      d_regs_out_o : out    std_logic_vector (7 downto 0);
      q_a_o        : out    std_logic_vector (7 downto 0);
      q_x_o        : out    std_logic_vector (7 downto 0);
      q_y_o        : out    std_logic_vector (7 downto 0)
   );
   end component;
   component Reg_PC
   port (
      adr_i        : in     std_logic_vector (15 downto 0);
      clk_clk_i    : in     std_logic ;
      ld_i         : in     std_logic_vector (1 downto 0);
      ld_pc_i      : in     std_logic ;
      offset_i     : in     std_logic_vector (15 downto 0);
      rst_rst_n_i  : in     std_logic ;
      sel_pc_in_i  : in     std_logic ;
      sel_pc_val_i : in     std_logic_vector (1 downto 0);
      adr_nxt_pc_o : out    std_logic_vector (15 downto 0);
      adr_pc_o     : out    std_logic_vector (15 downto 0)
   );
   end component;
   component Reg_SP
   port (
      adr_low_i   : in     std_logic_vector (7 downto 0);
      clk_clk_i   : in     std_logic ;
      ld_low_i    : in     std_logic ;
      ld_sp_i     : in     std_logic ;
      rst_rst_n_i : in     std_logic ;
      sel_sp_as_i : in     std_logic ;
      sel_sp_in_i : in     std_logic ;
      adr_sp_o    : out    std_logic_vector (15 downto 0)
   );
   end component;

   -- Optional embedded configurations
   -- pragma synthesis_off
--   for all : FSM_Execution_Unit use entity R65C02_TC.FSM_Execution_Unit;
--   for all : FSM_NMI use entity R65C02_TC.FSM_NMI;
--   for all : RegBank_AXY use entity R65C02_TC.RegBank_AXY;
--   for all : Reg_PC use entity R65C02_TC.Reg_PC;
--   for all : Reg_SP use entity R65C02_TC.Reg_SP;
   -- pragma synthesis_on


begin

   -- ModuleWare code(v1.9) for instance 'U_11' of 'add'
   mw_U_11temp_din0 <= '0' & ch_a_o_i;
   mw_U_11temp_din1 <= '0' & ch_b_o_i;
   u_11combo_proc: process (mw_U_11temp_din0, mw_U_11temp_din1)
   variable temp_carry : std_logic;
   begin
      temp_carry := '0';
      mw_U_11sum <= unsigned(mw_U_11temp_din0) + unsigned(mw_U_11temp_din1) + temp_carry;
   end process u_11combo_proc;
   d_alu_o_i <= conv_std_logic_vector(mw_U_11sum(7 downto 0),8);
   reg_0flag_o_i <= mw_U_11sum(8) ;

   -- ModuleWare code(v1.9) for instance 'U_5' of 'decoder1'
   u_5combo_proc: process (d_alu_o_i(2 DOWNTO 0))
   begin
      alu_dec_val_o_i <= (others => '0');
      case d_alu_o_i(2 DOWNTO 0) is
         when "000" => alu_dec_val_o_i(0) <= '1';
         when "001" => alu_dec_val_o_i(1) <= '1';
         when "010" => alu_dec_val_o_i(2) <= '1';
         when "011" => alu_dec_val_o_i(3) <= '1';
         when "100" => alu_dec_val_o_i(4) <= '1';
         when "101" => alu_dec_val_o_i(5) <= '1';
         when "110" => alu_dec_val_o_i(6) <= '1';
         when "111" => alu_dec_val_o_i(7) <= '1';
         when others => alu_dec_val_o_i <= (others => '0');
      end case;
   end process u_5combo_proc;

   -- ModuleWare code(v1.9) for instance 'U_8' of 'inv'
   reg_1flag_o_i <= not(d_alu_or_o_i);

   -- ModuleWare code(v1.9) for instance 'U_9' of 'inv'
   reg_7flag_o_i <= not(d_alu_n_o_i);

   -- ModuleWare code(v1.9) for instance 'U_10' of 'inv'
   d_alu_n_o_i <= not(d_alu_o_i(7));

   -- ModuleWare code(v1.9) for instance 'U_7' of 'por'
   d_alu_or_o_i <= d_alu_o_i(0) or  d_alu_o_i(1) or  d_alu_o_i(2) or  d_alu_o_i(3) or  d_alu_o_i(4) or  d_alu_o_i(5) or  d_alu_o_i(6) or  d_alu_o_i(7);

   -- Instance port mappings.
   U_4 : FSM_Execution_Unit
      port map (
         adr_nxt_pc_i  => adr_nxt_pc_o_i,
         adr_pc_i      => adr_pc_o_i,
         adr_sp_i      => adr_sp_o_i,
         alu_dec_val_i => alu_dec_val_o_i,
         clk_clk_i     => clk_clk_i,
         d_alu_i       => d_alu_o_i,
         d_i           => d_i,
         d_regs_out_i  => d_regs_out_o_i,
         irq_n_i       => irq_n_i,
         nmi_i         => nmi_o_i,
         q_a_i         => q_a_o_i,
         q_x_i         => q_x_o_i,
         q_y_i         => q_y_o_i,
         rdy_i         => rdy_i,
         reg_0flag_i   => reg_0flag_o_i,
         reg_1flag_i   => reg_1flag_o_i,
         reg_7flag_i   => reg_7flag_o_i,
         rst_rst_n_i   => rst_rst_n_i,
         so_n_i        => so_n_i,
         a_o           => a_o,
         adr_o         => adr_o_i,
         ch_a_o        => ch_a_o_i,
         ch_b_o        => ch_b_o_i,
         d_o           => d_o,
         d_regs_in_o   => d_regs_in_o_i,
         fetch_o       => fetch_o_i,
         ld_o          => ld_o_i,
         ld_pc_o       => ld_pc_o_i,
         ld_sp_o       => ld_sp_o_i,
         load_regs_o   => load_regs_o_i,
         offset_o      => offset_o_i,
         rd_o          => rd_o,
         sel_pc_in_o   => sel_pc_in_o_i,
         sel_pc_val_o  => sel_pc_val_o_i,
         sel_rb_in_o   => sel_rb_in_o_i,
         sel_rb_out_o  => sel_rb_out_o_i,
         sel_reg_o     => sel_reg_o_i,
         sel_sp_as_o   => sel_sp_as_o_i,
         sel_sp_in_o   => sel_sp_in_o_i,
         sync_o        => sync_o,
         wr_o          => wr_o
      );
   U_3 : FSM_NMI
      port map (
         clk_clk_i   => clk_clk_i,
         fetch_i     => fetch_o_i,
         nmi_n_i     => nmi_n_i,
         rst_rst_n_i => rst_rst_n_i,
         nmi_o       => nmi_o_i
      );
   U_2 : RegBank_AXY
      port map (
         clk_clk_i    => clk_clk_i,
         d_regs_in_i  => d_regs_in_o_i,
         load_regs_i  => load_regs_o_i,
         rst_rst_n_i  => rst_rst_n_i,
         sel_rb_in_i  => sel_rb_in_o_i,
         sel_rb_out_i => sel_rb_out_o_i,
         sel_reg_i    => sel_reg_o_i,
         d_regs_out_o => d_regs_out_o_i,
         q_a_o        => q_a_o_i,
         q_x_o        => q_x_o_i,
         q_y_o        => q_y_o_i
      );
   U_0 : Reg_PC
      port map (
         adr_i        => adr_o_i,
         clk_clk_i    => clk_clk_i,
         ld_i         => ld_o_i,
         ld_pc_i      => ld_pc_o_i,
         offset_i     => offset_o_i,
         rst_rst_n_i  => rst_rst_n_i,
         sel_pc_in_i  => sel_pc_in_o_i,
         sel_pc_val_i => sel_pc_val_o_i,
         adr_nxt_pc_o => adr_nxt_pc_o_i,
         adr_pc_o     => adr_pc_o_i
      );
   U_1 : Reg_SP
      port map (
         adr_low_i   => adr_o_i(7 DOWNTO 0),
         clk_clk_i   => clk_clk_i,
         ld_low_i    => ld_o_i(0),
         ld_sp_i     => ld_sp_o_i,
         rst_rst_n_i => rst_rst_n_i,
         sel_sp_as_i => sel_sp_as_o_i,
         sel_sp_in_i => sel_sp_in_o_i,
         adr_sp_o    => adr_sp_o_i
      );

end struct;
