VERSION 6
BEGIN SCHEMATIC
    BEGIN ATTR DeviceFamilyName "spartan3"
        DELETE all:0
        EDITNAME all:0
        EDITTRAIT all:0
    END ATTR
    BEGIN NETLIST
        SIGNAL Tx_Data(7:0)
        SIGNAL Rx_flush
        SIGNAL Rx_Data(7:0)
        SIGNAL Rx_valid
        SIGNAL Tx_full
        SIGNAL Rx_full
        SIGNAL XLXN_58
        SIGNAL XLXN_59
        SIGNAL Tx_write
        SIGNAL XLXN_66
        SIGNAL XLXN_57
        SIGNAL Rx_ack
        SIGNAL Tx_reset
        SIGNAL SYSCLK
        SIGNAL XLXN_32
        SIGNAL BaudSel(2:0)
        SIGNAL XLXN_112
        SIGNAL XLXN_113
        SIGNAL SEL
        SIGNAL XLXN_115
        SIGNAL Opto_Tx
        SIGNAL Opto_Rx
        SIGNAL Serial_Tx
        SIGNAL Serial_Rx
        PORT Input Tx_Data(7:0)
        PORT Input Rx_flush
        PORT Output Rx_Data(7:0)
        PORT Output Rx_valid
        PORT Output Tx_full
        PORT Output Rx_full
        PORT Input Tx_write
        PORT Input Rx_ack
        PORT Input Tx_reset
        PORT Input SYSCLK
        PORT Input BaudSel(2:0)
        PORT Input SEL
        PORT Output Opto_Tx
        PORT Input Opto_Rx
        PORT Output Serial_Tx
        PORT Input Serial_Rx
        BEGIN BLOCKDEF kcbaud
            TIMESTAMP 2009 11 2 17 22 18
            RECTANGLE N 0 20 64 44 
            LINE N 64 32 0 32 
            LINE N 64 -32 0 -32 
            LINE N 320 -32 384 -32 
            RECTANGLE N 64 -64 320 64 
        END BLOCKDEF
        BEGIN BLOCKDEF uart_rx
            TIMESTAMP 2009 4 9 11 56 17
            RECTANGLE N 64 -320 464 0 
            LINE N 64 -288 0 -288 
            LINE N 64 -224 0 -224 
            LINE N 64 -160 0 -160 
            LINE N 64 -96 0 -96 
            LINE N 64 -32 0 -32 
            LINE N 464 -288 528 -288 
            LINE N 464 -224 528 -224 
            LINE N 464 -160 528 -160 
            RECTANGLE N 464 -44 528 -20 
            LINE N 464 -32 528 -32 
        END BLOCKDEF
        BEGIN BLOCKDEF uart_tx
            TIMESTAMP 2009 4 9 11 56 51
            RECTANGLE N 64 -320 464 0 
            LINE N 64 -288 0 -288 
            LINE N 64 -224 0 -224 
            LINE N 64 -160 0 -160 
            LINE N 64 -96 0 -96 
            RECTANGLE N 0 -44 64 -20 
            LINE N 64 -32 0 -32 
            LINE N 464 -288 528 -288 
            LINE N 464 -224 528 -224 
            LINE N 464 -160 528 -160 
        END BLOCKDEF
        BEGIN BLOCKDEF fd
            TIMESTAMP 2000 1 1 10 10 10
            RECTANGLE N 64 -320 320 -64 
            LINE N 0 -128 64 -128 
            LINE N 0 -256 64 -256 
            LINE N 384 -256 320 -256 
            LINE N 80 -128 64 -144 
            LINE N 64 -112 80 -128 
        END BLOCKDEF
        BEGIN BLOCKDEF and2b1
            TIMESTAMP 2000 1 1 10 10 10
            LINE N 64 -48 64 -144 
            LINE N 64 -144 144 -144 
            LINE N 144 -48 64 -48 
            ARC N 96 -144 192 -48 144 -48 144 -144 
            LINE N 256 -96 192 -96 
            LINE N 0 -128 64 -128 
            LINE N 0 -64 40 -64 
            CIRCLE N 40 -76 64 -52 
        END BLOCKDEF
        BEGIN BLOCKDEF COM_mux
            TIMESTAMP 2009 9 25 11 41 26
            RECTANGLE N 64 -268 320 -16 
            LINE N 64 -160 0 -160 
            LINE N 0 -112 64 -112 
            LINE N 320 -192 384 -192 
            LINE N 320 -96 384 -96 
            LINE N 384 -48 320 -48 
            LINE N 320 -240 384 -240 
            LINE N 64 -48 0 -48 
            LINE N 320 -40 304 -48 
            LINE N 320 -56 320 -40 
            LINE N 304 -48 320 -56 
            LINE N 304 -192 320 -200 
            LINE N 320 -200 320 -184 
            LINE N 304 -192 320 -184 
            LINE N 64 -112 80 -120 
            LINE N 64 -112 80 -104 
            LINE N 80 -104 80 -120 
        END BLOCKDEF
        BEGIN BLOCK XLXI_8 uart_rx
            PIN serial_in XLXN_113
            PIN read_buffer XLXN_58
            PIN reset_buffer Rx_flush
            PIN en_16_x_baud XLXN_32
            PIN clk SYSCLK
            PIN buffer_data_present Rx_valid
            PIN buffer_full
            PIN buffer_half_full Rx_full
            PIN data_out(7:0) Rx_Data(7:0)
        END BLOCK
        BEGIN BLOCK XLXI_9 uart_tx
            PIN write_buffer XLXN_66
            PIN reset_buffer Tx_reset
            PIN en_16_x_baud XLXN_32
            PIN clk SYSCLK
            PIN data_in(7:0) Tx_Data(7:0)
            PIN serial_out XLXN_115
            PIN buffer_full Tx_full
            PIN buffer_half_full
        END BLOCK
        BEGIN BLOCK XLXI_12 fd
            PIN C SYSCLK
            PIN D Tx_write
            PIN Q XLXN_59
        END BLOCK
        BEGIN BLOCK XLXI_13 and2b1
            PIN I0 XLXN_59
            PIN I1 Tx_write
            PIN O XLXN_66
        END BLOCK
        BEGIN BLOCK XLXI_10 fd
            PIN C SYSCLK
            PIN D Rx_ack
            PIN Q XLXN_57
        END BLOCK
        BEGIN BLOCK XLXI_11 and2b1
            PIN I0 XLXN_57
            PIN I1 Rx_ack
            PIN O XLXN_58
        END BLOCK
        BEGIN BLOCK XLXI_6 kcbaud
            PIN SYSCLK SYSCLK
            PIN BAUDx16 XLXN_32
            PIN BaudSel(2:0) BaudSel(2:0)
        END BLOCK
        BEGIN BLOCK XLXI_14 COM_mux
            PIN UART_Tx XLXN_115
            PIN UART_Rx XLXN_113
            PIN COM0_Rx Opto_Rx
            PIN COM1_Tx Serial_Tx
            PIN COM1_Rx Serial_Rx
            PIN COM0_Tx Opto_Tx
            PIN SEL SEL
        END BLOCK
    END NETLIST
    BEGIN SHEET 1 3520 2720
        BEGIN BRANCH Tx_Data(7:0)
            WIRE 592 1376 1632 1376
        END BRANCH
        BEGIN BRANCH Rx_flush
            WIRE 592 624 1632 624
        END BRANCH
        BEGIN BRANCH Rx_Data(7:0)
            WIRE 2160 752 2400 752
        END BRANCH
        BEGIN BRANCH Tx_full
            WIRE 2160 1184 2400 1184
        END BRANCH
        BEGIN BRANCH Rx_full
            WIRE 2160 624 2400 624
        END BRANCH
        BEGIN INSTANCE XLXI_8 1632 784 R0
        END INSTANCE
        BEGIN INSTANCE XLXI_9 1632 1408 R0
        END INSTANCE
        BEGIN BRANCH XLXN_58
            WIRE 1552 192 1616 192
            WIRE 1616 192 1616 560
            WIRE 1616 560 1632 560
        END BRANCH
        BEGIN BRANCH XLXN_59
            WIRE 1264 1664 1296 1664
        END BRANCH
        INSTANCE XLXI_12 880 1920 R0
        INSTANCE XLXI_13 1296 1728 R0
        BEGIN BRANCH Tx_write
            WIRE 592 1504 784 1504
            WIRE 784 1504 784 1664
            WIRE 784 1664 880 1664
            WIRE 784 1504 1280 1504
            WIRE 1280 1504 1280 1600
            WIRE 1280 1600 1296 1600
        END BRANCH
        BEGIN BRANCH XLXN_66
            WIRE 1552 1632 1584 1632
            WIRE 1584 1120 1584 1632
            WIRE 1584 1120 1632 1120
        END BRANCH
        BEGIN BRANCH XLXN_57
            WIRE 1264 224 1296 224
        END BRANCH
        INSTANCE XLXI_10 880 480 R0
        INSTANCE XLXI_11 1296 288 R0
        BEGIN BRANCH Rx_ack
            WIRE 592 224 688 224
            WIRE 688 224 880 224
            WIRE 688 80 688 224
            WIRE 688 80 1280 80
            WIRE 1280 80 1280 160
            WIRE 1280 160 1296 160
        END BRANCH
        BEGIN BRANCH Tx_reset
            WIRE 592 1184 1632 1184
        END BRANCH
        BEGIN DISPLAY 1376 84 TEXT "Pulse Shaper 1 SYSCLK cycle"
            FONT 40 "Arial"
        END DISPLAY
        BEGIN BRANCH XLXN_32
            WIRE 1488 688 1632 688
            WIRE 1488 688 1488 1248
            WIRE 1488 1248 1632 1248
            WIRE 1488 1248 1488 1488
            WIRE 1488 1488 1936 1488
            WIRE 1936 1488 1936 2144
            WIRE 1888 2144 1936 2144
        END BRANCH
        BEGIN DISPLAY 2184 1356 TEXT "Ken Chapmans UART for PicoBlaze"
            FONT 40 "Arial"
        END DISPLAY
        IOMARKER 592 752 SYSCLK R180 28
        IOMARKER 592 1376 Tx_Data(7:0) R180 28
        IOMARKER 592 624 Rx_flush R180 28
        IOMARKER 592 224 Rx_ack R180 28
        IOMARKER 592 1504 Tx_write R180 28
        IOMARKER 592 1184 Tx_reset R180 28
        IOMARKER 2400 752 Rx_Data(7:0) R0 28
        IOMARKER 2400 496 Rx_valid R0 28
        IOMARKER 2400 1184 Tx_full R0 28
        IOMARKER 2400 624 Rx_full R0 28
        BEGIN BRANCH Rx_valid
            WIRE 2160 496 2400 496
        END BRANCH
        BEGIN BRANCH SYSCLK
            WIRE 592 752 688 752
            WIRE 688 752 1632 752
            WIRE 688 752 688 1312
            WIRE 688 1312 1632 1312
            WIRE 688 1312 688 1792
            WIRE 688 1792 880 1792
            WIRE 688 1792 688 2144
            WIRE 688 2144 1504 2144
            WIRE 688 352 880 352
            WIRE 688 352 688 752
        END BRANCH
        BEGIN INSTANCE XLXI_6 1504 2176 R0
        END INSTANCE
        BEGIN DISPLAY 332 1792 TEXT "0=38400 Bd"
            FONT 40 "Arial"
        END DISPLAY
        BEGIN DISPLAY 328 1844 TEXT "1=19200 Bd"
            FONT 40 "Arial"
        END DISPLAY
        BEGIN DISPLAY 332 1892 TEXT "2=9600 Bd"
            FONT 40 "Arial"
        END DISPLAY
        BEGIN DISPLAY 332 1940 TEXT "3=4800 Bd"
            FONT 40 "Arial"
        END DISPLAY
        BEGIN DISPLAY 332 1988 TEXT "4=2400 Bd"
            FONT 40 "Arial"
        END DISPLAY
        BEGIN DISPLAY 332 2036 TEXT "5=1200 Bd"
            FONT 40 "Arial"
        END DISPLAY
        BEGIN DISPLAY 332 2084 TEXT "6=600 Bd"
            FONT 40 "Arial"
        END DISPLAY
        BEGIN DISPLAY 332 2132 TEXT "7=300 Bd"
            FONT 40 "Arial"
        END DISPLAY
        BEGIN BRANCH BaudSel(2:0)
            WIRE 624 2208 1488 2208
            WIRE 1488 2208 1504 2208
        END BRANCH
        IOMARKER 624 2208 BaudSel(2:0) R180 28
        BEGIN INSTANCE XLXI_14 2688 1072 R0
        END INSTANCE
        BEGIN BRANCH XLXN_113
            WIRE 1552 496 1632 496
            WIRE 1552 496 1552 960
            WIRE 1552 960 2688 960
        END BRANCH
        BEGIN BRANCH SEL
            WIRE 2656 1024 2688 1024
        END BRANCH
        IOMARKER 2656 1024 SEL R180 28
        BEGIN DISPLAY 2724 1288 TEXT "Ser_SEL $31F, 0=Opto, 1=RS232"
            FONT 40 "Arial"
        END DISPLAY
        BEGIN BRANCH XLXN_115
            WIRE 2160 1120 2416 1120
            WIRE 2416 912 2416 1120
            WIRE 2416 912 2688 912
        END BRANCH
        BEGIN BRANCH Opto_Tx
            WIRE 3072 832 3104 832
        END BRANCH
        IOMARKER 3104 832 Opto_Tx R0 28
        BEGIN BRANCH Opto_Rx
            WIRE 3072 880 3104 880
        END BRANCH
        IOMARKER 3104 880 Opto_Rx R0 28
        BEGIN BRANCH Serial_Tx
            WIRE 3072 976 3104 976
        END BRANCH
        IOMARKER 3104 976 Serial_Tx R0 28
        BEGIN BRANCH Serial_Rx
            WIRE 3072 1024 3104 1024
        END BRANCH
        IOMARKER 3104 1024 Serial_Rx R0 28
    END SHEET
END SCHEMATIC
