-- T65 Core Wrapper
-- 17.06.2009 mit bereinigten Clock-Signalen von C. Meyer, cm@ctmagazin.de
-- 26.11.2009 Bugfix HALTED, siehe Simulation t65_test.tbw

-- 65C02
-- supported : inc, dec, phx, plx, phy, ply
-- missing : bra, ora, lda, cmp, sbc, tsb*2, trb*2, stz*2, bit*2, wai, stp, jmp, bbr*8, bbs*8

library ieee;
  use ieee.std_logic_1164.all;
  use ieee.std_logic_arith.all;
  use ieee.std_logic_unsigned.all;
library unisim;
use unisim.vcomponents.all;


entity t65_wrap is
  port (
    ADDR         : out   std_logic_vector(15 downto 0);
    DATA_O       : out   std_logic_vector(7 downto 0);
    DATA_I       : in   std_logic_vector(7 downto 0);
    --
    RST          : in    std_logic;
    IRQ          : in    std_logic;
    NMI          : in    std_logic;
	WR_N         : out    std_logic;
	BUSENA_N     : out    std_logic;
	CLK_X4     : out    std_logic;
--	SYNC     : out    std_logic;
    HALT         : in    std_logic;
    HALTED       : out    std_logic;
    RD_N         : out    std_logic;
--    CLK_OUT       : out    std_logic;
    SYSCLK       : in    std_logic
    );
end;


architecture RTL of t65_wrap is
	signal CLK_dcm               : std_logic;

	signal ena_count			: std_logic_vector(1 downto 0) := (others => '0');
	signal clk_count			: std_logic_vector(2 downto 0) := (others => '0');
	signal ena_clk_x1			: std_ulogic;
	signal clk_fb				: std_logic;

  -- cpu
	signal c_rw_l				: std_logic:='1';
	signal c_irq_l				: std_logic:='1';
	signal c_nmi_l				: std_logic:='1';
	signal reset_l				: std_logic:='1';
	signal clk_i				: std_logic;
	signal sync_i				: std_logic;
	signal halt_del			: std_logic;
	signal rd_n_i				: std_logic;
	signal addr_intern		: std_logic_vector(15 downto 0) := (others => '0');
	signal addr_unused		: std_logic_vector(7 downto 0) := (others => '0');
	signal busena_late		: std_logic;
	signal busena_early		: std_logic;

	component T65 is
		port(
			Mode    : in  std_logic_vector(1 downto 0);      -- "00" => 6502, "01" => 65C02, "10" => 65C816
			Res_n   : in  std_logic;
			Enable  : in  std_logic;
			Clk     : in  std_logic;
			Rdy     : in  std_logic;
			Abort_n : in  std_logic;
			IRQ_n   : in  std_logic;
			NMI_n   : in  std_logic;
			SO_n    : in  std_logic;
			R_W_n   : out std_logic;
			Sync    : out std_logic;
			EF      : out std_logic;
			MF      : out std_logic;
			XF      : out std_logic;
			ML_n    : out std_logic;
			VP_n    : out std_logic;
			VDA     : out std_logic;
			VPA     : out std_logic; -- low on vector pull
			A       : out std_logic_vector(23 downto 0);
			DI      : in  std_logic_vector(7 downto 0);
			DO      : out std_logic_vector(7 downto 0)
		);
	end component;
	
	

begin
-- wr schn gewesen, luft aber noch amok

--DCM_inst : DCM
--generic map (
--	CLKDV_DIVIDE => 2.0, --  Divide by: 1.5,2.0,2.5,3.0,3.5,4.0,4.5,5.0,5.5,6.0,6.5
--								--     7.0,7.5,8.0,9.0,10.0,11.0,12.0,13.0,14.0,15.0 or 16.0
--	CLKFX_DIVIDE => 2,   --  Can be any interger from 1 to 32
--	CLKFX_MULTIPLY => 3, --  Can be any integer from 1 to 32
--	CLKIN_DIVIDE_BY_2 => FALSE, --  TRUE/FALSE to enable CLKIN divide by two feature
--	CLKIN_PERIOD => 20.0,          --  Specify period of input clock
--	CLKOUT_PHASE_SHIFT => "NONE", --  Specify phase shift of NONE, FIXED or VARIABLE
--	CLK_FEEDBACK => "1X",         --  Specify clock feedback of NONE, 1X or 2X
--	DESKEW_ADJUST => "SYSTEM_SYNCHRONOUS", --  SOURCE_SYNCHRONOUS, SYSTEM_SYNCHRONOUS or
--														--     an integer from 0 to 15
--	DFS_FREQUENCY_MODE => "LOW",     --  HIGH or LOW frequency mode for frequency synthesis
--	DLL_FREQUENCY_MODE => "LOW",     --  HIGH or LOW frequency mode for DLL
--	DUTY_CYCLE_CORRECTION => TRUE, --  Duty cycle correction, TRUE or FALSE
--	FACTORY_JF => X"C080",          --  FACTORY JF Values
--	PHASE_SHIFT => 0,        --  Amount of fixed phase shift from -255 to 255
--	SIM_MODE => "SAFE", -- Simulation: "SAFE" vs "FAST", see "Synthesis and Simulation
--							  -- Design Guide" for details
--	STARTUP_WAIT => TRUE) --  Delay configuration DONE until DCM LOCK, TRUE/FALSE
--	
--
--port map (
--	CLK0 => clk_fb,     -- 0 degree DCM CLK ouptput
--	CLK180 => open, -- 180 degree DCM CLK output
--	CLK270 => open, -- 270 degree DCM CLK output
--	CLK2X => open,   -- 2X DCM CLK output
--	CLK2X180 => open, -- 2X, 180 degree DCM CLK out
--	CLK90 => open,   -- 90 degree DCM CLK output
--	CLKDV => open,   -- Divided DCM CLK out (CLKDV_DIVIDE)
--	CLKFX => CLK_dcm,   -- DCM CLK synthesis out (M/D)
--	CLKFX180 => open, -- 180 degree CLK synthesis out
--	LOCKED => open, -- DCM LOCK status output
--	PSDONE => open, -- Dynamic phase adjust done output
--	STATUS => open, -- 8-bit DCM status bits output
--	CLKFB => clk_fb,   -- DCM clock feedback
--	CLKIN => SYSCLK,   -- Clock input (from IBUFG, BUFG or DCM)
--	PSCLK => '0',   -- Dynamic phase adjust clock input
--	PSEN => '0',     -- Dynamic phase adjust enable input
--	PSINCDEC => '0', -- Dynamic phase adjust increment/decrement
--	RST => '0'        -- DCM asynchronous reset input
--);


--CLK_dcm <= SYSCLK;	-- ohne DCM

ADDR <= addr_intern;
clk_i <= clk_count(2) when addr_intern(15 downto 8)= x"06" 
--	else CLK_dcm when addr_intern(15 downto 8) >= x"08" 
	else SYSCLK;
	
CLK_X4 <= clk_i;

p_wait : process(ena_count(1),RST)  -- sync delay
	begin
		if RST='1' then
			halt_del<='0';
		elsif rising_edge(ena_count(1)) then
-- HALT sync fr DMA-Zugriff
			halt_del <= HALT;
		end if;
	end process;

p_clk : process(SYSCLK,RST)  -- clock divider
	begin
		if RST='1' then
			clk_count<="000";
--		elsif rising_edge(CLK_dcm) then
		elsif rising_edge(SYSCLK) then
			clk_count <= clk_count + 1;
		end if;
	end process;

p_ena : process(clk_i,RST)  -- clock divider for slow IO $0600
	begin
		if RST='1' then
			ena_clk_x1 <= '0';
			ena_count <= "00";
		elsif rising_edge(clk_i) then
			ena_count <= ena_count + 1;
			if halt_del = '0' then	-- 
				ena_clk_x1 <= ena_count(1) and ena_count(0);
				busena_late <= not ena_count(1);
				busena_early <= ena_count(1) xnor ena_count(0); -- fr write, um SRAM-Hold-Zeit vorgezogen
			else
				ena_clk_x1 <= '0';
				busena_late <= '1';
				busena_early <= '1';
			end if;
		end if;
	end process;


  cpu : T65 -- main cpu
      port map (
          Mode    => "01",	-- 00=6502, 01=65C02
          Res_n   => reset_l,
          Enable  => ena_clk_x1,
          Clk     => clk_i,
          Rdy     => '1', -- not halt_i,
          Abort_n => '1',
          IRQ_n   => c_irq_l,
          NMI_n   => c_nmi_l,
          SO_n    => '1',
          R_W_n   => c_rw_l,
          Sync    => sync_i,
          EF      => open,
          MF      => open,
          XF      => open,
          ML_n    => open,
          VP_n    => open,
          VDA     => open,
          VPA     => open,
          A(15 downto 0)  => addr_intern,
          A(23 downto 16)  => addr_unused,
          DI      => DATA_I,
          DO      => DATA_O
      );
		
	HALTED<= halt_del and HALT;
	c_irq_l <= not IRQ;
	c_nmi_l <= not NMI;
	WR_N <= busena_early when c_rw_l='0' else '1'; -- c_rw_l or (not ena_clk_x1_l);
--	WR_N <= busena_late when c_rw_l='0' else '1'; -- c_rw_l or (not ena_clk_x1_l);
	RD_N <= busena_late when c_rw_l='1'  else '1';
	reset_l <= not RST;
	BUSENA_N <= busena_late;

end RTL;
