----------------------------------------------------------------------------------
-- Company: c't-Lab
-- Engineer: Carsten Meyer
-- 
-- Create Date:    17:17:17 04/27/2008 
-- Design Name: 
-- Module Name:    SPI-INmux8 - Behavioral 
-- Project Name: 
-- Target Devices: 
-- Tool versions: 
-- Description: 4fach Input Multiplexer fr SPI-Ausgangsschieberegister
--
-- Dependencies: 
--
-- Revision: 
-- Revision 0.01 - File Created
-- Additional Comments: 
--
----------------------------------------------------------------------------------
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;

---- Uncomment the following library declaration if instantiating
---- any Xilinx primitives in this code.
--library UNISIM;
--use UNISIM.VComponents.all;

entity SPI_inmux4 is
    Port ( 	CLK: in STD_LOGIC;
				ENA: in STD_LOGIC;
				SEL : in STD_LOGIC_VECTOR (1 downto 0);
				D0 : in  STD_LOGIC_VECTOR (31 downto 0);
				D1 : in  STD_LOGIC_VECTOR (31 downto 0);
				D2 : in  STD_LOGIC_VECTOR (31 downto 0);
				D3 : in  STD_LOGIC_VECTOR (31 downto 0);
				Q : out STD_LOGIC_VECTOR (31 downto 0) );
end SPI_inmux4;

architecture Behavioral of SPI_inmux4 is

begin
	process begin  
		wait until (CLK'event and CLK = '1');
		if ENA = '1' then
			case SEL is
				when "00" => Q <= D0;
				when "01" => Q <= D1; 
				when "10" => Q <= D2;
				when others => Q <= D3;
			end case;
		end if;
	end process;
end Behavioral;

