----------------------------------------------------------------------------------
-- Company: 
-- Engineer: Carsten Meyer
-- 
-- Create Date:	17:17:17 04/27/2008 
-- Design Name:	SRAM Interface fr AutoIncrement-LoadCore und Glue-Logik
-- Module Name:	BASIC_Glue 
-- Project Name:	ct-Lab BASIC on Chip
----------------------------------------------------------------------------------

library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;

-- Uncomment the following library declaration if instantiating
-- any Xilinx primitives in this code.
--library UNISIM;
--use UNISIM.VComponents.all;

entity BASIC_glue is
	Port ( 	CLK_X4		: in  STD_LOGIC;
	SYSCLK		: in  STD_LOGIC;
-- UART Interface
		Rx_full		: in  STD_LOGIC;
		Tx_full		: in  STD_LOGIC;
		Rx_valid	: in  STD_LOGIC;
		Rx_DATAi	: in  std_logic_vector (7 downto 0);
		Tx_write	: out STD_LOGIC;
		Rx_ack		: out STD_LOGIC;
		Rx_flush	: out STD_LOGIC;
		Tx_reset	: out STD_LOGIC;

		RAM_ADR		: out STD_LOGIC_VECTOR (18 downto 0);
		CPU_ADR		: in  STD_LOGIC_VECTOR (15 downto 0);
		LC_ADR		: in  STD_LOGIC_VECTOR (18 downto 0);
		CPU_DATAo	: out STD_LOGIC_VECTOR (7 downto 0); 
		CPU_DATAi	: in  STD_LOGIC_VECTOR (7 downto 0); 
		TEXTREAD		: in  STD_LOGIC_VECTOR (7 downto 0);	-- bei Adr $330 bis $33F
		CPU_RST		: in  STD_LOGIC;
		CPU_RDn		: in  STD_LOGIC;
		CPU_WRn		: in  STD_LOGIC;
		LC_WEn		: in  STD_LOGIC;
		LC_OEn		: in  STD_LOGIC;	
		RAM_OEn		: out STD_LOGIC;
		RAM_WEn		: out STD_LOGIC;
		GCMD_WR		: out STD_LOGIC;	-- auf Adr $320 bis $32F
		TCMD_WR		: out STD_LOGIC;	-- auf Adr $330 bis $33F
		IRQ_ACK		: out STD_LOGIC;	-- IRQ Acknowledge bei Aufrufen des IRQ-Vektors
		IRQ_CLR		: out STD_LOGIC;  -- IRQ-Clear in der IRQvec-Routine
		Bd_SEL		: out STD_LOGIC_VECTOR (2 downto 0); 
		SER_SEL		: out STD_LOGIC;	-- Select UART input/output
		DMA			: out STD_LOGIC;	-- hier nur fr TestLED
		LC_ENA		: in  STD_LOGIC;
		LC_DATA  	: in  std_logic_vector (31 downto 0);
		RAM_DATAz	: inout  std_logic_vector (7 downto 0);
		COMin			: in  STD_LOGIC_VECTOR (7 downto 0);	-- auf $0309 Lesen, war Eingabe-Port auf $B700
		COMout		: out STD_LOGIC_VECTOR (7 downto 0);	-- auf $0309 Schreiben, war Ausgabe-Port auf $B600
		IRQsrc		: in  STD_LOGIC_VECTOR (7 downto 0);	-- auf $030E Lesen, war RegSel-Port auf $BF00
		INTstr		: out STD_LOGIC_VECTOR (7 downto 0);	-- auf $030E Schreiben, war Flag-Port fr F_Int
		ASCII			: in  STD_LOGIC_VECTOR (7 downto 0);	-- auf $0307 Lesen, ASCII-Code von SPI (Keyboard-Emulation)
		VSYNC			: in  STD_LOGIC;
		PORT340	: out STD_LOGIC_VECTOR (7 downto 0); 
		PORT341	: out STD_LOGIC_VECTOR (7 downto 0); 
		PORT342	: out STD_LOGIC_VECTOR (7 downto 0); 
		PORT343	: out STD_LOGIC_VECTOR (7 downto 0); 
		PIN340	: in  STD_LOGIC_VECTOR (7 downto 0);
		PIN341	: in  STD_LOGIC_VECTOR (7 downto 0);
		PIN342	: in  STD_LOGIC_VECTOR (7 downto 0);
		PIN343	: in  STD_LOGIC_VECTOR (7 downto 0);
		IO600_WEn	: out STD_LOGIC;
		IO600_RDn	: out STD_LOGIC;
		PLOTSYNC	: in  STD_LOGIC;
		PS2_TxData	: out STD_LOGIC_VECTOR (7 downto 0) := x"00";
		PS2_TxStr	: out STD_LOGIC;
		PS2_RxData	: in  STD_LOGIC_VECTOR (7 downto 0);	-- auf $0304, auch auf $0308 mit Shift im oberen Bit
		PS2_TxBusy		: in  STD_LOGIC
	 );

end BASIC_glue;

architecture behave of BASIC_glue is

signal bank: STD_LOGIC_VECTOR (2 downto 0) :="000";
signal Mult_out : STD_LOGIC_VECTOR (31 downto 0) := x"00000000";
signal Mult_in1 : STD_LOGIC_VECTOR (15 downto 0) := x"0000";
signal Mult_in2 : STD_LOGIC_VECTOR (15 downto 0) := x"0000";

-- Lesbare Register
signal TextX : STD_LOGIC_VECTOR (7 downto 0) := x"00";
signal TextY : STD_LOGIC_VECTOR (7 downto 0) := x"00";
signal CursX : STD_LOGIC_VECTOR (7 downto 0) := x"00";
signal CursY : STD_LOGIC_VECTOR (7 downto 0) := x"00";
signal CursorStyle : STD_LOGIC_VECTOR (2 downto 0) := "111";
signal TextColor : STD_LOGIC_VECTOR (7 downto 0) := x"00";
signal write_cycle	: STD_LOGIC := '1';
signal write_delayed	: STD_LOGIC := '1';



begin

Mult_Out <= Mult_in1 * Mult_in2;
write_cycle <= CPU_WRn and write_delayed;

process(LC_ENA, CPU_RST, CLK_X4)

begin
	if (LC_ENA='1' or CPU_RST='1') then -- Reset
		write_delayed <= '1';		
	elsif rising_edge(CLK_X4) then
		write_delayed <= CPU_WRn;
	end if;
end process;

process(CPU_ADR, CPU_DATAi, CPU_RDn, CPU_WRn, LC_ADR, LC_ENA, LC_WEn, CPU_RST, CLK_X4)
-- variable cpu_data_temp	: STD_LOGIC_VECTOR (7 downto 0);

begin
	IRQ_CLR <= '0';
	if (LC_ENA='1' or CPU_RST='1') then -- AutoIncrement-Load durchschalten, gleichzeitig Reset
		RAM_ADR <= LC_ADR;
		if LC_OEn='0' then	-- es wird vom AVR gelesen
			RAM_DATAz <= (others => 'Z');
			RAM_WEn<='1';			-- Schreiben sperren
			RAM_OEn<=LC_OEn;
		else
			RAM_DATAz <= LC_DATA(7 downto 0);
			RAM_OEn<='1';			-- Lesen sperren
			RAM_WEn<=LC_WEn;	-- Schreiben zulassen
		end if;
		SER_SEL <= '0';
		DMA <= '1';
		COMout<=x"00";
		INTstr<=x"00";
		bank<="000";
		Bd_SEL<="000";
	else
		DMA <= '0';
		IRQ_ACK <= '0';
		RAM_ADR(15 downto 0) <= CPU_ADR;
		GCMD_WR <= '0';
		TCMD_WR <= '0';
		RAM_DATAz <= (others => 'Z');	-- nur beim Schreiben freischalten!
		Tx_reset <='0';
		Rx_flush <='0';
		Tx_write <='0';
		Rx_ack <='1';
		IO600_WEn <= '1';	
		IO600_RDn <= '1';			
		RAM_WEn<='1';			
		RAM_OEn <= '1';	
		PS2_TxStr <='0';
		if CPU_ADR(15 downto 8) = x"03" then -- innerhalb internem IO-Bereich
			if CPU_ADR(7 downto 0) = x"02" then  -- PIO 8255 Port PC0..7, Input und Output
				if (CPU_RDn='0') then	-- Lesen von Port C
					CPU_DATAo(7) <= VSYNC;
					CPU_DATAo(6) <= PLOTSYNC; -- High whrend Grafik-Frame vertikal ON
					CPU_DATAo(5 downto 0) <= "000000";
				end if;
			elsif CPU_ADR(7 downto 0) = x"03" then -- Bank Select $0303
				if CPU_WRn='0' then	-- Schreiben auf Port
					bank <= CPU_DATAi(2 downto 0);
				end if;			

-- PS/2 Interface, neu, mit Tx, auch fr Maus geeignet

			elsif CPU_ADR(7 downto 0) = x"04" then  -- Port x0304, I/O PS/2
				if (CPU_RDn='0') then
					CPU_DATAo <= PS2_RxData;	-- Lesen von Keyboard-Scancode
				end if;
				if (CPU_WRn='0') then	-- Schreiben auf Port
					PS2_TxData <= CPU_DATAi;
					PS2_TxStr <='1';
				end if;
				
			elsif CPU_ADR(7 downto 0) = x"05" then  -- Port x0305, Status von PS/2
				if (CPU_RDn='0') then
					CPU_DATAo(7) <= PS2_TxBusy;
					CPU_DATAo(6 downto 0) <= "0000000";
				end if;
				
			elsif CPU_ADR(7 downto 0) = x"07" then -- Key-Simulator from AVR
				if (CPU_RDn='0') then
					CPU_DATAo <= ASCII;	-- Lesen von SPI-ASCII
				end if;
			elsif CPU_ADR(7 downto 0) = x"09" then -- Input from AVR
				if (CPU_RDn='0') then
					CPU_DATAo <= COMin;	-- Lesen von Port $0309
				end if;
				if CPU_WRn='0' then	-- Schreiben auf Port $0309
					COMout <=CPU_DATAi;
				end if;			
			elsif CPU_ADR(7 downto 0) = x"0D" then -- IRQ-Source, IntEna
				if (CPU_RDn='0') then
					CPU_DATAo <= IRQsrc;	-- Lesen von IRQ-Source
				end if;
				if CPU_WRn='0' then	-- Int-Flag F_INT
					INTstr<=CPU_DATAi;
				end if;
			elsif CPU_ADR(7 downto 0) = x"0E" then -- Zugriff auf Vector lscht IRQ-Anfrage
				if (CPU_RDn='0') then
					IRQ_ACK <= '1';	-- Lesen von IRQ-Source
				end if;
			elsif CPU_ADR(7 downto 0) = x"0F" then -- Clear IRQ Latch
				IRQ_CLR <= not CPU_RDn;
				
-- Ken Chapmans UART, 16 Byte FIFO ab $0310
			elsif CPU_ADR(7 downto 0) = x"10" then -- UART Datenregister $310=784
				if (CPU_RDn='0') then
					CPU_DATAo <= Rx_DATAi;
					Rx_ack <='0';	-- nchstes Byte fr nchstes Lesen bereitstellen
				end if;
				if (CPU_WRn='0') then	-- Schreiben auf Port
					Tx_write <='1';
				end if;
--			elsif CPU_ADR(7 downto 0) = x"11" then -- UART Rx_ack-Register
--				if ((CPU_RDn='0') or (CPU_WRn='0')) then	
--					-- Lesen oder schreiben ACK, holt nchstes Byte aus FIFO
--					Rx_ack <='1';
--				end if;
			elsif CPU_ADR(7 downto 0) = x"12" then -- UART Rx-Statusregister $312=786
				if (CPU_RDn='0') then	-- Lesen 
					CPU_DATAo(7) <= Rx_valid;
					CPU_DATAo(6) <= Rx_full;
					CPU_DATAo(5 downto 0) <= "000000";
				end if;
			elsif CPU_ADR(7 downto 0) = x"13" then -- UART Tx-Statusregister $313=787
				if (CPU_RDn='0') then	-- Lesen 
					CPU_DATAo(7) <= '1';
					CPU_DATAo(6) <= Tx_full;
					CPU_DATAo(5 downto 0) <= "000000";
				end if;
			elsif CPU_ADR(7 downto 0) = x"14" then -- UART Rx-Clear-Register $314=788
				if (CPU_WRn='0') then	
					-- Schreiben Flush Rx-FIFO
					Rx_flush <='1';
				end if;
			elsif CPU_ADR(7 downto 0) = x"15" then -- UART Tx-Clear-Register $315=789
				if (CPU_WRn='0') then	
					-- Schreiben Reset Tx-FIFO
					Tx_reset <='1';
				end if;
			elsif CPU_ADR(7 downto 0) = x"1E" then -- UART PortSelect-Register $31F=799
				if (CPU_WRn='0') then	
					-- Serial Baud Select, 0 = 38400, 1 = 19200, 2 = 9600 ... 7 = 300 Bd
					Bd_SEL<=CPU_DATAi(2 downto 0);
				end if;
			elsif CPU_ADR(7 downto 0) = x"1F" then -- UART PortSelect-Register $31F=799
				if (CPU_WRn='0') then	
					-- Serial Port Select, 0 = OptoBusCore, 1 = SerBusCore
					SER_SEL <= CPU_DATAi(0);	
				end if;

-- extern end-dekodiert, Grafik- und Text-Register
			elsif CPU_ADR(7 downto 4) = x"2" then -- 16 Grafik-Register $32x
				-- Schreiben Grafik-Unit GTEXT
				GCMD_WR <= not CPU_WRn;
			elsif CPU_ADR(7 downto 4) = x"3" then -- 16 Text-Register $32x
				-- Schreiben in Grafik-Unit GTEXT
				TCMD_WR <= not CPU_WRn;	-- TCMD_WR ist active high!
				-- Gleichzeitig Register schreiben/lesen
				case CPU_ADR(3 downto 0) is
				when x"0" =>  -- Cursor Position Xnew Byte, setzt auch Textpositition
					if CPU_WRn='0' then
						CursX <= CPU_DATAi;
						TextX <= CPU_DATAi;
					end if;
					if CPU_RDn='0' then	-- Lesen 
						CPU_DATAo <= CursX;
					end if;
				when x"1" =>  -- Cursor Position Ynew Byte, setzt auch Textpositition
					if CPU_WRn='0' then
						CursY <= CPU_DATAi;
						TextY <= CPU_DATAi;
					end if;
					if CPU_RDn='0' then	-- Lesen 
						CPU_DATAo <= CursY;
					end if;
				when x"2" =>  -- Cursor Style
					if CPU_WRn='0' then
						CursorStyle <= CPU_DATAi(2 downto 0);
					end if;
					if CPU_RDn='0' then	-- Lesen 
						CPU_DATAo <= "00000" & CursorStyle;
					end if;
				when x"3" =>  -- TextColor Byte
					if CPU_WRn='0' then
						TextColor <= CPU_DATAi;
					end if;
					if CPU_RDn='0' then	-- Lesen 
						CPU_DATAo <= TextColor;
					end if;
				when x"4" =>  -- Read/Write Position Text X (cols) Byte
					if CPU_WRn='0' then
						TextX <= CPU_DATAi;
					end if;
					if CPU_RDn='0' then	-- Lesen 
						CPU_DATAo <= TextX;
					end if;
				when x"5" =>  -- Read/Write Position Text Y (rows) Byte
					if CPU_WRn='0' then
						TextY <= CPU_DATAi;
					end if;
					if CPU_RDn='0' then	-- Lesen 
						CPU_DATAo <= TextY;
					end if;
				when others =>	-- TEXTRAM_WR auf $0337, hier lesen:
					if CPU_RDn='0' then	-- Lesen 
						CPU_DATAo <= TEXTREAD;					
					end if;
				end case;

-- interne Ports zur allgemeinen Verwendung				
			elsif CPU_ADR(7 downto 0) = x"40" then -- Port $340 usw.
				if CPU_WRn='0' then	-- Schreiben auf Port
					PORT340<=CPU_DATAi;
				end if;			
				if (CPU_RDn='0') then
					CPU_DATAo <= PIN340;	-- Lesen von Port IN
				end if;				
			elsif CPU_ADR(7 downto 0) = x"41" then -- Port $340 usw.
				if CPU_WRn='0' then	-- Schreiben auf Port OUT
					PORT341<=CPU_DATAi;
				end if;	
				if (CPU_RDn='0') then
					CPU_DATAo <= PIN341;	-- Lesen von Port IN
				end if;				
			elsif CPU_ADR(7 downto 0) = x"42" then -- Port $340 usw.
				if CPU_WRn='0' then	-- Schreiben auf Port
					PORT342<=CPU_DATAi;
				end if;			
				if (CPU_RDn='0') then
					CPU_DATAo <= PIN342;	-- Lesen von Port IN
				end if;				
			elsif CPU_ADR(7 downto 0) = x"43" then -- Port $340 usw.
				if CPU_WRn='0' then	-- Schreiben auf Port
					PORT343<=CPU_DATAi;
				end if;			
				if (CPU_RDn='0') then
					CPU_DATAo <= PIN343;	-- Lesen von Port IN
				end if;				

-- 16 Bit unsigned Multiplizierer, 32-Bit-Ergebnis
			elsif CPU_ADR(7 downto 0) = x"E8" then -- Port $3E8 = POKE 1000 usw.
				if CPU_WRn='0' then	-- Schreiben auf Mult_in1 low
					Mult_in1(7 downto 0)<=CPU_DATAi;
				end if;			
				if (CPU_RDn='0') then
					CPU_DATAo <= Mult_out(7 downto 0);	-- Lesen von Mult_out0 LSB
				end if;				
			elsif CPU_ADR(7 downto 0) = x"E9" then -- Port $3E9 = POKE 1001
				if CPU_WRn='0' then	-- Schreiben auf Mult_in1 high
					Mult_in1(15 downto 8)<=CPU_DATAi;
				end if;	
				if (CPU_RDn='0') then
					CPU_DATAo <= Mult_out(15 downto 8);	-- Lesen von Mult_out1
				end if;				
			elsif CPU_ADR(7 downto 0) = x"EA" then
				if CPU_WRn='0' then	-- Schreiben auf Mult_in2 low
					Mult_in2(7 downto 0)<=CPU_DATAi;
				end if;			
				if (CPU_RDn='0') then
					CPU_DATAo <= Mult_out(23 downto 16);	-- Lesen von Mult_out2
				end if;				
			elsif CPU_ADR(7 downto 0) = x"EB" then
				if CPU_WRn='0' then	-- Schreiben auf Mult_in2 high
					Mult_in2(15 downto 8)<=CPU_DATAi;
				end if;			
				if (CPU_RDn='0') then
					CPU_DATAo <= Mult_out(31 downto 24);	-- Lesen von Mult_out3 MSB
				end if;				
			
-- ggf. weitere $3xx Ports hier vor "end if" einfgen			
			end if;
			
		elsif CPU_ADR(15 downto 8) >= x"B2" then	-- ab Block $B200 schreibgeschtzt
			RAM_OEn <= CPU_RDn;			
			CPU_DATAo <= RAM_DATAz;
			RAM_ADR(18 downto 16) <= "000";
		else	-- normaler RAM-Bereich und externes IO600
			CPU_DATAo <= RAM_DATAz;
			if CPU_ADR(15 downto 8) = x"06" then -- innerhalb externem IO-Bereich
				IO600_WEn <= CPU_WRn;	
				IO600_RDn <= CPU_RDn;
			else
				RAM_WEn <= CPU_WRn;	
				RAM_OEn <= CPU_RDn;			
			end if;
			if write_cycle ='0' then
				RAM_DATAz <= CPU_DATAi;	-- berschreibt oben gesetzten Tristate-Zustand
			end if;
			if CPU_ADR(15 downto 11) = "00000" then	-- $0000 bis $07FF = Zeropage, Stack und Buffer
				RAM_ADR(18 downto 16) <= "000";
			else
				RAM_ADR(18 downto 16) <= bank;	-- zwischen $0800 und $AFFF
			end if;
		end if;
	end if;
end process;

-- Scancode-Umsetzer, liefert getrennte Shift-, ESC- und CTRL-Signale

--kbd_ctrl <= ps2_ctrl when (ps2_keydown='1') else ('1');--  (spi_ctrl); -- active low!
--kbd_shift <= ps2_shift when (ps2_keydown='1') else ('1'); -- active low!
--kbd_esc <= ps2_esc when (ps2_keydown='1') else ('1'); -- active low!
--
--process(SYSCLK, LC_ENA)	-- LC_ENA auch als Reset; Achtung: gleicher Takt wie ps2kbd-Modul!
--
--begin
--	if LC_ENA='1' then	-- auch als Reset
--		ps2_keydown<= '0';
--		ps2_shift<='1';	-- neg. Logik!
--		ps2_ctrl<='1';	-- neg. Logik!		
--	elsif rising_edge(SYSCLK) then -- gleicher Takt wie ps2kbd-Modul
--		if PS2_DWN='1' then
--			if (PS2_CODE=x"12") or (PS2_CODE=x"59") then	-- zwei Shift-Tasten
--				ps2_shift<='0';	-- neg. Logik!
--			elsif PS2_CODE(6 downto 0)="0010100" then	-- Ctrl-Tasten $14, $94
--				ps2_ctrl<='0';	-- neg. Logik!
--			elsif PS2_CODE=x"76" then	-- ESC-Taste
--				ps2_esc<='0';	-- neg. Logik!
--				ps2_keydown<='1';
--			else
--				ps2_keydown<='1';
--			end if;
--		end if;
--		if PS2_UP='1' then
--			if (PS2_CODE=x"12") or (PS2_CODE=x"59") then	-- zwei Shift-Tasten
--				ps2_shift<='1';	-- neg. Logik!
--			elsif PS2_CODE(6 downto 0)="0010100" then	-- Ctrl-Tasten $14, $94
--				ps2_ctrl<='1';	-- neg. Logik!
--			elsif PS2_CODE=x"76" then	-- ESC-Taste
--				ps2_esc<='1';	-- neg. Logik!
--				ps2_keydown<='0';
--			else
--				ps2_keydown<='0';
--			end if;
--		end if;
--	end if;
--end process;

end behave;

