-- BASIC-52 with updated baud rate recognition

library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.numeric_std.all;

entity ROM52 is
	port(
		Clk	: in std_logic;
		A	: in std_logic_vector(12 downto 0);
		D	: out std_logic_vector(7 downto 0)
	);
end ROM52;

architecture rtl of ROM52 is
	signal A_r : std_logic_vector(12 downto 0);
	type rom_type is array(0 to 8191) of std_logic_vector(7 downto 0);
	signal ROM : rom_type := ( 
"01100001",
"10000111",
"00110111",
"00100000",
"00110001",
"00101101",
"11000000",
"11010000",
"00000010",
"01000000",
"00000011",
"11000000",
"11010000",
"00100000",
"00101110",
"00010000",
"00000010",
"01000000",
"00001011",
"00100000",
"00010010",
"00101011",
"11000000",
"11010000",
"00000010",
"01000000",
"00010011",
"11000000",
"11010000",
"00000010",
"00011111",
"01111000",
"00000010",
"00011000",
"11111100",
"11000000",
"11010000",
"00100000",
"00011111",
"00011100",
"00000010",
"01000000",
"00100011",
"11000000",
"11010000",
"00000010",
"01000000",
"00101011",
"00000010",
"00011001",
"00110110",
"00100000",
"00100110",
"00001000",
"11000010",
"10010110",
"00110000",
"10110010",
"11111101",
"11010010",
"10010110",
"00110010",
"00000010",
"00100000",
"01000000",
"11010010",
"00010110",
"00110010",
"00000010",
"00100000",
"01010000",
"00010111",
"01111110",
"00010010",
"00001110",
"00001111",
"11100000",
"00001111",
"11010110",
"00000100",
"10010101",
"00000110",
"11010010",
"00000110",
"10111001",
"00000110",
"10011111",
"00010011",
"10010111",
"00010011",
"00010110",
"00010001",
"10011011",
"00010111",
"00111000",
"00010011",
"11110101",
"00010111",
"00010011",
"00010100",
"10000011",
"00010100",
"01101111",
"00010100",
"01111000",
"00010011",
"10001100",
"00010011",
"11000110",
"00010011",
"11010010",
"00010011",
"11010110",
"00010011",
"11001100",
"00010011",
"11000001",
"00010011",
"10110000",
"00010011",
"01111010",
"00010011",
"01011000",
"00010011",
"10000000",
"00010100",
"10000001",
"00010001",
"01011000",
"00010001",
"10111011",
"00010001",
"01011100",
"00010010",
"01111000",
"00010011",
"10011000",
"00010011",
"00010010",
"00010001",
"11001011",
"00010010",
"10101011",
"00010011",
"10100001",
"00010011",
"10101001",
"00010100",
"01101010",
"00010011",
"11011100",
"00010100",
"10010100",
"00010111",
"00001000",
"00010111",
"00011000",
"00001111",
"11011100",
"00010110",
"00111010",
"00010111",
"00100000",
"00010100",
"10100100",
"00010100",
"10101000",
"00010100",
"10101100",
"00010100",
"10110010",
"00010100",
"10111000",
"00010100",
"10111110",
"00010100",
"11000010",
"00010100",
"11000110",
"00010100",
"11001010",
"00010100",
"11010000",
"00010100",
"11010100",
"00001111",
"01000110",
"00010110",
"01000111",
"00010100",
"11011011",
"00010101",
"10100101",
"00010000",
"10000101",
"00001101",
"01101000",
"00001110",
"11010000",
"00001110",
"11011000",
"00000111",
"10001011",
"00001000",
"00001000",
"00000001",
"00001111",
"00001110",
"00001010",
"00001000",
"00001010",
"00001000",
"00000011",
"00000101",
"00000100",
"00001100",
"00000110",
"00000110",
"00000110",
"00000110",
"00000110",
"00000110",
"00001111",
"00001111",
"00001111",
"00001111",
"00001111",
"00001111",
"00001111",
"00001111",
"00001111",
"00001111",
"00001111",
"00001111",
"00001111",
"00001111",
"01010011",
"01010100",
"01001111",
"01010000",
"00100010",
"01010100",
"01010010",
"01011001",
"00100000",
"01000001",
"01000111",
"01000001",
"01001001",
"01001110",
"00100010",
"01010010",
"01000101",
"01000001",
"01000100",
"01011001",
"00100010",
"00100000",
"00101101",
"00100000",
"01001001",
"01001110",
"00100000",
"01001100",
"01001001",
"01001110",
"01000101",
"00100000",
"00100010",
"00001000",
"00001000",
"00010000",
"00110011",
"00001011",
"00001011",
"00000110",
"01010110",
"00011000",
"00111000",
"00000100",
"01100001",
"00010111",
"01101010",
"00010111",
"01110110",
"00000101",
"00110110",
"00000100",
"01011010",
"00001001",
"01110001",
"00000110",
"10001001",
"00001010",
"01111001",
"00001010",
"10101101",
"00010110",
"01111101",
"00001100",
"00101100",
"00011001",
"00100101",
"00011001",
"00101010",
"00001010",
"10000000",
"00001100",
"00110000",
"00001110",
"01100110",
"00001101",
"01100100",
"00000110",
"00000110",
"00010110",
"11110000",
"00011001",
"00010010",
"00001100",
"00101110",
"00001000",
"01011110",
"00001110",
"01011001",
"00010100",
"00000100",
"00001011",
"00010001",
"00001111",
"00001000",
"00001011",
"11010001",
"00001110",
"11111111",
"00001011",
"01100010",
"00010011",
"11111010",
"00001100",
"11101110",
"00001101",
"11111000",
"00001011",
"11100110",
"00001110",
"11101111",
"00001011",
"00010011",
"00001010",
"10001001",
"00001011",
"00110000",
"00001010",
"00111111",
"00001010",
"11111111",
"00001011",
"00000100",
"00010111",
"01111110",
"00011000",
"01010101",
"00001111",
"11101000",
"00001111",
"11101100",
"00000101",
"00001100",
"00000111",
"10111110",
"10000000",
"01001100",
"01000101",
"01010100",
"10000001",
"01000011",
"01001100",
"01000101",
"01000001",
"01010010",
"10000010",
"01010000",
"01010101",
"01010011",
"01001000",
"10000011",
"01000111",
"01001111",
"01010100",
"01001111",
"10000100",
"01010000",
"01010111",
"01001101",
"10000101",
"01010000",
"01001000",
"00110000",
"00101110",
"10000110",
"01010101",
"01001001",
"10000111",
"01010101",
"01001111",
"10001000",
"01010000",
"01001111",
"01010000",
"10001001",
"01010000",
"01010010",
"01001001",
"01001110",
"01010100",
"10001001",
"01010000",
"00101110",
"10001001",
"00111111",
"10001010",
"01000011",
"01000001",
"01001100",
"01001100",
"10001011",
"01000100",
"01001001",
"01001101",
"10001100",
"01010011",
"01010100",
"01010010",
"01001001",
"01001110",
"01000111",
"10001101",
"01000010",
"01000001",
"01010101",
"01000100",
"10001110",
"01000011",
"01001100",
"01001111",
"01000011",
"01001011",
"10001111",
"01010000",
"01001000",
"00110001",
"00101110",
"10010000",
"01010011",
"01010100",
"01001111",
"01010000",
"10010001",
"01001111",
"01001110",
"01010100",
"01001001",
"01001101",
"01000101",
"10010010",
"01001111",
"01001110",
"01000101",
"01011000",
"00110001",
"10010011",
"01010010",
"01000101",
"01010100",
"01001001",
"10010100",
"01000100",
"01001111",
"10010101",
"01010010",
"01000101",
"01010011",
"01010100",
"01001111",
"01010010",
"01000101",
"10010110",
"01010010",
"01000101",
"01001101",
"10010111",
"01001110",
"01000101",
"01011000",
"01010100",
"10011000",
"01001111",
"01001110",
"01000101",
"01010010",
"01010010",
"10011001",
"01001111",
"01001110",
"10011010",
"01001001",
"01001110",
"01010000",
"01010101",
"01010100",
"10011011",
"01010010",
"01000101",
"01000001",
"01000100",
"10011100",
"01000100",
"01000001",
"01010100",
"01000001",
"10011101",
"01010010",
"01000101",
"01010100",
"01010101",
"01010010",
"01001110",
"10011110",
"01001001",
"01000110",
"10011111",
"01000111",
"01001111",
"01010011",
"01010101",
"01000010",
"10100000",
"01000110",
"01001111",
"01010010",
"10100001",
"01010111",
"01001000",
"01001001",
"01001100",
"01000101",
"10100010",
"01010101",
"01001110",
"01010100",
"01001001",
"01001100",
"10100011",
"01000101",
"01001110",
"01000100",
"10100100",
"01010100",
"01000001",
"01000010",
"10100101",
"01010100",
"01001000",
"01000101",
"01001110",
"10100110",
"01010100",
"01001111",
"10100111",
"01010011",
"01010100",
"01000101",
"01010000",
"10101000",
"01000101",
"01001100",
"01010011",
"01000101",
"10101001",
"01010011",
"01010000",
"01000011",
"10101010",
"01000011",
"01010010",
"10101011",
"01001001",
"01000100",
"01001100",
"01000101",
"10101100",
"01010011",
"01010100",
"01000000",
"10101101",
"01001100",
"01000100",
"01000000",
"10101110",
"01010000",
"01000111",
"01001101",
"10101111",
"01010010",
"01010010",
"01001111",
"01001101",
"11100000",
"00101000",
"11100001",
"00101010",
"00101010",
"11100010",
"00101010",
"11100011",
"00101011",
"11100100",
"00101111",
"11100101",
"00101101",
"11100110",
"00101110",
"01011000",
"01001111",
"01010010",
"00101110",
"11100111",
"00101110",
"01000001",
"01001110",
"01000100",
"00101110",
"11101000",
"00101110",
"01001111",
"01010010",
"00101110",
"11101010",
"00111101",
"11101011",
"00111110",
"00111101",
"11101100",
"00111100",
"00111101",
"11101101",
"00111100",
"00111110",
"11101110",
"00111100",
"11101111",
"00111110",
"10110000",
"01000001",
"01000010",
"01010011",
"10110001",
"01001001",
"01001110",
"01010100",
"10110010",
"01010011",
"01000111",
"01001110",
"10110011",
"01001110",
"01001111",
"01010100",
"10110100",
"01000011",
"01001111",
"01010011",
"10110101",
"01010100",
"01000001",
"01001110",
"10110110",
"01010011",
"01001001",
"01001110",
"10110111",
"01010011",
"01010001",
"01010010",
"10111000",
"01000011",
"01000010",
"01011001",
"10111001",
"01000101",
"01011000",
"01010000",
"10111010",
"01000001",
"01010100",
"01001110",
"10111011",
"01001100",
"01001111",
"01000111",
"10111100",
"01000100",
"01000010",
"01011001",
"10111101",
"01011000",
"01000010",
"01011001",
"10111110",
"01010000",
"01001001",
"10111111",
"01010010",
"01001110",
"01000100",
"11000000",
"01000111",
"01000101",
"01010100",
"11000001",
"01000110",
"01010010",
"01000101",
"01000101",
"11000010",
"01001100",
"01000101",
"01001110",
"11000011",
"01011000",
"01010100",
"01000001",
"01001100",
"11000100",
"01001101",
"01010100",
"01001111",
"01010000",
"11000110",
"01001001",
"01000101",
"11000111",
"01001001",
"01010000",
"11001000",
"01010100",
"01001001",
"01001101",
"01000101",
"01010010",
"00110000",
"11001001",
"01010100",
"01001001",
"01001101",
"01000101",
"01010010",
"00110001",
"11001010",
"01010100",
"01001001",
"01001101",
"01000101",
"01010010",
"00110010",
"11000101",
"01010100",
"01001001",
"01001101",
"01000101",
"11001011",
"01010100",
"00110010",
"01000011",
"01001111",
"01001110",
"11001100",
"01010100",
"01000011",
"01001111",
"01001110",
"11001101",
"01010100",
"01001101",
"01001111",
"01000100",
"11001110",
"01010010",
"01000011",
"01000001",
"01010000",
"00110010",
"11001111",
"01010000",
"01001111",
"01010010",
"01010100",
"00110001",
"11010000",
"01010000",
"01000011",
"01001111",
"01001110",
"11010001",
"01000001",
"01010011",
"01000011",
"00101000",
"11010010",
"01010101",
"01010011",
"01001001",
"01001110",
"01000111",
"00101000",
"11010010",
"01010101",
"00101110",
"00101000",
"11010011",
"01000011",
"01001000",
"01010010",
"00101000",
"11110000",
"01010010",
"01010101",
"01001110",
"11110001",
"01001100",
"01001001",
"01010011",
"01010100",
"11110010",
"01001110",
"01010101",
"01001100",
"01001100",
"11110011",
"01001110",
"01000101",
"01010111",
"11110100",
"01000011",
"01001111",
"01001110",
"01010100",
"11110101",
"01010000",
"01010010",
"01001111",
"01000111",
"11110110",
"01011000",
"01000110",
"01000101",
"01010010",
"11110111",
"01010010",
"01000001",
"01001101",
"11111000",
"01010010",
"01001111",
"01001101",
"11111001",
"01000110",
"01010000",
"01010010",
"01001111",
"01000111",
"11111111",
"01000101",
"01011000",
"01010100",
"01010010",
"01000001",
"00100000",
"01001001",
"01000111",
"01001110",
"01001111",
"01010010",
"01000101",
"01000100",
"00100010",
"01000001",
"00101101",
"01010011",
"01010100",
"01000001",
"01000011",
"01001011",
"00100010",
"01000011",
"00101101",
"01010011",
"01010100",
"01000001",
"01000011",
"01001011",
"00100010",
"01110101",
"10011000",
"01011010",
"01110101",
"10001001",
"00010000",
"01110101",
"10001000",
"01010100",
"01110101",
"11001000",
"00110100",
"10010000",
"00100000",
"00000001",
"11100100",
"10010011",
"10110100",
"10101010",
"00000011",
"00010010",
"00100000",
"10010000",
"01111000",
"11111111",
"11100100",
"11110110",
"11011000",
"11111101",
"01110101",
"00111110",
"01001101",
"10000101",
"00111110",
"10000001",
"01110101",
"00010011",
"10000000",
"01110101",
"00010100",
"00010001",
"10010000",
"10000000",
"00000000",
"11100000",
"11000011",
"10010100",
"00110001",
"11110101",
"01000101",
"11000010",
"11100010",
"11111111",
"10100011",
"10110001",
"10110100",
"00010010",
"00001000",
"10001011",
"10100011",
"10110001",
"10110100",
"10010000",
"00000000",
"01011111",
"11100000",
"10010000",
"00000000",
"00000000",
"10110100",
"10100101",
"00001000",
"11100101",
"01000101",
"11000010",
"11100000",
"01100100",
"00000100",
"01100000",
"00101001",
"10111111",
"00000010",
"00000010",
"10000000",
"00000011",
"10111111",
"00000011",
"00000100",
"11010001",
"01110111",
"10000000",
"00010001",
"10101011",
"10000011",
"10101001",
"10000010",
"10100011",
"01110100",
"01011010",
"11110000",
"11100000",
"10110100",
"01011010",
"00000101",
"11100100",
"11110000",
"10111011",
"11100000",
"11101111",
"10111011",
"00000011",
"00000000",
"01000000",
"10001110",
"10010000",
"00000001",
"00001010",
"10110001",
"11111101",
"11010001",
"01010110",
"11010001",
"01101001",
"00010010",
"00010110",
"01000010",
"11100101",
"01000101",
"10110100",
"00000101",
"00000011",
"00010010",
"01000000",
"00111001",
"01010000",
"00001101",
"00110000",
"11100000",
"00100101",
"10010000",
"10000000",
"00010000",
"11100000",
"10110100",
"01010101",
"00011110",
"00000010",
"00001000",
"00001000",
"11100100",
"11111011",
"11111001",
"11110101",
"11001100",
"11000010",
"11001010",
"00100000",
"10110000",
"11111101",
"01110101",
"11001000",
"00000101",
"00010010",
"00011001",
"01101011",
"00110000",
"10110000",
"11111101",
"01110101",
"11001000",
"00110100",
"00010010",
"00001000",
"10001011",
"00000000",
"00000000",
"10010000",
"00011111",
"11010011",
"11010001",
"10100111",
"00000010",
"00010111",
"01110110",
"01111111",
"00000000",
"01111110",
"00000001",
"01111010",
"01111111",
"01111000",
"11111111",
"10010001",
"10011000",
"00001110",
"11100101",
"11001011",
"10010001",
"10011000",
"11100101",
"11001010",
"01111110",
"00000011",
"01111001",
"00001001",
"01111011",
"00000001",
"10010001",
"10011000",
"10000000",
"00110111",
"10010000",
"00000001",
"00101010",
"11010010",
"00110011",
"10000000",
"00000101",
"10010000",
"00000001",
"00101000",
"11000010",
"00110011",
"10110001",
"01111100",
"11000010",
"10010101",
"00010010",
"00001110",
"11100100",
"01110000",
"11010000",
"01111100",
"11111110",
"11010010",
"00011101",
"10110001",
"01010101",
"00010010",
"00011000",
"01001110",
"11101100",
"11110100",
"00010010",
"00010100",
"10011100",
"00010010",
"00011001",
"10100001",
"10110001",
"00010110",
"11010001",
"10011111",
"10101000",
"00001110",
"10101010",
"00001111",
"01110100",
"01010101",
"00001110",
"10111110",
"00000000",
"00000001",
"00001111",
"10010001",
"10011011",
"11010010",
"10010101",
"10100001",
"00111010",
"10001011",
"10100000",
"11100011",
"00010010",
"00010101",
"01100001",
"01111101",
"00000001",
"11111100",
"10010001",
"11010110",
"10010001",
"11110000",
"00100000",
"00110011",
"00001100",
"01101100",
"01110000",
"00100000",
"00010010",
"00010110",
"00110010",
"01110000",
"11101000",
"01010011",
"11010000",
"11100111",
"00100010",
"01101100",
"01110000",
"00001111",
"11101100",
"10010001",
"11010110",
"10010001",
"11100000",
"10010001",
"11100000",
"10010001",
"11100000",
"11011101",
"11111000",
"10010001",
"11110000",
"10000000",
"11100010",
"00001101",
"11101100",
"10111101",
"00011001",
"11010101",
"11010010",
"10010101",
"01110101",
"11010000",
"00000000",
"00110000",
"00101111",
"11100000",
"10010000",
"00011111",
"10011010",
"00000010",
"00011000",
"10001001",
"10001000",
"10000000",
"10001010",
"10100000",
"10110001",
"00000101",
"11000010",
"10010011",
"11110101",
"10000000",
"00000000",
"00000000",
"00000000",
"00000000",
"00000000",
"00000000",
"10110001",
"00000101",
"11000010",
"10010100",
"10110001",
"00100111",
"00110000",
"10001111",
"11111101",
"00100010",
"11010010",
"10010100",
"10110001",
"00000101",
"00110000",
"10110010",
"11111101",
"01110101",
"10000000",
"11111111",
"11000010",
"10110111",
"10110001",
"00000101",
"11100101",
"10000000",
"11010010",
"10110111",
"11010010",
"10010011",
"00100010",
"01110101",
"00001111",
"00001100",
"11010101",
"00001111",
"11111101",
"00100010",
"11000010",
"10010101",
"01110101",
"11010000",
"00011000",
"10010001",
"10010101",
"11010010",
"10010101",
"00100010",
"10110001",
"10000100",
"10100011",
"10101011",
"00010011",
"10101001",
"00010100",
"11000011",
"11100101",
"10000010",
"10011001",
"11111110",
"11100101",
"10000011",
"10011011",
"11111111",
"00100010",
"10110001",
"00100110",
"11000010",
"10001110",
"10000101",
"01000000",
"10001101",
"10000101",
"01000001",
"10001011",
"11000010",
"10001111",
"11010010",
"10001110",
"00100010",
"11000010",
"00010111",
"10110001",
"00111101",
"00000010",
"00010000",
"01110111",
"00010010",
"00001110",
"11100100",
"01111100",
"00000001",
"01010000",
"00000100",
"00010010",
"00001110",
"10010001",
"11111100",
"10110001",
"01010101",
"10111100",
"00000000",
"00010001",
"10100011",
"10000101",
"10000011",
"00010011",
"10000101",
"10000010",
"00010100",
"00100010",
"10010000",
"10000000",
"00010000",
"11100000",
"10110100",
"01010101",
"00001001",
"11011100",
"00000001",
"00100010",
"10100011",
"10110001",
"10100110",
"10100011",
"10000000",
"11110011",
"00010000",
"00011101",
"11110110",
"10010000",
"00011111",
"11001001",
"10000001",
"11010011",
"11100000",
"11111010",
"10100011",
"11100000",
"11111000",
"00100010",
"11001011",
"11000101",
"10000011",
"11001011",
"11001001",
"11000101",
"10000010",
"11001001",
"00100010",
"11100000",
"11110101",
"01000000",
"10100011",
"11100000",
"11110101",
"01000001",
"00100010",
"11010010",
"00101001",
"00010010",
"00001110",
"10011110",
"00010010",
"00001010",
"10100111",
"01100000",
"00010010",
"10100011",
"00100000",
"00101001",
"00001010",
"10110001",
"11000110",
"10110001",
"10111100",
"11100000",
"00100000",
"00101010",
"00000110",
"01000000",
"00000100",
"10110001",
"11011000",
"10000000",
"11101001",
"11000010",
"00101001",
"00100010",
"10010000",
"00000010",
"00000000",
"11010010",
"00101001",
"10000000",
"11011111",
"11100000",
"11000000",
"11100000",
"10100011",
"11100000",
"11110101",
"10000010",
"11010000",
"10000011",
"00100010",
"11100000",
"11111011",
"10100011",
"11100000",
"11111001",
"00100010",
"10110001",
"10111100",
"11000101",
"10000010",
"01110000",
"00000010",
"00010101",
"10000011",
"00010100",
"11000101",
"10000010",
"00100010",
"11000010",
"00101010",
"11100000",
"10110101",
"00000011",
"00001010",
"10100011",
"11100000",
"10110001",
"10111100",
"10110101",
"00000001",
"00000011",
"10110011",
"10110010",
"00101010",
"10110011",
"00100010",
"00100101",
"10000010",
"11110101",
"10000010",
"01010000",
"00000010",
"00000101",
"10000011",
"00100010",
"11010001",
"10010100",
"10110001",
"10100011",
"01110100",
"00000110",
"10110001",
"11011000",
"10110001",
"01110011",
"10010000",
"00000001",
"00001000",
"10110001",
"11111111",
"10110001",
"10110100",
"10010000",
"00000001",
"00100010",
"10110001",
"10101010",
"00010010",
"00001010",
"00000101",
"10010000",
"00000001",
"00000100",
"10110001",
"11111111",
"11101011",
"11110000",
"10100011",
"11101001",
"11110000",
"10100011",
"00100010",
"00010010",
"00001110",
"10001000",
"10010000",
"00000001",
"00100010",
"10110001",
"11111111",
"00001110",
"10001110",
"00111111",
"11000001",
"01011110",
"10010000",
"00000001",
"00000100",
"10110001",
"10101010",
"10110001",
"10111010",
"11100000",
"01100000",
"00100000",
"10100011",
"10110101",
"00000111",
"00001111",
"11100000",
"10110101",
"00000110",
"00001011",
"11100101",
"10000010",
"10010100",
"00000010",
"11111000",
"11100101",
"10000011",
"10010100",
"00000000",
"11111010",
"00100010",
"11100101",
"10000010",
"11000011",
"10010100",
"00001001",
"11110101",
"10000010",
"01010000",
"11100001",
"00010101",
"10000011",
"10000000",
"11011101",
"00010010",
"00001101",
"11110010",
"11000011",
"11010001",
"00100101",
"11101000",
"10010100",
"00000110",
"11111001",
"11101010",
"10010100",
"00000000",
"11111011",
"10010000",
"00000001",
"00000110",
"10110001",
"11111111",
"10110001",
"11000110",
"01000000",
"00110010",
"11010011",
"00100010",
"10010000",
"00000010",
"00000000",
"01110100",
"00000001",
"11110000",
"11000010",
"00010101",
"10110001",
"11100001",
"10010000",
"00000001",
"00001010",
"10110001",
"10110100",
"10110001",
"10100011",
"11010001",
"01110111",
"10010000",
"00000000",
"11111110",
"11100100",
"11110000",
"01110101",
"00010001",
"11111110",
"01110101",
"00001001",
"11111110",
"11000010",
"00010111",
"00100010",
"10100011",
"11100100",
"11110000",
"11100000",
"01110000",
"00001001",
"11101011",
"10110101",
"10000011",
"11110110",
"11101001",
"10110101",
"10000010",
"11110010",
"00100010",
"00000010",
"00010101",
"10100000",
"00010010",
"00001110",
"11100100",
"01010000",
"11010000",
"00010010",
"00001110",
"11011010",
"10110100",
"01001001",
"11010101",
"00110000",
"00010010",
"00000010",
"11000010",
"10101010",
"01010011",
"00100010",
"00100000",
"00110010",
"11010001",
"10011111",
"01111101",
"00001101",
"11110001",
"00001011",
"01111101",
"00001010",
"11100001",
"00001011",
"11010001",
"10011111",
"11100100",
"10010011",
"11000010",
"11100111",
"10110100",
"00100010",
"00000001",
"00100010",
"11010010",
"00110100",
"11111101",
"11110001",
"00001011",
"10100011",
"10000000",
"00000100",
"10110001",
"01110011",
"01111100",
"00001101",
"00010000",
"00110100",
"11101001",
"11100000",
"01100000",
"00000011",
"10110101",
"00000100",
"00000001",
"00100010",
"10110100",
"00001101",
"11101001",
"00000010",
"00011000",
"01111111",
"10110100",
"00000100",
"00010110",
"11010001",
"10011111",
"01110101",
"10100000",
"00000000",
"01111000",
"00000111",
"11110001",
"10001011",
"11111101",
"10110100",
"01111111",
"11110000",
"10111000",
"00000111",
"00011000",
"01111101",
"00000111",
"11110001",
"00001011",
"10000000",
"11110001",
"11110010",
"10110100",
"00001101",
"00000010",
"11000001",
"10011111",
"10110100",
"00100000",
"00000000",
"01000000",
"11110001",
"00001000",
"10111000",
"01010110",
"11101101",
"00011000",
"10000000",
"11101000",
"00011000",
"01111101",
"00001000",
"11110001",
"00001011",
"11110001",
"00001001",
"01111101",
"00001000",
"10000000",
"11011111",
"01111110",
"00000000",
"00000000",
"01010000",
"01100111",
"01000001",
"01111101",
"00100000",
"11000000",
"11100000",
"11000000",
"10000011",
"11000000",
"10000010",
"00110000",
"00110101",
"00000100",
"11110001",
"10000111",
"10000000",
"11111001",
"11101101",
"00110000",
"00101100",
"00000101",
"00010010",
"00100000",
"01000000",
"11100001",
"01100000",
"00110000",
"00011100",
"00000101",
"00010010",
"01000000",
"00110000",
"11100001",
"01100000",
"00110000",
"00100111",
"00001000",
"00110000",
"00011001",
"00000101",
"00010010",
"01000000",
"00111100",
"11100001",
"01100000",
"00110000",
"00011011",
"00100010",
"10010000",
"00000001",
"00100100",
"10110001",
"01111100",
"11000010",
"10010111",
"10110001",
"00100111",
"11101101",
"11010011",
"01111101",
"00001001",
"00010011",
"00110000",
"10001111",
"11111101",
"10010010",
"10010111",
"10110001",
"00100111",
"11011101",
"11110110",
"00110000",
"10001111",
"11111101",
"10110001",
"00100111",
"00110000",
"10001111",
"11111101",
"11111101",
"10000000",
"00000111",
"00110000",
"10011001",
"11111101",
"11000010",
"10011001",
"10001101",
"10011001",
"10111101",
"00001101",
"00000011",
"01110101",
"00010110",
"00000000",
"10111101",
"00001010",
"00001011",
"11100101",
"00010101",
"01100000",
"00000111",
"01111101",
"00000000",
"11110001",
"00001011",
"00010100",
"01110000",
"11111001",
"10111101",
"00001000",
"00000010",
"00010101",
"00010110",
"10111101",
"00100000",
"00000000",
"01000000",
"00000010",
"00000101",
"00010110",
"11010000",
"10000010",
"11010000",
"10000011",
"11010000",
"11100000",
"00100010",
"11110001",
"11000110",
"01010000",
"00110010",
"00110000",
"00110010",
"00000101",
"00010010",
"00100000",
"01100000",
"10000000",
"00010001",
"00110000",
"00011110",
"00000101",
"00010010",
"01000000",
"00110011",
"10000000",
"00001001",
"00110000",
"10011000",
"11111101",
"11100101",
"10011001",
"11000010",
"10011000",
"11000010",
"11100111",
"10110100",
"00010011",
"00000010",
"11010010",
"00110101",
"10110100",
"00010001",
"00000010",
"11000010",
"00110101",
"10110100",
"00000011",
"00000100",
"00110000",
"00110000",
"00100110",
"00100010",
"11000010",
"00101000",
"10110100",
"00010111",
"00000010",
"11010010",
"00101000",
"11010011",
"00100010",
"11010010",
"00011101",
"10110001",
"00111101",
"00010000",
"00011101",
"01000011",
"00100010",
"00110000",
"00110010",
"00000011",
"00000010",
"00100000",
"01101000",
"00110000",
"00011110",
"00000011",
"00000010",
"01000000",
"00110110",
"10100010",
"10011000",
"00100010",
"10010000",
"00011001",
"01111000",
"11010001",
"10101001",
"11000010",
"00110101",
"00010010",
"00001100",
"00110100",
"11010001",
"10011111",
"00010000",
"00101000",
"11110001",
"00110000",
"00101111",
"01111111",
"10100001",
"00111010",
"11100101",
"01001000",
"10101001",
"01001001",
"10110101",
"01001000",
"11111001",
"11001001",
"10010101",
"01001100",
"11101001",
"10010101",
"01001011",
"00100010",
"11110001",
"11101001",
"01000000",
"01000000",
"11010010",
"00010100",
"11000010",
"00010000",
"10100010",
"00010001",
"10010010",
"00101011",
"10010000",
"00000001",
"00100110",
"10000000",
"00111100",
"00010010",
"00000110",
"01011100",
"01110001",
"11010011",
"01010001",
"10100111",
"01100000",
"01001010",
"11010001",
"10111011",
"11110001",
"00100110",
"10010001",
"00111111",
"11000010",
"00101111",
"10000101",
"00111110",
"10000001",
"00100000",
"00101111",
"00000110",
"10000101",
"00001010",
"01000010",
"10000101",
"00001000",
"01000011",
"00010010",
"00000111",
"10000111",
"00100000",
"00101111",
"00100100",
"10110000",
"00011000",
"01010000",
"00000110",
"10010000",
"00000001",
"00000000",
"11110000",
"11010010",
"00011000",
"00100000",
"00010100",
"00010111",
"00100000",
"00010000",
"10111100",
"00110000",
"00010110",
"00010001",
"00100000",
"00010001",
"00001110",
"10010000",
"00000001",
"00100000",
"01111100",
"00000010",
"01110001",
"00111000",
"11010010",
"00010001",
"00010010",
"00000101",
"01101101",
"01000001",
"11111011",
"00010001",
"11111011",
"11110001",
"00011010",
"01010000",
"11000100",
"00110000",
"00101111",
"00000011",
"00000010",
"00010111",
"10010100",
"00000010",
"00010111",
"01111110",
"11110001",
"00011010",
"10000101",
"00001010",
"01000010",
"10000101",
"00001000",
"01000011",
"11010010",
"00010111",
"10010000",
"00000000",
"11101100",
"11010010",
"00100000",
"00000010",
"00011000",
"10100111",
"10110100",
"11001000",
"00000101",
"10001011",
"10001100",
"10001001",
"10001010",
"00100010",
"10110100",
"11001001",
"00000101",
"10001011",
"10001101",
"10001001",
"10001011",
"00100010",
"10110100",
"11001010",
"00000101",
"10001011",
"11001101",
"10001001",
"11001100",
"00100010",
"10110100",
"11001110",
"00000101",
"10001011",
"11001011",
"10001001",
"11001010",
"00100010",
"00110001",
"11011000",
"10110100",
"11001011",
"00000011",
"10001001",
"11001000",
"00100010",
"10110100",
"11000110",
"00000011",
"10001001",
"10101000",
"00100010",
"10110100",
"11000111",
"00000011",
"10001001",
"10111000",
"00100010",
"10110100",
"11001100",
"00000011",
"10001001",
"10001000",
"00100010",
"10110100",
"11001101",
"00000011",
"10001001",
"10001001",
"00100010",
"10110100",
"11001111",
"00101111",
"10001001",
"10010000",
"00100010",
"11110101",
"00001111",
"11010001",
"11011010",
"00110001",
"11001011",
"11100101",
"00001111",
"10110100",
"11000011",
"00000011",
"00000010",
"00010110",
"01000111",
"11010001",
"10010011",
"11100101",
"00001111",
"10110100",
"11000100",
"00001001",
"10010000",
"00000001",
"00001010",
"00010010",
"00000101",
"11111111",
"00000010",
"00000110",
"01011110",
"10110100",
"11000101",
"10011001",
"10100010",
"10101111",
"11000010",
"10101111",
"10001011",
"01001000",
"10001001",
"01001001",
"10010010",
"10101111",
"00100010",
"10110100",
"11010000",
"01010110",
"10001001",
"10000111",
"00100010",
"10110100",
"11010001",
"11001011",
"11010001",
"11001110",
"10110100",
"00100100",
"01001011",
"01010001",
"00100001",
"10110001",
"10110000",
"00010010",
"00010100",
"10011111",
"00110001",
"11100000",
"00100001",
"00100100",
"11010001",
"11010000",
"00110000",
"00101101",
"00001110",
"10110100",
"00100000",
"00000000",
"01010000",
"00001001",
"00010010",
"00100000",
"01110000",
"11010001",
"11011010",
"01010100",
"00001111",
"10000000",
"01010001",
"10110100",
"11000011",
"00000000",
"01010000",
"11010101",
"00110000",
"11100111",
"01011011",
"10110100",
"10111100",
"00000110",
"00110001",
"11011100",
"00110001",
"11011000",
"11110111",
"00100010",
"10110100",
"10111101",
"00000110",
"00110001",
"11011100",
"10001011",
"10100000",
"11110011",
"00100010",
"10110100",
"10101011",
"00000000",
"01000000",
"00001001",
"10110100",
"10110000",
"00000000",
"01010000",
"00001001",
"00100100",
"11111001",
"10000000",
"00011101",
"10110100",
"10100100",
"00000000",
"01000000",
"00000011",
"00000010",
"00011000",
"01111111",
"00110000",
"00101111",
"00010010",
"10110100",
"10010000",
"00000000",
"01000000",
"00001101",
"10110100",
"10100000",
"00000010",
"10000000",
"00001000",
"10110100",
"10010111",
"00000010",
"10000000",
"00000011",
"10110100",
"10010110",
"11101000",
"11010001",
"11011010",
"10010000",
"00000001",
"00100001",
"10110100",
"10000000",
"00000010",
"10000000",
"10011110",
"01010100",
"00111111",
"00100011",
"00100101",
"10000010",
"11110101",
"10000010",
"11100100",
"10010011",
"11000000",
"11100000",
"10100011",
"11100100",
"10010011",
"11010000",
"10000011",
"11110101",
"10000010",
"11100100",
"01110011",
"11010001",
"11000010",
"01000000",
"01010000",
"11000010",
"00010101",
"00010010",
"00000101",
"01110011",
"01111111",
"11101010",
"10010001",
"11101000",
"11010001",
"11010000",
"10110100",
"00100010",
"00010001",
"10101111",
"00111111",
"11010001",
"11011010",
"11010001",
"11100100",
"01100000",
"10110000",
"11110000",
"10110100",
"00100010",
"00100110",
"01110100",
"00001101",
"11110000",
"11000001",
"11011010",
"11000000",
"10000011",
"11000000",
"10000010",
"11010001",
"11000010",
"01000000",
"10011111",
"11010000",
"00000000",
"11010000",
"00000010",
"10101111",
"00111111",
"00010010",
"00010101",
"10000001",
"10110100",
"00001101",
"00000001",
"00100010",
"11011111",
"00000101",
"01110100",
"00001101",
"11110010",
"11000001",
"01010001",
"00010010",
"00010101",
"01100001",
"10000000",
"11101101",
"11011111",
"00000110",
"00110001",
"10001111",
"11010001",
"01010001",
"11000001",
"11101111",
"10100011",
"10000000",
"11000101",
"10010000",
"00011000",
"00100010",
"10000001",
"00010001",
"00110001",
"11001001",
"11100001",
"11010110",
"11110001",
"00000100",
"11000000",
"00000010",
"11000000",
"00000000",
"01111111",
"11101010",
"11110001",
"01000100",
"11010000",
"00000001",
"11010000",
"00000011",
"00100010",
"10111011",
"00000000",
"11100101",
"00100010",
"11010001",
"11011010",
"10010001",
"11100010",
"00110001",
"11001011",
"00010010",
"00010100",
"10001100",
"11101110",
"10111111",
"00000000",
"11010111",
"00100010",
"11010001",
"10011000",
"00110001",
"11011000",
"00001001",
"11101001",
"01100000",
"11001110",
"10010000",
"00000001",
"00000100",
"10000101",
"00111111",
"11110000",
"01010001",
"00010011",
"10010000",
"00000001",
"00001010",
"00010010",
"00010101",
"10011011",
"10000101",
"00111111",
"10000010",
"00010101",
"10000011",
"11000011",
"11101001",
"10010101",
"10000010",
"11111001",
"11101011",
"10010101",
"10000011",
"11111011",
"01001001",
"00100010",
"01110101",
"11110000",
"00000110",
"00010010",
"00000101",
"10101010",
"11101001",
"10100100",
"00100101",
"10000010",
"11111001",
"11100101",
"11110000",
"00110101",
"10000011",
"11111011",
"00100010",
"00110001",
"11101010",
"11000000",
"00000011",
"11000000",
"00000001",
"01111111",
"00101100",
"10010001",
"11101000",
"11010001",
"10010001",
"11101001",
"10110101",
"00111111",
"00000000",
"01010000",
"10001101",
"00011001",
"11010000",
"11100000",
"00101001",
"11111001",
"11010000",
"00000011",
"01010000",
"00000001",
"00001011",
"10000001",
"11100110",
"00110001",
"11001001",
"11000000",
"00000011",
"11000000",
"00000001",
"11110001",
"11010110",
"01111111",
"10100110",
"11110001",
"01000100",
"11010001",
"11010000",
"10110100",
"10100111",
"00000110",
"11010001",
"11011010",
"11110001",
"01000110",
"10000000",
"00000011",
"00010010",
"00010100",
"00101110",
"01110100",
"11101111",
"01110001",
"10110100",
"01110001",
"11000000",
"01111011",
"00000000",
"10101001",
"00000000",
"11110001",
"11010110",
"11110001",
"11010110",
"11010001",
"10100101",
"10101000",
"00000001",
"01110001",
"00111100",
"11010000",
"00001000",
"11010000",
"00001010",
"01111100",
"00000001",
"01110001",
"00111100",
"11010001",
"10111011",
"00000001",
"00011001",
"11110001",
"01000110",
"11010001",
"11001001",
"01010000",
"11111010",
"00100010",
"11110001",
"00000100",
"11110001",
"11010100",
"11010001",
"11001001",
"01010000",
"11111000",
"00100010",
"01010001",
"11001010",
"11111001",
"11010001",
"11010000",
"10110100",
"10100101",
"00000010",
"11010001",
"11011010",
"10111001",
"00000000",
"00001011",
"01111111",
"10101000",
"11010001",
"11110001",
"01100000",
"11101100",
"11010001",
"11011010",
"10110100",
"10101000",
"11110101",
"11110001",
"00111000",
"01010000",
"01010110",
"00000001",
"11111011",
"11100000",
"00010100",
"00100000",
"11100111",
"00101110",
"00100010",
"01010001",
"11110101",
"11010001",
"10111011",
"00010000",
"00100101",
"00001000",
"00110000",
"00010101",
"00000011",
"00010010",
"00000110",
"01011100",
"00000001",
"00010111",
"00010000",
"00010100",
"00000101",
"01010011",
"00100010",
"10111101",
"00000001",
"00011001",
"10100010",
"00101011",
"10010010",
"00010001",
"00000001",
"00011001",
"11110001",
"01000110",
"00010010",
"00010010",
"00111010",
"01100000",
"00000010",
"01110100",
"11111111",
"00100010",
"11010001",
"10011110",
"11100000",
"11111111",
"11011111",
"00000101",
"10010000",
"00011111",
"10110101",
"10000001",
"00010001",
"00100000",
"11100111",
"11111000",
"10100011",
"11100000",
"10110101",
"00000010",
"00001000",
"10100011",
"00011111",
"11100000",
"10110101",
"00000000",
"00000010",
"10100011",
"00100010",
"11101111",
"00010010",
"00000101",
"11011000",
"10000000",
"11100001",
"11110001",
"00110011",
"01010001",
"11010100",
"11100001",
"00011010",
"01010001",
"11010100",
"01000001",
"10101111",
"01010001",
"11001010",
"11110100",
"10000000",
"00000010",
"01010001",
"11001010",
"01111100",
"00000011",
"11111101",
"10000000",
"00001100",
"11110001",
"00110011",
"10001000",
"00010101",
"00000001",
"01011011",
"11010010",
"00100101",
"01111100",
"00000010",
"01111101",
"01010101",
"01110001",
"01001110",
"11100010",
"11110101",
"10000011",
"00001000",
"11100010",
"11110101",
"10000010",
"00001000",
"11100000",
"10110100",
"00000001",
"00000010",
"00000001",
"01011011",
"11101101",
"01100000",
"10000101",
"10001000",
"00010001",
"11110100",
"01110000",
"10000000",
"00100010",
"01010001",
"11110101",
"01111100",
"00000010",
"01110001",
"00111000",
"01000001",
"01110101",
"01110100",
"11111101",
"01110001",
"10110100",
"01110101",
"10100000",
"00000000",
"11100101",
"00001000",
"11110010",
"00011000",
"11100101",
"00001010",
"11110010",
"00011000",
"11101100",
"11110010",
"00100010",
"01110100",
"00000011",
"01110001",
"10110100",
"10101000",
"00010001",
"01110101",
"10100000",
"00000000",
"11100010",
"10110101",
"00000100",
"00000010",
"00001000",
"00100010",
"01100000",
"01101001",
"10110100",
"00000001",
"11101100",
"01110001",
"10110010",
"10000000",
"11101100",
"01111100",
"00000001",
"01110001",
"01001110",
"10001000",
"00001111",
"01111001",
"00001011",
"11100010",
"11110111",
"00001001",
"00001000",
"10111001",
"00001111",
"11111001",
"10110001",
"01101000",
"01010000",
"00000100",
"10101010",
"00001011",
"10101000",
"00001100",
"11101010",
"10110101",
"00001011",
"01000111",
"11101000",
"10110101",
"00001100",
"01000011",
"11110001",
"11100000",
"01110100",
"00001110",
"00100101",
"00001111",
"11111000",
"01111010",
"00000000",
"10001010",
"10100000",
"11100010",
"00001000",
"11000000",
"11100000",
"11110001",
"11100000",
"11000000",
"00000000",
"00010010",
"00010111",
"00111000",
"00010010",
"00010100",
"00010111",
"10101011",
"00001011",
"10101001",
"00001100",
"11110001",
"11010110",
"01111010",
"00000000",
"11010000",
"00000000",
"11110001",
"11100000",
"00010010",
"00011001",
"10010111",
"11010000",
"11100000",
"01100000",
"00000001",
"10110011",
"01110010",
"11010101",
"01000000",
"00010111",
"01110100",
"00010001",
"00100101",
"00010001",
"10110100",
"01100001",
"00000000",
"01000000",
"00001001",
"11000101",
"00010001",
"00010100",
"11111000",
"00100010",
"11110001",
"00011010",
"01010000",
"11111011",
"10010000",
"00000011",
"01111111",
"10000001",
"00010001",
"10000101",
"00001101",
"00001010",
"10000101",
"00001110",
"00001000",
"00000001",
"00011001",
"01110001",
"11011001",
"11010001",
"10011110",
"11010001",
"10111011",
"11110001",
"00100110",
"11000101",
"00001010",
"11000101",
"00010010",
"11000101",
"00001010",
"11000101",
"00001000",
"11000101",
"00010000",
"11000101",
"00001000",
"00100010",
"01110001",
"11011001",
"11010001",
"11001001",
"01000000",
"00010110",
"11110001",
"01000110",
"11010001",
"11010000",
"10110100",
"00101100",
"00000010",
"10000000",
"00000010",
"11110001",
"00011010",
"01110001",
"11011001",
"11110001",
"00000100",
"11110001",
"11010100",
"11010001",
"11001001",
"01010000",
"11100101",
"00100010",
"10110100",
"10011100",
"00000100",
"11010001",
"11011010",
"10000000",
"11100011",
"10110100",
"00000001",
"00001000",
"01110001",
"11011001",
"10010000",
"00011111",
"10000001",
"00000010",
"00011000",
"10001001",
"11010001",
"11101111",
"11110001",
"00011010",
"01000000",
"11110010",
"10000000",
"11001100",
"11010001",
"11010000",
"10110100",
"00100011",
"00000100",
"11010010",
"00011011",
"11000001",
"11001110",
"10110100",
"01000000",
"11011001",
"11010010",
"00011001",
"11000001",
"11001110",
"11010010",
"00110110",
"11010010",
"00110111",
"10010001",
"00011100",
"10010001",
"00111011",
"01010011",
"00100011",
"11110101",
"01010011",
"00100110",
"00111111",
"00100010",
"11010001",
"11100100",
"01000000",
"00000111",
"00000010",
"00000110",
"10011111",
"11010001",
"11001001",
"01000000",
"11111001",
"11010001",
"10101100",
"01010000",
"11111000",
"10110100",
"10100100",
"00001000",
"11010001",
"10011000",
"10010101",
"00010110",
"01000000",
"11101111",
"10000000",
"00000101",
"10110100",
"10101001",
"00001010",
"11010001",
"10011000",
"01100000",
"11100110",
"00010010",
"00000111",
"00001001",
"00010100",
"10000000",
"11111000",
"10110100",
"11010011",
"00010011",
"11010001",
"11001110",
"10110100",
"00100100",
"00000110",
"11110001",
"11111100",
"11010001",
"10010011",
"10000000",
"00000100",
"11010001",
"10010001",
"10010001",
"11100110",
"10101101",
"00000001",
"10000000",
"00000111",
"10110100",
"10101010",
"00001001",
"11010001",
"11011010",
"01111101",
"00001101",
"00010010",
"00000111",
"00001011",
"10000000",
"10111110",
"10110100",
"11010010",
"01010011",
"11010001",
"11001110",
"10110100",
"01000110",
"00010110",
"01110101",
"00010111",
"11110000",
"11010001",
"11001110",
"11010001",
"11011010",
"01010100",
"00001111",
"01100000",
"00000111",
"10110100",
"00000011",
"00000000",
"01010000",
"00000010",
"01110100",
"00000011",
"01000010",
"00010111",
"10000000",
"00101010",
"10110100",
"00110000",
"00000111",
"01110101",
"00010111",
"00000000",
"11010001",
"11011010",
"10000000",
"00100000",
"10110100",
"00100011",
"00011101",
"10010001",
"11010000",
"10001111",
"00010111",
"10110100",
"00101110",
"00010001",
"11010001",
"11001110",
"10010001",
"11010000",
"11101111",
"00100101",
"00010111",
"00100100",
"11110111",
"01010000",
"00000010",
"00100001",
"00111011",
"11101111",
"11000100",
"01000010",
"00010111",
"11100101",
"00010111",
"11000100",
"11110101",
"00010111",
"10010001",
"11100110",
"10000001",
"01000010",
"01111111",
"00000000",
"10110100",
"00100011",
"00001100",
"00001111",
"11010001",
"11001110",
"10000000",
"11111000",
"11010001",
"11100110",
"01010000",
"00000011",
"10110100",
"10101000",
"00110100",
"00100010",
"01111111",
"11100000",
"11110001",
"01000100",
"01111111",
"00101001",
"11010001",
"11011000",
"10110101",
"00000111",
"11010100",
"00100010",
"11010001",
"10010001",
"11010001",
"11011000",
"10110100",
"10000011",
"00000100",
"10110001",
"00000000",
"01000001",
"01110101",
"10110100",
"10011111",
"11000101",
"10110001",
"00000000",
"01100001",
"00110010",
"10111001",
"00000000",
"00000110",
"11110001",
"00110011",
"11010001",
"11101111",
"01000001",
"11110111",
"01111111",
"00101100",
"11010001",
"11110001",
"10110100",
"00101100",
"10110001",
"00011001",
"11010001",
"11011010",
"10000000",
"11101011",
"11010001",
"11000010",
"01000000",
"00000101",
"00010010",
"00000110",
"10111001",
"10000001",
"01000010",
"11110001",
"01000110",
"01110100",
"01001000",
"10110101",
"00010110",
"00000000",
"01010000",
"00000010",
"10010001",
"00111111",
"00110000",
"00110111",
"00010100",
"00010010",
"00010001",
"11101101",
"01000000",
"00001111",
"00010010",
"00010011",
"01111010",
"01110000",
"00000111",
"11010001",
"10010011",
"00010010",
"00011001",
"10101001",
"10000001",
"01000010",
"00010010",
"00010011",
"10001100",
"00010010",
"00011001",
"10100001",
"01110100",
"00000001",
"10000001",
"01011010",
"11010001",
"11001110",
"00010010",
"00011111",
"11101101",
"01000000",
"00001100",
"10110100",
"01011111",
"00000001",
"00100010",
"10110100",
"01000001",
"00000000",
"01000000",
"00000100",
"10110100",
"01011011",
"00000000",
"10110011",
"00100010",
"00110000",
"11010101",
"00111110",
"10010000",
"00010111",
"01011000",
"10000001",
"00010001",
"11010010",
"11010101",
"10000000",
"00000010",
"11000010",
"11010101",
"11010001",
"11010000",
"10110001",
"01010010",
"01010000",
"00000100",
"00100000",
"11010101",
"11101100",
"00100010",
"11111111",
"11100100",
"11111101",
"11111110",
"10110001",
"01000111",
"01000000",
"00000111",
"11001111",
"00101101",
"11001111",
"01111101",
"00011010",
"10000000",
"11110100",
"11000010",
"00010101",
"10110100",
"11100000",
"00101111",
"01000011",
"00000110",
"10000000",
"00010010",
"00000110",
"00010011",
"11000000",
"00000010",
"11000000",
"00000000",
"01010000",
"11001000",
"00100000",
"11010101",
"00101000",
"01111001",
"00001010",
"01111011",
"00000000",
"10110001",
"11001111",
"11010001",
"10011010",
"10111011",
"00000000",
"10111101",
"11010000",
"10000010",
"11010000",
"10000011",
"11100000",
"00010100",
"10011001",
"01000000",
"10110100",
"00010010",
"00000101",
"10111010",
"01010001",
"00010000",
"11001001",
"11001000",
"11001001",
"11001011",
"11001010",
"11001011",
"00100010",
"00100000",
"11010101",
"10100101",
"00010010",
"00000110",
"00010011",
"11000011",
"00100010",
"11010001",
"10011010",
"10111011",
"00000000",
"10011011",
"11010000",
"00000000",
"11010000",
"00000010",
"10110001",
"11001111",
"11010001",
"11001001",
"01010000",
"10010110",
"00100010",
"00001001",
"11101001",
"01100000",
"10001100",
"11111100",
"10010000",
"00000001",
"00001000",
"01010001",
"00010000",
"10101111",
"10000011",
"10101110",
"10000010",
"10010000",
"00000001",
"00000110",
"00010010",
"00010101",
"10011011",
"10010000",
"00000001",
"00001000",
"00010010",
"00000101",
"11111111",
"10001000",
"10000010",
"10001010",
"10000011",
"11101100",
"11110000",
"00010010",
"00000101",
"10111010",
"11101111",
"11110000",
"10100011",
"11101110",
"11110000",
"00100010",
"11010001",
"10101100",
"11010001",
"11001001",
"01010000",
"00000111",
"10010001",
"00111111",
"01111101",
"00111111",
"00010010",
"00000111",
"00001011",
"11010010",
"00100010",
"00010010",
"00000110",
"11010010",
"11000010",
"00100010",
"01110101",
"00001111",
"00000000",
"01110101",
"00001110",
"00000111",
"11010001",
"11000010",
"01000000",
"00001101",
"10110001",
"10110000",
"10101011",
"00001111",
"10101001",
"00001110",
"00110001",
"10100000",
"11010001",
"11001001",
"01010000",
"11011110",
"00100010",
"00010010",
"00011000",
"01000111",
"00010010",
"00011001",
"01001110",
"01110000",
"00011000",
"00010010",
"00011000",
"01001110",
"11110001",
"00000100",
"11110001",
"11010100",
"00010010",
"00011000",
"01000111",
"11010001",
"11001001",
"01000000",
"00010011",
"11100000",
"10110100",
"00101100",
"00000110",
"10100011",
"00010010",
"00011000",
"01001110",
"10000000",
"11001111",
"10010000",
"00000000",
"11110001",
"00010010",
"00000110",
"10100111",
"00000010",
"00011000",
"00111110",
"11100000",
"10110100",
"00001101",
"00000001",
"00100010",
"10010000",
"00000011",
"01101001",
"00010010",
"00000110",
"10100111",
"10000001",
"00111111",
"11010001",
"10001000",
"10001011",
"01001011",
"10001001",
"01001100",
"10010000",
"00000001",
"00100110",
"11010010",
"00010000",
"10100001",
"11110010",
"11110001",
"00110011",
"10111010",
"00000000",
"00001010",
"11101000",
"00100000",
"11100111",
"00000110",
"00101000",
"10010000",
"01000001",
"00000000",
"11110101",
"10000010",
"00110001",
"01101111",
"01010011",
"11010000",
"11100111",
"00100010",
"11010001",
"10010001",
"00010010",
"00010110",
"01110010",
"10001011",
"01000000",
"10001001",
"01000001",
"01111111",
"00101100",
"10010001",
"11101000",
"11110001",
"01000110",
"01111111",
"00101100",
"11110001",
"01000100",
"00000010",
"00010100",
"10001100",
"11110001",
"01000110",
"00010010",
"00010010",
"00001110",
"11101001",
"00100010",
"11010001",
"11011010",
"10010001",
"11100010",
"10000000",
"11110101",
"10000101",
"00010011",
"10000011",
"10000101",
"00010100",
"10000010",
"00100010",
"10000101",
"00001010",
"10000011",
"10000101",
"00001000",
"10000010",
"00100010",
"11010001",
"11010000",
"10110100",
"00100010",
"01110011",
"11010001",
"10100101",
"10100011",
"01111100",
"00100010",
"00010010",
"00000110",
"10111101",
"10100011",
"11000011",
"10000101",
"10000011",
"00001010",
"10000101",
"10000010",
"00001000",
"00100010",
"11010001",
"11010000",
"10110100",
"00100100",
"01011101",
"00100001",
"11101010",
"11010001",
"11010000",
"10110100",
"00101100",
"01010110",
"11010001",
"11011010",
"11010010",
"11010011",
"10001010",
"10100000",
"11100010",
"11000010",
"11010011",
"00100010",
"11010001",
"11010000",
"11010010",
"11010011",
"00001000",
"10111000",
"00000000",
"00000001",
"00001010",
"11000010",
"11010011",
"00100010",
"11010001",
"11010000",
"10110100",
"00001101",
"00000010",
"11100100",
"00100010",
"10110100",
"00111010",
"00110110",
"00100010",
"01111111",
"00001101",
"11010001",
"11100100",
"01010000",
"11111001",
"10110101",
"00000111",
"00000001",
"00100010",
"11010001",
"11011010",
"10000000",
"11110100",
"11010001",
"11011010",
"11010001",
"11100100",
"01110000",
"11111010",
"00100010",
"10110001",
"01101000",
"10000000",
"00101101",
"01110001",
"11000000",
"01111100",
"00000011",
"01110001",
"00111000",
"00000001",
"00011001",
"10110100",
"00111010",
"00000010",
"11000001",
"11011010",
"10110100",
"10101000",
"01101101",
"11010001",
"11111111",
"11010001",
"11010000",
"10110100",
"00001101",
"11110001",
"11010001",
"11001110",
"10110100",
"00000001",
"00000010",
"11010011",
"00100010",
"11000101",
"00001000",
"00100100",
"00000011",
"11000101",
"00001000",
"00010000",
"11010111",
"00000001",
"00100010",
"00000101",
"00001010",
"00100010",
"11110001",
"00111000",
"01000000",
"01001110",
"00100010",
"11010001",
"10100101",
"00010010",
"00011001",
"10100101",
"11010001",
"10111011",
"10001010",
"10000011",
"10001000",
"10000010",
"00100010",
"10010001",
"11101000",
"01111010",
"11001101",
"11000000",
"00000010",
"11000010",
"00100100",
"11100101",
"10000001",
"00100100",
"00001100",
"01010000",
"00000011",
"00000010",
"00011000",
"10000110",
"11100101",
"00001001",
"10010100",
"00111000",
"01010000",
"00000011",
"00000010",
"00010010",
"00000101",
"00100000",
"00100100",
"00010011",
"10110001",
"01101000",
"01010000",
"00001101",
"11110001",
"11110010",
"01010000",
"00001011",
"11010001",
"11010000",
"10110100",
"11100000",
"00000110",
"01110100",
"11001110",
"10000000",
"01010101",
"11110001",
"11100000",
"11010001",
"11010000",
"10110100",
"11100000",
"00000000",
"01010000",
"00001110",
"10110100",
"10110000",
"00000000",
"01010000",
"00111011",
"11010000",
"00000010",
"00100000",
"00100100",
"10111110",
"11000011",
"00000010",
"00011000",
"10000001",
"01010100",
"00011111",
"00100000",
"00100100",
"00000101",
"10110100",
"00000101",
"00111100",
"01110100",
"00001001",
"00100100",
"11001110",
"11111010",
"10010000",
"00000000",
"00000000",
"10010011",
"11111100",
"11010000",
"11100000",
"11111101",
"10010011",
"10110101",
"00000100",
"00000100",
"10110100",
"00001100",
"10011110",
"11010011",
"01010000",
"10011011",
"11000000",
"00000101",
"11000000",
"00000010",
"11010001",
"11011010",
"11110001",
"01001000",
"11010000",
"11100000",
"10010000",
"00000000",
"01010111",
"00100100",
"00110010",
"00110001",
"01011111",
"11100001",
"01001100",
"11010001",
"11011010",
"00100100",
"00101110",
"00100000",
"00100100",
"11000011",
"10110100",
"11101100",
"00000000",
"01010000",
"11101011",
"11000000",
"11100000",
"10010001",
"11100010",
"10000000",
"11100011",
"10110100",
"00000011",
"10110101",
"11010001",
"11011010",
"11100001",
"01001100",
"10110001",
"10110000",
"00010010",
"00010010",
"00111010",
"00000010",
"00010100",
"01011101",
"01111010",
"00000001",
"01111000",
"00010011",
"00010010",
"00010001",
"11110110",
"11010010",
"00100100",
"00000010",
"00010100",
"01011101",
"11010001",
"10010001",
"10000000",
"11101010",
"11010001",
"10010001",
"10110001",
"10110000",
"10000000",
"11101110",
"11010001",
"11010000",
"10110100",
"11010001",
"00010011",
"11010001",
"11001110",
"10110100",
"00100100",
"00000101",
"01010001",
"00100001",
"00000010",
"00010011",
"10101011",
"00010010",
"00010100",
"10011100",
"00010010",
"00001110",
"11011010",
"00000010",
"00001100",
"11100110",
"00010010",
"00001110",
"10100101",
"00010010",
"00011001",
"01001110",
"10110100",
"11111111",
"00000010",
"11010011",
"00100010",
"01110000",
"00000110",
"11000011",
"11010010",
"00100100",
"00000010",
"00001110",
"10111011",
"01010100",
"00001011",
"01100000",
"11110011",
"10010000",
"00010111",
"01001000",
"00110000",
"11100000",
"00000011",
"10010000",
"00010111",
"11111110",
"00110000",
"11100001",
"00000011",
"10010000",
"00011111",
"10001001",
"00000010",
"00011000",
"10001001",
"00010010",
"00001100",
"00011100",
"01110001",
"10110110",
"00010010",
"00001111",
"00111000",
"11100100",
"11111011",
"11111001",
"01000000",
"00010100",
"00010010",
"00011000",
"01001110",
"00010010",
"00001110",
"11011000",
"10110100",
"11100101",
"00000111",
"01010001",
"00111010",
"00010010",
"00001111",
"00110011",
"10010001",
"10011111",
"10101011",
"00001111",
"10101001",
"00001110",
"00010010",
"00000101",
"10000110",
"01100000",
"00011110",
"00010001",
"00011010",
"10100011",
"11010001",
"00111101",
"00110001",
"11110011",
"01000000",
"00010101",
"00010010",
"00000111",
"10000111",
"00110001",
"11110110",
"00010010",
"00001110",
"10100101",
"00010001",
"10001000",
"00010001",
"00011010",
"00010001",
"01111001",
"10100011",
"11100000",
"11010101",
"11100000",
"11100100",
"01010001",
"00111010",
"11100001",
"01111110",
"10010000",
"00000000",
"00000111",
"00010010",
"00000110",
"10111011",
"00010010",
"00001110",
"10100101",
"00000010",
"00000110",
"10011111",
"00010010",
"00000101",
"01110011",
"01111011",
"00000000",
"01111001",
"00000111",
"10100011",
"00010001",
"00011010",
"00010010",
"00000101",
"01101101",
"00010010",
"00011001",
"10100011",
"00010010",
"00001110",
"10100101",
"10100011",
"10111001",
"00001101",
"00000000",
"01000000",
"00100010",
"10100011",
"11100000",
"11111110",
"00100000",
"11100111",
"00100100",
"10110100",
"00100000",
"00000000",
"01010000",
"00000011",
"10110100",
"00001101",
"00011100",
"10110100",
"00100010",
"00001001",
"00110001",
"00001100",
"00110001",
"00001110",
"10110100",
"00100010",
"11111011",
"10000000",
"11100001",
"10110100",
"00111010",
"00001001",
"00110001",
"00001010",
"11101110",
"00110001",
"00001100",
"00110001",
"00001010",
"10000000",
"11010101",
"00110001",
"00010000",
"10000000",
"11010001",
"00010001",
"00011010",
"10100010",
"00101101",
"10010010",
"11010101",
"10010000",
"00000001",
"01110011",
"00110000",
"11010101",
"00000011",
"00010010",
"00100000",
"01111000",
"11100100",
"10010011",
"10100011",
"10110100",
"11111111",
"00000101",
"00010000",
"11010101",
"11101110",
"11100001",
"01111110",
"10110101",
"00000110",
"11110010",
"10110100",
"10110000",
"00000000",
"01010000",
"00000010",
"00110001",
"00001010",
"11100100",
"10010011",
"00100000",
"11100111",
"00000111",
"01100000",
"00000101",
"00110001",
"00001100",
"10100011",
"10000000",
"11110100",
"00010010",
"00001110",
"10100101",
"11101110",
"01100100",
"10010110",
"01110000",
"00000100",
"00110001",
"00001110",
"10000000",
"11111100",
"01010000",
"10010011",
"00110001",
"00001010",
"10000000",
"10001111",
"01110100",
"00100000",
"11000001",
"00101111",
"10100011",
"11100000",
"10110100",
"00001101",
"11111001",
"11000001",
"00011011",
"01111110",
"00000000",
"01010111",
"00100010",
"01100110",
"00101000",
"01111111",
"00000001",
"00110111",
"01010111",
"00010110",
"00010110",
"01111111",
"00000000",
"00010100",
"10010110",
"10010000",
"01000010",
"01111111",
"00000001",
"01000000",
"10010110",
"00101000",
"01110101",
"10000000",
"00000000",
"01100100",
"01100010",
"01100101",
"00010000",
"10000000",
"00000001",
"10011001",
"10001000",
"00100000",
"00010100",
"10000000",
"00000000",
"01010001",
"00110101",
"10011001",
"00011001",
"10000000",
"00000001",
"01000101",
"00110001",
"00110011",
"00110011",
"10000001",
"00000000",
"00000000",
"00000000",
"00000000",
"00010000",
"11111111",
"10000001",
"00000000",
"00000000",
"00000000",
"00000000",
"00100000",
"01111100",
"00000000",
"00000000",
"00000000",
"00000100",
"00010011",
"00110001",
"01111101",
"11110001",
"00111000",
"10010001",
"01101010",
"00110001",
"10100000",
"11100101",
"01000110",
"01010100",
"00000001",
"01100010",
"01000101",
"10010001",
"00010111",
"00110001",
"01111101",
"00110001",
"11110011",
"01000000",
"00000100",
"10010001",
"01101010",
"11110001",
"00010011",
"01110001",
"01111010",
"10010000",
"00010110",
"11000101",
"00110001",
"10000110",
"00110001",
"11000101",
"00100001",
"11100111",
"10010001",
"01101010",
"10010000",
"00010001",
"01001100",
"10010001",
"00011110",
"01100001",
"11110101",
"10010001",
"00010101",
"00110001",
"10011011",
"10010001",
"00110011",
"10010001",
"00011110",
"10010001",
"00111010",
"00110001",
"10011011",
"10010001",
"00011110",
"11110001",
"00111000",
"11100100",
"10010011",
"10110100",
"11111111",
"11110011",
"00010010",
"00011001",
"10011001",
"00000001",
"00011101",
"10010001",
"01010111",
"01110001",
"11110101",
"01110001",
"01111010",
"11110101",
"01000101",
"10010001",
"00010101",
"01010001",
"00001110",
"11000000",
"00000011",
"10001001",
"01000110",
"01110001",
"01011000",
"11110001",
"00010011",
"10010001",
"01000001",
"00110001",
"10011011",
"11010000",
"00000011",
"00100010",
"10010001",
"00010111",
"00110001",
"01011100",
"10010001",
"01000101",
"00110001",
"01011000",
"01100001",
"11110101",
"01010001",
"00111110",
"01111011",
"00000001",
"01100001",
"01101100",
"01110001",
"01111010",
"11110101",
"01000101",
"01010001",
"00111110",
"00100100",
"01111111",
"10010010",
"00101010",
"01010000",
"00000010",
"01010001",
"01100111",
"10010000",
"00010001",
"00010101",
"00110001",
"10000110",
"00110000",
"00101010",
"00000110",
"01110001",
"10001100",
"00110001",
"01111101",
"11110001",
"00111000",
"11100101",
"01000101",
"01100000",
"00011001",
"01100001",
"10001100",
"10010001",
"00010111",
"01110001",
"10110110",
"10010001",
"01000101",
"00000010",
"00011001",
"10010111",
"01110100",
"11111010",
"00100101",
"00001001",
"10110100",
"00110010",
"00000000",
"01000000",
"00000110",
"11110101",
"00001001",
"11111001",
"01111011",
"00000001",
"00100010",
"10010000",
"00000011",
"01110111",
"00000001",
"00110000",
"10010001",
"00011110",
"00110001",
"10011011",
"11100100",
"11111011",
"11111001",
"10101000",
"00001001",
"01110101",
"10100000",
"00000001",
"11100010",
"11000011",
"10010100",
"10000001",
"11111100",
"00011000",
"11100010",
"01110000",
"01010110",
"01000000",
"00011001",
"00001100",
"11101000",
"10010100",
"00000101",
"11111000",
"00001000",
"11100010",
"11000100",
"00010010",
"00011001",
"10100111",
"01000000",
"01000111",
"11011100",
"00000010",
"10000000",
"00001000",
"11100010",
"00010010",
"00011001",
"10100111",
"01000000",
"00111101",
"11011100",
"11101100",
"01110100",
"00000110",
"10000000",
"00000001",
"11100100",
"10101000",
"00001001",
"01111010",
"00000001",
"10001010",
"10100000",
"00101000",
"01000000",
"10111101",
"11110101",
"00001001",
"11100010",
"00100010",
"10010001",
"00101110",
"00110001",
"10100000",
"10111011",
"00000000",
"00100010",
"10010001",
"01010111",
"01010001",
"00111010",
"10010001",
"00110011",
"10010001",
"00101110",
"11100101",
"01000110",
"01110000",
"00001110",
"11100101",
"01000101",
"01100000",
"11101000",
"10010000",
"00000001",
"00011110",
"11110000",
"10010001",
"00101110",
"10010001",
"01000101",
"01100001",
"11110101",
"00010101",
"01000110",
"10010001",
"00111010",
"00110001",
"10011011",
"10000000",
"11100110",
"00000010",
"00001001",
"11000000",
"01110001",
"01111010",
"01110000",
"11111001",
"10010001",
"01010111",
"10010001",
"00110011",
"01111000",
"00011001",
"11100010",
"01100000",
"00100100",
"00100100",
"10000000",
"01010000",
"00000101",
"00000011",
"01010100",
"01111111",
"10000000",
"00000111",
"11110100",
"00000100",
"00000011",
"01010100",
"01111111",
"11110100",
"00000100",
"00100100",
"10000000",
"11110010",
"10010001",
"01000001",
"10010001",
"00111010",
"01110001",
"11110101",
"10010001",
"00111010",
"11110001",
"00111000",
"00110001",
"01111111",
"01110001",
"00000111",
"00110000",
"11010101",
"11101111",
"10000001",
"00111010",
"01110001",
"01111010",
"01110000",
"11000110",
"11110101",
"01000110",
"00001000",
"11100010",
"01100000",
"11000000",
"10110100",
"10000001",
"00000000",
"10010010",
"00101010",
"01000000",
"00000010",
"01010001",
"01100111",
"10010001",
"00010111",
"10010001",
"00101110",
"00110001",
"11110011",
"01010000",
"00011101",
"01010001",
"00111110",
"00100100",
"10000101",
"01010000",
"00001110",
"10010001",
"00011011",
"01110100",
"00000001",
"00100101",
"01000110",
"01000000",
"10100001",
"11110101",
"01000110",
"00110001",
"10011011",
"10000000",
"11100100",
"10010000",
"00010111",
"11100110",
"10010001",
"00011110",
"01110100",
"00001011",
"10000000",
"11101101",
"10010001",
"01010111",
"10010001",
"00101110",
"11110001",
"00010011",
"10010001",
"01000001",
"10010001",
"00101110",
"11110001",
"00111000",
"01110001",
"11110101",
"10010000",
"00010110",
"10100000",
"00110001",
"10000110",
"10100011",
"10010001",
"00011110",
"00110001",
"10011011",
"11100101",
"01000110",
"10010001",
"10011100",
"11110001",
"00010011",
"00110001",
"11000101",
"00110000",
"00101010",
"01110100",
"00100010",
"10010001",
"00111010",
"10010001",
"01000101",
"10010001",
"00010111",
"10010001",
"00110011",
"00000010",
"00011001",
"10010111",
"10010001",
"00011011",
"10010001",
"01000101",
"01010001",
"01001100",
"10010000",
"00000001",
"00011111",
"11100000",
"01100000",
"11101000",
"10010001",
"01000001",
"10010001",
"00111010",
"01010001",
"00111110",
"01100000",
"00000010",
"01010001",
"10101011",
"00110001",
"10011011",
"10010001",
"00011011",
"10010001",
"01000101",
"01010001",
"01001100",
"01110101",
"01000110",
"00000000",
"10010001",
"00101110",
"10010001",
"00010111",
"10010001",
"00110011",
"10010001",
"01000001",
"00110001",
"10011011",
"00000101",
"01000110",
"11100101",
"01000110",
"10010001",
"10011100",
"01110001",
"11110101",
"10010001",
"00010111",
"10010001",
"00111010",
"11110001",
"00111000",
"01110001",
"00000111",
"00110000",
"11010101",
"11101001",
"01010001",
"00111010",
"10010001",
"00111010",
"00110001",
"10011011",
"00100001",
"10011011",
"01010001",
"00111110",
"10010100",
"10000001",
"01010000",
"00000111",
"01010001",
"00111010",
"10010000",
"00000100",
"11100000",
"10000001",
"00011110",
"10010100",
"00000111",
"01010000",
"00010000",
"11110100",
"00000100",
"11111011",
"00011000",
"00011000",
"11100010",
"01010100",
"11110000",
"11110010",
"11011011",
"00000001",
"00100010",
"11100100",
"11110010",
"11011011",
"11110100",
"00100010",
"01110001",
"10001100",
"01110000",
"00011001",
"11110010",
"00100010",
"01010001",
"00111010",
"01100000",
"11011100",
"00011000",
"11100010",
"11111111",
"10010001",
"00101110",
"11101111",
"01100000",
"00001011",
"01010001",
"00111110",
"00011000",
"01100000",
"00000110",
"11100010",
"01100100",
"00000001",
"11110010",
"01100100",
"00000001",
"00100010",
"01010001",
"00001110",
"00010010",
"00000101",
"01110011",
"11100100",
"10010011",
"10000001",
"10011100",
"01010001",
"00001110",
"00010010",
"00001001",
"11011000",
"11100111",
"10000001",
"10011100",
"01010001",
"00001110",
"10001011",
"10100000",
"11100011",
"10000001",
"10011100",
"00110001",
"11110011",
"01110010",
"11010101",
"01000000",
"10101010",
"10010000",
"00010011",
"10111011",
"10000001",
"00011110",
"10000101",
"00000000",
"00000000",
"01010000",
"01010011",
"01100101",
"00110001",
"11110011",
"10110011",
"10000000",
"11101110",
"00110001",
"11110011",
"10100010",
"11010101",
"10000000",
"11110111",
"00110001",
"11110011",
"10110010",
"11010101",
"10000000",
"11110110",
"00110001",
"11110011",
"10000000",
"11011110",
"00110001",
"11110011",
"01110010",
"11010101",
"10000000",
"11100111",
"10010000",
"00000001",
"00001100",
"00010010",
"00000101",
"10110100",
"11101001",
"11000011",
"00010011",
"11111000",
"01110100",
"00000110",
"00010011",
"00101001",
"11001000",
"00111011",
"11111010",
"00010101",
"10000010",
"10010001",
"00001111",
"10010001",
"10011111",
"01110001",
"10110110",
"00010010",
"00011001",
"10011011",
"00000001",
"00011101",
"00010010",
"00001111",
"00110011",
"11010010",
"00010011",
"10010000",
"00000001",
"00000010",
"10000000",
"00001011",
"00010010",
"00001111",
"00110011",
"11010010",
"00010010",
"01000011",
"10101000",
"10000100",
"10010000",
"00000001",
"00100000",
"11101010",
"11110000",
"10100011",
"11101000",
"11110000",
"00100010",
"10010001",
"00010111",
"01010001",
"00111110",
"10000000",
"00100011",
"10010000",
"00010111",
"11101100",
"00110001",
"11110110",
"10001011",
"10100000",
"01111011",
"00000110",
"11100100",
"10010011",
"11110011",
"10100011",
"00011001",
"11011011",
"11111001",
"11010010",
"00100100",
"00100010",
"10010000",
"00010110",
"11101001",
"10000001",
"00011110",
"01111011",
"00000001",
"01111001",
"00011001",
"00000010",
"00001111",
"11010110",
"01111000",
"00011001",
"01111010",
"00000001",
"00000010",
"00001111",
"11100000",
"01111000",
"00011111",
"10000000",
"11110111",
"01010001",
"00111110",
"01110100",
"00000110",
"11111010",
"00101000",
"11111001",
"11100010",
"11111011",
"11100011",
"11110010",
"11101011",
"11110011",
"00011001",
"00011000",
"11011010",
"11110110",
"00100010",
"01010001",
"00111110",
"01111011",
"00000001",
"01111001",
"00011111",
"01111100",
"00000110",
"10001010",
"10100000",
"11100010",
"10001011",
"10100000",
"11110011",
"10110001",
"01110110",
"11011100",
"11110110",
"00100010",
"10010000",
"00010111",
"11111000",
"10000001",
"00011110",
"10010001",
"10001100",
"11101011",
"01011111",
"11111010",
"11101001",
"01011110",
"10000000",
"00100110",
"10010001",
"10001100",
"11101011",
"01001111",
"11111010",
"11101001",
"01001110",
"10000000",
"00011101",
"01110001",
"10110110",
"10010001",
"10001100",
"11101011",
"01101111",
"11111010",
"11101001",
"01101110",
"10000000",
"00010010",
"01010001",
"00001110",
"10101111",
"00000011",
"10101110",
"00000001",
"01000001",
"00001110",
"10010000",
"00000001",
"00000000",
"11100000",
"00010000",
"00011000",
"00000001",
"11100100",
"01111010",
"00000000",
"11111000",
"11010010",
"00100100",
"00000010",
"00011001",
"10101011",
"11100101",
"10101000",
"10000000",
"11110100",
"11100101",
"10111000",
"10000000",
"11110000",
"10101010",
"10001100",
"10101000",
"10001010",
"10000000",
"11101101",
"10101010",
"10001101",
"10101000",
"10001011",
"10000000",
"11100111",
"10101010",
"11001101",
"10101000",
"11001100",
"10000000",
"11100001",
"11100101",
"11001000",
"10000000",
"11011010",
"11100101",
"10001000",
"10000000",
"11010110",
"11100101",
"10001001",
"10000000",
"11010010",
"10101010",
"11001011",
"10101000",
"11001010",
"10000000",
"11001111",
"11100101",
"10010000",
"10000000",
"11001000",
"11100101",
"10000111",
"10000000",
"11000100",
"00000010",
"00000101",
"01101000",
"11100101",
"00010011",
"10110100",
"00000010",
"11111000",
"00010010",
"00000101",
"10100011",
"10101100",
"10000010",
"10101101",
"10000011",
"10101011",
"00001111",
"10101001",
"00001110",
"00010010",
"00000101",
"10000110",
"01110000",
"00010010",
"11100101",
"00001101",
"10110100",
"00000100",
"00000001",
"00100010",
"10110001",
"10010011",
"10101010",
"00000101",
"10101000",
"00000100",
"10110001",
"01010001",
"01110100",
"00000001",
"10100001",
"10000100",
"11111111",
"00010010",
"00011000",
"01001110",
"11100101",
"00001101",
"01000000",
"00001001",
"10110100",
"00000100",
"00000001",
"11100100",
"10011111",
"01100000",
"00110110",
"01000000",
"00011111",
"11111111",
"11100101",
"00001101",
"10110100",
"00000100",
"00000001",
"00100010",
"11101111",
"10110001",
"10010011",
"00010010",
"00011000",
"01000111",
"10110001",
"10001000",
"00010010",
"00001101",
"10110000",
"10101001",
"00000100",
"10101011",
"00000101",
"00001110",
"10111110",
"00000000",
"00000001",
"00001111",
"10110001",
"01101100",
"10000000",
"00010101",
"11110100",
"00000100",
"00010010",
"00000101",
"11011000",
"10110001",
"10001000",
"10101001",
"10000010",
"10101011",
"10000011",
"10101010",
"00001111",
"10101000",
"00001110",
"01100000",
"00000010",
"10110001",
"01011000",
"10010001",
"11111110",
"10101010",
"00001111",
"10101000",
"00001110",
"11100101",
"00001101",
"10110100",
"00000100",
"00000001",
"00100010",
"11100100",
"01111001",
"00000100",
"11111011",
"10101110",
"00001101",
"11111111",
"10110001",
"10000001",
"10110001",
"01100001",
"11010001",
"00110010",
"01110000",
"11111000",
"00100010",
"00001000",
"10111000",
"00000000",
"00000001",
"00001010",
"00001001",
"10111001",
"00000000",
"00000001",
"00001011",
"00100010",
"10110001",
"10000001",
"10110001",
"01110110",
"11010001",
"00110010",
"01110000",
"11111000",
"00000000",
"00100010",
"00011000",
"10111000",
"11111111",
"00000001",
"00011010",
"00011001",
"10111001",
"11111111",
"11110101",
"00011011",
"00100010",
"10001011",
"10100000",
"11100011",
"10001010",
"10100000",
"11110010",
"00100010",
"11101100",
"11000011",
"10010101",
"10000010",
"11111110",
"11101101",
"10010101",
"10000011",
"11111111",
"01001110",
"00100010",
"00101100",
"11111001",
"11100100",
"00111101",
"11111011",
"10010000",
"00000001",
"00000100",
"00010010",
"00000101",
"11000110",
"01000000",
"11110010",
"10010000",
"00011000",
"00010000",
"00000001",
"00110000",
"11110001",
"01100011",
"00010010",
"00001111",
"00111000",
"00010010",
"00011000",
"01001110",
"10010010",
"11010101",
"10010000",
"00000000",
"00000101",
"10010001",
"00001111",
"10101000",
"00001000",
"01111001",
"00000111",
"11000010",
"00100100",
"10010000",
"00000001",
"01110011",
"10001000",
"00000101",
"11100100",
"10010011",
"11111111",
"11100010",
"11111011",
"10110100",
"01100001",
"00000000",
"01000000",
"00000111",
"10110100",
"01111011",
"00000000",
"01010000",
"00000010",
"11000010",
"11100101",
"11111010",
"11110010",
"10100011",
"11100100",
"10010011",
"10110101",
"00000010",
"00000011",
"00001000",
"10000000",
"11100111",
"00100000",
"11100111",
"00101111",
"01100000",
"00101101",
"10100011",
"11100100",
"10010011",
"00100000",
"11100111",
"00000011",
"01110000",
"11111000",
"10100011",
"10101000",
"00000101",
"10110100",
"11111111",
"11001111",
"10111010",
"00100000",
"00000011",
"00001000",
"10000000",
"11000100",
"00110000",
"00101101",
"00001010",
"00100000",
"00100100",
"00000111",
"11010010",
"00100100",
"00010010",
"00100000",
"01111000",
"10100001",
"10111101",
"11010001",
"00011010",
"10110100",
"00100010",
"10110010",
"11010001",
"00011010",
"10110100",
"00100010",
"11111011",
"10000000",
"10101011",
"11101111",
"11010001",
"00101111",
"10110100",
"10010110",
"10100101",
"11101011",
"11010001",
"00011011",
"11010001",
"00011010",
"10000000",
"11111100",
"11100010",
"10110100",
"00001101",
"00010000",
"11010000",
"00000000",
"11010000",
"00000000",
"11110011",
"00001001",
"01110100",
"00000001",
"11110011",
"11101001",
"10010100",
"00000100",
"11110101",
"00001101",
"01111001",
"00000100",
"00001000",
"11110011",
"00001001",
"00100010",
"00011110",
"10111110",
"11111111",
"00000001",
"00011111",
"11101111",
"01001110",
"00100010",
"10010000",
"00000001",
"00001010",
"00010010",
"00000101",
"01101101",
"10000001",
"10011111",
"10010000",
"00010111",
"11100000",
"10010001",
"00011110",
"10010001",
"00010101",
"10010001",
"00010111",
"10010000",
"00000111",
"00000011",
"11010001",
"01110000",
"10010000",
"00000001",
"00101000",
"11110001",
"00000101",
"10010000",
"00010111",
"11110010",
"11010001",
"01110000",
"10010000",
"00000001",
"00101010",
"11110001",
"00000101",
"10010000",
"00010001",
"01010010",
"01010001",
"00001010",
"11101001",
"11110100",
"00000100",
"11110101",
"01001010",
"01111011",
"00000001",
"01111001",
"00010011",
"00000010",
"00001111",
"11010110",
"01010001",
"00001010",
"11101001",
"11110100",
"00100100",
"00001111",
"11111001",
"11101011",
"11110100",
"00110100",
"00000000",
"11111011",
"00100010",
"00010010",
"00001110",
"01111011",
"11010001",
"01110010",
"11000010",
"10010010",
"11000010",
"10001110",
"10001011",
"10001101",
"10001001",
"10001011",
"11000010",
"10001111",
"11010010",
"10001110",
"11010001",
"00110010",
"00110000",
"10001111",
"11111101",
"01110001",
"10010111",
"11010010",
"10010010",
"00010010",
"00000101",
"00101001",
"00110000",
"10001111",
"11111101",
"01110000",
"11100011",
"00100010",
"10000000",
"00000000",
"01110001",
"00110111",
"00010011",
"00011001",
"01111111",
"00000000",
"01110110",
"01100100",
"00110111",
"10010100",
"10000000",
"00000000",
"00000111",
"00100010",
"01110101",
"00010111",
"10000000",
"00000000",
"01010010",
"00110101",
"10010011",
"00101000",
"10000000",
"00000000",
"01110001",
"10010001",
"10000101",
"10000110",
"11111111",
"10000001",
"00000000",
"01010001",
"01011000",
"00000010",
"00100011",
"01110111",
"00000000",
"01000100",
"10010000",
"00000101",
"00010110",
"01111001",
"00000001",
"00001000",
"00100001",
"00000101",
"00100101",
"01111011",
"00000000",
"00011001",
"01110011",
"01010101",
"00100111",
"01111101",
"00000001",
"01110000",
"00010010",
"10000100",
"00011001",
"01111110",
"00000000",
"00110011",
"00110011",
"00110011",
"10000011",
"10000000",
"00000001",
"01100111",
"01100110",
"01100110",
"00010110",
"10000001",
"00000000",
"00000000",
"00000000",
"00000000",
"00010000",
"11111111",
"00010010",
"00001111",
"11011100",
"00010010",
"00001111",
"01000110",
"01110100",
"00001100",
"10010001",
"10011100",
"00110001",
"10011011",
"01110001",
"11110101",
"01010001",
"00001110",
"11010001",
"01110010",
"10010000",
"00000001",
"00100100",
"00000010",
"00000101",
"11111111",
"11010001",
"00111010",
"00010010",
"00000101",
"10100011",
"10101000",
"10000010",
"10101010",
"10000011",
"10010001",
"10011111",
"00010010",
"00011001",
"10010101",
"00000001",
"00011101",
"00010010",
"00000101",
"00010110",
"10101010",
"00000111",
"11101110",
"10000001",
"10011110",
"10100010",
"10101111",
"11000010",
"10101111",
"11000000",
"01000111",
"10101010",
"01001000",
"11100101",
"01001001",
"10010010",
"10101111",
"10010001",
"10011110",
"11010000",
"11100000",
"10010001",
"10011100",
"01110100",
"11001000",
"10010001",
"10011100",
"01110001",
"11110101",
"00010010",
"00011001",
"10010011",
"00000001",
"00011101",
"01000010",
"01000001",
"01000100",
"00100000",
"01010011",
"01011001",
"01001110",
"01010100",
"01000001",
"01011000",
"00100010",
"10001010",
"01000100",
"01001001",
"01010110",
"01001001",
"01000100",
"01000101",
"00100000",
"01000010",
"01011001",
"00100000",
"01011010",
"01000101",
"01010010",
"01001111",
"00100010",
"01000001",
"01010010",
"01010010",
"01000001",
"01011001",
"00100000",
"01010011",
"01001001",
"01011010",
"01000101",
"00100010",
"01110101",
"00001010",
"00000000",
"01110101",
"00001000",
"00000111",
"00100010",
"00010010",
"00000101",
"00010110",
"01111010",
"00000010",
"01111000",
"00000000",
"10110001",
"01011000",
"00010010",
"00000110",
"01011110",
"11000010",
"00010111",
"01110101",
"00010011",
"00000010",
"01110101",
"00010100",
"00000000",
"00010010",
"00001100",
"00110100",
"11000010",
"00101101",
"11100100",
"10010000",
"00100000",
"00000010",
"10010011",
"10110100",
"01011010",
"00000011",
"00010010",
"00100000",
"01001000",
"10010000",
"00000000",
"11111011",
"00010010",
"00000110",
"10100111",
"11010010",
"00101111",
"10000101",
"00111110",
"10000001",
"00010001",
"10000010",
"11000010",
"00011000",
"10010000",
"00000000",
"01011110",
"11100000",
"01100100",
"00110100",
"01110000",
"00000011",
"00000010",
"00001000",
"00001000",
"01111101",
"00111110",
"00010010",
"00000111",
"00001011",
"00010010",
"00000110",
"11010010",
"10110001",
"10100101",
"00100000",
"11010101",
"00001111",
"10010001",
"11011011",
"00010010",
"00000101",
"11100001",
"00100000",
"00010101",
"11011110",
"11010010",
"00010101",
"00010010",
"00000110",
"01011110",
"10000000",
"11010111",
"11110001",
"01100011",
"00010010",
"00001110",
"11100100",
"01100000",
"11001001",
"10010000",
"00000001",
"00001101",
"10110100",
"11110000",
"00000000",
"01000000",
"00001010",
"00010010",
"00001110",
"11011010",
"01010100",
"00001111",
"00010010",
"00001001",
"01011111",
"10000000",
"10110111",
"00000010",
"00001000",
"00011001",
"10001000",
"00000000",
"00000000",
"10010010",
"00000101",
"00010001",
"10000101",
"00000000",
"01000010",
"01000001",
"10000111",
"01011001",
"10000001",
"00000000",
"00011000",
"00101000",
"00011000",
"00100111",
"01111100",
"00000000",
"00000000",
"00000000",
"01110101",
"10000011",
"10000001",
"00000000",
"00100110",
"01011001",
"01000001",
"00110001",
"10011110",
"01000001",
"01010010",
"01001001",
"01010100",
"01001000",
"00101110",
"00100000",
"01010101",
"01001110",
"01000100",
"01000101",
"01010010",
"01000110",
"01001100",
"01001111",
"01010111",
"00100010",
"01001101",
"01000101",
"01001101",
"01001111",
"01010010",
"01011001",
"00100000",
"01000001",
"01001100",
"01001100",
"01001111",
"01000011",
"01000001",
"01010100",
"01001001",
"01001111",
"01001110",
"00100010",
"10101000",
"01000010",
"01000001",
"01000100",
"00100000",
"01000001",
"01010010",
"01000111",
"01010101",
"01001101",
"01000101",
"01001110",
"01010100",
"00100010",
"01001001",
"00101101",
"01010011",
"01010100",
"01000001",
"01000011",
"01001011",
"00100010",
"10010000",
"00011111",
"10100110",
"00110000",
"00010111",
"01001011",
"10000101",
"01000010",
"00001010",
"10000101",
"01000011",
"00001000",
"00000010",
"00001000",
"00010101",
"10000101",
"00001111",
"10000011",
"10000101",
"00001110",
"10000010",
"00100010",
"10000101",
"10000011",
"00001111",
"10000101",
"10000010",
"00001110",
"00100010",
"00100000",
"00101111",
"00100111",
"11000010",
"10010110",
"01000011",
"10000111",
"00000001",
"00100000",
"00010110",
"00001011",
"00010000",
"00100001",
"00001000",
"00110000",
"00010000",
"11110100",
"00010010",
"00000111",
"11101001",
"01000000",
"11101111",
"11010010",
"10010110",
"00100010",
"10100011",
"00100000",
"00101111",
"00100011",
"00110000",
"00010011",
"00100000",
"10010000",
"00000001",
"00000001",
"00010010",
"00000110",
"01101101",
"10100011",
"00000010",
"00001000",
"01001010",
"10100010",
"00101111",
"10010000",
"00010111",
"00111101",
"10000000",
"00000100",
"10010000",
"00011000",
"00110000",
"11000011",
"10000101",
"00111110",
"10000001",
"00010010",
"00001100",
"00110100",
"11100100",
"10010011",
"00010000",
"11100111",
"11011001",
"00010001",
"01001110",
"01000000",
"00000011",
"00010010",
"00000110",
"01101001",
"00010010",
"00000110",
"10011101",
"10010000",
"00011111",
"11111000",
"00010010",
"00000110",
"10101001",
"00010001",
"01000111",
"00010010",
"00000110",
"10101001",
"00110000",
"00101111",
"00000101",
"11000010",
"00100000",
"00000010",
"00010111",
"01111110",
"10010000",
"00000001",
"00000001",
"00010010",
"00000110",
"10101001",
"00010010",
"00001110",
"10011110",
"11100100",
"00010001",
"01001110",
"00010010",
"00000101",
"11011000",
"00010001",
"11110101",
"01000000",
"00000110",
"01100000",
"00000100",
"11100000",
"10110100",
"00000001",
"11110001",
"00010001",
"01000111",
"00010001",
"11110101",
"11101001",
"00100100",
"00001010",
"11110101",
"01000101",
"10100011",
"00010010",
"00010110",
"00111101",
"00110001",
"10100001",
"00100000",
"00100000",
"11010000",
"00010010",
"00000110",
"10011101",
"00010001",
"01000111",
"00010010",
"00010000",
"10001000",
"00010010",
"00010000",
"01111001",
"01111101",
"00101101",
"00110001",
"10010000",
"11010101",
"01000101",
"11111001",
"01111101",
"01011000",
"00110001",
"10010000",
"00000001",
"10101101",
"10101011",
"00001010",
"10101001",
"00001000",
"00000010",
"00001010",
"00000101",
"10000101",
"01001010",
"10001100",
"11000101",
"01000111",
"00000100",
"10110100",
"11001000",
"00001000",
"11100100",
"00000101",
"01001001",
"10110101",
"01001001",
"00000010",
"00000101",
"01001000",
"11000101",
"01000111",
"11010000",
"11010000",
"00110010",
"00110001",
"00101111",
"11000010",
"10101001",
"11000010",
"00101110",
"01010000",
"00001010",
"01010011",
"10001001",
"11110000",
"11010010",
"00101110",
"01000011",
"10101000",
"10000010",
"11010010",
"10001100",
"00100010",
"00110001",
"00101111",
"10010010",
"00011110",
"00100010",
"00110001",
"00101111",
"10010010",
"00011100",
"00100010",
"00010010",
"00001110",
"11011000",
"10010100",
"00110001",
"10110011",
"00100010",
"00100000",
"11010100",
"11111100",
"00100000",
"11010011",
"11111001",
"00010000",
"11100111",
"00000110",
"10010000",
"00000000",
"01000111",
"00000010",
"00001001",
"01011111",
"00100000",
"11100000",
"01010111",
"01100000",
"01000110",
"10010000",
"00011001",
"10010001",
"01110011",
"00110001",
"10011101",
"01010000",
"01001101",
"00110001",
"10100101",
"01110000",
"00110100",
"11000000",
"10000011",
"11000000",
"10000010",
"00110001",
"10101011",
"11010000",
"10000010",
"11010000",
"10000011",
"11100100",
"00100010",
"10000101",
"11001100",
"11100000",
"00100000",
"11100011",
"11111010",
"00010010",
"00010101",
"01111010",
"10000101",
"11001100",
"11100000",
"00110000",
"11100011",
"11111010",
"00110000",
"10110000",
"11101110",
"00100000",
"10110000",
"11111101",
"00100010",
"00101100",
"00100000",
"01001001",
"11001110",
"11010100",
"11000101",
"11001100",
"10100000",
"11000011",
"11001111",
"11010010",
"11010000",
"00101110",
"00100000",
"00110001",
"10111001",
"00111000",
"00110101",
"00100010",
"--------",
"--------",
"--------",
"--------",
"--------",
"00000010",
"00000111",
"00001011",
"00100001",
"10110111",
"00100001",
"10101101",
"01000001",
"01101010",
"01000001",
"10011010",
"01000001",
"11001111",
"10000001",
"10010110",
"10000001",
"11001111",
"10100001",
"10000111",
"11100001",
"00000100",
"11000001",
"10101011",
"11000001",
"11100000",
"11100001",
"01001100",
"10000001",
"11000011",
"01110101",
"10100000",
"00000001",
"10101000",
"00001001",
"00011000",
"11100010",
"10110010",
"11100000",
"11110010",
"10010001",
"01110111",
"11101111",
"01100000",
"00001101",
"10111110",
"00000000",
"00010010",
"10010001",
"01101011",
"01111111",
"00000110",
"11100010",
"11110011",
"00011000",
"00011001",
"11011111",
"11111010",
"11100101",
"00001001",
"00100100",
"00000110",
"11110101",
"00001001",
"11100100",
"00100010",
"10011110",
"10001111",
"00110000",
"10001100",
"00101111",
"01010000",
"00001001",
"10001110",
"00110000",
"10001011",
"00101111",
"11110100",
"00000100",
"11001000",
"11001001",
"11001000",
"11111111",
"11000010",
"00100011",
"10111101",
"00000000",
"00000010",
"11010010",
"00100011",
"10010001",
"10001000",
"10111111",
"00001011",
"00000000",
"01000000",
"00000010",
"01111111",
"00001010",
"01110101",
"00101010",
"00000000",
"01110001",
"11001000",
"01111111",
"00000100",
"01111001",
"00101110",
"01110100",
"10011110",
"11000011",
"10011100",
"11010100",
"11001100",
"01110000",
"00000001",
"11111100",
"10110100",
"01010000",
"00000000",
"00110000",
"00100011",
"00011000",
"10110011",
"01010001",
"00011001",
"01010000",
"00001000",
"00000101",
"00101010",
"01111111",
"00000001",
"01110001",
"11001000",
"01110001",
"01111111",
"01100001",
"01110000",
"11100010",
"00110111",
"11010100",
"11110111",
"00011000",
"00011001",
"11011111",
"11111000",
"00100010",
"11100010",
"11111110",
"11100100",
"00110100",
"10011001",
"10010111",
"00101110",
"11010100",
"11110111",
"00011000",
"00011001",
"11011111",
"11110011",
"01000000",
"00010001",
"10110010",
"01111000",
"01111001",
"00101110",
"01111111",
"00000100",
"01110100",
"10011010",
"10010111",
"00100100",
"00000000",
"11010100",
"11110111",
"00011001",
"10110011",
"11011111",
"11110101",
"01111000",
"00101011",
"01111111",
"00000000",
"11100110",
"01110000",
"00001000",
"00001111",
"00001111",
"00001000",
"10111000",
"00101111",
"11110111",
"01100001",
"10111000",
"10110100",
"00010000",
"00000000",
"01010000",
"00000001",
"00001111",
"11100101",
"00110000",
"11000011",
"10011111",
"01100000",
"00001011",
"01000000",
"00001001",
"11110101",
"00110000",
"10010001",
"00000010",
"01110101",
"00101010",
"00000000",
"01100001",
"01110000",
"01100001",
"10110010",
"10010001",
"01110111",
"11100101",
"00001001",
"00100100",
"00001100",
"11110101",
"00001001",
"11101110",
"11000010",
"11010101",
"10011111",
"01100000",
"00001010",
"01000000",
"00000011",
"11101011",
"10000000",
"00000001",
"11101100",
"01100000",
"00000001",
"10110011",
"00100010",
"10111101",
"00000000",
"11110101",
"01111111",
"00000100",
"00011000",
"00011000",
"00011000",
"00011001",
"00011001",
"00011001",
"11100010",
"11111110",
"11100011",
"10011110",
"01110000",
"11101010",
"00001000",
"00001001",
"11011111",
"11110110",
"11010010",
"11010101",
"00100010",
"10010001",
"01110101",
"10111110",
"00000000",
"00000010",
"01100001",
"10111000",
"10001101",
"00101111",
"11101111",
"01100000",
"11111001",
"00101110",
"00100000",
"11100111",
"00000101",
"00010000",
"11010111",
"00000110",
"01100001",
"10110010",
"01010000",
"00000010",
"01100001",
"10100001",
"10010100",
"10000001",
"11111110",
"01110001",
"10001011",
"01111011",
"00000100",
"10101100",
"00000001",
"10001100",
"00000001",
"11100011",
"11111010",
"10010001",
"00111000",
"11101010",
"11000100",
"10010001",
"00111000",
"00011100",
"11011011",
"11110011",
"10001110",
"00110000",
"10001101",
"00101111",
"01100001",
"00110000",
"10010001",
"01110111",
"10001101",
"00101111",
"10111111",
"00000000",
"00000110",
"01110001",
"10100001",
"11100100",
"11010010",
"11100011",
"00100010",
"11101110",
"01100000",
"11000000",
"10011111",
"00100000",
"11100111",
"00000100",
"01010000",
"00000100",
"01100001",
"10110010",
"01010000",
"11001000",
"00100100",
"10000001",
"11110101",
"00110000",
"10010001",
"10001000",
"01111010",
"00110100",
"10101011",
"00000000",
"01110101",
"00101010",
"00000000",
"01111101",
"11111111",
"11010011",
"10001011",
"00000000",
"01111001",
"00101110",
"01111111",
"00000100",
"01010000",
"00010111",
"11100010",
"11111110",
"11100100",
"00110100",
"10011001",
"10011110",
"00100111",
"11010100",
"11110111",
"00011000",
"00011001",
"11011111",
"11110011",
"00001101",
"01000000",
"11101000",
"11100111",
"10010100",
"00000001",
"11110111",
"10110011",
"10000000",
"11100001",
"01010001",
"00011001",
"01110111",
"00000000",
"10001010",
"00000000",
"10100110",
"00000101",
"00001010",
"01111111",
"00000001",
"10010001",
"00000000",
"10111010",
"00111110",
"11001110",
"11010101",
"00110000",
"00000010",
"01100001",
"10110010",
"01110101",
"00101010",
"00000000",
"01111000",
"00110100",
"11100110",
"11111110",
"01100000",
"00000011",
"01110001",
"01111111",
"00011000",
"00001000",
"01110100",
"00001000",
"11111001",
"00101000",
"11111000",
"10110110",
"00000101",
"00000000",
"01000000",
"00010011",
"11010011",
"11100100",
"00011000",
"00110110",
"11010100",
"11010110",
"00110000",
"11100100",
"00001001",
"11011001",
"11110101",
"00011000",
"01110110",
"00000001",
"01110001",
"01111111",
"10000000",
"00000110",
"00011001",
"11101001",
"11000011",
"11001000",
"10011000",
"11111000",
"01111001",
"00101011",
"11100110",
"11000100",
"00001000",
"11010110",
"01000010",
"00000110",
"11110111",
"00001000",
"00001001",
"10111001",
"00101111",
"11110100",
"11101110",
"01110000",
"00000011",
"01110101",
"00110000",
"00000000",
"10010001",
"01101011",
"10001001",
"00001001",
"01111000",
"00110000",
"11100110",
"11110011",
"00011000",
"00011001",
"10111000",
"00101010",
"11111001",
"11100100",
"00100010",
"00000101",
"00110000",
"11100101",
"00110000",
"01110000",
"11111001",
"11010000",
"11100000",
"11010000",
"11100000",
"01100001",
"10100001",
"11000000",
"00000001",
"01111001",
"00110010",
"11100010",
"01010100",
"00001111",
"11110111",
"11100010",
"11000100",
"01010100",
"00001111",
"00011001",
"11110111",
"00011000",
"00011001",
"10111001",
"00101010",
"11110001",
"11010000",
"00000001",
"00100010",
"01111000",
"00101110",
"01110100",
"10011001",
"11110110",
"00011000",
"10111000",
"00101010",
"11111011",
"01110101",
"00110000",
"11111111",
"01110001",
"01110000",
"11010010",
"11100001",
"00100010",
"01110001",
"10111000",
"11100100",
"11010010",
"11100000",
"00100010",
"01110001",
"10111111",
"01110001",
"01110000",
"11010010",
"11100010",
"00100010",
"11100100",
"01111000",
"00111101",
"11110110",
"00011000",
"10111000",
"00101001",
"11111011",
"00100010",
"01111100",
"00000000",
"11000011",
"11101111",
"01100000",
"00100010",
"10010100",
"00000010",
"01010000",
"00011111",
"11000000",
"00000000",
"11000000",
"00000001",
"01111001",
"00101110",
"01111000",
"00101101",
"11101100",
"11010111",
"11000100",
"11111100",
"11100111",
"11010110",
"11000100",
"11110111",
"00011000",
"00011001",
"10111001",
"00101010",
"11110111",
"11100111",
"11000100",
"01010100",
"00001111",
"11110111",
"11010000",
"00000001",
"11010000",
"00000000",
"00100010",
"11111111",
"11100100",
"11000101",
"00101010",
"11000101",
"00101011",
"11000101",
"00101100",
"11000101",
"00101101",
"11000101",
"00101110",
"11111100",
"10000000",
"11001011",
"01111100",
"00000000",
"11000011",
"11101111",
"01100000",
"00100010",
"10010100",
"00000010",
"01010000",
"00011111",
"11000000",
"00000000",
"11000000",
"00000001",
"01111000",
"00101010",
"01111001",
"00101011",
"11100110",
"11000100",
"11110110",
"11100111",
"11000100",
"11010110",
"11110111",
"00001000",
"00001001",
"10111000",
"00101110",
"11110111",
"11101100",
"11000100",
"11010110",
"01010100",
"11110000",
"11111100",
"11010000",
"00000001",
"11010000",
"00000000",
"00100010",
"11111111",
"11100100",
"11001100",
"11000101",
"00101110",
"11000101",
"00101101",
"11000101",
"00101100",
"11000101",
"00101011",
"11000101",
"00101010",
"10000000",
"11001011",
"01010100",
"00001111",
"11111111",
"01111000",
"00111100",
"01111001",
"00110010",
"11100100",
"11110101",
"00110011",
"00011000",
"00100110",
"11010100",
"00110000",
"11100100",
"00000011",
"00011000",
"00000110",
"00001000",
"11010110",
"10001111",
"11110000",
"11100111",
"10100100",
"01110101",
"11110000",
"00001010",
"10000100",
"11000101",
"11110000",
"00100110",
"11010100",
"00110000",
"11100100",
"00000010",
"00000101",
"11110000",
"00001000",
"11010110",
"00011000",
"11100101",
"11110000",
"00011001",
"10111001",
"00101010",
"11011100",
"00100101",
"00110011",
"11010100",
"11110110",
"00100010",
"01110101",
"10100000",
"00000001",
"10101000",
"00001001",
"01110100",
"00000110",
"00101000",
"11111001",
"00100010",
"01110001",
"10111111",
"10010001",
"01101011",
"11100010",
"11111111",
"11100011",
"11111110",
"00011000",
"00011001",
"11100010",
"11111100",
"11100011",
"11111011",
"01101100",
"11111101",
"00011000",
"00011001",
"00100010",
"11000000",
"00000000",
"01111000",
"00101110",
"11100011",
"11110110",
"00011001",
"00011000",
"10111000",
"00101010",
"11111001",
"11010000",
"00000000",
"00100010",
"10110001",
"01101100",
"11000000",
"10000011",
"11000000",
"10000010",
"11100000",
"11110001",
"11101101",
"01000000",
"00010010",
"10010001",
"10110110",
"01000000",
"00001110",
"11000010",
"11100101",
"10110100",
"01001000",
"00000011",
"11010011",
"10000000",
"00000001",
"11000011",
"11010000",
"10000010",
"11010000",
"10000011",
"00100010",
"10100011",
"10000000",
"11100110",
"11000010",
"11100101",
"10110100",
"01000111",
"00000000",
"01000000",
"00000001",
"00100010",
"10110100",
"01000001",
"00000000",
"10110011",
"00100010",
"01111011",
"00000000",
"01111001",
"01011000",
"11110001",
"00000100",
"01110100",
"00001101",
"11110011",
"10010000",
"00000000",
"01011000",
"01110001",
"10111111",
"10110001",
"01101100",
"10110001",
"01110010",
"10010010",
"01111000",
"01111000",
"00110100",
"01111110",
"01111111",
"11010010",
"11010101",
"11110001",
"11101011",
"01010000",
"00000111",
"01010100",
"00001111",
"10110001",
"01000101",
"10100011",
"10000000",
"11110101",
"10110100",
"00101110",
"00001100",
"00100000",
"01010001",
"01100011",
"11010010",
"01010001",
"10111000",
"00110100",
"11110010",
"11010010",
"01010010",
"10000000",
"11101110",
"00100000",
"11010101",
"01010111",
"10110100",
"01100101",
"00000010",
"10000000",
"00000011",
"10110100",
"01000101",
"00110011",
"10110001",
"01101011",
"10110001",
"01110010",
"10010010",
"01010000",
"11110001",
"11101011",
"01010000",
"01000101",
"01010100",
"00001111",
"11111101",
"10100011",
"11110001",
"11101011",
"01010000",
"00001101",
"01010100",
"00001111",
"11001101",
"01110101",
"11110000",
"00001010",
"10100100",
"00101101",
"11111101",
"01010000",
"11110000",
"01111101",
"11111111",
"11101101",
"00110000",
"01010000",
"00001001",
"11000011",
"10011110",
"11110100",
"00000100",
"01000000",
"00001001",
"01110100",
"00000001",
"00100010",
"00101110",
"01010000",
"00000011",
"01110100",
"00000010",
"00100010",
"11001110",
"10001110",
"00110000",
"10111000",
"00110100",
"00000010",
"01110001",
"10111111",
"11100101",
"00001001",
"11000011",
"10010100",
"00001100",
"11110101",
"00001001",
"01100001",
"00110000",
"11000010",
"11010101",
"01110000",
"00001011",
"10111000",
"00110100",
"00001000",
"00110000",
"01010010",
"00000100",
"11011110",
"00000010",
"01110100",
"11111111",
"00100010",
"00100000",
"01010011",
"00000010",
"11000010",
"01010010",
"00100000",
"01010010",
"11110011",
"00100000",
"01010001",
"00000001",
"00001110",
"00100000",
"01010011",
"11110000",
"10111000",
"00111101",
"00000010",
"11010010",
"01010011",
"11110110",
"00001000",
"00100010",
"10100011",
"11100000",
"10110100",
"00100000",
"00010110",
"10000000",
"11111001",
"10110100",
"11100011",
"00000010",
"10000000",
"00001110",
"10110100",
"00101011",
"00000010",
"10000000",
"00001001",
"10110100",
"11100101",
"00000010",
"10000000",
"00000011",
"10110100",
"00101101",
"00000010",
"11010011",
"10100011",
"00100010",
"10010001",
"01110111",
"00110001",
"11001001",
"11101111",
"11111110",
"01110001",
"10001011",
"01111000",
"00101011",
"11100101",
"00010111",
"11111011",
"01100000",
"01001001",
"10110100",
"11110000",
"00000000",
"01010000",
"01110011",
"11101110",
"01110000",
"00000010",
"01111110",
"10000000",
"11101011",
"11000100",
"01010100",
"00001111",
"11111010",
"11010001",
"01110100",
"11001010",
"11000011",
"10011010",
"11111111",
"01010000",
"00000110",
"01111101",
"00111111",
"11010001",
"10101001",
"10100001",
"11011111",
"10111010",
"00000000",
"00000111",
"00011111",
"11010001",
"10010110",
"11010001",
"10100011",
"10000000",
"00000110",
"11010001",
"10010110",
"11101010",
"11111111",
"11010001",
"01011000",
"11101011",
"01010100",
"00001111",
"11111010",
"01100000",
"10111101",
"11010001",
"10011111",
"11010001",
"01111101",
"10110101",
"00000010",
"00000011",
"11101010",
"11000001",
"10001101",
"01010000",
"11111011",
"11001010",
"11000011",
"10011010",
"11001010",
"11010001",
"10001101",
"11101010",
"11111111",
"11000001",
"01011000",
"11101110",
"01110000",
"00000100",
"11010001",
"10100111",
"11000001",
"10100011",
"01111011",
"11110000",
"01110100",
"01110111",
"00101110",
"01000000",
"00100001",
"10010100",
"11110111",
"01000000",
"00011101",
"11010001",
"10011000",
"11010001",
"01110100",
"10110100",
"00001000",
"00000010",
"11000001",
"01011000",
"11010001",
"01011000",
"11010001",
"01101010",
"01100000",
"01010111",
"11010001",
"10011111",
"01111111",
"00000001",
"11010001",
"01011000",
"01110000",
"01001111",
"11010001",
"01101010",
"01100000",
"01001011",
"10000000",
"11110100",
"11010001",
"10011000",
"01111111",
"00000001",
"11010001",
"01011000",
"11010001",
"10011111",
"11101011",
"01010100",
"00001111",
"01100000",
"00000110",
"11111111",
"00011111",
"11010001",
"01011000",
"10000000",
"00000010",
"11010001",
"00000010",
"11010001",
"10100111",
"01111101",
"01000101",
"11010001",
"10101001",
"11101110",
"01100000",
"00000100",
"00010100",
"10110100",
"10000000",
"00000101",
"11010001",
"10100111",
"11100100",
"10000000",
"00001100",
"01000000",
"00000110",
"01111101",
"00101011",
"11010001",
"10101001",
"10000000",
"00000100",
"11010001",
"10011011",
"11110100",
"00000100",
"11000010",
"11100111",
"11111000",
"01111010",
"00000000",
"01111001",
"01011000",
"01111011",
"00000000",
"11110001",
"00000100",
"01111000",
"01011000",
"11100010",
"11111101",
"11010001",
"10101001",
"00001000",
"11101000",
"10110101",
"00000001",
"11110111",
"00100010",
"11101111",
"01100000",
"00001110",
"11100110",
"01000100",
"00110000",
"00001000",
"00011111",
"11111101",
"11010001",
"10101001",
"11100100",
"10111000",
"00110011",
"11110001",
"01110100",
"01010101",
"00100010",
"10101001",
"00000000",
"11100111",
"01110000",
"00000100",
"00001001",
"10111001",
"00110011",
"11111001",
"00100010",
"11101110",
"11000011",
"10010100",
"10000000",
"01010000",
"00000001",
"11100100",
"11111111",
"00100010",
"11000011",
"01110100",
"10000000",
"10011110",
"01010000",
"00000001",
"11100100",
"00100010",
"11101111",
"01100000",
"11111100",
"11010001",
"10100111",
"00011111",
"10000000",
"11111000",
"11111111",
"11101111",
"01100000",
"11110011",
"11010001",
"10100011",
"00011111",
"10000000",
"11111000",
"11010001",
"10000101",
"11101100",
"01100000",
"00001100",
"01111101",
"00101101",
"10000000",
"00001010",
"01111101",
"00101110",
"10000000",
"00000110",
"01111101",
"00110000",
"10000000",
"00000010",
"01111101",
"00100000",
"00100001",
"10010000",
"10010001",
"10010110",
"10010010",
"00100011",
"11110001",
"11101011",
"10110011",
"01000000",
"00101000",
"01111011",
"00000000",
"01111001",
"00000000",
"10000000",
"00010101",
"10100011",
"10001001",
"00000000",
"10001011",
"00000010",
"11110001",
"11101011",
"01000000",
"00001100",
"00110000",
"00100011",
"00010110",
"10010001",
"10110110",
"01000000",
"00000011",
"10100011",
"10000000",
"00001111",
"00100100",
"00001001",
"01110101",
"11110000",
"00001010",
"00110000",
"00100011",
"00000011",
"01110101",
"11110000",
"00010000",
"11010001",
"11100011",
"01010000",
"11011110",
"11100100",
"10010010",
"11100001",
"00100010",
"01110101",
"11110000",
"00001010",
"11000000",
"11100000",
"11000000",
"11110000",
"11101001",
"10100100",
"11111001",
"11101011",
"10101011",
"11110000",
"11010000",
"11110000",
"10100100",
"10100010",
"11010010",
"10010010",
"11010101",
"00101011",
"11111011",
"11010000",
"11100000",
"01110010",
"11010101",
"01000000",
"00000111",
"01010100",
"00001111",
"00101001",
"11111001",
"11100100",
"00111011",
"11111011",
"00100010",
"11100100",
"10010000",
"00100111",
"00010000",
"11110001",
"00100001",
"10010000",
"00000011",
"11101000",
"11110001",
"00100001",
"10010000",
"00000000",
"01100100",
"11110001",
"00100001",
"10010000",
"00000000",
"00001010",
"11110001",
"00100001",
"10010000",
"00000000",
"00000001",
"11110001",
"00100001",
"01100000",
"00100000",
"00100010",
"01111110",
"11111111",
"00001110",
"11001010",
"10110101",
"10000011",
"00000000",
"11001010",
"01000000",
"00010010",
"11001000",
"10010101",
"10000010",
"11001000",
"11001010",
"10010101",
"10000011",
"11001010",
"01010000",
"11101110",
"11001000",
"00100101",
"10000010",
"11001000",
"11001010",
"00110101",
"10000011",
"11001010",
"01001110",
"01100000",
"11100000",
"01110100",
"00110000",
"00101110",
"10001011",
"10100000",
"11110011",
"00001001",
"10111001",
"00000000",
"00000001",
"00001011",
"00100010",
"11010001",
"10100111",
"10100010",
"00110110",
"10010010",
"00100011",
"11101011",
"11110001",
"01101111",
"11101011",
"11110001",
"01110000",
"11000010",
"00100011",
"11101001",
"11110001",
"01101111",
"11101001",
"11110001",
"01110000",
"01111101",
"01001000",
"11000001",
"10101001",
"11000010",
"00100011",
"00100100",
"10010000",
"11010100",
"00110100",
"01000000",
"11010100",
"11111101",
"10000000",
"11110011",
"11000100",
"01010100",
"00001111",
"01110000",
"11110000",
"00110000",
"00100011",
"11101101",
"00100010",
"00100000",
"00011010",
"00000011",
"00000010",
"01000000",
"00011011",
"00000010",
"00100000",
"10001000",
"01001110",
"01001111",
"00100000",
"01000100",
"01000001",
"01010100",
"01000001",
"00100010",
"10010100",
"01000001",
"01010010",
"01001001",
"01010100",
"01001000",
"00101110",
"00100000",
"01001111",
"01010110",
"01000101",
"01010010",
"01000110",
"01001100",
"01001111",
"01010111",
"00100010",
"01010000",
"01010010",
"01001111",
"01000111",
"01010010",
"01000001",
"01001101",
"01001101",
"01001001",
"01001110",
"01000111",
"00100010",
"01000011",
"01000001",
"01001110",
"00100111",
"01010100",
"00100000",
"01000011",
"01001111",
"01001110",
"01010100",
"01001001",
"01001110",
"01010101",
"01000101",
"00100010",
"01001001",
"01001110",
"01010110",
"01000001",
"01001100",
"01001001",
"01000100",
"00100000",
"01001100",
"01001001",
"01001110",
"01000101",
"00100000",
"01001110",
"01010101",
"01001101",
"01000010",
"01000101",
"01010010",
"00100010",
"01010000",
"01010010",
"01001111",
"01001101",
"00100000",
"01001101",
"01001111",
"01000100",
"01000101",
"00100010",
"00101010",
"01001101",
"01000011",
"01010011",
"00101101",
"00110101",
"00110001",
"00101000",
"01110100",
"01101101",
"00101001",
"00100000",
"01000010",
"01000001",
"01010011",
"01001001",
"01000011",
"00100000",
"01010110",
"00110001",
"00101110",
"00110001",
"00101010",
"00100010",
"10110001",
"01101100",
"10110100",
"00111010",
"00000000",
"01000000",
"00000001",
"00100010",
"10110100",
"00110000",
"00000000",
"10110011",
"00100010",
"01000101",
"01010010",
"01010010",
"01001111",
"01010010",
"00111010",
"00100000",
"00100010"
);
begin
	process (Clk)
	begin
		if Clk'event and Clk = '1' then
			A_r <= A;
		end if;
	end process;
	process (A_r)
	begin
		D <= ROM(to_integer(unsigned(A_r)));
	end process;
end;
