----------------------------------------------------------------------------------
-- Company: 
-- Engineer: 
-- 
-- Create Date:    12:39:23 04/30/2008 
-- Design Name:    Frequenzteiler 48 MHz auf 50 Hz
-- Module Name:    Teiler50 - Behavioral 
-- Project Name: 
-- Target Devices: 
-- Tool versions: 
-- Description: 
--
-- Dependencies: 
--
-- Revision: 
-- Revision 0.01 - File Created
-- Additional Comments: 
--
----------------------------------------------------------------------------------
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;

---- Uncomment the following library declaration if instantiating
---- any Xilinx primitives in this code.
--library UNISIM;
--use UNISIM.VComponents.all;

entity Teiler50T is
    Port ( Clk : in  STD_LOGIC;
           Reset : in  STD_LOGIC;
           Q : out  STD_LOGIC);
end Teiler50T;

architecture Behavioral of Teiler50T is

begin

process (Reset, Clk) is
  variable var_zustand_vektor : std_logic_vector (1 downto 0);
  variable var_zaehler_vektor : integer range 0 to 1000000;

  begin

    if Reset = '1' then
      var_zustand_vektor := "00";
      var_zaehler_vektor := 0;
    elsif (Clk'event AND Clk='1') then

    CASE var_zustand_vektor is
      when "00" =>
        if var_zaehler_vektor = 500000 then
          var_zustand_vektor := "01";
        else
          var_zaehler_vektor := var_zaehler_vektor + 1;
          Q <= '1';
        end if;
      when "01" =>
        if var_zaehler_vektor = 999999 then
          var_zustand_vektor := "00";
          var_zaehler_vektor := 0;
        else
          var_zaehler_vektor := var_zaehler_vektor + 1;
          Q <= '0';
        end if;
      when others =>
        var_zustand_vektor := "00";
      End Case;

    end if;
  end Process;

end Behavioral;

